%{
/*    File:	 parser.y  (~bevemyr/KAM/Emulator/parser.y)
 *    Author:	 Johan Bevemyr
 *    Created:	 23 March 1992
 *    Purpose:   Example top level. 
 */ 

#include "include.h"

#define Store_OpCode(C,O)  *(C++) = (TAGGED) (O)
#define Store_RegNr(C,R)   *(C++) = (TAGGED) (R)
#define Store_Const(C,Con) *(C++) = (TAGGED) (Con)
#define Store_Functor(C,F) *(C++) = (TAGGED) (F)
#define Store_Def(C,D)     *(C++) = (TAGGED) (D)
#define Store_Label(C,L)   *(C++) = (TAGGED) (L)

#define MAXLABELNUMBER  100

static TAGGED functorname;
static int  functorarity;
static TAGGED predname;
static int  predarity;

FILE 	 *inputfilea[MAXFILERECURSION];
int	 infilecount;

    /* Defined by (f)lex: */

extern char *yytext;
extern FILE *yyin;

    /* Define by storage.c */

extern code *code_current;

/* Used to set label references to their proper adresses */    

typedef struct {
    int label;
    code *address;
} backpatch;

static backpatch resolved[MAXLABELNUMBER];
static int resolvedtop;

static backpatch unresolved[MAXLABELNUMBER];
static int unresolvedtop;

code *get_label_address PROTO((int));
void bpatch PROTO((int,code *));

%}	

%token Switch_On_Term Switch_On_Constant Switch_On_Structure
%token Try Retry Trust 
%token Get_Structure Get_Constant Get_Variable Get_Value
%token Put_Structure Put_Definition Put_Constant Put_Variable Put_Value
%token Put_Void
%token Unify_Void Unify_Variable Unify_Value Unify_Constant 
%token Execute Meta_Execute Demo_Execute Inline Builtin Halt Label Fail
%token LOAD QUIT CD GO PREDICATE ATOMNAME LPAR RPAR SLASH NUMBER END

%%
  
begin	: {
	    infilecount = 0;
	  } toploop
	;

/* main loop */

toploop : toploop command
        |
        ;

command	: pred 
    	| QUIT { exit(0); } 
	| CD ATOMNAME
	  { if(chdir(yytext) != NULL) 
	        printf("Couldn't change directory to %s\n",yytext);
	    printf("[OK]\n");
	  } 
    	| GO
	  { if(engine(get_definition(MakeFunctor(store_atom("start"),0)))) {
	      printf("Yes\n");
	    } else {
	      printf("No\n");
	    }
	  } 
	| LOAD ATOMNAME 
	  { char tmpstr[255];
	    inputfilea[infilecount++] = yyin;
	    strcpy(tmpstr,yytext);
	    if((yyin = fopen(tmpstr,"r")) == NULL) {
	      printf("can't open %s to read\n",tmpstr);
	      yyin = inputfilea[--infilecount];
	    }
	  } 
	| error { fprintf(stderr,"[%s : Command Ignored]\n",yytext); }
	| END 
	;

pred	: PREDICATE LPAR ATOMNAME
	  { predname = store_atom(yytext); 
	  } SLASH NUMBER 
	  { predarity = atoi(yytext); 
	    (void) store_emulated_predicate(MakeFunctor(predname,predarity),
					    code_current);
	    unresolvedtop = 0; 
	    resolvedtop = 0;
	  }  codes RPAR 
	  { printf("%s/%d inserted\n",GetString(predname),predarity);
	    Store_OpCode(code_current,END_OF_PRED);
	  }
	;

codes   : codes code
        |
        ;

code	: Switch_On_Term { Store_OpCode(code_current,SWITCH_ON_TERM) }
		label label label 
	| Switch_On_Constant { Store_OpCode(code_current,SWITCH_ON_CONSTANT) }
		index LPAR consts RPAR label 
	| Switch_On_Structure { Store_OpCode(code_current,SWITCH_ON_STRUCTURE)}
		index LPAR functs RPAR label 
	| Try { Store_OpCode(code_current,TRY) } label 
	| Retry { Store_OpCode(code_current,RETRY) } label 
	| Trust { Store_OpCode(code_current,TRUST) } label 
	| Get_Structure { Store_OpCode(code_current,GET_STRUCTURE) } 
		functor register 
	| Get_Constant { Store_OpCode(code_current,GET_CONSTANT) }
		constant register 
	| Get_Variable { Store_OpCode(code_current,GET_VARIABLE) }
		register register 
	| Get_Value { Store_OpCode(code_current,GET_VALUE) }
		register register 
	| Put_Structure { Store_OpCode(code_current,PUT_STRUCTURE) }
		functor register 
	| Put_Definition { Store_OpCode(code_current,PUT_DEFINITION) }
		def register 
	| Put_Constant { Store_OpCode(code_current,PUT_CONSTANT) }
		constant register 
	| Put_Variable { Store_OpCode(code_current,PUT_VARIABLE) }
		register register 
	| Put_Value { Store_OpCode(code_current,PUT_VALUE) }
		register register 
	| Put_Void { Store_OpCode(code_current,PUT_VOID) }
		register 
	| Unify_Void { Store_OpCode(code_current,UNIFY_VOID) }
		index 
	| Unify_Variable { Store_OpCode(code_current,UNIFY_VARIABLE) }
		register 
	| Unify_Value { Store_OpCode(code_current,UNIFY_VALUE) }
		register 
	| Unify_Constant { Store_OpCode(code_current,UNIFY_CONSTANT) }
		constant
	| Execute { Store_OpCode(code_current,EXECUTE) }
		def 
	| Meta_Execute { Store_OpCode(code_current,META_EXECUTE) }
		register register 
	| Demo_Execute { Store_OpCode(code_current,DEMO_EXECUTE) }
		register 
	| Inline { Store_OpCode(code_current,INLINE) }
		label builtin regs 
	| Builtin { Store_OpCode(code_current,BUILTIN) }
		builtin regs 
	| Halt { Store_OpCode(code_current,HALT) } 

	| Label NUMBER { bpatch(atoi(yytext), code_current); } 
	| error { fprintf(stderr,"[%s : instructions Ignored]\n",yytext); }
	;

label    : NUMBER { Store_Label(code_current,get_label_address(atoi(yytext)));}
	 | Fail { Store_Label(code_current,NULL); }
         ;
     
index    : NUMBER { Store_RegNr(code_current,atoi(yytext)); }

register : NUMBER { Store_RegNr(code_current,atoi(yytext)); }

regs     : register regs
	 |
	 ;

func     : ATOMNAME 
	   { functorname = store_atom(yytext); }
	   SLASH NUMBER
	   { functorarity = atoi(yytext); }
functor  : func
	   {Store_Functor(code_current,MakeFunctor(functorname,functorarity));}
	 ;

constant : NUMBER   { Store_Const(code_current,MakeInteger(atoi(yytext))); }
	 | ATOMNAME { Store_Const(code_current,store_atom(yytext)); }
	 ;

consts   : constant label consts
	 |
	 ;

functs   : functor label functs
	 |
	 ;

def	 : func
	   { Store_Def(code_current, 
		       get_definition(MakeFunctor(functorname,functorarity)));}
	 ;

builtin : index
	| ATOMNAME 
          { int i; 
	    for(i = 0 ; i < INLINE_TABLE_SIZE ; i++) {
	        if(strcmp(inline_table[i].pname,yytext) == 0) /* equal */
		    break;
            }
	    if(i == INLINE_TABLE_SIZE) {
	        printf("Error - no such builtin function %s\n",yytext);
	        i = 0;
	    }
	    Store_RegNr(code_current,i);
	  }
        ;

%%
yyerror(s)
     char *s;
{
  fprintf(stderr,"%s\n",s);
}

code *get_label_address(lab)
    int lab;
{
    register int res;

    for(res = 0 ; res != resolvedtop ; res++) {
	if(resolved[res].label == lab) {
	    return (code *) (((unsigned long) resolved[res].address)-
			     ((unsigned long) code_current));
	}
    }
    unresolved[unresolvedtop].label = lab;
    unresolved[unresolvedtop].address = code_current;
    unresolvedtop++;

    return NULL;
}

void bpatch(lab,add)
    int lab;
    code *add;
{
    register int ures;
    
    resolved[resolvedtop].label = lab;
    resolved[resolvedtop].address = add;
    resolvedtop++;

    for(ures = 0 ; ures != unresolvedtop ; ures++) {
	if(unresolved[ures].label == lab) {
	    *(unresolved[ures].address) = 
		((unsigned long) add) -
		((unsigned long) unresolved[ures].address);
	}
    }
}
    

main()
{
  printf("Uppsala Binary Prolog version 1.0\n");

  init();

  yyparse();
}


