/*    File:	 init.c  (~bevemyr/KAM/Emulator/init.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Mar 24 11:50:49 1992
 *    Purpose:   Example of code for initializing the machine.
 */ 

#include "include.h"
#include "builtin.h"

void def_c_pred(name,arity,func)
    char *name;
    int arity;
    BOOL (*func)();
{
    store_c_predicate(MakeFunctor(store_atom(name),arity),func);
}

void init_builtin()
{
    def_c_pred("display",2,pl_display);
    def_c_pred("nl",1,pl_nl);
}

void init_once()
{
    init_memory();
    init_atomtable();
    init_database();
    init_builtin();
}

void init_every_time()
{
}

void init()
{
    init_once();
    init_every_time();
}
