/*    File:	 atom_table.c  (~bevemyr/KAM/Emulator/atom_table.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Mar 24 10:21:42 1992
 *    Purpose:   Example atom table code.
 */ 

#include "include.h"

/* The hash table consists of buckets. We first locate the proper bucket,
 * then search the bucket for an atom with the same print name, if it
 * is found we return it's entry, otherwise we make a new entry for it.
 *
 */

typedef struct atom_bucket {
    TAGGED a;
    struct atom_bucket *next;
} atom_bucket;

static atom_bucket *atomtable[ATOMHASHLEN];

TAGGED make_atom(pname)
    char *pname;
{
    register atom a;
    register int len;

    a = (atom) static_alloc(sizeof(struct atom));

    for(len = 0; pname[len] != 0 ; len++);

    a->pname = (char *) static_alloc((sizeof(char) * (len + 1)) +
				   (4 - (sizeof(char) * (len + 1)) % 4));

    (void) strcpy(a->pname,pname);

    return Tag(RemAtomBase(a),CON);
}

atom_bucket *make_atom_bucket(pname,next)
    char *pname;
    atom_bucket *next;
{
    atom_bucket *res;

    res = (atom_bucket *) static_alloc(sizeof(atom_bucket));
    res->a = make_atom(pname);
    res->next = next;
    
    return res;
}

int hash_atom(str)                            /* primitive hash function */
    char *str;
{
    long hval;
    int i;
    
    hval = str[0] * 113;
    i = 0;
    
    while(str[i]!=0) i++;
    hval += str[i-1] * 109;
    hval += i;
    
    return (int) (hval % ATOMHASHLEN);
}

TAGGED store_atom(str)                    /* returns a TAGGED atom object */
    char *str;
{
    register atom_bucket *bucket;
    register int hv;

    hv = hash_atom(str);                    /* calculate the hash value   */

    for(bucket = atomtable[hv] ;            /* find the right bucket      */
	bucket != NULL ;                    /* if bucket not empty search */
	bucket = bucket->next) 
      {
	if(strcmp(str,GetString(bucket->a)) == 0)
	  return bucket->a;
      }

    /* add atom first in bucket */
    atomtable[hv] = make_atom_bucket(str,atomtable[hv]);
    return atomtable[hv]->a;
}

void init_atomtable()
{
    int	i;

    for(i=0 ; i != ATOMHASHLEN ; i++)
	atomtable[i] = NULL;
}

