/*    File:	 storage.c  (~bevemyr/KAM/Emulator/storage.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Mar 24 11:27:58 1992
 *    Purpose:   Example of memory managing routines.
 */ 


#include "include.h"

/* These routines operates on five areas. The code area, the static
 * area, the heap, the stack, and the trail.
 *
 * The bounds of the code area are defined by code_start, code_end
 * and code_current. Space is normally allocated from the code area
 * by incrementing the code_current pointer.
 * 
 * The bounds of the static area are defined by static_start, static_end,
 * and static_current. Space is normally allocated from the static
 * area by using the function static_allocate().
 *
 * The bounds of the heap are defined by heap_start, heap_end, and
 * heap_current. Space is normally allocated from the heap by incrementing
 * the heap_current pointer.
 *
 * The bounds of the stack are defined by stack_start, stack_end, and
 * stack_current. Space is normally allocated from the stack by incrementing
 * the stack_current pointer.
 *
 * The bounds of the trail are defined by trail_start, trail_end, and
 * trail_current. Space is normally allocated from the trail by incrementing
 * the trail_current pointer.
 */

code *code_start, *code_end, *code_current;
TAGGED *static_start, *static_end, *static_current;
TAGGED *heap_start, *heap_end, *heap_current;
TAGGED *stack_start, *stack_end, *stack_current;
TAGGED *trail_start, *trail_end, *trail_current;

long atombase;

void init_code(size)
    long size;
{
    code_start = (code *) malloc(size);

    if(code_start == NULL) {
	printf("can't allocate code space\n");
	exit(1);
    }
    
    code_current = code_start;
    code_end = (code *) ((long) code_start + size);
}

void init_static(size)
    long size;
{
    static_start = (TAGGED *) malloc(size);

    if(static_start == NULL) {
	printf("can't allocate static space\n");
	exit(1);
    }
    
    atombase = (long) (static_start);

    static_current = static_start;
    static_end = (code *) ((long) static_start + size);
}

void init_heap(size)
    long size;
{
    heap_start = (TAGGED *) malloc(size);

    if(heap_start == NULL) {
	printf("can't allocate heap space\n");
	exit(1);
    }
    
    heap_current = heap_start;
    heap_end = (code *) ((long) heap_start + size);
}

void init_stack(size)
    long size;
{
    stack_start = (TAGGED *) malloc(size);

    if(stack_start == NULL) {
	printf("can't allocate stack space\n");
	exit(1);
    }
    
    stack_current = stack_start;
    stack_end = (code *) ((long) stack_start + size);
}

void init_trail(size)
    long size;
{
    trail_start = (TAGGED *) malloc(size);

    if(trail_start == NULL) {
	printf("can't allocate trail space\n");
	exit(1);
    }
    
    trail_current = trail_start;
    trail_end = (code *) ((long) trail_start + size);
}

TAGGED *static_alloc(size)
    long size;
{
    register TAGGED *ret;
    size = (size + sizeof(TAGGED)-1) / sizeof(TAGGED);
    ret = static_current;
    static_current += size;
    if(static_current > static_end) {
	printf("static area out of memory\n");
	exit(1);
    }

    return ret;
}

void init_memory()
{
    init_code(CODE_SIZE);
    init_static(STATIC_SIZE);
    init_heap(HEAP_SIZE);
    init_stack(STACK_SIZE);
    init_trail(TRAIL_SIZE);
}
	
