%{
/*    File:	 parser.l  (~bevemyr/KAM/Emulator/parser.l)
 *    Author:	 Johan Bevemyr
 *    Created:	 23 March 1992
 */ 

#include "include.h"
#include "parser.tab.h"

    /* Defined in parser.y */

extern FILE	*inputfilea[MAXFILERECURSION];
extern int	infilecount;

%}

%%
"switch_on_term"		{ return Switch_On_Term; }
"switch_on_constant"		{ return Switch_On_Constant; }
"switch_on_structure"		{ return Switch_On_Structure; }

"try"				{ return Try; }
"retry"				{ return Retry; }
"trust"				{ return Trust; }
	
"get_structure"			{ return Get_Structure; }
"get_constant"			{ return Get_Constant; }
"get_variable"			{ return Get_Variable; }
"get_value"			{ return Get_Value; }
	
"put_structure"			{ return Put_Structure; }
"put_definition"		{ return Put_Definition; }
"put_constant"			{ return Put_Constant; }
"put_variable"			{ return Put_Variable; }
"put_value"			{ return Put_Value; }
"put_void"                      { return Put_Void; }

"unify_void"                    { return Unify_Void; }
"unify_variable"		{ return Unify_Variable; }
"unify_value"			{ return Unify_Value; }
"unify_constant"		{ return Unify_Constant; }

"execute"			{ return Execute; }
"meta_execute"			{ return Meta_Execute; }
"demo_execute"			{ return Demo_Execute; }
"inline"			{ return Inline; }
"builtin"                       { return Builtin; }
"halt"                          { return Halt; }

"label"                         { return Label; }
"fail"                          { return Fail; }

"load"				{ return LOAD;}
"quit"				{ return QUIT; }
"QUIT"				{ return QUIT; }
"cd" 				{ return CD; }
"go"				{ return GO; }
	
"predicate"			{ return PREDICATE; }
[a-zA-Z_$=\\][[a-zA-Z_0-9$=\\]* { return ATOMNAME; }
"'"[\01-\46\50-\176\t]+"'"      { int i=0;
				  int j=1;
				  
				  parseatom:
				  if(yytext[j] == 39)
				    if(yytext[j+1] == 39)
				      j++;
				    else {
				      yytext[i]=0;
				      return ATOMNAME;
				    }
				  yytext[i]=yytext[j];
				  i++; j++;
				  goto parseatom;
				}
"("				{ return LPAR; }
")"				{ return RPAR; }
"/"				{ return SLASH; }
[0-9]+				{ return NUMBER; }
"-"[0-9]+			{ return NUMBER; }
[\n\t ]			        ;
%[\40-\176\t]*		        ;
<<EOF>>				{ yyin = inputfilea[--infilecount]; 
				  YY_NEW_FILE; 
                                  return END; }

