/*    File:	 inline.h  (~bevemyr/KAM/Emulator/inline.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Mar 25 10:16:45 1992
 *    Purpose:   
 */ 

#define INLINE_TABLE_SIZE 2

#define InArgProto         long *, TAGGED *
#define InArg              regs, areg
#define InArgDec           register long *regs ; register TAGGED *areg 

#define GetInlineArity(F)  inline_table[F].arity
#define GetInlineFnk(F)    inline_table[F].fnk
#define GetInlineName(F)   inline_table[F].pname

typedef struct {
  char *pname;
  int  arity;
  BOOL (*fnk) PROTO((InArgProto));
} inline_entry;

extern inline_entry inline_table[];

extern void init_inline PROTO(());

