/*    File:	 database.h  (~bevemyr/KAM/Emulator/database.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Mar 23 19:59:59 1992
 *    Purpose:   Example database include file.
 */ 

typedef enum {
    ENTER_EMULATED,
    ENTER_C,
    ENTER_UNDEFINED
} enter_inst;

union definfo {
  code *incoreinfo;
  BOOL (*cinfo)();
};

typedef struct definition {
    enter_inst enter_instruction;
    TAGGED name;
    union definfo entry_code;
    struct definition *next;
} definition;

extern definition *get_definition PROTO((TAGGED));
extern void store_c_predicate PROTO((TAGGED, BOOL ()));
extern void store_emulated_predicate PROTO((TAGGED, code *));
extern void init_database PROTO(());

