/*    File:	 database.c  (~bevemyr/KAM/Emulator/database.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Mar 24 11:03:16 1992
 *    Purpose:   Example database code.
 */ 

#include "include.h"

/* The database consists of a hash table containing buckets.
 * Each bucket is a definition structure containing all necessary
 * information about the predicate.
 * We use the functor as key in the hash table.
 */

#define HashFunctor(F) (ArityOf(F)+(((unsigned long) F) >> 2)) % PREDHASHLEN

definition *predtable[PREDHASHLEN];

definition *make_undefined(name, next)
    TAGGED name;
    definition *next;
{
    definition *def;

    def = (definition *) static_alloc(sizeof(definition));
    def->enter_instruction = ENTER_UNDEFINED;
    def->name = name;
    def->next = next;

    return def;
}

definition *get_definition(name)
    TAGGED name;
{
    register definition *bucket;
    register int hv;

    hv = HashFunctor(name);

    for(bucket = predtable[hv];
	bucket != NULL;
	bucket = bucket->next)
      {
	if(bucket->name == name)
	  return bucket;
      }
    
    predtable[hv] = make_undefined(name,predtable[hv]);
    return predtable[hv];
}

void store_emulated_predicate(name,c)
    TAGGED name;
    code *c;
{
    definition *def = get_definition(name);

    def->enter_instruction = ENTER_EMULATED;
    def->entry_code.incoreinfo = c;
}

void store_c_predicate(name,func)
    TAGGED name;
    BOOL (*func)();
{
    definition *def = get_definition(name);

    def->enter_instruction = ENTER_C;
    def->entry_code.cinfo = func;
}

void init_database()
{
    int i;

    for(i=0 ; i != PREDHASHLEN ; i++)
	predtable[i] = NULL;
}
