/*    File:	 builtin.c  (~bevemyr/KAM/Emulator/builtin.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Mar 25 11:12:00 1992
 */ 

#include "include.h"
#include "builtin.h"

void pl_display_args(arity, t)
    int arity;
    TAGGED *t;
{
    register TAGGED Term;

    arity -= 1;

    while(arity--) {
	Deref(Term,*t);
	switch(TagOf(Term)) {
	case VAR:
	    printf("_%ld",(long) Term);
	    break;
	case CON:
	    /* Use subtag to determine if atom or integer */
	    if(IsAtom(Term)) {
		printf("%s",GetString(Term));
	    } else {
		printf("%d",GetInteger(Term));
	    }
	    break;
	case STR:
	    printf("%s(",GetString(FunctorToAtom(GetFunctor(Term))));
	    pl_display_args(GetArity(Term),GetArg(Term,0));
	    printf(")");
	    break;
	}
	t++;
	printf(",");
    }

    Deref(Term,*t);
    switch(TagOf(Term)) {
    case VAR:
	printf("_%ld",(long) Term);
	break;
    case CON:
	/* Use subtag to determine if atom or integer */
	if(IsAtom(Term)) {
	    printf("%s",GetString(Term));
	} else {
	    printf("%d",GetInteger(Term));
	}
	break;
    case STR:
	printf("%s(",FunctorToAtom(GetFunctor(Term)));
	pl_display_args(GetArity(Term),GetArg(Term,0));
	printf(")");
	break;
    }
}

BOOL pl_display(Arg)
    ArgDec;
{
    register TAGGED Term;

    Deref(Term,X(0));

    switch(TagOf(Term)) {
    case VAR:
	printf("_%ld",(long) Term);
	break;
    case CON:
	/* Use subtag to determine if atom or integer */
	if(IsAtom(Term)) {
	    printf("%s",GetString(Term));
	} else {
	    printf("%d",GetInteger(Term));
	}
	break;
    case STR:
	printf("%s(",FunctorToAtom(GetFunctor(Term)));
	pl_display_args(GetArity(Term),GetArg(Term,0));
	printf(")");
	break;
    }

    return TRUE;
}

BOOL pl_nl(Arg)
    ArgDec;
{
    printf("\n");
    return TRUE;
}
