/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * dont_care_op.h
 *
 * This is the header for the "Don't Care" operator.  It is meant to be
 * used in PCN programs in places where you don't care whether a
 * sequential block or a parallel block is used.
 *
 * For example, you might have a procedure:
 *
 *	p()
 *	{DC
 *		do_thing_1(),
 *		do_thing_2()
 *	}
 *
 * In this case, they will be done either sequentially or in parallel
 * depending on which is more efficient and better suited on a
 * particular architecture.
 *
 * In addition, the DC_PREFERENCE is set to DC_PREFER_SEQUENTIAL if
 * sequential operation is better suited on a particular architecture,
 * or to DC_PREFER_PARALLEL if parallel operation is better suited
 * on an architecture.  These can be used with #ifdef's in your
 * code to customize the code to a particular preference.
 */

#ifndef _PCN_INCLUDE_DONT_CARE_OP_H
#define _PCN_INCLUDE_DONT_CARE_OP_H

#define DC_PREFER_PARALLEL	0
#define DC_PREFER_SEQUENTIAL	1

#ifndef DC_PREFERENCE
#define DC_PREFERENCE DC_PREFER_SEQUENTIAL
#endif

#if DC_PREFERENCE == DC_PREFER_PARALLEL
#define DC ||
#else
#define DC ;
#endif

#endif /* _PCN_INCLUDE_DONT_CARE_OP_H */
