
/* C code for using PTN_LIB_PATH environment variable */

#include <stdio.h>
#include "pcn_c_hdr.h"
#include "pcn_types.h"

#define MAX_LIB_PATH	128	/* Max length of path to .lib files */
#define MAX_PATH_LENGTH 1024	/* max length of any file path */

extern FILE * _p_open_file_in_pcn_path();

#ifndef DEFAULT_PTN_LIB_PATH
#define DEFAULT_PTN_LIB_PATH ""
#endif

static char _p_lib_path_string[MAX_PATH_LENGTH];

static lib_path_length=0;
static char *lib_path[MAX_PATH_LENGTH];

/*
 *	_p_init_lib_path()
 *
 * This sets up the (local) lib_path data structure which is used for
 * searching for pam files.
 *
 * We first initialize _p_lib_path_string with the lib path
 */
void _p_init_lib_path()
{
    char *p1, *p2;
    int done;
    char *s;
    static char *default_ptn_lib_path = DEFAULT_PTN_LIB_PATH;

    _p_lib_path_string[0] = '\0';

    s = (char *) getenv("PTN_LIB_PATH");
    if (s == (char *) NULL)
	s = default_ptn_lib_path;
    
    if ((strlen(s) + 1) >= MAX_PATH_LENGTH)
    {
	printf("The PTN_LIB_PATH string is too long");
	exit(1);
    }
    strcpy(_p_lib_path_string, s);

    /*
     * The _p_lib_path_string variable should be a colon separated
     * list of paths.  There should be no spaces or tabs in the path, and
     * all paths should be absolute paths.
     */
    lib_path_length = 0;
    if (_p_lib_path_string[0] != '\0')
    {
	p1 = _p_lib_path_string;
	for (done = 0; !done ;)
	{
	    if (lib_path_length >= MAX_LIB_PATH)
	    {
		printf("Warning: PTN_LIB_PATH environment variable has too many components\n");
		break;
	    }
	    p2 = (char *) strchr(p1, ':');
	    if (p2 == (char *) NULL)
		done = 1;
	    else
		*p2++ = '\0';
	    lib_path[lib_path_length++] = p1;
	    p1 = p2;
	}
    }
}

lib_path_len(len)
int_t *len;
{
  *len = (int_t) lib_path_length;
}

lib_next_file(file,findex,path)
char file[], path[]; int_t *findex;
{
  sprintf(path,"%s/%s",lib_path[*findex],file);
}


try_open(file,r)
char file[]; int_t *r;
{
    FILE *fd;
    if((fd=fopen(file,"r"))==NULL)
	*r=0;
    else {
	*r=1;
	fclose(fd);
    }
}


void _p_open_pcnfile(fbase, file, found)
char *fbase, *file;
int_t *found;
{
  FILE *fd;
  char *p;

  *found = 0;
  if ( (fd = _p_open_file_in_pcn_path(".", fbase, file)) != NULL )
    {
      *found = 1;
      p = strrchr(file,'.');
      p[0] = '\0';  /* cut the extention .pcn */
      fclose(fd);
    }
}

