#ifndef PCN

/*
 * Primitives
 */

#define TAG_SKIP                0
#define TAG_RUN                 1
#define TAG_MAKE_TUPLE          2
#define TAG_DEFINE              3
#define TAG_ASSIGN              4
#define TAG_CAPABILITY          5

/*
 * Expression operators
 */

#define TAG_LENGTH              6
#define TAG_PLUS                7
#define TAG_MINUS               8
#define TAG_TIMES               9
#define TAG_DIV                 10
#define TAG_MODULO              11

/*
 * Match operators
 */

#define TAG_LESS_THAN           12
#define TAG_LESS_EQUAL          13
#define TAG_GREATER_THAN        14
#define TAG_GREATER_EQUAL       15
#define TAG_EQUAL               16
#define TAG_NOT_EQUAL           17
#define TAG_MATCH               18

/*
 * Type tests
 */

#define TAG_DATA                19
#define TAG_INT                 20
#define TAG_DOUBLE              21
#define TAG_CHAR                22
#define TAG_STREAM              23

/*
 * Implication stuff
 */

#define TAG_IMPLIES             24
#define TAG_DEFAULT             25
#define TAG_GUARD_INFIX_OP      26
#define TAG_GUARD_CALL          27
#define TAG_GUARD_TYPE_TEST     28

/*
 * Pieces of terms
 */

#define TAG_STRING_CONST        29
#define TAG_INTEGER_CONST       30
#define TAG_DOUBLE_CONST        31
#define TAG_TUPLE               32
#define TAG_VAR                 33
#define TAG_EXP                 34

/*
 * Variables whose values should be interpolated into a quoted block
 */

#define TAG_INTERP_VAR          35

/*
 * Composition operators and other "flow of control"
 */

#define TAG_PAR_COMP            36
#define TAG_SEQ_COMP            37
#define TAG_CHOICE_COMP         38
#define TAG_USER_DEF_COMP       39
#define TAG_BLOCK               40
#define TAG_CALL                41
#define TAG_DIRECTIVE           42
#define TAG_IN                  43
#define TAG_OVER                44
#define TAG_PRIM                45
#define TAG_PROGRAM             46

#define TAG_COLON               47
#define TAG_CURRENT_MODULE	48

#define D_TAG_SKIP                  _p_co_new_tag(TAG_SKIP)
#define D_TAG_RUN                   _p_co_new_tag(TAG_RUN)
#define D_TAG_MAKE_TUPLE            _p_co_new_tag(TAG_MAKE_TUPLE)
#define D_TAG_DEFINE                _p_co_new_tag(TAG_DEFINE)
#define D_TAG_ASSIGN                _p_co_new_tag(TAG_ASSIGN)
#define D_TAG_CAPABILITY            _p_co_new_tag(TAG_CAPABILITY)
#define D_TAG_LENGTH                _p_co_new_tag(TAG_LENGTH)
#define D_TAG_PLUS                  _p_co_new_tag(TAG_PLUS)
#define D_TAG_MINUS                 _p_co_new_tag(TAG_MINUS)
#define D_TAG_TIMES                 _p_co_new_tag(TAG_TIMES)
#define D_TAG_DIV                   _p_co_new_tag(TAG_DIV)
#define D_TAG_MODULO                _p_co_new_tag(TAG_MODULO)
#define D_TAG_LESS_THAN             _p_co_new_tag(TAG_LESS_THAN)
#define D_TAG_LESS_EQUAL            _p_co_new_tag(TAG_LESS_EQUAL)
#define D_TAG_GREATER_THAN          _p_co_new_tag(TAG_GREATER_THAN)
#define D_TAG_GREATER_EQUAL         _p_co_new_tag(TAG_GREATER_EQUAL)
#define D_TAG_EQUAL                 _p_co_new_tag(TAG_EQUAL)
#define D_TAG_NOT_EQUAL             _p_co_new_tag(TAG_NOT_EQUAL)
#define D_TAG_MATCH                 _p_co_new_tag(TAG_MATCH)
#define D_TAG_DATA                  _p_co_new_tag(TAG_DATA)
#define D_TAG_INT                   _p_co_new_tag(TAG_INT)
#define D_TAG_DOUBLE                _p_co_new_tag(TAG_DOUBLE)
#define D_TAG_CHAR                  _p_co_new_tag(TAG_CHAR)
#define D_TAG_STREAM                _p_co_new_tag(TAG_STREAM)
#define D_TAG_IMPLIES               _p_co_new_tag(TAG_IMPLIES)
#define D_TAG_DEFAULT               _p_co_new_tag(TAG_DEFAULT)
#define D_TAG_GUARD_INFIX_OP        _p_co_new_tag(TAG_GUARD_INFIX_OP)
#define D_TAG_GUARD_CALL            _p_co_new_tag(TAG_GUARD_CALL)
#define D_TAG_GUARD_TYPE_TEST       _p_co_new_tag(TAG_GUARD_TYPE_TEST)
#define D_TAG_STRING_CONST          _p_co_new_tag(TAG_STRING_CONST)
#define D_TAG_INTEGER_CONST         _p_co_new_tag(TAG_INTEGER_CONST)
#define D_TAG_DOUBLE_CONST          _p_co_new_tag(TAG_DOUBLE_CONST)
#define D_TAG_TUPLE                 _p_co_new_tag(TAG_TUPLE)
#define D_TAG_VAR                   _p_co_new_tag(TAG_VAR)
#define D_TAG_EXP                   _p_co_new_tag(TAG_EXP)
#define D_TAG_INTERP_VAR            _p_co_new_tag(TAG_INTERP_VAR)
#define D_TAG_PAR_COMP              _p_co_new_tag(TAG_PAR_COMP)
#define D_TAG_SEQ_COMP              _p_co_new_tag(TAG_SEQ_COMP)
#define D_TAG_CHOICE_COMP           _p_co_new_tag(TAG_CHOICE_COMP)
#define D_TAG_USER_DEF_COMP         _p_co_new_tag(TAG_USER_DEF_COMP)
#define D_TAG_BLOCK                 _p_co_new_tag(TAG_BLOCK)
#define D_TAG_CALL                  _p_co_new_tag(TAG_CALL)
#define D_TAG_DIRECTIVE             _p_co_new_tag(TAG_DIRECTIVE)
#define D_TAG_IN                    _p_co_new_tag(TAG_IN)
#define D_TAG_OVER                  _p_co_new_tag(TAG_OVER)
#define D_TAG_PRIM                  _p_co_new_tag(TAG_PRIM)
#define D_TAG_PROGRAM               _p_co_new_tag(TAG_PROGRAM)
#define D_TAG_COLON                 _p_co_new_tag(TAG_COLON)
#define D_TAG_CURRENT_MODULE	    _p_co_new_tag(TAG_CURRENT_MODULE)

static char *tagnames[] = {
    "SKIP",                 /* 0 */
    "RUN",                  /* 1 */
    "MAKE_TUPLE",           /* 2 */
    "DEFINE",               /* 3 */
    "ASSIGN",               /* 4 */
    "CAPABILITY",           /* 5 */
    "LENGTH",               /* 6 */
    "PLUS",                 /* 7 */
    "MINUS",                /* 8 */
    "TIMES",                /* 9 */
    "DIV",                  /* 10 */
    "MODULO",               /* 11 */
    "LESS_THAN",            /* 12 */
    "LESS_EQUAL",           /* 13 */
    "GREATER_THAN",         /* 14 */
    "GREATER_EQUAL",        /* 15 */
    "EQUAL",                /* 16 */
    "NOT_EQUAL",            /* 17 */
    "MATCH",                /* 18 */
    "DATA",                 /* 19 */
    "INT",                  /* 20 */
    "DOUBLE",               /* 21 */
    "CHAR",                 /* 22 */
    "STREAM",               /* 23 */
    "IMPLIES",              /* 24 */
    "DEFAULT",              /* 25 */
    "GUARD_INFIX_OP",       /* 26 */
    "GUARD_CALL",           /* 27 */
    "GUARD_TYPE_TEST",      /* 28 */
    "STRING_CONST",         /* 29 */
    "INTEGER_CONST",        /* 30 */
    "DOUBLE_CONST",         /* 31 */
    "TUPLE",                /* 32 */
    "VAR",                  /* 33 */
    "EXP",                  /* 34 */
    "INTERP_VAR",           /* 35 */
    "PAR_COMP",             /* 36 */
    "SEQ_COMP",             /* 37 */
    "CHOICE_COMP",          /* 38 */
    "USER_DEF_COMP",        /* 39 */
    "BLOCK",                /* 40 */
    "CALL",                 /* 41 */
    "DIRECTIVE",            /* 42 */
    "IN",                   /* 43 */
    "OVER",                 /* 44 */
    "PRIM",                 /* 45 */
    "PROGRAM",              /* 46 */
    "COLON",                /* 47 */
    "CURRENT_MODULE",       /* 48 */
    (char *) 0, 
};

static int num_tags = 49;

#else /* PCN*/

#include "pcn_co_tags.h"

#define TAGS_TUPLE { \
    SKIP, \
    RUN, \
    MAKE_TUPLE, \
    DEFINE, \
    ASSIGN, \
    CAPABILITY, \
    LENGTH, \
    PLUS, \
    MINUS, \
    TIMES, \
    DIV, \
    MODULO, \
    LESS_THAN, \
    LESS_EQUAL, \
    GREATER_THAN, \
    GREATER_EQUAL, \
    EQUAL, \
    NOT_EQUAL, \
    MATCH, \
    DATA, \
    INT, \
    DOUBLE, \
    CHAR, \
    STREAM, \
    IMPLIES, \
    DEFAULT, \
    GUARD_INFIX_OP, \
    GUARD_CALL, \
    GUARD_TYPE_TEST, \
    STRING_CONST, \
    INTEGER_CONST, \
    DOUBLE_CONST, \
    TUPLE, \
    VAR, \
    EXP, \
    INTERP_VAR, \
    PAR_COMP, \
    SEQ_COMP, \
    CHOICE_COMP, \
    USER_DEF_COMP, \
    BLOCK, \
    CALL, \
    DIRECTIVE, \
    IN, \
    OVER, \
    PRIM, \
    PROGRAM, \
    COLON, \
    CURRENT_MODULE \
}

#endif /* PCN*/

