/*
 * PCN System Compiler -- pcncomp
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * co_cpp.c
 *
 * Support procedures for co_cpp.pcn
 */

#include "pcn_c_hdr.h"
#include "pcn_types.h"

#include "driver_conf.h"

#ifndef CPP_PATH
#define CPP_PATH "/lib/cpp"
#endif

#ifndef CPP_PREPEND_ARGS
#define CPP_PREPEND_ARGS "-DPCN"
#endif

#ifndef CPP_APPEND_ARGS
#define CPP_APPEND_ARGS "-I/usr/local/pcn/include"
#endif

_p_get_cpp_args(cpp_path, cpp_prepend_args, cpp_append_args)
char_t *cpp_path, *cpp_prepend_args, *cpp_append_args;
{
    strcpy(cpp_path, CPP_PATH);
    strcpy(cpp_prepend_args, CPP_PREPEND_ARGS);
    strcpy(cpp_append_args, CPP_APPEND_ARGS);
}
