typedef struct {
    char *name;
    void *value;
} AssocArrayEntry;

typedef struct {
    AssocArrayEntry *entries;
    int nEntries;
    int nEntriesAlloc;
    char *name;
} AssocArray;

typedef struct
{
    AssocArray *a;
    int n;
} AssocState;

#ifdef ANSI_PROTOTYPING
AssocArray *assoc_new();
int assoc_lookup_entry_idx(AssocArray *a, char *name);
void assoc_assign(AssocArray *a, char *name, void *val);
void *assoc_lookup(AssocArray *a, char *name);

void assoc_dump(AssocArray *a, FILE *fp);
void *assoc_delete(AssocArray *a, char *name);

AssocState *assoc_iter_init(AssocArray *a);
AssocState *assoc_iter_next(AssocState *a);
char *assoc_this_key(AssocState *s);
void *assoc_this_value(AssocState *s);
#else  /* ANSI_PROTOTYPING */
AssocArray *assoc_new();
int assoc_lookup_entry_idx();
void assoc_assign();
void *assoc_lookup();

void assoc_dump();
void *assoc_delete();

AssocState *assoc_iter_init();
AssocState *assoc_iter_next();
char *assoc_this_key();
void *assoc_this_value();
#endif /* ANSI_PROTOTYPING */
