#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Widgets.c,v 1.1 1992/04/17 18:27:08 mei Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <string.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "Xsw.h"

#include <X11/Shell.h>
#include <X11/Xatom.h>
#include <X11/Xaw/Command.h>

typedef struct {
  StringList name;
} NameData, *NameDataPtr;

static XtResource libdir_resources[] = {
  { "libDir", "LibDir", XtRStringList, sizeof (StringList),
      XtOffset(NameDataPtr, name), XtRString, "." },
};

typedef struct {
  Widget w;
  XtGrabKind type;
  Widget origin_w;
  PType position;
} PopupData;


String 
XswGetLibName(name)
String name;
{
  char text[MAXPATHLEN+2];
  StringList paths;
  struct stat buf;

  paths = XswLibDir(XswTopWidget());

  if (! stat(name, &buf) )
    return XtNewString(name);
  else {
    while (*paths != NULL) {
      sprintf(text, "%s/%s", *paths, name);
      if (! stat(text, &buf)) 
	return XtNewString(text);
      paths++;
    }
  }

  return XtNewString(name);
}


/* ARGSUSED */
void 
XswFreeMemCallback(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;	
{
    XtFree(client_data);
}

int
XswCountStrings(list)
StringList list;
{
  int i;
  
  if (list == NULL) return 0;

  i = 0;
  while (list[i] != NULL) i++;

  return i;
}

void
XswFreeStringList(list)
StringList list;
{
  int i;
  
  if (list != NULL) {
    i = 0;
    while (list[i] != NULL) XtFree(list[i++]);
    
    XtFree((char *) list);
  }
}

/* ARGSUSED */
void 
XswFreeStringListCallback(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;	
{
    XswFreeStringList((StringList)client_data);
}

/* ARGSUSED */
void 
XswDestroyWidgetCallback(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;	
{
    XtDestroyWidget((Widget)client_data);
}

/* ARGSUSED */
void
XswExitProgramCallback(widget, client, call)
Widget widget;
XtPointer client, call;
{
  exit((int)client);
}

	
/* ARGSUSED */
void 
XswDestroyWidgetAction(w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     int num_params;
{
    XtDestroyWidget(w); 
}

/* ARGSUSED */
void 
XswPopdownAction(w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     int num_params;
{
    XtPopdown(w); 
}

/* ARGSUSED */
void
XswCallCallbacksAction(w,event,params,num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
  XtCallCallbacks(w,XtNcallback,(XtPointer) NULL);
}

void
XswPositionPopup(w, position)
Widget w;
PType position;
{
  XswPositionWidget(w, XtParent(XtParent(w)), position);
}

void
XswPositionWidget(w, origin_w, position)
Widget w, origin_w;
PType position;
{
  Arg		args[5];
  Position	x, y;
  Dimension	width, height;
  Dimension     parent_width, parent_height;
  Cardinal	n;
  Window child;
  int x0, y0;

  if (position != XswMouse) {
    n = 0;
    XtSetArg(args[n], XtNwidth, &parent_width); n++;
    XtSetArg(args[n], XtNheight, &parent_height); n++;
    XtGetValues(origin_w, args, n);  
  }

  n = 0;
  XtSetArg(args[n], XtNwidth, &width); n++;
  XtSetArg(args[n], XtNheight, &height); n++;
  XtGetValues(w, args, n);
  
  switch (position) {
  case XswCenter:
    XtTranslateCoords(origin_w,  /* Widget */
		      (Position) parent_width/2,        /* x */
		      (Position) parent_height/2,       /* y */
		      &x, &y);          /* coords on root window */
  
    x -= width/2; y -= height/2;
    break; 
  case XswRight:
    XtTranslateCoords(origin_w,  /* Widget */
		      (Position) parent_width,        /* x */
		      (Position) parent_height/2,       /* y */
		      &x, &y);          /* coords on root window */
    y -= height/2;
    break; 
  case XswLeft:
    XtTranslateCoords(origin_w,  /* Widget */
		      (Position) 0,        /* x */
		      (Position) parent_height/2,       /* y */
		      &x, &y);          /* coords on root window */
  
    x -= width; y -= height/2;
    break; 
  case XswTop:
    XtTranslateCoords(origin_w,  /* Widget */
		      (Position) parent_width/2,        /* x */
		      (Position) 0,       /* y */
		      &x, &y);          /* coords on root window */
  
    x -= width/2; y -= height;
    break; 
  case XswBottom:
    XTranslateCoordinates(XtDisplay(origin_w), XtWindow(origin_w),
		     ROOTWINDOW(origin_w),
		     (int) parent_width/2,        /* x */
		     (int) parent_height,       /* y */
		     &x0, &y0, &child);   /* coords on root window */
    x = x0; y = y0;
    x -= width/2;
    break; 
  case XswMouse: 
    {
      Window junk1, junk2;
      int root_x, root_y, junkX, junkY;
      unsigned int junkM;
      
      if (True) {
	if (XQueryPointer(XtDisplay(w), 
			  ROOTWINDOW(w),
			  &junk1, &junk2, 
			  &root_x, &root_y, &junkX, &junkY, &junkM)
	    == FALSE) {
	  char error_buf[128];
	  sprintf(error_buf, "%s %s", "Xsw : XswPositionPopup",
		  "Could not find location of mouse pointer");
	  XtAppWarning(XtWidgetToApplicationContext(w), error_buf);
	  return;
	}
	x = (Position) root_x;
	y = (Position) root_y;
      } else {
	x = (Position) 0;
	y = (Position) 0;
	
      }
    }  
    x -= width/2; y -= height/2;
    break;
  }
	
  if (x < 2) 
    x = 2;
  else {
    int scr_width = WidthOfScreen(XtScreen(w));
    if (x + width + 16 > scr_width)
      x = scr_width - width - 16;
  }
  
  if (y < 2)
    y = 2;
  else {
    int scr_height = HeightOfScreen(XtScreen(w));
	    if (y + height + 16 > scr_height)
	      y = scr_height - height - 16;
  }
    
  n = 0;
  XtSetArg(args[n], XtNx, x);	n++;
  XtSetArg(args[n], XtNy, y);	n++;
  XtSetValues(XtParent(w), args, n);
  
}

static Boolean
PopupWhenRealized(popup_data)
PopupData * popup_data;
{
  if (XtIsRealized(popup_data->w) && 
      ((popup_data->position == XswMouse) || 
       (popup_data->origin_w == NULL) ||
       (XtIsRealized(popup_data->origin_w)))) {
    XswPositionWidget(popup_data->w, popup_data->origin_w,
		      popup_data->position);
    XtPopup(XtParent(popup_data->w), popup_data->type);
    XtFree((char *) popup_data);
    return True;
  } else {
/* hui 4/24 */
    XtFree((char *) popup_data);
    return False;
  }
}

XswPopup(w, type, origin_w, position)
Widget w;
XtGrabKind type;
Widget origin_w;
PType position;
{
  PopupData * popup_data;
  Display *dpy = XtDisplay(XtParent(w));
  Atom wm_delete_window = XInternAtom(dpy, "WM_DELETE_WINDOW", False);

  XtRealizeWidget(XtParent(w));
  (void) XSetWMProtocols(dpy, XtWindow(XtParent(w)), &wm_delete_window, 1);
  XtAugmentTranslations(w,
    XtParseTranslationTable("<Message>WM_PROTOCOLS:XswPopdown()"));

  /* If origin is not realized, then assume that
     we don't want to position with respect to it */
  if (! XtIsRealized(origin_w)) origin_w = NULL;

  if (XtIsRealized(w) && 
      ((position == XswMouse) || (origin_w == NULL) ||
       (XtIsRealized(origin_w)))) {

    if (position == XswMouse || ((origin_w != NULL) && XtIsRealized(origin_w)))
      XswPositionWidget(w, origin_w, position);

    XtPopup(XtParent(w), type);
  } else {
    popup_data = (PopupData *)XtMalloc(sizeof(PopupData));
    popup_data->w = w;
    popup_data->origin_w = origin_w;
    popup_data->position = position;
    popup_data->type = type;
    (void)XtAppAddWorkProc(XtWidgetToApplicationContext(w),
			   PopupWhenRealized,popup_data);
  }
}

Widget
XswPopupBox(w, name, text)
Widget w;
String name;
String text;
{
  return XswPopupBoxPlus(w, name, text, XswCenter, XtGrabNone);
}


Widget
XswPopupBoxPlus(w, name, text, position, type)
Widget w;
String name;
String text;
PType position;
XtGrabKind type;
{
    Widget	popup, label;
    Widget      original_parent = w;
    Arg		args[5];

    /* The following line is needed because many composite widgets
       cause unpredictable behavior if they are given a Shell child 
       and then that child is destroyed. This is a bug in either
       the intrinsics or the Athena Widget set. */
    while (XtIsComposite(w) && !XtIsShell(w)) w = XtParent(w);

    popup = XtCreatePopupShell(name, transientShellWidgetClass, w,
			       NULL, 0);

    XtSetArg(args[0], XtNlabel, text);

    label = XtCreateManagedWidget("text", commandWidgetClass,
				  popup,args, 1);

    XtAddCallback(label, XtNcallback, 
		  XswDestroyWidgetCallback, (XtPointer)popup);

    XswPopup(label, type, original_parent, position);

    return popup;
}

XswProcessTool(name,cmd) {}


XswSetWMNames(w,wname,iname)
     Widget w;
     String wname, iname;
{
  while (!XtIsShell(w)) w = XtParent(w);
  if (XtIsRealized(w)) {
    XChangeProperty(XtDisplay(w), XtWindow(w),
		    XA_WM_NAME, XA_STRING, 8, PropModeReplace,
		    (unsigned char *) wname, strlen(wname));
    
    XChangeProperty(XtDisplay(w), XtWindow(w),
		    XA_WM_ICON_NAME, XA_STRING, 8, PropModeReplace,
		    (unsigned char *) iname, strlen(iname));
  } else {
    Arg argList[3];
    int args = 0;
    XtSetArg(argList[args], XtNtitle, wname); args++;
    XtSetArg(argList[args], XtNiconName, iname); args++;
    XtSetValues(w, argList, args);
  }
}


static XtAppContext application_context=NULL;

XtAppContext XswApplicationContext()
{
  return application_context;
}

void
XswMainLoop()
{
  application_context = NULL;
  for (;;) {
    XEvent event;
    XswDisplayWarnings(NULL);
    XtNextEvent(&event);
    XtDispatchEvent(&event);
  }
}

void
XswAppMainLoop(app_context)
XtAppContext app_context;
{
  application_context = app_context;
  for (;;) {
    XEvent event;
    XswDisplayWarnings(app_context);
    XtAppNextEvent(app_context, &event);
    XtDispatchEvent(&event);
  }
}

static NameData lib_data;
static Widget TopWidget;

StringList
XswLibDir(w)
Widget w;
{
  return lib_data.name;
}

Widget
XswTopWidget()
{
  return TopWidget;
}

void
XswInitialize(parent)
Widget parent;
{
  
  static XtActionsRec window_actions[] = {
    { "XswDestroy", XswDestroyWidgetAction },
    { "XswQuit", XswDestroyWidgetAction },
    { "XswPopdown", XswPopdownAction },
    { "XswCallCallbacks", XswCallCallbacksAction },
  };

  Display *dpy;

  XtSetWarningHandler(XswWarning);
  XtSetErrorHandler(XswError);
  XswInitConverters(parent);

  XtGetApplicationResources(parent, &lib_data, libdir_resources, 
			    XtNumber(libdir_resources), NULL, 0);

  TopWidget = parent;
  /*XswCreateHelpWidget(parent);*/
  
  XtAppAddActions(XtWidgetToApplicationContext(parent),
		  window_actions, XtNumber(window_actions));

  XswRegisterCallback("XswExitProgramCallback", 
		      XswExitProgramCallback, (XtPointer)0);  
  XswRegisterCallback("XswDestroyWidget", 
		      XswDestroyWidgetCallback, (XtPointer)0);  
}







