

/* 
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/ScaleP.h,v 1.2 91/09/13 17:01:49 carl Exp $
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

/* ScaleP.h - Private definitions for Scale widget
 * 
 * This is the Scale widget, it is useful to display a scale, without the
 * overhead of having a widget for each item in the scale. */

#ifndef _XawScaleP_h
#define _XawScaleP_h

/***********************************************************************
 *
 * Scale Widget Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/SimpleP.h>
#include "Scale.h"


/* New fields for the Scale widget class record */

typedef struct {int foo;} ScaleClassPart;

/* Full class record declaration */
typedef struct _ScaleClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    ScaleClassPart	scale_class;
} ScaleClassRec;

extern ScaleClassRec scaleClassRec;

/* New fields for the Scale widget record */
typedef struct {
    /* resources */
    Pixel	foreground;
    int         longest;
    int         indent;
    int      axis_length;	/* number of items in the scale. */
    XFontStruct	*font;
    Boolean     vertical;
    Boolean     log;
    double      maximum;
    double      minimum;
    XtCallbackList  callback;

    /* private state */

    int         old_width, old_height;
    double      interval;
    double      maxinterval, mininterval;
    int         numIntervals;
    GC		normgc,		/* a couple o' GC's. */
                cleargc;		/* used when inactive. */

} ScalePart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _ScaleRec {
    CorePart	core;
    SimplePart	simple;
    ScalePart	scale;
} ScaleRec;

#endif /* _XawScaleP_h */
