#ifndef _XtQuerySet_h
#define _XtQuerySet_h
/*
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/QuerySet.h,v 1.2 91/09/13 17:01:41 carl Exp $
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

/* Resources:

 Name                Class              RepType         Default Value
 ----                -----              -------         -------------
 directory           Directory          Widget          NULL
 fileTags            FileTags           StringList      file
 help                Help               Widget          NULL
 names               Names              SCPairList      Query Popup

*/

#define XtNdirectory "directory"
#define XtNfileTags "fileTags"
#define XtNhelp "help"
#define XtNnames    "names"

#define XtCDirectory "Directory"
#define XtCFileTags "FileTags"
#define XtCHelp      "Help"
#define XtCNames    "Names"

typedef struct _QuerySetRec *QuerySet;
typedef struct _QuerySetClassRec *QuerySetClass;


#ifndef QUERYSET
externalref WidgetClass querySetClass;
#endif

/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/

/*      Function Name: QuerySetPopdownCurrent.
 *      Description: Pops down the currently visible Query widget.
 *      Arguments: qs - the QuerySet object.
 *      Returns: none.
 */
void XswQuerySetPopdownCurrent(/*QuerySet qs*/);


/*      Function Name: QuerySetPopup.
 *      Description: Pops up the named Query widget.
 *      Arguments: qs - the QuerySet object.
 *                 name - the name of the Query widget to pop up.
 *      Returns: none.
 */
void XswQuerySetPopup(/*QuerySet qs, String name*/);


/*      Function Name: QuerySetSaveValues.
 *      Description: Saves the entries in the currently visible
 *                   Query widget.
 *      Arguments: qs - the QuerySet object.
 *                 ret_struct - a structure containing the current 
 *                      entries in the Query widget.
 *      Returns: none.
 */
void XswQuerySetSaveValues(/*QuerySet qs, 
			     XswQueryReturnStruct * ret_struct*/);


/*      Function Name: QuerySetValue.
 *      Description: Sets the a single text field of the given 
 *                   Query widget.
 *      Arguments: qs - the QuerySet object.
 *                 queryname - the name of the Query widget to set.
 *                 tag - indicates which text field in the Query 
 *                       widget should be set.
 *                 value - the text to be placed in the indicated
 *                         text field.
 *      Returns: True if the indicated Query widget exists.
 */
Boolean XswQuerySetValue(/*QuerySet qs, String queryname, String tag,
			 String value*/);

#endif /* _XtRect_h */
/* DON'T ADD STUFF AFTER THIS #endif */

