/*
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/Query.h,v 1.2 91/09/13 17:01:35 carl Exp $
 *
 * Public definitions for Query widget
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _Query_h
#define _Query_h

#include <X11/Xaw/Paned.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 directory           Directory          DType            None
 entries             Entries            StringSet       NULL
 
*/

/* fields added to Form */
#define XtNdirectory            "directory"
#define XtNentries           "entries"

#define XtCDirectory            "Directory"
#define XtCEntries           "Entries"

typedef struct {
  StringList entry;
  StringList file;
  StringList flag;
} XswQueryReturnStruct;

#define XtRDType   "DType"
typedef int DType;

#define NoList 1
#define Single 2
#define Multi 3

extern WidgetClass queryWidgetClass;

typedef struct _QueryClassRec *QueryWidgetClass;
typedef struct _QueryRec  *QueryWidget;


/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/
/*      Function Name: XswQueryClear.
 *      Description: Clear all text fields and directory selections.
 *      Arguments: w - the query widget.
 *      Returns: none.
 */
extern void XswQueryClear(/*Widget w*/);


/*      Function Name: XswQueryGetAll.
 *      Description: Get text fields, directory selections, and tags
 *                   from the query widget.
 *      Arguments: w - the query widget.
 *      Returns: A pointer to an XswQueryReturnStruct with the data.
 */
extern XswQueryReturnStruct * XswQueryGetAll(/*Widget w*/);


/*      Function Name: XswQueryGetEntries.
 *      Description: Get text fields in the entry widget.
 *      Arguments: w - the query widget.
 *      Returns: a StringList of all text fields in the entry widget.
 */
extern StringList XswQueryGetEntries(/*Widget w*/);


/*      Function Name: XswQuerySetEntries.
 *      Description: Set text fields in the entry widget.
 *      Arguments: w - the query widget.
 *                 list - the list of Strings to set entry fields to.
 *      Returns: none.
 */
extern void XswQuerySetEntries(/*Widget w, StringList list*/);


/*      Function Name: XswQueryGetEntry.
 *      Description: Get a single text field from the entry widget.
 *      Arguments: w - the query widget.
 *                 tag - a string used to reference the desired field.
 *      Returns: the String in the requeted field.
 */
extern String XswQueryGetEntry(/*Widget w, String tag*/);


/*      Function Name: XswQuerySetEntry.
 *      Description: Set a single text field in the entry widget.
 *      Arguments: w - the query widget.
 *                 tag - a string used to reference the desired field.
 *                 value - the String to place in the desired field.
 *      Returns: none.
 */
extern void XswQuerySetEntry(/*Widget w, String tag, String value*/);

#endif /* _Query_h */


