#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/MakeIt.c,v 1.4 91/09/13 17:02:31 carl Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include "Xsw.h"
#include "Count.h"

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

void XswMakeMenu(parent, name)
Widget parent;
char * name;
{
  Widget menu_w;
  int i;
  CountData data;
  char item[20];

  menu_w = XtCreatePopupShell(name, simpleMenuWidgetClass, 
			   parent, NULL, 0);

  XtGetApplicationResources(menu_w, &data, cnt_resources, 
			    XtNumber(cnt_resources), NULL, 0);

  (void)XtCreateManagedWidget(name,
			      smeLineObjectClass,
			      menu_w, NULL, 0);


  for(i = 1; i <= data.count; i++) {
    sprintf(item, "item%d", i);
    (void)XtCreateManagedWidget(item,
				smeBSBObjectClass,
				menu_w, NULL, 0);
  }
}



void XswMakeCommandButtons(box_w)
Widget box_w;
{
  int i;
  char name[20];
  CountData data;

  XtGetApplicationResources(box_w, &data, cnt_resources, 
			    XtNumber(cnt_resources), NULL, 0);

  for(i = 1; i <= data.count; i++) {
    (void)sprintf(name, "button%d", i);
    (void)XtCreateManagedWidget(name,
				commandWidgetClass,
				box_w, NULL, 0);
  }
}

/*
  Make a set of radio buttons.
   box_w - parent widget in which to place
           the buttons.
   buttons - a set of existing radio buttons from
           which to initialize the button state
*/

void XswMakeRadioButtons(box_w, buttons)
Widget box_w;
Widget buttons;
{
  int i;
  char name[20];
  CountData data;
  Widget toggle;

  XtGetApplicationResources(box_w, &data, cnt_resources, 
			    XtNumber(cnt_resources), NULL, 0);

  for(i = 1; i <= data.count; i++) {
    sprintf(name, "radio%d", i);    
    toggle = (buttons == (Widget) NULL) ? NULL : XtNameToWidget(buttons,name);
    XswMakeRadioSet(box_w, name, toggle);
  }
}

void XswMakeRadioSet(parent, name, toggle)
Widget parent;
char * name;
Widget toggle;
{  
  static char toggle_trans[] = "<Btn1Down>,<Btn1Up>: set()notify()";

  Widget set_w, t1_w, t2_w;
  Arg wargs[3];
  XtTranslations trans_table;
  char n1[20];
  CountData data;
  int argc;
  int i, pos;
  int truetoggle;
  Boolean state = False;
  Widget first_w = NULL;

  trans_table = XtParseTranslationTable(toggle_trans);

  set_w = XtCreateManagedWidget(name,
				     boxWidgetClass,
			             parent, NULL, 0);

  XtGetApplicationResources(set_w, &data, cnt_resources, 
			    XtNumber(cnt_resources), NULL, 0);

  if (data.count <= 0) data.count = 2;
  t2_w = NULL;
  sprintf(n1, "%sA", name);
  pos = strlen(n1) - 1;
  truetoggle = -1;
  if (toggle != (Widget) NULL)
    truetoggle = (int)XawToggleGetCurrent(XtNameToWidget(toggle,n1));
  for(i=0; i < data.count; i++) {
    argc = 0;
    XtSetArg(wargs[argc], XtNradioData, (i+1)); argc++;
    if (truetoggle > 0) {
      XtSetArg(wargs[argc], XtNstate, False); argc++;
    }
    t1_w = XtCreateManagedWidget(n1,
				 toggleWidgetClass,
				 set_w, wargs, argc);
    if (first_w == NULL) first_w = t1_w;
    XtOverrideTranslations(t1_w, trans_table);
    if (t2_w != NULL) {
      XawToggleChangeRadioGroup(t1_w, t2_w);
      XawToggleChangeRadioGroup(t2_w, t1_w);
    }
    t2_w = t1_w;
    /* Initialize state from existing radio button */
    if (!state) {
      XtSetArg(wargs[0], XtNstate, &state);
      XtGetValues(t1_w, wargs, 1);
      if (state) XtCallCallbacks(t1_w, XtNcallback, (XtPointer)(i+1));
    }
    n1[pos]++;
  }
  if (!state) {
    truetoggle = (truetoggle < 0) ? 1 : truetoggle;
    XawToggleSetCurrent(first_w,(XtPointer) truetoggle);
  }
}  


