/*
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/Help.h,v 1.2 91/09/13 17:01:17 carl Exp $
 *
 * Public definitions for Help widget
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _Help_h
#define _Help_h

#include <X11/Shell.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 helpSet             HelpSet            StringSet      help:default.hlp

*/

/* fields added to Shell */
#define XtNhelpSet      "helpSet"

#define XtCHelpSet      "HelpSet"

extern WidgetClass helpWidgetClass;

typedef struct _HelpClassRec *HelpWidgetClass;
typedef struct _HelpRec  *HelpWidget;


/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/

/*      Function Name: XswHelpShow.
 *      Description: Pops up the Help widget displaying the file
 *                   which corresponds to name.
 *      Arguments: w - the Help widget.
 *                 name - a name from helpSet which is associated
 *                        with the file to display.
 *      Returns: True if name is associated with a valid file.
 */
Boolean XswHelpShow(/*Widget w, String name*/);

#endif /* _HelpShell_h */





