/*
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/Entry.h,v 1.2 91/09/13 17:01:11 carl Exp $
 *
 * Public definitions for Entry widget
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _Entry_h
#define _Entry_h

#include <X11/Xaw/Form.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 callback            Callback           XtCallbackList   NULL
 defaults            Defaults           StringList       NULL
 labels              Labels             StringList       NULL
*/

/* fields added to Form */
#define XtNlabels               "labels"
#define XtNdefaults             "defaults"

#define XtCLabels               "Labels"
#define XtCDefaults             "Defaults"

#define XtNNULL                 "NULL"

extern WidgetClass entryWidgetClass;

typedef struct _EntryClassRec *EntryWidgetClass;
typedef struct _EntryRec  *EntryWidget;


/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/
/*      Function Name: XswEntryGetAll.
 *      Description: Get text fields in the entry widget.
 *      Arguments: w - the entry widget.
 *      Returns: a StringList of all text fields in the entry widget.
 */
extern StringList XswEntryGetAll(/*Widget w*/);


/*      Function Name: XswEntryGetOne.
 *      Description: Get a single text field.
 *      Arguments: w - the entry widget.
 *                 entry - index to desired text field.
 *      Returns: a String of the value of requested text field.
 */
extern String XswEntryGetOne(/*Widget w, Cardinal entry*/);


/*      Function Name: XswEntrySetAll.
 *      Description: Set text fields in the entry widget.
 *      Arguments: w - the entry widget.
 *                 list - StringList of text fields to use.
 */
extern void XswEntrySetAll(/*Widget w, StringList list*/);


/*      Function Name: XswEntrySetOne.
 *      Description: Set a single text field.
 *      Arguments: w - the entry widget.
 *                 entry - index of field to set.
 *                 value - String to put in field.
 */
extern Boolean XswEntrySetOne(/*Widget w, Cardinal entry, String value*/);


/*      Function Name: XswEntryClear.
 *      Description: Clears all text fields in the entry widget.
 *      Arguments: w - the entry widget.
 *      Returns: none.
 */
extern void XswEntryClear(/*Widget w*/);

#endif /* _Entry_h */






