/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Dir.h,v 1.1 1992/04/17 18:24:25 mei Exp $
 *
 * Public definitions for Dir widget
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _Dir_h
#define _Dir_h

#include <X11/Xaw/Form.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 currentDirectory    CurrentDirectory   String            .
 directoryChange     DirectoryChange    CallbackList      NULL
 userDirectory       UserDirectory      CallbackList      NULL
 extensions          Extensions         SCPairList        All
 fullPath            FullPath           Boolean           False
 interval            Interval           Int               10
 selectType          SelectType         SType             Single
 showDirectories     ShowDirectories    Boolean           True
 showDotFiles        ShowDotFiles       Boolean           False
 showBackupFiles     ShowBackupFiles    Boolean           False

*/

/* fields added to Form */
#define XtNcurrentDirectory      "currentDirectory"
#define XtNdirectoryChange       "directoryChange"
#define XtNuserDirectory         "userDirectory"
#define XtNextensions            "extensions"
#define XtNfullPath              "fullPath"
#define XtNinterval              "interval"
#define XtNselectType            "selectType"
#define XtNshowDirectories         "showDirectories"
#define XtNshowDotFiles            "showDotFiles"
#define XtNshowBackupFiles         "showBackupFiles"

#define XtCCurrentDirectory      "CurrentDirectory"
#define XtCDirectoryChange       "DirectoryChange"
#define XtCUserDirectory         "UserDirectory"
#define XtCExtensions            "Extensions"
#define XtCFullPath              "FullPath"
/* hui
#define XtCInterval              "Interval"
*/
#define XtCSelectType            "SelectType"
#define XtCShowDirectories         "ShowDirectories"
#define XtCShowDotFiles            "ShowDotFiles"
#define XtCShowBackupFiles         "ShowBackupFiles"

#define XtNNO_EXTENSION "NO_EXTENSION"

#define XtRSType   "SType"
typedef int SType;

#define Single 2
#define Multi 3

extern WidgetClass dirWidgetClass;

typedef struct _DirClassRec *DirWidgetClass;
typedef struct _DirRec  *DirWidget;

typedef struct {
  char **dir_name;
  char ***file_list;
} UserDirStruct;


/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/

/*      Function Name: XswDirGetEntriesAndClear.
 *      Description: returns selected items and then clears selections.
 *      Arguments: w - the directory widget.
 *      Returns: a list of selected items.
 */
StringList XswDirGetEntriesAndClear(/*Widget w*/);
StringList XswDirGetEntries(/*Widget w*/);

void XswDirUpdate(/*Widget w*/);

#endif /* _Dir_h */

