
/* 
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/ChartP.h,v 1.1 1992/04/17 18:23:02 mei Exp $
 *
 * ChartP.h - Private definitions for Chart widget
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _ORAChartP_h
#define _ORAChartP_h

#include <X11/CoreP.h>
#include "Chart.h"

/* New fields for the Chart widget class record */

typedef struct {
	int make_compiler_happy;	/* keep compiler happy */
} ChartClassPart;

/* Full class record declaration */
typedef struct _ChartClassRec {
    CoreClassPart	core_class;
    ChartClassPart	chart_class;
} ChartClassRec;

extern ChartClassRec chartClassRec;

/* New fields for the Chart widget record */
typedef struct {
    /* resources */
    Pixel	foreground;
    Pixel       highlight;
    XtCallbackList callback;	/* application installed callback function(s) */
    XtCallbackList chart_resize;
    Dimension	width;
    Dimension	height;
    int cell_width, cell_height;
    int cur_x, cur_y;  /* position of visible corner in big pixmap */
    double max_val, min_val; /* maximum and minimum values in chart */
    double *cell;	/* array for keeping track of array of bits */
    Boolean *state;     /* data on whether or not each cell is selected*/
    Boolean twoD;      /* Flag indicating 2 or 3 D chart */
    Boolean zoom;      /* Flag indicating zoom mode */
    Boolean rigid_zoom;      /* Flag indicating type of zoom */
    Boolean log;      /* Flag indicating log scale */
    Boolean box;      /* Flag indicating box cell to select */
    int border;        /* Number of pixels between cells */
    int frame;        /* Number of pixels in box */
    String palette;
    Pixel * colors;
    int * patterns;

    /* private state */
    ChartPointInfo info;
    int save_y, save_x;
    int save_frame, save_border;
    int save_width, save_height;
    Boolean     tog_state;
    int         styles;
    int         values;
    GC          *value_gc;
    GC          *style_gc;
    GC          cleargc; /* for erasing bars */
    GC          boxgc; /* for boxing selections */
} ChartPart;

/*
 * Full instance record declaration
 */
typedef struct _ChartRec {
    CorePart		core;
    ChartPart	        chart;
} ChartRec;

#endif /* _ORAChartP_h */

