#ifndef  _tables_h
#define  _tables_h

/********************************************************/
/*   export function for tables.c                       */
/********************************************************/

/*      Function Name: initialize_procpernode
 *      Function Name: initialize_clausepernode
 *      Description: allocate the header tables for snapshot
 *                   profile data
 *      Arguments:
 *      Returns: none.
 */
extern void initialize_procpernode(
#if NeedFunctionPrototypes
     Histo  *    /* hPtr */,
     Procedure * /* pPtr */
#endif
);
extern void initialize_clausepernode(
#if NeedFunctionPrototypes
     Histo  *   /* hPtr */,
     Clause *   /* clause_model */
#endif
);


/*      Function Name: find_procedure
 *      Description: find the position of the procedure with 
 *                   a given module and a given procedure name
 *      Arguments: modules - hash table for all modules
 *                 module -  module name
 *                 proc - procedure name
 *      Returns: Procedure * 
 */
extern Procedure * find_procedure(
#if NeedFunctionPrototypes
     HBucket **   /* modules */,
     char *       /* module */,
     char *       /* proc */
#endif
);


/*      Function Name: find_module
 *      Description: check to see if the module is in the
 *                   module table. If not, allocate a space
 *                   for it. 
 *      Arguments: modules - hash table for all modules
 *                 module - module name
 *      Returns: Module *
 */
extern Module * find_module(
#if NeedFunctionPrototypes
     HBucket **   /* modules */,
     char *       /* modules */
#endif
);


/*      Function Name: map_procedures
 *      Description: To generate the map_table call on every
 *                   procedures
 *      Arguments: modules - hash table for all modules
 *                 func - given function
 *                 pass - structure returned from the func call
 *      Returns: char *
 */
extern char * map_procedures(
#if NeedFunctionPrototypes
     HBucket **   /* modules */,
     char *(*)()  /* func */,
     char *       /* pass */
#endif
);


/*      Function Name: map_table 
 *      Description: To process every entry in the given hash
 *                   table with the given function.
 *      Arguments: htable - hash table
 *                 func - given function
 *                 pass - structure returned from the func call
 *      Returns: char *
 */
extern char * map_table(
#if NeedFunctionPrototypes
     HBucket **   /* htable */,
     char *(*)()  /* func */,
     char *       /* pass */
#endif
);


/*      Function Name: lookup_module 
 *      Description: To see if the given module exist or not.
 *      Arguments: modules - hash table for all modules
 *                 module - given function
 *      Returns: Module *
 */
extern Module * map_table(
#if NeedFunctionPrototypes
     HBucket **   /* modules */,
     char *       /* module */
#endif
);


/*      Function Name: lookup_procsnapprof 
 *      Description: 
 *      Arguments: 
 *      Returns: 
 */
extern ( 
#if NeedFunctionPrototypes
#endif
);


/*      Function Name: insert_procsnapprof 
 *      Description: 
 *      Arguments: 
 *      Returns: 
 */
extern ( 
#if NeedFunctionPrototypes
#endif
);


/*      Function Name: lookup_clausnapprof
 *      Description: 
 *      Arguments: 
 *      Returns: 
 */
extern ( 
#if NeedFunctionPrototypes
#endif
);


#endif /* _tables_h */
/*      Function Name: lookup_clausnapprof2
 *      Description: 
 *      Arguments: 
 *      Returns: 
 */
extern ( 
#if NeedFunctionPrototypes
#endif
);


#endif /* _tables_h */
/*      Function Name: insert_clausnapprof
 *      Description: 
 *      Arguments: 
 *      Returns: 
 */
extern ( 
#if NeedFunctionPrototypes
    Procedure *  /* pPtr */,
    int          /* clause_sz */,
    int          /* snap_no */,
    int          /* node_no */
#endif
);


#endif /* _tables_h */
