#if (!defined(lint) && !defined(SABER)) 
static char *rcsid = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/RCS/tables.c,v 1.9 1992/04/17 21:11:36 mei Exp $";
#endif

/********************************************************/
/* FILE : tables.c                                      */
/* Content :                                            */
/********************************************************/
#include <stdio.h>
#include <strings.h>
#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#endif

#ifndef _MODEL_H
#include "model.h"
#endif

/* AERO_MASG */

static  char *map_procedures1();

unsigned long hash_entry(name)
     char *name;
{
  register unsigned long y;
  register int i;
  
  for (y = 0; i = (int)(*name++);)
    y <<= 1,
  y += i;
  return y % TABLE_SIZE;
}

/********************************************************/
/* Name : find                                          */
/* Content : To match the KEY with a entry in the TABLE */
/*  if not found, then if need to INSERT then malloc    */
/*  space for it. VALUE returned is the ptr used or to  */
/*  be used for pointing to the "data block" associated */
/*  with this table entry : note, this table maybe the  */
/*  module table or the procedure table                 */
/* Date : OLD routines                                  */
/********************************************************/
char **find(key,htable,insert,found)
     char *key;
     HBucket **htable;
     int insert;
     int *found;
{
  int entry = hash_entry(key);
  HBucket **bucket = htable+entry;
  HBucket *new_bucket;
  char **value;

  while (*bucket != (HBucket *) NULL && strcmp((*bucket)->key,key))
    bucket = &((*bucket)->next);
  if (*bucket == (HBucket *) NULL) {
    *found = 0;
    if (insert) {
      new_bucket = (HBucket *) checkmalloc(sizeof(HBucket),"find");
      value = &(new_bucket->value);
      new_bucket->key = strcpy(checkmalloc(sizeof(char)*(strlen(key)+1),"find"),key);
      new_bucket->next = (HBucket *) NULL;
      *bucket = new_bucket;
    }
    else			/* key not found and insert false */
      value = (char **) NULL;
  }
  else {
    /* key found */
    *found = 1;
    value = &((*bucket)->value);
  }      
  return value;
}

/********************************************************/
/* Name : map_table                                     */
/* Content : step through the given(from argument list) */
/*   table one by one and call the function passed in   */
/*   as an argument (like assign_counter_values or      */
/*   assign_timer_values - to distribute the .cnt data  */
/*   into procedure table) to process on the table entry*/
/* Date : OLD routines                                  */
/********************************************************/
char *map_table(htable,func,pass) /* htable =hash table */
     HBucket **htable;
     char  *(*func)();
     char *pass;
{
  int entry = 0;
  HBucket *bucket;

  while (entry < TABLE_SIZE)
    for(bucket = htable[entry++]; 
	bucket != (HBucket *) NULL;
	bucket = bucket->next)
      pass = (*func)(bucket->key,bucket->value,pass);
  return pass;
}

struct map_args {
  char *(*func)();
  char *pass;
};

/********************************************************/
/* Name : map_procedures+map_procedures1                */
/* Content : to generate the map_table call on the      */
/*   every module and all their procedure tables        */ 
/* Date : OLD routines                                  */
/********************************************************/
/*ARGSUSED*/
char *map_procedures(modules,func,pass)
     HBucket **modules;
     char *(*func)();
     char *pass;
{
  /* char *map_procedures1(); */
  struct map_args args;

  args.func = func;
  args.pass = pass;

  map_table(modules,map_procedures1,(char *)&args);
  return args.pass;
}

/*ARGSUSED*/
static char *map_procedures1(name,module,pass)
     char *name;
     Module *module;
     char *pass;
{
  char *(*func)() = ((struct map_args *) pass)->func;
  char *pass1 = ((struct map_args *) pass)->pass;

  ((struct map_args *) pass)->pass = 
    map_table(module->procedures,func,pass1);

  return pass;
}

/********************************************************/
/* Name : insert_snaptable                              */
/* Content :           */
/* Date : 1/7/92                                        */
/********************************************************/
insert_snaptable(mPtr,node_no,snap_no,snapPtr)
Module *mPtr;
int node_no,snap_no;
ProcedureProfileData *snapPtr;
{
SnapTableEntry *stPtr,*tPtr;
int i,tbl_cnt;

/* set the new entry */
stPtr= (SnapTableEntry *)
     checkmalloc(sizeof(SnapTableEntry),"insert_snaptable");
stPtr->node_no=node_no;
stPtr->procprofile=snapPtr;

tbl_cnt=mPtr->snaptable[snap_no].tbl_cnt;

if(tbl_cnt==0) { /* first entry */
  mPtr->snaptable[snap_no].tbl_cnt=1; 
  mPtr->snaptable[snap_no].data_ptr=(SnapTableEntry *)stPtr;
  stPtr->next_node_list=(SnapTableEntry *)NULL;
  }else {                        /* a link-at-end entry */
    tPtr= (SnapTableEntry *)mPtr->snaptable[snap_no].data_ptr;

    for(i=0;i<tbl_cnt;i++) {
      if(tPtr->node_no==node_no){ /*found right node list*/
        while(tPtr->next_snap_entry !=(SnapTableEntry *) NULL)
             tPtr=tPtr->next_snap_entry;
        tPtr->next_snap_entry=stPtr;
        stPtr->next_snap_entry=(SnapTableEntry *) NULL;
        break; /* leave the for loop */
        } else {
          if(tPtr->next_node_list !=(SnapTableEntry *) NULL)
             tPtr=tPtr->next_node_list; /*stop at last valid entry*/
        }/*if*/
    }/*for*/
    if(i==tbl_cnt) { /* add a new node list */
        tPtr->next_node_list=stPtr;
        mPtr->snaptable[snap_no].tbl_cnt++; 
        stPtr->next_node_list=(SnapTableEntry *)NULL;
    }/*if*/
}/* if */

}
/********************************************************/
/* Name: initialize_procpernode                         */
/* Name: initialize_clausepernode                       */
/* Content: allocation and initialization of the header */
/*  tables for the snap profile data for procedure      */
/*  (procpernode) and for clause(clausepernode)         */
/* Date: 2/10                                           */
/********************************************************/
void initialize_procpernode(hPtr,pPtr)
Histo *hPtr;
Procedure *pPtr;
{
int i;

  pPtr->procpernode = (TableHeader *)
    checkmalloc(sizeof(TableHeader) * hPtr->info.node_cnt,"initialize_procpernode");
  for(i=0;i<hPtr->info.node_cnt;i++) {
    pPtr->procpernode[i].tbl_cnt=0;
    pPtr->procpernode[i].data_ptr=(ProcedureProfileData *) NULL;
  }
}

void  initialize_claupernode(hPtr,clause_model)
Histo *hPtr;
Clause *clause_model;
{
int i;

  clause_model->claupernode = (TableHeader *) 
        checkmalloc(hPtr->info.node_cnt*sizeof(TableHeader),
            "read_clause_model");
  for(i=0;i < hPtr->info.node_cnt;i++) {
    clause_model->claupernode[i].tbl_cnt=0;
    clause_model->claupernode[i].data_ptr= (ClauseProfileData *) NULL;
  }
}

/********************************************************/
/* Name: lookup_procesnapprof                           */
/* Content: */
/* Date: 12/30/92                                       */
/********************************************************/
ProcedureProfileData *lookup_procsnapprof(pPtr,snap_no,node)
Procedure *pPtr;
int snap_no,node;
{
int i;
int snap_cnt= pPtr->procpernode[node].tbl_cnt;
ProcedureProfileData 
        *Ptr = (ProcedureProfileData *)pPtr->procpernode[node].data_ptr;

     for(i=0;i<snap_cnt;i++) {
         if(Ptr->snap_no==snap_no)
            return( Ptr );
            else if(Ptr->next != (ProcedureProfileData *) NULL)
                 Ptr = Ptr->next;
     }
     if(snap_no == LAST) /* looking for the last snapshot */
         return( Ptr ); /*assuming the last is always the last*/
     return( (ProcedureProfileData *) NULL);
}

/********************************************************/
/* Name: insert_procesnapprof                           */
/* Content: */
/* Date: 12/30/92                                       */
/********************************************************/
ProcedureProfileData *insert_procsnapprof(pPtr,snap_no,node)
Procedure *pPtr;
int snap_no,node;
{
int i;
/* these should be already initialized in hread_model.h just in
case that the model file is incorrect */
int snap_cnt= pPtr->procpernode[node].tbl_cnt;
ProcedureProfileData 
    *Ptr = (ProcedureProfileData *) pPtr->procpernode[node].data_ptr;

for(i=0;i<snap_cnt-1;i++) {/*stopped at the last without check*/
   if(Ptr->snap_no==snap_no) {
      sprintf(TextBuffer,
          "repeated profile data for node[%d] snap[%d]",
          node,snap_no);
      GaugeError("insert_procsnapprof",TextBuffer);
      }
      else Ptr = Ptr->next;
} /*for*/

if(snap_cnt==0) {
   Ptr = (ProcedureProfileData *) checkmalloc(sizeof(ProcedureProfileData),
            "insert_procsnapprof");
   Ptr->snap_no=snap_no;
   Ptr->proc_ptr=pPtr;
   Ptr->next=(ProcedureProfileData *) NULL;

   pPtr->procpernode[node].data_ptr = (ProcedureProfileData *)Ptr;
   pPtr->procpernode[node].tbl_cnt=1;

   return( Ptr );
   } else {
     if( Ptr->snap_no==snap_no) { /* check last entry's */
       sprintf(TextBuffer, "repeated profile data for node[%d] snap[%d]",
            node,snap_no);
       GaugeError("insert_procsnapprof",TextBuffer);
     } /* if */ 
     pPtr->procpernode[node].tbl_cnt++;
     Ptr->next= (ProcedureProfileData *)
         checkmalloc(sizeof(ProcedureProfileData),
         "insert_procsnapprof");
     Ptr->next->snap_no=snap_no;
     Ptr->next->proc_ptr=pPtr;
     Ptr->next->next= (ProcedureProfileData *) NULL;
     return(Ptr->next);
} /*if-else*/
}

/********************************************************/
/* Name: lookup_clausnapprof                            */
/* Name: lookup_clausnapprof2                           */
/* Content: */
/* Date: 12/30/92                                       */
/********************************************************/
/* 12/30 hui */
ClauseProfileData *lookup_clausnapprof(pPtr,clause_no,snap_no,node_no)
Procedure *pPtr;
int clause_no,snap_no,node_no;
{    /* clause_no starts at 0 */
Clause *clause = pPtr->clauses+clause_no; 

return(lookup_clausnapprof2(clause,snap_no,node_no));
}

/* 12/31 hui note entry point is different than from above */
ClauseProfileData *lookup_clausnapprof2(cPtr,snap_no,node_no)
Clause *cPtr;
int snap_no,node_no;
{    /* clause_no starts at 0 */
int i;
int snap_cnt = cPtr->claupernode[node_no].tbl_cnt;
ClauseProfileData 
    *Ptr = (ClauseProfileData *) cPtr->claupernode[node_no].data_ptr;

     for(i=0;i<snap_cnt;i++) {
         if(Ptr->snap_no==snap_no)
            return( Ptr );
            else if(Ptr->next != (ClauseProfileData *) NULL)
                    Ptr = Ptr->next;
     }
     if(snap_no == LAST) /* looking for the last snapshot */
         return( Ptr ); /*assuming the last is always the last*/
     return( (ClauseProfileData *) NULL);
}

/********************************************************/
/* Name: insert_clausnapprof                            */
/* Content: storing snapshot profile data. Since clause */
/*  of couple blocks of snapshot data space is allocated*/
/*  at once. The routine first check if space is avail- */
/*  able or not. If so, just copy the data in. If not   */
/*  allocate the whole segment and then store into the  */
/*  particular snapshot data block into it.             */
/* Date: 12/31/92                                       */
/********************************************************/
ClauseProfileData *insert_clausnapprof(pPtr,clause_sz,snap_no,node_no)
Procedure *pPtr;
int clause_sz,snap_no,node_no;
{
/* space is allocated as a whole segment at once then link each
   clause data individually - this means that a whole segment
   of data can be access as if its an array */
static ClauseProfileData *cpPtr;
ClauseProfileData *tPtr; /* temporary data ptr */
Clause *clause;
int i,snap_cnt;
ClauseProfileData *Ptr;


/* check if exist already */
if(lookup_clausnapprof(pPtr,0,snap_no,node_no) !=
                               (ClauseProfileData *) NULL) {
  sprintf(TextBuffer,
          "repeated clause profile data for node[%d] snap[%d]",
          node_no,snap_no);
  GaugeError("insert_clausnapprof",TextBuffer);
}/*if*/

clause=pPtr->clauses;
snap_cnt=clause->claupernode[node_no].tbl_cnt;/* first one's */

/* malloc the whole section */
cpPtr = (ClauseProfileData *)
           checkmalloc(sizeof(ClauseProfileData)*clause_sz,
             "insert_clausnapprof");


for(i=0; i<clause_sz;i++) { /* link up */
 
  if(snap_cnt==0) {
   tPtr=cpPtr+i;
   tPtr->snap_no=snap_no;
   tPtr->node_no=node_no;
   tPtr->clau_ptr=clause;
   tPtr->next= (ClauseProfileData *) NULL;
   clause= pPtr->clauses+i;
   clause->claupernode[node_no].tbl_cnt=1; /* link up */
   clause->claupernode[node_no].data_ptr=(ClauseProfileData *)tPtr; 
   } else {
     clause= pPtr->clauses+i;
     clause->claupernode[node_no].tbl_cnt++;
     Ptr=(ClauseProfileData *) clause->claupernode[node_no].data_ptr;
              /* go down the individual link */
     while(Ptr->next != (ClauseProfileData *) NULL)
        Ptr=Ptr->next;

     Ptr->next=cpPtr+i; /* link up */
     Ptr->next->snap_no=snap_no;
     Ptr->next->node_no=node_no;
     Ptr->next->clau_ptr=clause;
     Ptr->next->next=(ClauseProfileData *) NULL;
  } /* if-else */
} /* for */
return(cpPtr);

}

/********************************************************/
/* Name : find_module                                   */
/* Content : look for the Module in the Modules(table)  */
/*   if not found, malloc a data block for module and   */
/*   attach to the module table                         */
/* Date : OLD routines                                  */
/********************************************************/
Module *find_module(modules,module)
     HBucket **modules;
     char *module;
{
  int found;
  Module **mPtr = (Module **) find(module,modules,1,&found);

  if (!found) {
    *mPtr = (Module *) checkmalloc(sizeof(Module),"find_module");
    (*mPtr)->name = strcpy(checkmalloc(strlen(module)+1,"insert_procedure"),module);
    (*mPtr)->snaptable=(TableHeader *) NULL;
  }
  return *mPtr;
}


/********************************************************/
/* Name : lookup_module                                 */
/* Content: return T/F depending on whether the given   */ 
/*   module exists or not                               */
/* Date : OLD routines                                  */
/********************************************************/
Module *lookup_module(modules,module)
     HBucket **modules;
     char *module;
{
  int found;
  Module **mPtr = (Module **) find(module,modules,0,&found);

  return found ? *mPtr : (Module *) NULL;
}

/********************************************************/
/* Name : find_procedure                                */
/* Content: find the position of a procedure data block */ 
/*  with given module and procedure names               */
/* Date : OLD routines                                  */
/********************************************************/
Procedure *find_procedure(modules,module,proc)
     HBucket **modules;
     char *module,*proc;
{
  int found;
  Module *mPtr = find_module(modules,module);
  Procedure **pPtr;

  pPtr = (Procedure **) find(proc,mPtr->procedures,0,&found);
  return found ? *pPtr : (Procedure *) NULL;
}

/********************************************************/
/* Name : insert_procedure                              */
/* Content: insert the given procedure after the given  */ 
/*   module                                             */
/* Date : OLD routines                                  */
/********************************************************/
insert_procedure(modules,module,name,proc)
     HBucket **modules;
     char *module, *name;
     Procedure *proc;
{
  int found;
  Module *mPtr = find_module(modules,module);
  Procedure **pPtr = (Procedure **) find(name,mPtr->procedures,1,&found);
  
  if (found) {
    fprintf(stderr,"Redefining procedure %s:%s\n",module,name);
    exit(1);
  }
  *pPtr = proc;
}

/********************************************************/
/* Name : free_table                                    */
/* Content: */ 
/* Date : OLD routines                                  */
/********************************************************/
free_table(table)
     HBucket **table;
{
  int entry = 0;
  HBucket *bucket, *bucket1, *table_bucket;

  while (entry < TABLE_SIZE) {
    table_bucket = table[entry++]; 
    for(bucket = table_bucket; 
	bucket != (HBucket *) NULL;
	bucket = bucket1)
      {
	bucket1 = bucket->next;
	free(bucket->key);
	if (bucket != table_bucket)
	  free(bucket);
      }
  }
}
