
static char *rcsid = "$Header: /ufs/comp/carl/PCN/IF/Model/RCS/read_v3_counters.c,v 1.1 1992/01/21 18:12:56 carl Exp $";

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <stdio.h>
#include <strings.h>
#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#include <Gauge/Gauge.h>
#endif
#include "model.h"

char *Buffer;

#define MODEL_FILE 0
#define COUNTER_FILE 1

read_v3_counter_values(hPtr,file,mPtr,node,linecnt)
     Histo *hPtr;
     FILE *file;
     int linecnt;
     Module **mPtr;
     int *node;
{
  int counters;

  long *cPtr;
  char module[MAX_NAME];
  /* MAX_NAME chars */

  if (fscanf(file," %d %49s %d",node,module,&counters) != 3) 
    goto format_error;
  if ((*mPtr = lookup_module(hPtr->modules,module)) == (Module *) NULL)
    goto format_error;
  expand_buffer(sizeof(long) * counters * hPtr->stats.nodes,
					  "read_counter_values");
  (*mPtr)->ncounters = counters;
  cPtr = (long *) Buffer;
  while (counters--) {
    if (fscanf(file," %ul ",cPtr) != 1)
      goto format_error;
    cPtr++;
  }
  return;
 format_error:
  sprintf(TextBuffer,"Invalid counter values in counter file at line %d\n",linecnt);
  GaugeError(TextBuffer);
}

read_v3_timer_values(hPtr,file,mPtr,node,linecnt)
     Histo *hPtr;
     FILE *file;
     int linecnt;
     int *node;
     Module **mPtr;
{
  int timers;
  unsigned long sec, usec;
  double *tPtr;
  char module[MAX_NAME];
  /* MAX_NAME chars */

  if (fscanf(file," %d %49s %d",node,module,&timers) != 3) 
    goto format_error;
  if ((*mPtr = lookup_module(hPtr->modules,module)) == (Module *) NULL)
    goto format_error;

  expand_buffer(sizeof(double) * timers * hPtr->stats.nodes,
		"read_counter_values");
  (*mPtr)->ntimers = timers;
  tPtr = (double *) Buffer;
  while (timers--) {
    if (fscanf(file," %lu %lu",&sec,&usec) != 2)
      goto format_error;
    *(tPtr++) =  sec + (usec / 1000000.0);
  }
  return;
 format_error:
  sprintf(TextBuffer,"Invalid timer values in counter file at line %d\n",linecnt);
  GaugeError(TextBuffer);
  exit(1);
}

read_v3_processors(hPtr,file,linecnt)
     Histo *hPtr;
     FILE *file;
     int linecnt;
{
  int node;
  int scan_args = fscanf(file," %d %d %d ",
			 &(hPtr->stats.nodes),
			 &(hPtr->stats.first_node), 
			 &(hPtr->stats.last_node)); 

  if (scan_args != 3) {
    sprintf(TextBuffer,"Invalid processor decleration in counter file at line %d\n",linecnt);
    GaugeError(TextBuffer);
  }
  hPtr->machine_types = 1;
  hPtr->nodes =
    (Node *) checkmalloc(sizeof(Node) * hPtr->stats.nodes,"read_histogram");
  hPtr->architecture =  (struct arch_descriptor *)
    checkmalloc(sizeof(struct arch_descriptor) * hPtr->machine_types,"read_histogram");

  hPtr->architecture[0].node_range.low = hPtr->stats.first_node;
  hPtr->architecture[0].node_range.hi = hPtr->stats.last_node;

  for (node = 0 ; node < hPtr->stats.nodes ; node++) {
    hPtr->nodes[node].node = node;
    hPtr->nodes[node].total.counts.use = 
      hPtr->nodes[node].total.counts.failure =
	hPtr->nodes[node].total.counts.commit =
	  hPtr->nodes[node].total.counts.suspend = 0;
    hPtr->nodes[node].total.cost.success = 
      hPtr->nodes[node].total.cost.failure =
	hPtr->nodes[node].total.cost.suspend =
	  hPtr->nodes[node].total.cost.total = 0;
    hPtr->nodes[node].bar.pattern = "default";
    hPtr->nodes[node].machine = hPtr->architecture;
  }

  if (hPtr->stats.last_node > hPtr->stats.nodes - 1) {
    sprintf(TextBuffer,"Invalid processor range\n");
    GaugeError(TextBuffer);
  }
   
}

read_v3_execution_time(hPtr,file,linecnt)
     Histo *hPtr;
     FILE *file;
     int linecnt;
{
  if (fscanf(file," %d %d ",
	   &(hPtr->stats.secs),&(hPtr->stats.msecs)) != 2) {
    sprintf(TextBuffer,"Invalid execution time in counter file at line %d\n",linecnt);
    GaugeError(TextBuffer);
  }
  hPtr->stats.msecs /= 1000;
  hPtr->stats.mins = hPtr->stats.secs / 60;
  hPtr->stats.secs = hPtr->stats.secs % 60;
}

read_v3_node_stats(hPtr,file,linecnt)
     Histo *hPtr;
     FILE *file;
     int linecnt;
{
  int node;

  if (fscanf(file," %d ",&node) != 1) {
    sprintf(TextBuffer,"Invalid node statistics at line %d\n",linecnt);
    GaugeError(TextBuffer);
  }
  if (node >= hPtr->stats.nodes) {
    sprintf(TextBuffer,"Invalid node statistics at line %d\n",linecnt);
    GaugeError(TextBuffer);
  }
  if (fscanf(file," %d %d %d %d %d %d %d %d %d %d %d ",
	     &(hPtr->nodes[node].stats.secs),
	     &(hPtr->nodes[node].stats.msecs),
	     &(hPtr->nodes[node].stats.gc_secs),
	     &(hPtr->nodes[node].stats.gc_msecs),
	     &(hPtr->nodes[node].stats.gc_count),
	     &(hPtr->nodes[node].stats.send_small),
	     &(hPtr->nodes[node].stats.send_big),
	     &(hPtr->nodes[node].stats.send_length),
	     &(hPtr->nodes[node].stats.rcv_small),
	     &(hPtr->nodes[node].stats.rcv_big),
	     &(hPtr->nodes[node].stats.rcv_length)) != 11) {
    sprintf(TextBuffer,"Invalid node statistics at line %d\n",linecnt);
    GaugeError(TextBuffer);
  }
  hPtr->nodes[node].stats.mins = hPtr->nodes[node].stats.secs / 60;
  hPtr->nodes[node].stats.secs = hPtr->nodes[node].stats.secs % 60;
  hPtr->nodes[node].stats.idle_mins = hPtr->nodes[node].stats.idle_secs / 60;
  hPtr->nodes[node].stats.idle_secs = hPtr->nodes[node].stats.idle_secs % 60;
  hPtr->nodes[node].stats.gc_mins = hPtr->nodes[node].stats.gc_secs / 60;
  hPtr->nodes[node].stats.gc_secs = hPtr->nodes[node].stats.gc_secs % 60;
}

read_v3_module_def(hPtr,file,linecnt)
     Histo *hPtr;
     FILE *file;
     int linecnt;
{
  int node;
  char module[MAX_NAME];
  char machine[MAX_NAME];

  if (fscanf(file," %d %s %s ",&node,module,machine) != 3) {
    sprintf(TextBuffer,"Invalid module definition at line %d\n",linecnt);
    GaugeError(TextBuffer);
  }
  if (node == 0)
    strcpy(hPtr->architecture[0].host_name,machine);
  find_module(hPtr->modules,module);
}

read_v3_counters(hPtr,file, linecnt, end_seen, endname, counterfile)
     Histo *hPtr;
     FILE *file;
     int *linecnt;
     int *end_seen;
     char *endname, *counterfile;
{
  int type;
  Module *mPtr;
  int node;
  char *assign_counter_values(), *assign_timer_values();
  struct {
    char *buff;
    Histo *hPtr;
    int node;
  } args;

  while ((type = line_type(file)) != EOF) {
    *linecnt += 1;
    switch (type) {
    case VERSION:
      read_version_number(hPtr,file,COUNTER_FILE,*linecnt);
      break;
    case COUNTER:
      read_v3_counter_values(hPtr,file,&mPtr,&node,*linecnt);
      args.buff = Buffer;
      args.hPtr = hPtr;
      args.node = node;
      map_table(mPtr->procedures,assign_counter_values,&args);
      break;
    case TIMER:
      read_v3_timer_values(hPtr,file,&mPtr,&node,*linecnt);
      args.buff = Buffer;
      args.hPtr = hPtr;
      args.node = node;
      map_table(mPtr->procedures,assign_timer_values,&args);
      break;
    case NODES:
      read_v3_processors(hPtr,file,*linecnt);
      break;
    case PER_NODE_STATS:
      read_v3_node_stats(hPtr,file,*linecnt);
      break;
    case EXECUTION_TIME:
      read_v3_execution_time(hPtr,file,*linecnt);
      break;
    case MODULE:
      read_v3_module_def(hPtr,file,*linecnt);
      break;
    case START:
      *linecnt = read_model(hPtr,file,*linecnt);
      break;
    case END:
      if ((fscanf(file," profile %s",endname) != 1) ||
	  strcmp(endname,counterfile)) 
	goto error;
      else
	*end_seen = 1;
      break;
    case UNKNOWN:
    default:
      goto error;
    }
  }

  if ( *end_seen) {
    load_arch_dbase(hPtr,hPtr->architecture);
    return;
  }

 error:
  sprintf(TextBuffer,"Invalid counter file format at line %d\n",*linecnt);
  GaugeError(TextBuffer);
}
