
/********************************************************/
/* File : ppshowdef.h                                   */
/* Content : define variables for ppshow.c              */
/* Date : 1/1992                                        */
/********************************************************/

#ifndef _PPSHOW_H
#define _PPSHOW_H

#ifndef _MODEL_H
#include "model.h"
#endif

#define ALL -1
#define NODE 1
#define UTILIZATION 2
#define COMM_VOLUME 3
#define MSG_COUNT 4
#define IDLE_TIME 5
#define INITIALIZE -6

#define SORT 1
#define UNSORT 2

/**************************************/
/** display format for ViewChanged() **/
/**************************************/
#define UTILIZATION_FMT "Displaying processor utilization for %s" 
#define GLOBAL_FMT \
"Total Execution Time (mins:secs:msecs): %d:%d:%d\n\
Total Reductions: %lu\nTotal Suspensions: %lu"

#define COMM_FMT \
  "Displaying %s\nSent:     %lu\nReceived: %lu\nTotal:    %lu"

#define IDLE_FMT "Displaying idle time for ALL processors"

/************/
/** macros **/
/************/
#define NODE_DISPLAY(mode) ((mode) != ALL && (mode) != NODE)

#define SEND_CNT(stat) ((stat)->send_small + (stat)->send_big)
#define RCV_CNT(stat) ((stat)->rcv_small + (stat)->rcv_big)
#define SEND_VOL(stat) \
 (((stat)->send_small*SMALL_MSG_THRESHOLD + (stat)->send_length) * 4)
#define RCV_VOL(stat) \
  ((((stat)->rcv_small*SMALL_MSG_THRESHOLD + (stat)->rcv_length)) * 4)

#define NO_CLAUSE_DATA(ptr)  (ptr==(ClauseProfileData *) NULL)
#define NO_PROC_DATA(ptr)    (ptr==(ProcedureProfileData *) NULL)

/********************************************************/
/* global data structure                                */
/********************************************************/
/** used in collect_usage_stats,show_usage_data,show_call_data **/
typedef struct UsageStatStruct{
  Procedure *proc;
  Clause *clause;
  int nodes;
  int display;
  int suspends;
  float cost;
  struct s_clausecounts *counts;
}UsageStats;

/********************************************************/
/* global definition                                    */
/********************************************************/

#define LABEL_MAX  128 /*used in ppshow and Gauge/Selectsnap.c*/
#define LIST_MAX   200 /*used in ppshow and Gauge/Selectsnap.c*/

/********************************************************/
/* global variable declared as external to be included  */
/* by hutil.c and model2.c                              */
/* Date: 2/1992                                         */
/********************************************************/

extern int ModeFlag;
extern int curr_snap_no;
extern char item_buffer[LABEL_MAX];

#endif /* _PPSHOW_H */
