
/*AERO_MESG*/

/********************************************************/
/* File : model2.c                                      */
/* Content :  routines that is call upon to process     */
/*  every entry in either module or procedure tables    */
/*  one by one                                          */
/* Date : OLD routines  (updated for version 005)       */
/********************************************************/

#include <stdio.h>

#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#include <Gauge/Gauge.h>
#endif

#ifndef _PPSHOW_H
#include "ppshow.h" 
#endif

/* global output file ptr to be shared between routines 
   without passing especially for routines called with
   map_table */
static FILE *OFile; 

/********************************************************/
/* only local to here for output_calibaration to use    */
/********************************************************/
struct calibration_parms {
  float success[INSTR_CLASSES];
  float failure[INSTR_CLASSES];
  double idle, foreign;
  int copy, suspend;
  int node,snap_no;
};


/********************************************************/
/* Name : execution_time                                */
/* Content : calculate the "total" accumulation of cost */
/*  across all nodes and for all snapshots              */
/* Date : updated (1/92)                                */
/********************************************************/
/*ARGSUSED*/
char *execution_time(name,proc,hPtr)
     char *name;
     Procedure *proc;
     char *hPtr;
{
  Clause *clsPtr; /* clause ptr */
  Node *nPtr;
  ClauseProfileData *clsdataPtr;  /* clause data ptr*/
  ProcedureProfileData *tPtr, /*procedure's total ptr */
                       *ntPtr, /* node's total ptr */
                       *procdataPtr; /* procedure's profile data */
  float Tf; /* temporary total failure cost for all clauses*/
  float Ts; /* temporary total success cost for all clauses*/
  int clause_number, node, i, snap_no;

for(snap_no=0;snap_no <((Histo *) hPtr)->info.snap_cnt;snap_no++) {

  for(node = 0;node < ((Histo *) hPtr)->info.node_cnt;node++) {

    tPtr=proc->total+snap_no;/*go to the right total structure*/
    procdataPtr=lookup_procsnapprof(proc,snap_no,node);
    if(procdataPtr == (ProcedureProfileData *)NULL) {

#ifdef HUIDEBUG
      sprintf(TextBuffer,"No profile data for node[%d] snap[%d] procname[%s]",
           ,node,snap_no,proc->name);
      GaugeWarning("execution_time",TextBuffer); /* just no snapshot data */
#endif

      continue;
    }/* if */
    nPtr=((Histo *)hPtr)->nodes+node;
    ntPtr=nPtr->total+snap_no;

    switch (proc->type) {
    case PCN_IMPLICATION:
    case PCN_PARALLEL:

      Ts = 0.0;
      Tf = 0.0;
      for(clause_number = 0; clause_number < proc->size; clause_number++) {

	clsPtr = proc->clauses+clause_number;
        clsdataPtr=lookup_clausnapprof2(clsPtr,snap_no,node);
        if(clsdataPtr == (ClauseProfileData *)NULL)
            continue; /* nothing to update */

        /* now the target clause data block is found */
	clsdataPtr->cost.success = clsdataPtr->cost.failure = 0;
	for (i = 0; i < INSTR_CLASSES ; i++) {
	  clsdataPtr->cost.success +=
	    clsdataPtr->counts.commit *
	      ((Histo *) hPtr)->nodes[node].machine->parameters.classtype[i] *
	      clsPtr->model.success[i];
	  clsdataPtr->cost.failure +=
	    clsdataPtr->counts.failure *
	      ((Histo *) hPtr)->nodes[node].machine->parameters.classtype[i] *
		clsPtr->model.failure[i];
	}/* for INSTR_CLASSES */

	Ts += clsdataPtr->cost.success;
	Tf += clsdataPtr->cost.failure;
      }/* for clause_number */
      
      tPtr->cost.success += procdataPtr->cost.success = Ts;
      tPtr->cost.failure += procdataPtr->cost.failure = Tf;
      tPtr->cost.suspend += procdataPtr->cost.suspend =
        ((Histo *) hPtr)->nodes[node].machine->parameters.suspend *
	    procdataPtr->counts.suspend;
      tPtr->cost.total += procdataPtr->cost.total =
        Ts + Tf + procdataPtr->cost.suspend;
      break;
    case FOREIGN_PROCEDURE:
      tPtr->cost.success += procdataPtr->cost.success;
      tPtr->cost.total += procdataPtr->cost.total;
      break;
    }/* switch */

    ntPtr->cost.success += procdataPtr->cost.success;
    ntPtr->cost.failure += procdataPtr->cost.failure;
    ntPtr->cost.suspend += procdataPtr->cost.suspend;
    ntPtr->cost.total += procdataPtr->cost.total;
  }/* for node */
}/* for snap_no */

return hPtr;
}

/********************************************************/
/* Name : output_time                                   */
/* Content : */
/* Date : updated (1/92)                                */
/********************************************************/
output_times(hPtr,ofile,printer)
     Histo *hPtr;
     FILE *ofile;
     char *(*printer)(); /* called with printer = print_time */
{

  OFile = ofile;         /* set for the print_time to use */
  fprintf(ofile,"stats %d %d %d %d %d %d\n",
	  hPtr->info.mins,hPtr->info.secs,hPtr->info.msecs,
	  hPtr->info.reductions,hPtr->info.suspensions,
          hPtr->info.node_cnt);
  (void) map_procedures(hPtr->modules,printer,(char *) hPtr);  
}

/********************************************************/
/* Name : print_time                                    */
/* Content : */
/* Date : updated (1/92)                                */
/********************************************************/
/*ARGSUSED*/
char *print_time(name,proc,hPtr) /* just the last snapshoted one */
     char *name;
     Procedure *proc;
     char *hPtr;
{
  int node;
  ProcedureProfileData *procdataPtr;

  printf("procedure %s:%s\n",proc->mod_ptr->name, proc->name);

  for (node = 0; node < ((Histo *) hPtr)->info.node_cnt ; node++){
    procdataPtr=lookup_procsnapprof(proc,curr_snap_no,node);
    if(NO_PROC_DATA(procdataPtr)) {
      sprintf(TextBuffer,"No stats data for node[%d] snap_no[%d]",
              node,curr_snap_no);
      GaugeWarning("print_time",TextBuffer);
      } else
    fprintf(OFile,"%f ", procdataPtr->cost.total);
  }/* for */
  fprintf(OFile,"\n");

  return hPtr;
}

/********************************************************/
/* Name : output_calibration                            */
/* Content : */
/* Date : updated (1/92)                                */
/********************************************************/
output_calibration(hPtr,ofile)
     Histo *hPtr;
     FILE *ofile;
{
  struct calibration_parms parms;
  char *sum_stats();
  struct node_stats *sPtr;
  Node *nPtr;
  int node, i;

  OFile = ofile; 

  for(node = hPtr->info.first_node;node <= hPtr->info.last_node;node++) {
      float time;

      for (i = 0 ; i < INSTR_CLASSES ; i++)
	parms.success[i] = parms.failure[i] = 0;

      parms.suspend = parms.copy = 0;
      parms.idle = parms.foreign = 0;
      parms.node = node;
      parms.snap_no=curr_snap_no; 

      (void) map_procedures(hPtr->modules,sum_stats,(char *)&parms);  

      nPtr = hPtr->nodes+node;
      sPtr = nPtr->stats+curr_snap_no;
      time = sPtr->mins * 60 +sPtr->secs + (float) sPtr->msecs/ 1000.0;
      time -= sPtr->gc_mins * 60 + sPtr->gc_secs + (float) sPtr->gc_msecs/ 1000.0;

      fprintf(ofile,"%d %f %f %f", node, time, parms.idle,parms.foreign);

      for (i = 0; i < INSTR_CLASSES ; i++)
	fprintf(ofile," %f",
              nPtr->machine->parameters.classtype[i] * parms.success[i]);

      for (i = 0; i < INSTR_CLASSES ; i++) 
	fprintf(ofile," %f",
              nPtr->machine->parameters.classtype[i] * parms.failure[i]);

      fprintf(ofile," %f %f",
	      nPtr->machine->parameters.suspend * parms.suspend,
	            nPtr->machine->parameters.copy * parms.copy);
      fprintf(ofile," %d %d %d",
	      sPtr->send_small, sPtr->send_big, sPtr->send_length);
      fprintf(ofile," %d %d %d",
	      sPtr->rcv_small, sPtr->rcv_big, sPtr->rcv_length);
      fprintf(ofile,"\n");
    }/* for */
}

/********************************************************/
/* Name : sum_stats                                     */
/* Content : */
/* Date : updated (1/92)                                */
/********************************************************/
/*ARGSUSED*/
char *sum_stats(name,proc,parms)
     char *name;
     Procedure *proc;
     struct calibration_parms *parms;
{
  Clause *clsPtr;
  int clause_number, i;
  ProcedureProfileData *procdataPtr;
  ClauseProfileData *clsdataPtr;

  procdataPtr=lookup_procsnapprof(proc,parms->snap_no,parms->node);

  switch (proc->type) {
  case PCN_PARALLEL:
  case PCN_IMPLICATION:
    for(clause_number = 0; clause_number < proc->size; clause_number++) {

      clsPtr = proc->clauses+clause_number;
      clsdataPtr=lookup_clausnapprof2(clsPtr,parms->snap_no,parms->node);

      for (i = 0 ; i < INSTR_CLASSES ; i++) {
	parms->success[i] +=  
          clsdataPtr->counts.commit * clsPtr->model.success[i];
	parms->failure[i] += 
	  clsdataPtr->counts.failure * clsPtr->model.failure[i];
      }
    }
    parms->idle += procdataPtr->cost.idle;
    parms->copy += procdataPtr->counts.copy;
    parms->suspend += procdataPtr->counts.suspend;
    break;
  case FOREIGN_PROCEDURE:
    parms->foreign += procdataPtr->cost.total;
    break;
  }
  return (char *) parms;
}

