
#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/Gauge/RCS/Gauge.c,v 1.4 1992/04/17 18:14:44 mei Exp $";
#endif

/* AERO_MESG */
#include <Xsw/Xsw.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Shell.h>

#include <Xsw/MyList.h>
#include "Viewer.h"
#include "Gauge.h"
#include "gauge_icon.h"
#include "Select.h"

typedef struct {
  int items;
  double maximum;
  double minimum;
  double total;
  double (*function)();
} StatsStruct;

/* Helper funtions to simplify interface */

ListElement * RowList(w)
     Widget w;
{
  Arg arg[2];
  ListElement *hlist;
  
  XtSetArg(arg[0], XtNhlist, &hlist);
  XtGetValues(w, arg, 1);

  return hlist;
}

ListElement * ColumnList(w)
     Widget w;
{
  Arg arg[2];
  ListElement *vlist;
  
  XtSetArg(arg[0], XtNvlist, &vlist);
  XtGetValues(w, arg, 1);

  return vlist;
}

void show_pos(y, x, name, d)
void * y, * x;
String name;
StatsStruct * d;
{
  double data;

  d->items++;
  data = (*(d->function))(y, x, name);
  d->total += data;
  if (data > d->maximum)
    d->maximum = data;
  if (data < d->minimum)
    d->minimum = data;
}

/* ARGSUSED */
void
Quit(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  XtDestroyWidget((Widget)client_data);
}

/* ARGSUSED */
static void
Tweak(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  StatsStruct data;
  StatsStruct * d = &data;
  char text[500];
  Widget view = *((Widget *)client_data);
  Arg args[2];
  double (*function)();

  XtSetArg(args[0], XtNgetValueFunction, &function);
  XtGetValues(view, args, 1);

  data.function = function;
  data.total = 0.0;
  data.items = 0;
  data.maximum = 0;
  data.minimum = 100000000;

  XswViewerMapSelections(view, show_pos, (void *)d);
  (void)sprintf(text,"\nStatistics\n\nTotal: %g\nItems: %d\nMean: %g\nMaximum: %g\nMinimum: %g\n\n ", data.total, data.items, data.total/(double)data.items, data.maximum, data.minimum);
  XswPopupBox(view, "Statistics", (char *)text);
}

/* ARGSUSED */
static void
Clear(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  Widget view = *((Widget *)client_data);
  XswViewerClearSelections(view);
}

/* ARGSUSED */
static void
Scale(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  Widget view = *((Widget *)client_data);
  XswViewerPopupScale(view);
}

/* ARGSUSED */
static void
SwitchView(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  int d;
  Widget view = *((Widget *)client_data);
  VTypeList root_type;
  VType core_type;

  d = (int)XawToggleGetCurrent(w);
  if ((d < 1) || (d > 3)) return;

  XtVaGetValues(view, XtNrootType, &root_type, NULL);
  XtVaSetValues(view, XtNradioView, w, NULL);

  core_type = *root_type;
  root_type++;
  while (*root_type != -1) {
    if (*root_type != ThreeD) {
      core_type = *root_type;
    }
    root_type++;
  }

  if (core_type == ThreeD) {
    XtSetSensitive(XtParent(w), True);
    switch (d) {
    case 1:
      XtVaSetValues(view, XtNshowType, ThreeD, NULL);
      break;
    case 2:
      XtVaSetValues(view, XtNshowType, ByProcedures, NULL);
      break;
    case 3:
      XtVaSetValues(view, XtNshowType, ByNodes, NULL); 
      break;
    }
  } else {
    if ((core_type == ByNodes) ? (d != 3) : (d != 2)) {
      XawToggleUnsetCurrent(w);
      XawToggleSetCurrent(w, (XtPointer)
			  (core_type == ByNodes ? 3 : 2));
    }
    XtSetSensitive(XtParent(w), False);
  } 
}

/* ARGSUSED */
static void
ToggleBucket(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  int d;
  Widget view = *((Widget *)client_data);

  d = (int)XawToggleGetCurrent(w);
  if (d == 1) {
    XtVaSetValues(view, XtNbucket, True, NULL);
  } else {
    if (d == 2) {
      XtVaSetValues(view, XtNbucket, False, NULL);
    }
  } 
}

/* ARGSUSED */
static void
ToggleZoom(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  int d;
  Widget view = *((Widget *)client_data);

  d = (int)XawToggleGetCurrent(w);
  if (d == 1) {
    XtVaSetValues(view, XtNzoom, True, NULL);
  } else {
    if (d == 2) {
      XtVaSetValues(view, XtNzoom, False, NULL);
    }
  } 
}

/* ARGSUSED */
static void
ToggleLog(w, client_data, call_data)
Widget w;
XtPointer call_data, client_data;
{
  int d;
  Widget view = *((Widget *)client_data);

  d = (int)XawToggleGetCurrent(w);
  if (d == 1) {
    XtVaSetValues(view, XtNlog, True, NULL);
  } else {
    if (d == 2) {
      XtVaSetValues(view, XtNlog, False, NULL);
    }
  } 
}

/* Note: gauge is not used, it should probably be removed at some time */ 
/* ARGSUSED */
Widget 
CreateGauge(vPtr,toplevel,gauge,hlist,vlist,get_value_function,currview)
Widget * vPtr;
Widget toplevel;
void *gauge;
ListElement * hlist, * vlist;
double (*get_value_function)();
ViewerWidget currview;
{  
  Widget root, view, cset_w, rset_w, sset_w;
  Widget toggles;
  Widget *viewPtr = (Widget *)XtMalloc(sizeof(Widget *));
  Arg arg[20];
  StringList data;
  Pixmap icon_pixmap = (Pixmap) 0;

  int i;

  XswRegisterCallback("Quit", Quit, (XtPointer)toplevel);
  XswRegisterCallback("Clear", Clear, (XtPointer)viewPtr);
  XswRegisterCallback("Scale", Scale, (XtPointer)viewPtr);
  XswRegisterCallback("Tweak", Tweak, (XtPointer)viewPtr);
  XswRegisterCallback("SwitchView", SwitchView, (XtPointer)viewPtr);
  XswRegisterCallback("ToggleZoom", ToggleZoom, (XtPointer)viewPtr);
  XswRegisterCallback("ToggleBucket", ToggleBucket, (XtPointer)viewPtr);
  XswRegisterCallback("ToggleLog", ToggleLog, (XtPointer)viewPtr);

  XtSetArg(arg[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(toplevel, arg, 1);
  if (icon_pixmap == (Pixmap) 0) {
    XtSetArg(arg[0], XtNiconPixmap,
	     XCreateBitmapFromData(XtDisplay(toplevel),
				   XtScreen(toplevel)->root,
				   gauge_bits, gauge_width, gauge_height));
    XtSetValues(toplevel, arg, 1);
  }

  root = XtVaCreateManagedWidget(
               "gauge", 
               panedWidgetClass, 
	       toplevel, 
               NULL);

  cset_w = XtVaCreateManagedWidget(
               "commandBox",
	       boxWidgetClass,
	       root,
               NULL);

  rset_w = XtVaCreateManagedWidget(
               "radioBox",
	       boxWidgetClass,
	       root,
               NULL);

  sset_w= XtVaCreateManagedWidget(
               "snapBox",
                selectWidgetClass,
                root,
                XtNdataPtr, (XtPointer *) gauge,
                XtNsnapWidth, 380,
                NULL);

  /* We only want to create a chart once */
  XswViewerDisableViewUpdate();

  view = XtVaCreateManagedWidget(
              "view", 
              viewerWidgetClass,
              root,
              XtNhlist, hlist,
              XtNvlist, vlist,
              XtNgetValueFunction, get_value_function,
              NULL);

  data = NULL;
  if (currview != (ViewerWidget) NULL) {
    Arg oldarg[1];
/* hui 4/22 fix subset bug 
    XtSetArg(oldarg[1], XtNdata, &data);
*/
    XtSetArg(oldarg[0], XtNdata, &data);
    XtGetValues((Widget) currview, oldarg, 1);
  }
  CreateViewMenu(view, "viewMenu", data);
  *viewPtr = view;
  *vPtr = view;

  (void)XswMakeCommandButtons(cset_w);

  if (currview != (ViewerWidget) NULL)
    toggles = XtNameToWidget(XtParent((Widget) currview),"radioBox");
  else
    toggles = NULL;
  (void)XswMakeRadioButtons(rset_w, toggles);

  /* Ok, now make the chart */
  XswViewerEnableViewUpdate();
  XswViewerUpdateView(view);
  return view;
}

 



