/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "arg.h"
#include "hash.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

//This redefines the definition of DCL_KEYWORD2(x,s) macro which is first 
//defined in builtin-syms.h.
#undef DCL_KEYWORD2(x,s)
#undef BUILTIN_SYMS
#define DCL_KEYWORD2(x,s)  Symbol* x = EnterSymbol(s);
#include "builtin-syms.h"

#undef DCL_KEYWORD2(x,s)
#define DCL_KEYWORD2(x,s) extern Symbol * x;



extern void SymbolTabInit();
typedef Association (*Func)(Pointer, Association*);
extern void ForEachTabElement(struct SymbolTable *, Func, Pointer) ;
int enter_symbol = 1;

struct SymbolPackage {
   SymbolPackage() { SymbolTabInit(); }
};

SymbolPackage KeywordPackage();

int SymbolTabInitDone = 0;

#define EQwith(el) (SymbolHash(el)==hash && SymbolLength(el) == len \
  && memcmp(SymbolString(el), s, len) == 0)

HashTable SymbolTab[1] =
  {{ 4, 2, 8 /* half log of initial size*/, 0, &StdHashFuncs, 0, 0 }};

static Name *
FindSymbol(const char *s, int len, HashVal hash) /* patterned after SymbolLookup */
{
#define tab SymbolTab
#define HASH_ELEMENT_TYPE Name
#define HASH_LENGTH_LOG tab->tab_len_log
#define HASH_ELEMENT_LOG tab->element_len_log
#define HASH_TO_INDEX(hash) (hash >> (HASH_WORD_LEN - tab->tab_len_log)) << tab->element_len_log
#define HASH_EQUAL(element,arg) EQwith(*element)
#define HASH_NULL(element) (*element==(Name)HashNull)
#define HASH_DATA tab->data
#define HASH_TO_STEP(hash) (((hash<<1)+1) & ((1<<tab->tab_len_log)-1)) << tab->element_len_log

#include "hashfunc.h"
#undef tab
}

void PrintSymbol(Name sym, FILE *ff)
{
    fputs(sym->string(), ff);
}

void SymbolTabInit()
{
 if (SymbolTabInitDone) return;
 SymbolTabInitDone = 1;
 RehashBigger(SymbolTab);
}

Name EnterSymbol(const char *str)
{
 int len;
 HashVal h; register Name *p, s;

 len = strlen(str);
 h = IntToHash(StrHash(str, len));

 if (!enter_symbol) {
   s = new Symbol(str, len, h);
   return s;
  }

 if (!SymbolTabInitDone)
   SymbolTabInit();
 
 p = (Name*)FindSymbol(str, len, h);
 if (*p != NULL) {
   return *p;
  }

 s = new Symbol(str, len, h);
 *p = s;
 TabInserted(SymbolTab, (Association*)s);

 return s;
}

static Association clear_symbol(Pointer , Association* ass)
{
 delete (Symbol *)(ass->val) ;
 return *ass ;
}

void clearSymbols()
{
/*** THIS CAUSES A CORE DUMP !!  PRAVEEN
 if (SymbolTab) {
   ForEachTabElement(SymbolTab, (Func)clear_symbol, 0) ;
  }
***/
 return;
}
