/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/


/*********************************************************************** 
  CORAL Software :: U.W.Madison
  pipelined.C: contains code relevant to the QFPipelinedModuleData
  class. This class is defined in pipelined.h as a subclass of
  QFModuleData. The other relevant header file is apply.h, which
  contains the type definition for the RuleInfo structure.
  
  ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "term.h"
#include "generic-rel.h"
#include "rules.h"
#include "builtin-rel.h"
#include "hash.h"
#include "externs.h"
#include "interp.h"
#include "derived-rel.h"
#include "profile.h"
#include "apply.h"
#include "annotations.h"
#include "globals.h"
#include "pipelined.h"
#include "arg.h"
#include "unify.h"


extern void add_pred_extern(Predicate *pred, enum PredKind kind, ModulePred *);
extern int determine_subsum_status(QFModuleData *md, Name name, int default_val);
extern void get_annos(QFModuleData *md, ModulePred *predicate);
extern RuleInfo *create_rule_info(Table *F, struct rule *rule);
extern void AddProfileInfo(ProfileInfo *A, ProfileInfo *B) ;
extern Relation *Find_External_Relation(Name name, int arity);
extern int count_var_list(VarLink *rest);
extern int getSuccessBacktrackPoint(RuleInfo *, int);
extern int getfirstFailureBacktrackPoint(RuleInfo *,int rhs_index, int);
extern int getnextFailureBacktrackPoint(RuleInfo *,int rhs_index, int);
extern void sprint_adornment(char *buf, BitVector* a);

extern int is_a_builtin(Name name);          // interp.C
extern VarLink * build_var_list(Literal * pred, VarLink *list);
extern VarLink *vars_between(struct rule *adrule, int i, int j,
					VarLink *rest, int*);
extern void create_an_annotation(PredAnnotations *&, 
				 Literal *lit, VarLink *var_list);
extern VarLink *intersect_var_lists(VarLink *varlist1, VarLink *varlist2);

Relation *makePipelinedRelation(QFPipelinedModuleData *md,Name name, int arity);

#define NULL_INT_VAL -2

int C_PipelinedConstructs = 0;
int C_PipelinedDestructs = 0;

static void initFailureBackTrack(RuleInfo *rInfo, int *ib_first_array,
				 int *ib_next_array, int non_ground)
{
    for (int i = rInfo->num_literals-1; i >0; i--) {
	ib_first_array[i] = getfirstFailureBacktrackPoint(rInfo, i, non_ground);
	ib_next_array[i] = getnextFailureBacktrackPoint(rInfo, i, non_ground);
      }
    ib_first_array[0] = -1;
    ib_next_array[0] = -1;
}

static void initRulePointers(Table *F, QFModuleData *md)
{
 ModulePred *predicates = md->predicates->next;
 F->moduledata = md;
 
 for (; predicates; predicates = predicates->next) { 
   Name name = predicates->pred->name;
   int arity = predicates->pred->arity;
   int offset = predicates->offset;

   switch (predicates->kind) {
    case QueryPredKind:
     F->rels[offset].AssignRel(Find_External_Relation(name, arity));
     break;

    case LocalPredKind:
     // We create PipelinedDerivedRelations for local
     // predicates only. No tuples will be actually inserted into any of 
     // these Relations, but we still need it so as to allow us to
     // do a get_next() on it
     
     F->rels[offset].AssignRel(makePipelinedRelation((QFPipelinedModuleData *) md,name,arity));
     break;

    case ExternalPredKind:
     F->rels[offset].AssignRel(Find_External_Relation(name, arity));
     
     struct AnnoStruct *cur;
     for(cur= predicates->index_annos; cur; cur=cur->next)
       if (cur->anno->arglist2)
	 F->rels[offset].relPtr->add_index(cur->anno->arglist1, cur->num_vars, cur->anno->arglist2) ;
       else F->rels[offset].relPtr->add_index(cur->anno->arglist1) ;
     
     F->rels[offset].relPtr->check_subsum = predicates->check_subsum;
      
     break;
    }
  }
}


// Member functions for PipelinedExecInfo
PipelinedExecInfo::PipelinedExecInfo(QFPipelinedModuleData *md, int pred_offset)
{
    Relation *rel;
    int offset;

    // Get the first rule defining this relation
    if (!(curRule = (md->pred_ptrs[pred_offset])->clauses)) return;

    // Extract its RuleInfo 
    rInfo = (md->ruleArray)->rInfoPtrs[curRule->rule_number];
    F = md->F; // Table is the same as that in the QFPipelinedModuleData
    indices = md->indices[curRule->rule_number];
    int numVars = md->maxNumVars[pred_offset];
    env = new ArrayBindEnv(numVars);
    int numLits = md->maxNumLiterals[pred_offset];
    tuple_its = new TupleIterator* [numLits];
    bzero((char *)tuple_its, numLits*sizeof(TupleIterator *) );
    tuples = new Tuple* [numLits];
    stack_marks = new StackMark [numLits];

    firstFailureBacktrack = md->backtrackInfo.
      firstFailureBacktrackArrays[curRule->rule_number];
    nextFailureBacktrack = md->backtrackInfo.
      nextFailureBacktrackArrays[curRule->rule_number];
    successBacktrack = md->backtrackInfo.
      successBacktrackPoints[curRule->rule_number];

#ifdef DEBUG
    C_PipelinedConstructs++;
#endif
    
    for (index = 0; index < rInfo->num_literals; index++)
    {
    	//Check if predicate should be negated, signalled by an offset <= -2.
    	if (NEGATED(index))
    	    offset = (-2) - rInfo->relations[index];
    	else
	    offset = rInfo->relations[index];
	
    	rel = F->rels[offset].relPtr ;
    	tuple_its[index] = new TupleIterator (rel, rInfo->arg_list[index],
					      env, NULL, NULL, &(indices[index]));
    }
    index = current = backtrack_index = 0;
    direction = FORWARD;
    cut_crossed = 0;
}

PipelinedExecInfo::init()
{
 return 0;
}


PipelinedExecInfo::~PipelinedExecInfo()
{
#ifdef DEBUG
  C_PipelinedDestructs++;
#endif
  if (!curRule) return;

  //delete env;
  for (int i=0; i< rInfo->num_literals; i++) {
    if (tuple_its[i]) {
      tuple_its[i]->release();
      delete tuple_its[i];
    }
  }
  delete  tuple_its;
  delete tuples;
  delete stack_marks;
  indices = NULL;
  curRule = NULL;
  rInfo = NULL;
  F = NULL;
}

/* 
 * Go to the next rule that defines this predicate. 
 * Sets up the info in PipelinedExecInfo
 *
 * Returns 1 on success, 0 on failure
 *
 */

int PipelinedExecInfo::NextRule(QFPipelinedModuleData *md)
{
    Relation *rel;
    int offset;

    // if we are already at the last rule defining the predicate
    if (!curRule->pnext)
    {
    	return 0;
    }
    // use the structures allocated earlier
    // after resetting their values
    // The trail has been used already to reset values in the bindenvs
    for (int i=0;i< rInfo->num_literals;i++)
    {
	if (tuple_its[i]) {
	    tuple_its[i]->release();
	    delete tuple_its[i];
	}
	// There might be a memory leak here
        tuple_its[i] = NULL;
	tuples[i] = NULL;
    }
    
    curRule = curRule->pnext;
    // Extract its RuleInfo 
    rInfo = (md->ruleArray)->rInfoPtrs[curRule->rule_number];
    indices = md->indices[curRule->rule_number];
    // Initialize all other fields
    firstFailureBacktrack = md->backtrackInfo.
      firstFailureBacktrackArrays[curRule->rule_number];
    nextFailureBacktrack = md->backtrackInfo.
      nextFailureBacktrackArrays[curRule->rule_number];
    successBacktrack = md->backtrackInfo.
      successBacktrackPoints[curRule->rule_number];

    for (index = 0; index < rInfo->num_literals; index++)
    {
    	//Check if predicate should be negated, signalled by an offset <= -2.
    	if (NEGATED(index))
	    offset = (-2) - rInfo->relations[index];
    	else offset = rInfo->relations[index];
	
    	rel = F->rels[offset].relPtr ;
    	tuple_its[index] = new TupleIterator (rel, rInfo->arg_list[index],
					      env, NULL, NULL, &(indices[index]));
    }
    //backtrack_index = NULL_INT_VAL;
    //new_iterator = 0;
    offset = current = backtrack_index = 0;
    direction = FORWARD;
    return 1;
}

// Member functions for PipelinedDerivedRelation

Relation *makePipelinedRelation(QFPipelinedModuleData *md,Name name, int arity )
{
    Relation *rel = new PipelinedDerivedRelation(md,name,arity);
    return rel;
}

PipelinedDerivedRelation::PipelinedDerivedRelation(QFPipelinedModuleData *module,Name _name,int new_arity)
{
    md = module;
    name = _name;
    _arity = new_arity;
    methods = NULL;
    r_kind = COR_R_DERIVED;
    has_release = 1;
    pred_offset = get_offset(module->F, name, _arity);
}

void PipelinedDerivedRelation::release(TupleIterator& iterator)
{
    // get rid of the state of the iterator
    if (iterator.pipe)
    {
	delete iterator.pipe;
    	iterator.pipe = NULL;
    }
}

BindEnv * PipelinedDerivedRelation::get_next(TupleIterator& iterator)
{
    this->get_next_tuple(iterator);
    if (iterator.no_match()) return NULL;
    return(iterator.bindenv);
}

#undef FAIL_RETURN
#define FAIL_RETURN { if (CurrModuleInfo != iterator.prev_module_info) { \
			CurrModuleInfo = iterator.prev_module_info; \
			T_Stack.pop(); \
		      } \
		      iterator.prev_module_info = NULL; \
		      return NULL; \
		    } 


Tuple * PipelinedDerivedRelation::get_next_tuple(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    iterator.tuple_env = NULL;
    Arg*** tempArg;
    ArgList *newArg;

#ifdef DO_PROFILE
    // profiling info
    (GlobalProfileInfo.getnexts)++ ;
#endif

    // Check if this is the first time that this iterator has been called
    // If so then perform initialization
    if (!iterator.pipe)
    {

#ifdef DO_TRACE
     if (exEnv.dbg_get_next) {
       fprintf(exEnv.trace_file,
	       "PipelinedDerivedRelation: new get_next called on %s(", 
	       name->string());
       iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
       fprintf(exEnv.trace_file, ")\n");
      }
#endif

        if (exEnv.C_interrupt_raised) {
	  iterator.set_no_match();
	  return NULL;
	}

    	// if this is the first exec on the module, 
    	// we have to set up the Table
    	//if (!md->TableSetUp)

	if (!md->TableSetUp++) initRulePointers(md->F,md);
	/*****
	  * Since the Table is being shared by all invocations on this
	  * module, we can change it directly instead of having to 
	  * make copies of it for each execution
	  * ::: this comment is invalid :: PRAVEEN
	  * Since we would like to maintain an actual stack that
	  * reflects the module invocations, we need to make copies
	  * of the Table.
	*****/

    	// This is the first time get_next is being called on this iterator
    	// Time to set up PipelinedExecInfo
#ifdef DO_TRACE
        if (exEnv.dbg_get_next) {
            fprintf(exEnv.trace_file,
		    "PipelinedDerivedRelation: starting on %s(",
		    name->string());
            iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
            fprintf(exEnv.trace_file, ")\n");
        }
#endif
	iterator.pipe = new PipelinedExecInfo(md, pred_offset);
	if (!iterator.pipe->curRule) {
	  // if there is no rule defining the predicate
	  iterator.set_no_match();
	  delete iterator.pipe;
	  iterator.pipe = NULL;
#ifdef DO_TRACE    
	  if (exEnv.dbg_get_next) {
	    fprintf(exEnv.trace_file,
		    "PipelinedDerivedRelation: new get_next failed on %s(",
		    name->string());
	    iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
	    fprintf(exEnv.trace_file, ")\n");
	  }
#endif
	  return NULL;
	}

    	// unify the arg_lists of the iterator and the head of the rule
    	// keep trying all the rules till either unification succeeds or 
    	// we have exhausted all the rules that define this relation
	
    	// get a mark so that we can undo the changes if it fails
    	iterator.pipe->stackmark0.get_mark();
    	// make an ArgList* from Arg***
    	// that points to the ArgList for the rule head
	
    	tempArg = (iterator.pipe)->rInfo->arg_list;
	
	// sanity check
	ASSERT(iterator.pipe->rInfo->num_literals ==iterator.pipe->curRule->num_preds);
    	ASSERT(env != NULL);

    	newArg = (ArgList *)(tempArg[(iterator.pipe)->rInfo->num_literals]);
    	while (unify_arg_lists( *newArg, iterator.arg_list,iterator.pipe->env,
				iterator.bindenv) != COR_U_SUCCEED)
    	{
    	    // unification failed - backtrack
    	    iterator.pipe->stackmark0.pop_to();
    	    // Try the next rule
    	    if (!(iterator.pipe->NextRule(md)))
    	    {
    	    	// if we have exhausted all the rules, give up
    	    	iterator.set_no_match();
		delete iterator.pipe;
                iterator.pipe = NULL;
#ifdef DO_TRACE    
	    	if (exEnv.dbg_get_next) {
		    fprintf(exEnv.trace_file,
			    "PipelinedDerivedRelation: new get_next failed on %s(",
			    name->string());
		    iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
		    fprintf(exEnv.trace_file, ")\n");
    	        }
#endif
    		return NULL;
		//FAIL_RETURN;
    	    }
    	    tempArg = (iterator.pipe)->rInfo->arg_list;
    	    newArg = (ArgList *)(tempArg[(iterator.pipe)->rInfo->num_literals]);
    	}
	
    } // if !iterator.pipe
    else {
//     iterator.pipe->stackmark0.pop_to();
#ifdef DO_TRACE
      if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,
		"PipelinedDerivedRelation: get_next repeat call on %s(", 
		name->string());
	iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
	fprintf(exEnv.trace_file, ")\n");
       }
#endif
     }

    // check to see that an interrupt has not been raised
    if (exEnv.C_interrupt_raised) {
#ifdef DO_TRACE
	    if (exEnv.dbg_get_next) {
    		fprintf(exEnv.trace_file,
			"PipelinedDerivedRelation: get_next failed on %s(",
			name->string());
    		iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
    		fprintf(exEnv.trace_file,") due to interrupt\n");
            }
#endif
      iterator.set_no_match();
      delete iterator.pipe;
      iterator.pipe = NULL;
      return NULL;
      //FAIL_RETURN;
    }
    
    iterator.prev_module_info = CurrModuleInfo;
    if (CurrModuleInfo != &(md->module_info))
      {
	T_Stack.push(md->F);
	CurrModuleInfo = &(md->module_info);
      }
    
    // Now go ahead and call Solve on PipelinedExecInfo
    // keep trying as long as no match is found
    while (!((iterator.pipe)->Solve()))
    {
    	iterator.pipe->stackmark0.pop_to();
    	// try the next rule 
    	if ( ((iterator.pipe)->cut_crossed) ||
    	    !(iterator.pipe->NextRule(md)))
    	{
            // if we have exhausted all the rules,
	    // or have failed because one rule tried to backtrack
            // past a cut, give up
    	    iterator.set_no_match();
	    delete iterator.pipe;
    	    iterator.pipe = NULL;
#ifdef DO_TRACE
	    if (exEnv.dbg_get_next) {
    		fprintf(exEnv.trace_file,
			"PipelinedDerivedRelation: get_next failed on %s(",
			name->string());
    		iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
    		fprintf(exEnv.trace_file,")\n");
            }
#endif
    	    //return NULL;
	    FAIL_RETURN;
    	}
    	tempArg = (iterator.pipe)->rInfo->arg_list;
    	newArg = (ArgList *)(tempArg[(iterator.pipe)->rInfo->num_literals]);
    	// See if the head of this rule unifies with the iterator
    	while (unify_arg_lists( *newArg, iterator.arg_list,
				(iterator.pipe)->env, env) != COR_U_SUCCEED)
    	{
	    // unification failed - backtrack
    	    iterator.pipe->stackmark0.pop_to();
    	    // Try the next rule
    	    if (!(iterator.pipe->NextRule(md))) {
    		// if we have exhausted all the rules, give up
    		iterator.set_no_match();
		delete iterator.pipe;
    		iterator.pipe = NULL;
#ifdef DO_TRACE
		if (exEnv.dbg_get_next) {
    		    fprintf(exEnv.trace_file,
			    "PipelinedDerivedRelation: get_next failed on %s(",
			    name->string());
    		    iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
                    fprintf(exEnv.trace_file, ")\n");
		}
#endif
    		//return NULL;
		FAIL_RETURN;
    	    }
    	    tempArg = (iterator.pipe)->rInfo->arg_list;
    	    newArg = (ArgList *)(tempArg[(iterator.pipe)->rInfo->num_literals]);
    	}
    }
    // Success
    iterator.reset_no_match();
#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
        fprintf(exEnv.trace_file,
		"PipelinedDerivedRelation: get_next succeeded on %s(",
		name->string());
        iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
        fprintf(exEnv.trace_file, ")\n");
    }
#endif
    
    //return NULL;
    FAIL_RETURN;
}

/*
 * used to automatically generate make_index annotations for a rule.
 * this function is similar to the identically named function in
 * interp.C
 */
static void generateIndices(RuleInfo *rInfo, QFModuleData *module)
{
  int i;
  VarLink *leading_vars, *indexing_vars ;

#define RULEPTR rInfo->rule
#define PREDINDEX(i) i

  /* The following code indexes base predicates in the rule */
  for(i=0; i < RULEPTR->num_preds; i++)
    // no point building an index on an arithmetic predicate
    if (!is_a_builtin(RULEPTR->preds[PREDINDEX(i)]->pred)) {
      leading_vars = vars_between(RULEPTR, 0, i-1, NULL, NULL);
      indexing_vars = intersect_var_lists(
	build_var_list(RULEPTR->preds[PREDINDEX(i)],NULL), leading_vars);
      create_an_annotation(module->index_annotations,
			   RULEPTR->preds[PREDINDEX(i)], indexing_vars);
    }

#undef RULE_STRUCT
#undef PREDINDEX
}

BacktrackInfoArray::BacktrackInfoArray(RuleInfoArray *rArray, int non_ground)
{
  numRules = rArray->numRules;
  firstFailureBacktrackArrays = new int* [numRules];
  nextFailureBacktrackArrays = new int* [numRules];
  successBacktrackPoints = new int [numRules];

  for (int i = 0; i < numRules; i++) {
    successBacktrackPoints[i] = 
	 getSuccessBacktrackPoint(rArray->rInfoPtrs[i], non_ground);

    if (rArray->rInfoPtrs[i]->num_literals) {
      firstFailureBacktrackArrays[i] = new int[rArray->rInfoPtrs[i]->num_literals];
      nextFailureBacktrackArrays[i] = new int[rArray->rInfoPtrs[i]->num_literals];

      initFailureBackTrack(rArray->rInfoPtrs[i], firstFailureBacktrackArrays[i],
			   nextFailureBacktrackArrays[i], non_ground);
     }
  }
}

// The class constructor for QFPipelinedModuleData

QFPipelinedModuleData::QFPipelinedModuleData (Table *table, 
					      RuleInfoArray *rArray,
					      ParserStruct& parserStruct)
	: backtrackInfo(rArray, parserStruct.CurModule.NonGroundFacts)
{
 F = table ;
 ruleArray = rArray ;
 multiset_annotations = parserStruct.MultisetAnnotations;
 index_annotations    = parserStruct.make_index_annotations;
 agg_sel_annotations  = NULL;
 prioritize_annotations  = NULL;
 diskrel_annotations    = NULL;
 
 TableSetUp = 0; // no pipelined execs in progress
 rel_options = 0;
 predicates = new ModulePred(NULL);
}

void QFPipelinedModuleData::clean_cache()
{
    for (int i = 0; i< ruleArray->num_rules();i++)
    	for (int j = 0;j< (ruleArray->rInfoPtrs[i])->num_literals;j++)
	    indices[i][j] = -1;
}


static void init_module_preds(QFModuleData *md)
{
 ModulePred *predicates = md->predicates->next;

 for (; predicates; predicates = predicates->next) { 
   Name name = predicates->pred->name;
   int arity = predicates->pred->arity;
   predicates->offset = get_offset(md->F, name, arity);
   switch (predicates->kind) {
    case QueryPredKind:
       predicates->check_subsum = determine_subsum_status(md, name, md->module_info.CheckSubsum);
       break;
    case LocalPredKind:
       predicates->check_subsum = determine_subsum_status(md, name, md->module_info.CheckSubsum);
       break;
    case MagicQueryPredKind:
       predicates->check_subsum = determine_subsum_status(md, name, md->module_info.CheckSubsum);
       break;
    case ExternalPredKind:
       break;
    }
   get_annos(md, predicates);
  }
}

/* 
 * interpretPipelined(QFPipelinedModuleData *md, ExportInfo *export_info)
 *
 * This function is passed a pointer to the QFPipelinedModuleData 
 * the information on the exported predicate 
 *
 * This function basically does for a Pipelined QFModuleData what Scc analysis 
 * does for a Materialized one
 */

void interpretPipelined(QFPipelinedModuleData *md, ExportInfo *export_info,
			ParserStruct& parserStruct)
{
    int i;
    Clause *tmp;
    int tvars,tliterals; // temporary vars used for calculating maximum vals

    ModulePred *predicates = md->predicates;

    Name exported_name = export_info->pred_name;
    Predicate *pred = export_info->predicate; /* ptr to exported pred */
    int query_arity = pred->arity;
    
    md->numPreds = 0;
    for(Predicate *p = parserStruct.AllPredicates; p!= NULL; 
	p = p->allprednext)
    {
    	for (Clause *c = p->clauses;c != *p->clause_tail; c = c->pnext)
    	{
            for (int ipred = 0; ipred < c->num_preds; ipred++) 
            {
    	        // not using Sccs for pipelining anyway
    		c->preds[ipred]->predicate->work = NULL;
    		c->preds[ipred]->predicate->scc = NULL;
		
    		// know whether already added using add_pred_extern() or not
    		c->preds[ipred]->predicate->mark = 0;
    	    }
    	}
    	md->numPreds++;
    }	
    
    // Make sure that all Relations used by the query are initialized
    // by initRulePointers. Use add_pred_extern to enter them into
    // the predicates collection to keep track of them.
    // First enter the the query predicate
    
    add_pred_extern(pred, QueryPredKind, predicates);
    // Have seen the exported predicate - all rules for it have been linked in
    pred->mark = 1;
    
    md->pred_ptrs = new Predicate *[md->numPreds] ;
    md->indices = new int*[md->ruleArray->num_rules()];
    md->maxNumVars= new int[md->numPreds];
    md->maxNumLiterals = new int[md->numPreds];
    
    for (i = 0,p = parserStruct.AllPredicates; p != NULL; 
	 p= p->allprednext,i++)
    {
    	md->maxNumVars[i] = md->maxNumLiterals[i] = 0; 
    	md->pred_ptrs[i] = p;
    	for (Clause *c = p->clauses;c != NULL ; c = c->pnext) 
    	{
    	    tliterals=((md->ruleArray)->rInfoPtrs[c->rule_number])->
		num_literals;
    	    tvars =((md->ruleArray)->rInfoPtrs[c->rule_number])->num_vars;
    	    // create indices
    	    md->indices[c->rule_number] = new int[((md->ruleArray)->
						   rInfoPtrs[c->rule_number])->num_literals];
    	    if (tliterals > md->maxNumLiterals[i])
    		md->maxNumLiterals[i] = tliterals;
    	    if (tvars > md->maxNumVars[i])
    		md->maxNumVars[i] = tvars;
    	    // Iterate over all the Literals that are invoked in c
    	    for (int ipred = 0; ipred < c->num_preds; ipred++) 
    	    {
    		Literal *child_literal = c->preds[ipred];
    		Predicate *child = child_literal->predicate;
    		// If we have already seen this predicate then don't insert it 
    		if (child->mark == 0)
    		{
    		    child->mark = 1;
    		    // add this predicate too
    		    tmp = child->clauses;
        	    // If child->clauses == *child->clause_tail, then
        	    // the child has no clauses, and is an ExternalPredKind.
                    add_pred_extern(child, tmp != *child->clause_tail ? 
				    LocalPredKind : ExternalPredKind, predicates);
    		}
    	    }
    	}
    }
    
    md->clean_cache();
    md->export_pred = export_info->predicate;
    md->module_info = parserStruct.CurModule;

    // move some of the run time work from initRulePointers to
    // compile time here. Determine what flags need to be set, etc.
    init_module_preds(md);
    
    // Insert the module structure along with its associated exported
    // query form into the DerivedMethod table.
    if (exported_name)
    {
        // The method really does not matter - not used anyway
        DerivedMethod* query_method = new DerivedMethod(exported_name,
							    export_info->adornment,NULL , (QFModuleData *)md);
    }
}

void PipelinedDerivedRelation::print_name(FILE *outf)
{
  char buf[500];

  sprintf(buf, "%s", SymbolString(name));
  fprintf(outf, "%15s/%d  : (pipelined) \n", buf, arity());
}

