/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifdef WITH_PERSISTENCE

#include "persistent-index.h"
#include <strings.h>
#include "interface.h"
#include "cor_error.h"
#include "persistent-rel.h"

extern int unify_literal(TupleIterator&, Tuple *, int) ;
extern int SM_initialized;

#define DELETE_INDEX_ENTRY 1
#define DELETE_OBJ_AND_INDEX_ENTRY 2

// temporary hack to avoid changing generic-index.h
// also see persistent-index.C  :: PRAVEEN
#define COR_I_PARTIAL_SUCCESS  2

/*------------------------------------------------------------------
  PersistentIndex() : Constructor that initializes the persistent-index
  structure from the catalog if it exists in the catalog. Otherwise,
  an error is raised.

 Oddities/Quirks :: Note that the file names are only guarenteed to be
 unique upto COR_MAX_FILE_NAME_LEN

 -------------------------------------------------------------------*/
PersistentIndex::PersistentIndex(PersistentRel *rel, BitVector *bv)
  : GenericIndex((StorageRelation *)rel, bv)
{
}

Tuple* PersistentIndex::get_next_tuple (TupleIterator& iterator)
{
  if (!SM_initialized) return NULL ;

  Tuple *tuple ;

  return p_rel()->indexScanGetNext(iterator, chosen_index);

}

BindEnv* PersistentIndex::get_next(TupleIterator& iterator)
{
  if (!SM_initialized) return NULL ;

  Tuple* tuple = get_next_tuple(iterator);
  if (iterator.no_match())
    return NULL;
  else return iterator.bindenv;
}

int PersistentIndexSet::insert_index(GenericIndex* index)
{
  if (!SM_initialized) return COR_I_FAIL ;

  PersistentIndex *p_index = (PersistentIndex *) index;

  for (int i = 0; i < num_in_array; i++) {
    if (p_index->argset != NULL) { /* argument form indexing */
      PersistentIndex *index_i = (PersistentIndex *)(Indices[i]);
      if (index_i->argset != NULL && 
	  *p_index->argset == *index_i->argset) {
#if DO_TRACE
	if (exEnv.GlobalRelationOptions & REL_DISPLAY_INDEXOPS) {
	  fprintf(exEnv.trace_file, "Duplicate index: not inserted\n");
	}
#endif
	return(COR_I_FAIL);
      }
    }
  }


  /* new index to be inserted in list */
  if (num_in_array == max_in_array) {
#ifdef DEBUG
    fprintf(exEnv.error_file, "Too many indices: not inserted\n");
#endif
    return COR_I_FAIL;
  }
    
  int e ;
  
  FileDescStruct *fd = & (((PersistentRel *)(p_index->relation))->fd);
  OID *oid = & (((PersistentRel *)(p_index->relation))->oid);
  USERDESC *u_desc ;
  
  // PRAVEEN:: These error checks are erroneous, since it is possible that the index does
  //           not really need to be created on disk !!

  // Check that an index can be added
  int index_offset ;
  if ((index_offset = fd->canAddIndex()) < 0 ) {
    CORAL_error(COR_INDEX_ERR, "Exceeded maximum number of indexes",
		"add_index") ;
    return COR_I_FAIL ;
  }
  
  ASSERT((p_index->argset != NULL) &&  
	 (p_index->argset->len() <= COR_MAX_ARGLIST_SIZE));

  // Create a new index on the file on the specified attributes
  p_index->chosen_index = fd->addIndex(index_offset, p_index->argset) ;


  // if a new index has been created
  if (p_index->chosen_index == index_offset) {

    if (OID_IS_INVALID(*oid)) {
      // this means that this relation is a temporary relation that has
      // not been entered into the catalog. 
      Indices[num_in_array++] = (GenericIndex *) p_index;
      return COR_I_SUCCESS;
     }

    // Change the catalog entry to reflect the new index
    if (!SM.retrieveObject(oid, &u_desc)) {
      CORAL_error(COR_ESM_ERR, NULL, "PersistentIndexSet::insert_index");
      return COR_I_FAIL;
    }
    // Safer to write the entire object, instead of calculating the
    // offset. You never know with C++ class structures what their
    // true sizes are !!
    e = sm_WriteObject(SM.bufGroup(), 0, sizeof(FileDescStruct),
		       (char *)(fd), u_desc, TRUE ) ;
    if (ErrorCheck(e, "sm_WriteObject")) return COR_I_FAIL ;

    Indices[num_in_array++] = (GenericIndex *) p_index;
    return COR_I_SUCCESS;
  }

  // otherwise, the index does not have to be created on disk. All the same, it is not
  // yet recorded in the indexset. This can happen during startup when indexes are being
  // added to a relation object based on what actually exists on disk.
  Indices[num_in_array++] = (GenericIndex *) p_index;
  return COR_I_PARTIAL_SUCCESS;
    
}

void PersistentIndexSet::fill_index(GenericIndex* index)
{
  SCANDESC *s_desc ;
  USERDESC *u_desc ;
  BOOL eof ;

  PersistentIndex *p_index = (PersistentIndex *) index;

  FileDescStruct& fd = ((PersistentRel *)(p_index->relation))->fd ;

  // If there are any existing tuples in the file, filter them
  // through the index

  int e = sm_OpenScanWithGroup(&(fd.fid), PHYSICAL_SCAN, SM.bufGroup(), &s_desc, NULL);
  if (ErrorCheck(e, "sm_OpenScanWithGroup")) return;
  
  int i;
  for (i = 0;;i++) {
    e = sm_ScanNextObject(s_desc, 0, READ_ALL, &u_desc, &eof) ;
    if (ErrorCheck(e, "sm_ScanNextObject")) break;
    
    // If there are no more tuples, break
    if (eof) break ;


    // start index scan for the first tuple :this is being done in this
    // fashion to work around an exodus bug
    if (i == 0) fd.startIndexScan(p_index->chosen_index);

    fd.addObjectToIndex(p_index->chosen_index, u_desc) ;
  }

  if (i)
    // end index scan
    fd.endIndexScan(p_index->chosen_index);
  
  e = sm_CloseScan(s_desc) ;
  ErrorCheck(e, "sm_CloseScan") ;
    
}


GenericIndex *PersistentIndexSet::find_index(ArgList &arg_list,
					     BindEnv *bindenv,
					     int *tryindexp /* = NULL*/)
{
/** find an index that best matches the pattern contained arg_list, bind_env **/
  
  if ( (tryindexp) && ((*tryindexp) >= 0) &&  ((*tryindexp) < num_in_array) )
    return ((GenericIndex *) Indices[*tryindexp]);

  if (num_in_array == 0) {
    return NULL;
  }

  // find bitvector of pattern 
  int arity = arg_list.count();

  BitVector adornment(arity);
  int num_bound = 0; /* number of bound arg positions in pattern */
  for (int i = 0; i < arity; i++) {
    int bound = 1;
    /* check which arguments are ground and set those bits to 1; rest 0 */
    if (arg_list[i]->hash(bindenv) == VarHashValue)
      bound = 0;
    if (bound == 1) num_bound++;
    adornment.set(i, bound);
  }

  // if it is an all-free query, do not choose an index !
  if (!num_bound) return NULL;

  GenericIndex *return_index = NULL;
  double max_weight = -1.0;
  
  for (i = 0; i < num_in_array; i++) {
    double cur_weight = 0.0;
    if (((PersistentIndex *) Indices[i])->argset != NULL) {
      if (arity != ((PersistentIndex *) Indices[i])->argset->len()) continue;
      if ((num_bound == arity) && 
	  (adornment == *(((PersistentIndex *) Indices[i])->argset))   
	  ) { /* All arguments are bound - no better match can be found. */
	if (tryindexp) *tryindexp = i;
	return ((GenericIndex *)Indices[i]) ;
      }
      for (int j = 0; j < arity; j++) {
	if (adornment.test(j) && 
	    ((PersistentIndex *) Indices[i])->argset->test(j)) {
	  cur_weight += 1.0;	/* both are bound */
	    continue;
	}
	if (((PersistentIndex *) Indices[i])->argset->test(j)) { 
	  /* and !adornment.test(j) 
	     the index has more bound arguments; it is useless */
	  cur_weight = 0.0; 
	  break;
	}
      }
    }
    if (cur_weight > max_weight) { /* need to update information */
      max_weight = cur_weight;
      if (tryindexp) *tryindexp = i;
      return_index = (GenericIndex *) Indices[i];
    }
  }

  return return_index;

}

#endif


