/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdio.h>
#include <string.h>
#include "parser.h"
#include "generic-rel.h"
#include "rules.h"
#include "collection.h"
#include "parse-utils.h"
#include "globals.h"

extern Arg* TheParameterArg;
static int C__BoundArgs12 = 1;


int check_builtin_op(Name name)
{
    for (int i = 0; builtin_ops[i] != 0; i++)
        if ((*builtin_ops[i]) == name) return i;
    return -1;
}

//This routine checks if the predicate is an arithmetic predicate
//Builtin_Arith_Start depends on the builtin_ops array defined in gram.y

static int is_arith_pred(Name pred_name) 
{
	if (check_builtin_op(pred_name) >= Builtin_Arith_Start) return(1) ;
	return(0) ;
}

static int is_convertible_pred(Name pred_name) 
{
	if (check_builtin_op(pred_name) >= Builtin_Convertible_Start) 
		return(1) ;
	return(0) ;
}
// Start a new argument list.
void push_arg_chain(ParserStruct& parserStruct)
{
    struct arg_chain *chain = new struct arg_chain;
    chain->pushed = parserStruct.cur_arg_chain;
    parserStruct.cur_arg_chain = chain;
    chain->count = 0;
    chain->last = NULL;
}

// Add an argument to the current argmenent list.
void append_arg(ParserStruct& parserStruct, Arg *a)
{
    struct arg_link *link = new struct arg_link;
    link->prev = parserStruct.cur_arg_chain->last;
    link->arg = a;
    parserStruct.cur_arg_chain->last = link;
    parserStruct.cur_arg_chain->count++;
}

// Add an argument to the current argmenent list.
void append_parameter(ParserStruct& parserStruct, Arg **a)
{
    struct parameter_link *link = new struct parameter_link;
    link->prev = parserStruct.parameters->last;
    link->parameter_slot = a;
    parserStruct.parameters->last = link;
    parserStruct.parameters->count++;
}

// Finish off and pop the currently-worked-on argument list.
void pop_arg_chain(ParserStruct& parserStruct, ArgList& args)
{
    register struct arg_chain *cur_chain = parserStruct.cur_arg_chain;
    if (!cur_chain) return;
    register Arg **dst_arg;
    int count = cur_chain->count;
    args.set_count(count);
    dst_arg = arg_vector(args) + count;
    for (;;) {
	struct arg_link *link = cur_chain->last;
	if (link == NULL) break;
	cur_chain->last = link->prev;
	*--dst_arg = link->arg;
	//if (link->arg == &TheParameterArg) {
	if (link->arg == TheParameterArg) {
	  append_parameter(parserStruct, dst_arg);
	  *dst_arg = &TheDontCareArg;
	}
	free (link);
    }
    parserStruct.cur_arg_chain = cur_chain->pushed;
    free (cur_chain);
}

void push_cur_set(ParserStruct& parserStruct, ArgPtr set) {

 /*
  *
  * utility routine for parsing sets.
  *
  * push the currently parsed set on a stack, and allocate a new slot
  * for a new nested set.
  *
  */

   set_stack *link = (set_stack *)malloc(sizeof(set_stack));
   link->info = set;
   link->prev = parserStruct.cur_set;
   parserStruct.cur_set = link;

}

void pop_cur_set(ParserStruct& parserStruct) {

 /*
  * 
  * utility routine for parsing sets.
  *
  * pop the set parse stack, and de-allocate the popped node.
  *
  */


   ASSERT(parserStruct.cur_set != NULL); // if NULL, it is a bug;
   set_stack *link = parserStruct.cur_set;
   parserStruct.cur_set = link->prev;
   free(link);

}


ArgPtr create_nested_multiset() {

 /*
  *
  * utility routine for parsing sets.
  *
  * allocate a new relation with subsumption turned off.
  * to store a nested multiset.
  *
  */


//   Relation *rel = AllocRelation(NestedSymbol,nested_set_arity);
   StorageRelation *rel = new HashSimpleRelation(nested_set_arity, 0,
					  COR_DEFAULT_SET_BUCKETS);
   rel->set_subsumption(0);
   rel->name = NestedSymbol;
   return( (ArgPtr)rel);

}



void insert_cur_set(ParserStruct& parserStruct, ArgPtr element) {

 /*
  * 
  * utility routine for parsing sets.
  *
  * insert an element into a nested set.
  *
  */


   Relation *rel = (Relation *)parserStruct.cur_set->info; 
   ArgList *copy_args = ArgList::New(nested_set_arity); 
   *(((Arg**)copy_args)+nested_set_arity) = element;
   Tuple *newtuple = new Tuple(copy_args);
   rel->insert_tuple(newtuple);
}

ArgPtr create_list(ParserStruct& parserStruct, ArgPtr cdr)
{
    register struct arg_chain *cur_chain = parserStruct.cur_arg_chain;
    while (cur_chain->last != NULL) {
	struct arg_link *link = cur_chain->last;
	FuncArg *cons = FuncArg::New(ConsSymbol, 2);
	cons->args[0] = link->arg;
	cons->args[1] = cdr;
	cur_chain->last = link->prev;
	free (link);
	cdr = cons;
    }
    parserStruct.cur_arg_chain = cur_chain->pushed;
    free (cur_chain);
    return cdr;
}

int rule_var_enter(ParserStruct& parserStruct, Name s)
{
    register int i;


    // NOTE : this is a kludge ! Unification with dont care terms
    // is tricky, so instead we force the DontCareSymbol to be
    // treated each time as a distinct variable. The parser
    // NEVER generates  TheDontCareArg !!
    if (s->equals(DontCareSymbol)){
	add_to_array(&parserStruct.rule_var_names, (int)s);
	return parserStruct.rule_var_names.length - 1;
    }

    for (i=0; i < parserStruct.rule_var_names.length; ++i)
	if (s == (Name)parserStruct.rule_var_names.data[i])
	    return (i);
    add_to_array(&parserStruct.rule_var_names, (int)s);
    return parserStruct.rule_var_names.length - 1;
}

rule_var_lookup(ParserStruct& parserStruct, Name s)
{
    register int i;

    for (i=0; i < parserStruct.rule_var_names.length; ++i)
	if ( s == (Name)parserStruct.rule_var_names.data[i])
	    return (i);
    fprintf(exEnv.error_file, "error line %d: %s not in rule\n", parseEnv.C_linenum, s);
    return (0);
}

int sip_var_lookup(ParserStruct& parserStruct, Name s)
{
    register int i;

    for (i=0; i < parserStruct.sip_var_names.length; ++i)
	if (s == (Name)parserStruct.sip_var_names.data[i])
	    return (i);
    fprintf(exEnv.error_file, "error line %d: %s not in plist\n", parseEnv.C_linenum, s);
    return (0);
}


// Makes array b a copy of array a 
// If no_arith is set, arithmetic predicates are not copied
static void copy_arrays(struct array * a, struct array * b, int no_arith) 
{
	if (a->data_size == 0) {
	    a->data_size = b->data_size;
	    a->data = (int *)malloc(a->data_size * sizeof(int));
	}
	else {
	    a->data_size = b->data_size;
	    a->data = (int*)realloc(a->data, a->data_size * sizeof(int));
	}

// Copy data from b to a
	if (!no_arith) {
	 // bcopy((char *)b->data,(char *)a->data, b->length*sizeof(int));
	 // memmove(a->data, b->data, b->length*sizeof(int)); :: NON_STANDARD
	 memcpy(a->data, b->data, b->length*sizeof(int));
	  a->length = b->length ;
	}
	else {
	  a->length = 0 ;
	  for (int i = 0; i < b->length; i++)
	  if ( ! is_arith_pred(((Literal *)(b->data[i]))->name()))
	 	a->data[a->length++] = b->data[i] ;

	}
}

//This routine checks to see if the arguments of the predicate are
//the same as either arg1 or arg2. If so, the corresponding Arg *
//is set to Arg *NULL to show that the argument has been bound
static void check_for_arg_bindings(Literal *pred, Arg**arg1, Arg**arg2)
{
  VarLink *list = NULL ;

// Get the list of variables bound in the predicate
  FOR_EACH_ARG(pred_arg, pred->args) {
	list = pred_arg->var_list(list);
  } END_EACH_ARG

  while (list != NULL) {

	if (*arg1 && ((VarArg *)(*arg1))->equals(list->arg))
		 *arg1 = NULL ;

	if (*arg2 && ((VarArg *)(*arg2))->equals(list->arg))
		 *arg2 = NULL ;

	list = list->next ;
  }

}

//This routine inserts the pred at position pos in the array
void insert_array_element(struct array *a, int pos, Literal * pred)
{
// Defensive programming :-)
	if (pos > a->length) return ;

	for (int i = a->length ; i > pos ; i--)
		a->data[i] = a->data[i-1] ;
	a->data[pos] = (int)pred ;
	(a->length)++ ;
}

//This routine inserts an arithmetic predicate in a position where its
// first two arguments are bound
static void insert_predicate(struct array *a, Literal *pred)
{
	Arg *arg1 = NULL, *arg2 = NULL;
	Arg ** temp ;
	int i ;

// Get the two unbound arguments of the predicate
//NOTE :: default C__BoundArgs12 is true.
	if (C__BoundArgs12) {
		temp = pred->args.first() ;
		arg1 = *(temp++);
		arg2 = *temp ;
	}
	if (arg1 && (arg1->kindof() != COR_VARIABLE)) arg1 = NULL ;
	if (arg2 && (arg2->kindof() != COR_VARIABLE)) arg2 = NULL ;

	for (i = 0; i < a->length ; i++) {
		// If both args are bound, get out of the loop
		if (!arg1 && !arg2) break ;
		check_for_arg_bindings((Literal *)(a->data[i]), &arg1, &arg2);
	}

	insert_array_element(a, i, pred) ;
	
}

extern int C_num_head_arith_lits;  /* declared in gram.y */

void simple_reorder_arith_preds(ParserStruct& parserStruct)
{

	if (C_num_head_arith_lits==0) 
		return;		/* No simple reordering to be done */
	struct array tempArray;
	int	curPred1 =0 ;     // Current predicate in parserStruct.rhspreds

	tempArray.length = tempArray.data_size = 0 ;
	tempArray.data = NULL ;

	for (curPred1 = C_num_head_arith_lits; 
			curPred1 < parserStruct.rhspreds.length; curPred1++) {

	    add_to_array(&tempArray,
		(int)(parserStruct.rhspreds.data[curPred1]));
	}
	for (curPred1 = 0; curPred1 < C_num_head_arith_lits; curPred1++)
	    add_to_array(&tempArray,
		(int)(parserStruct.rhspreds.data[curPred1]));

// NOTE : The memory allocated for one of the arrays must be freed
//        This is not done as of now

	parserStruct.rhspreds = tempArray ;
}


// This routine is probably outdated --- PRAVEEN
// This routine attempts to reorder the position of arithmetic predicates
//to improve efficiency of evaluation.
void reorder_arith_preds(ParserStruct& parserStruct)
{
	struct array tempArray;
	int	curPred1 =0 ;     // Current predicate in parserStruct.rhspreds

	tempArray.length = tempArray.data_size = 0 ;
	tempArray.data = NULL ;

// Make a copy of parserStruct.rhspreds, which will be reordered
	copy_arrays(&tempArray, &parserStruct.rhspreds, 1) ;

	for (curPred1 = 0; curPred1 < parserStruct.rhspreds.length; curPred1++) {

// This check identifies the arithmetic predicates.
		if (! is_arith_pred(
		((Literal *)(parserStruct.rhspreds.data[curPred1]))->name()) )
			continue ;

		// Move arithmetic predicate to a position where
		// its initial two arguments are bound
		insert_predicate(&tempArray,
				 (Literal *)(parserStruct.rhspreds.data[curPred1]));
	}

// NOTE : The memory allocated for one of the arrays must be freed
//        This is not done as of now

	parserStruct.rhspreds = tempArray ;
}

ArgPtr create_functor(ParserStruct& parserStruct, Name op)
{

    int builtin_index = check_builtin_op(op);
    // Check if something like: sum<ARG>.
    if (builtin_index >= 0 && builtin_index < (int)NoAggregation
	&& parserStruct.cur_arg_chain->count==1) {
	Arg *arg = parserStruct.cur_arg_chain->last->arg;
	if (arg->kindof() == COR_GROUPING) {
	    Grouping *nested = (Grouping*)arg;
	    Grouping *nest =
		new Grouping(nested->nestedArgs,
			     nested->index,
			     (enum AggregateKind)builtin_index);
	   // if (nest->kind == SetAggregation) nest->check_subsum = 1;
	    delete nested;
	    free(parserStruct.cur_arg_chain->last);
	    struct arg_chain *old_cur_chain = parserStruct.cur_arg_chain;
	    parserStruct.cur_arg_chain = parserStruct.cur_arg_chain->pushed;
	    free(old_cur_chain);
	    return nest;
	}
    }
    if (parserStruct.CurModule.ConvertFunctions && is_convertible_pred(op) ) {

	/* Rewrite: P(x op y) => op(x, y, TMP$i), P(TMP$i) */
	char tmp_buf[20]; Literal *pred;
	sprintf(tmp_buf, "TMP_%d_", parserStruct.rhspreds.length);
	Name tmp_sym = EnterSymbol(tmp_buf);;
	VarArg *tmp_var = 
	  new VarArg(tmp_sym,  
		     rule_var_enter(parserStruct, tmp_sym));
	pred = AllocLiteral(parserStruct, op,  
			    parserStruct.cur_arg_chain->count + 1);
	pop_arg_chain(parserStruct, pred->args);
	arg_vector(pred->args)[pred->args.count()] = tmp_var;
	pred->args.set_count(pred->args.count() + 1);
	add_to_array(&parserStruct.rhspreds, (int)pred);
	return tmp_var;
    }
    FuncArg *arg = FuncArg::New(op, parserStruct.cur_arg_chain->count);
    pop_arg_chain(parserStruct, arg->args);
    return arg;
}

ArgPtr pull_out_arith_expr(ParserStruct& parserStruct)
{
    char tmp_buf[20]; 
    Literal *pred;
    sprintf(tmp_buf, "TMP_%d_", parserStruct.rhspreds.length);
    Name tmp_sym = EnterSymbol(tmp_buf);
    VarArg *tmp_var = new VarArg(tmp_sym,
		 rule_var_enter(parserStruct, tmp_sym));
    pred = AllocLiteral(parserStruct, EquOpSymbol, 2);
    pop_arg_chain(parserStruct, pred->args);
    arg_vector(pred->args)[1] = tmp_var;
    pred->args.set_count(2);
    add_to_array(&parserStruct.rhspreds, (int)pred);
    return tmp_var;
}

ArgPtr create_grouping(ParserStruct& parserStruct)
{
    if (exEnv.dbg_aggregates)
      fprintf(exEnv.error_file,"in create relation count %d\n",
	      parserStruct.cur_arg_chain->count);
    Grouping *arg = Grouping::New(parserStruct.cur_arg_chain->count);
    arg->set_subsumption( (short)(1));
    arg->index = parserStruct.nested_index++;
    pop_arg_chain(parserStruct, arg->nestedArgs->args);
    return arg;
}

ArgPtr create_multi_grouping(ParserStruct& parserStruct)
{
    if (exEnv.dbg_aggregates)
    fprintf(exEnv.error_file,"in create relation count %d\n", parserStruct.cur_arg_chain->
count);
    Grouping *arg = Grouping::New(parserStruct.cur_arg_chain->count);
    arg->set_subsumption( (short)(0));
    arg->index = parserStruct.nested_index++;
    pop_arg_chain(parserStruct, arg->nestedArgs->args);
    return arg;
}

void AddExportInfo(ParserStruct& parserStruct, FuncArg *arg)
{
    if (arg->kindof() != COR_FUNCTOR) {
	fprintf(exEnv.error_file,
		"export must be followed by a functor.");
	return;
    }
    for (int i = 0; ; ) { /* Do at least once. */
	ExportInfo *new_info = new ExportInfo;
	new_info->next = parserStruct.CurModule.ExportedPreds;
	new_info->pred_name = arg->functor();
	new_info->adorn_symbol = NULL; /* Arity == 0. */
	new_info->sequence = parserStruct.CurModule.ExportedCount++;
	if (arg->args.count() == 0) ;
	else if (arg->args[i]->kindof() != COR_SYMBOL_CONST)
	    fprintf(exEnv.error_file, "Bad kind of adornment for export %s.\n",
		    arg->functor()->string());
	else {
	    new_info->adorn_symbol = (Name)arg->args[i];
	    if (ConvertAdornment(new_info->adornment,
				 new_info->adorn_symbol->string(),
				 (int) new_info->adorn_symbol->length()))
		fprintf(exEnv.error_file, "Bad character in adornment string '%s'\n",
			new_info->adorn_symbol->string());
	}
	new_info->predicate = NULL;
	parserStruct.CurModule.ExportedPreds = new_info;
	if (++i >= arg->args.count())
	    break;
    }
}


void COR_set_preprocessing(ModuleInfo& Module, int val)
{
  Module.PreProcessing = val;
}

void COR_set_no_magic(ModuleInfo& Module)
{
   Module.UseSupplementaryMagic = 0;
   Module.UseMagic = 0;
   Module.SupMagicIndexing = 0;
}

void COR_set_use_factormagic(ModuleInfo& Module, int val)
{
  Module.UseFactorMagic = val;
}

void COR_set_use_factoring(ModuleInfo& Module, int val)
{
  Module.UseFactoring = val;
}

void COR_set_supplementary_magic(ModuleInfo& Module, int val)
{
   Module.UseSupplementaryMagic = val;
   if (val) Module.UseMagic = 0;
}

void COR_set_ordinary_magic(ModuleInfo& Module, int val)
{
   Module.UseMagic = val;
   if (val) Module.UseSupplementaryMagic = 0;

}


void COR_set_exist_opt(ModuleInfo& Module, int val)
{
  Module.UseExistOpt = val;
}

/*
void COR_set_rewriting(ModuleInfo& Module, int val)
{
  Module.Rewriting = val;
}
*/

void COR_set_rewriting(ModuleInfo& Module, int val)
{
  Module.Rewriting = val;
/*  if (!val) {
    COR_set_no_magic(Module);
    COR_set_use_factoring(Module, 0);
    COR_set_use_factormagic(Module, 0);
    COR_set_exist_opt(Module, 0);
  }
*/
}


void COR_set_sup_magic_indexing(ModuleInfo& Module, int val)
{
   Module.SupMagicIndexing = val;
   if (val) COR_set_supplementary_magic(Module, val);
}

void COR_set_save_module(ModuleInfo& Module, int val)
{
   Module.SaveModule = val;
}

void COR_set_use_ordsearch(ModuleInfo& Module, int val)
{
  Module.UseOrdSearch = val;
}

void COR_set_eager_eval(ModuleInfo& Module, int val)
{
  Module.EagerEval = val;
}

void COR_set_monotonic(ModuleInfo& Module, int val)
{
  Module.Monotonic = val;
}


void COR_set_pipelining(ModuleInfo& Module, int val)
{
  Module.UsePipelining = val;
  if (val) {
    COR_set_rewriting(Module, 0);
  }
}

void COR_set_predicate_seminaive(ModuleInfo& Module, int val)
{
   Module.UsePredicateSN = val ;
}

void COR_set_check_subsum(ModuleInfo& Module, int val)
{
  Module.CheckSubsum = val;
}

void COR_set_return_unify(ModuleInfo& Module, int val)
{
  Module.UseReturnUnify = val;
}

void COR_set_multisets(ModuleInfo& Module, int val)
{
  Module.MultiSet = val;
  if (val) Module.CheckSubsum = 0;
}

void COR_set_non_ground_facts(ModuleInfo& Module, int val)
{
  Module.NonGroundFacts = val;
}

void COR_set_disk_resident(ModuleInfo& Module, int val)
{
  Module.DiskRel = val;
}


void COR_set_index_deltas(ModuleInfo& Module, int val)
{
  Module.IndexDeltas = val;
}

void COR_set_single_scc(ModuleInfo& Module, int val)
{
  Module.SingleScc = val;
}

void COR_set_single_answer(ModuleInfo& Module, int val)
{
  Module.SingleAnswer = val;
}

void COR_set_convert_functions(ModuleInfo& Module, int val)
{
  Module.ConvertFunctions = val;
}


// called from the parser : takes the information collected in the
// parserStruct and fills the cur_rule structure with it
void complete_rule(Clause *cur_rule, ParserStruct& parserStruct)
{
  cur_rule->num_var_names =  parserStruct.rule_var_names.length;
  if (parserStruct.rule_var_names.length == 0) {
    cur_rule->var_names = NULL;
   } else {
     // Keep the following as malloc so that 
     // we can realloc as required.
     cur_rule->var_names = (Name*)
       malloc(parserStruct.rule_var_names.length * sizeof(Name));
     for (int i=0; i< parserStruct.rule_var_names.length; ++i)
       cur_rule->var_names[i] = (Name)parserStruct.rule_var_names.data[i];
    }
  alloc_preds(cur_rule, parserStruct.rhspreds.length);
  
  simple_reorder_arith_preds(parserStruct);
  
  /* Copy literals from parserStruct.rhspreds 
     to new cur_rule. */
  for (int i= 0; i < parserStruct.rhspreds.length; ++i)
    cur_rule->preds[i] = (Literal*)parserStruct.rhspreds.data[i];
  
  add_rule(cur_rule, parserStruct.rules);
  
  AddClauseToPredicate(cur_rule->head->predicate,
		       cur_rule);
  parserStruct.rule_list = (struct rule*)parserStruct.rules->chain;

 }
