/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/**********

 This file contains functions used by the parser to perform actions on recognizing
various grammar rules.

**********/

#include <stdio.h>
#include "parser.h"
#include "generic-rel.h"
#include "builtin-syms.h"
#include "parse-utils.h"
#include "profile.h"
#include "annotations.h"
#include "globals.h"

#define TMP_RELNAME  "__RelTemp"

extern Association * DeleteInTab(struct SymbolTable *tab, ConstPointer arg);
extern int renameRelation(Name relname, Name newName);
extern void interpret_module(ParserStruct&);
extern void perform_rewriting(ParserStruct&);
extern int execute_single_rule(ParserStruct &parserStruct);
extern void complete_rule(Clause *cur_rule, ParserStruct& parserStruct);

extern FILE *yyin;
extern void yyrestart(FILE *);

void ParserEnv::init()
{
 C_linenum = 0;
 prompt = CORAL_PROMPT;
 show_prompt = 1;

 history = new History(MAX_HISTORY_DEPTH);
 command_count = 0;
 is_history_command = 0;

 linebuf[0] = '\0';
 line_offset = 0;
 commandbuf[0] = '\0';
 command_offset = 0;

 in_query_loop = 0;
 c_module_separator = 0;
 C_at_end_module = 1;
}

void ParserEnv::print_prompt()
{
 if (show_prompt && exEnv.C_print_prompt_default){
   printf("%d:%s", command_count, prompt);
   fflush(stdout) ;
  }
}

void ParserEnv::handle_history()
{
  if (incr_command_count && !is_history_command)
    (history)->addCommand(commandbuf, command_count++);
  
  if (line_offset + command_offset >= MAX_RULE_LENGTH) {
    fprintf(exEnv.error_file, "CORAL::Warning : Line buffer size exceeded !\n");
  }
  strncat(linebuf, commandbuf, command_offset);
  line_offset += command_offset;
  commandbuf[0] = '\0'; command_offset = 0;
  is_history_command = 0;
}

void ParserEnv::handle_new_file(FILE *fd, char *fname)
{
 if (!fileStack.is_empty()) {   
   fileStack.set_top_file_line(C_linenum);
  }
 fileStack.push(fd,1, fname);
 reset_position();
}

void ParserEnv::reset_position()
{
 yyin = fileStack.top_file();
 C_linenum = fileStack.top_file_line();
 show_prompt = (yyin == stdin);
 incr_command_count = (yyin == stdin);
 yyrestart(yyin);
}

int ParserEnv::get_next_file()
{
 fclose(yyin);
 fileStack.pop();
 if (fileStack.is_empty()) return 0;
 reset_position();
 return 1;
}

void ParserEnv::abort_file()
{
 if (!fileStack.is_empty() && fileStack.top_file() != stdin) {
   fclose(yyin);
   fileStack.pop();
   reset_position();
  }
 
}

/***********************************************************************************/

static int is_recursive(ParserStruct &parserStruct)
{
  Literal *head = parserStruct.cur_rule->head;
  Literal *body_pred;

  for (int i = 0; i < parserStruct.rhspreds.length; i++) {
    body_pred = (Literal*)parserStruct.rhspreds.data[i] ;
    if ((head->pred == body_pred->pred) &&
	(head->arity() == body_pred->arity())) {
      return 1;
    }
  }
  return 0;
}

void AppendFunction(ParserStruct& parserStruct)
{
  StackMark stack_mark;

  if (parseEnv.in_query_loop) {
    if (is_recursive(parserStruct)) {
      fprintf(exEnv.error_file, "CORAL::error :");
      fprintf(exEnv.error_file, "Recursion not allowed in imperative rule!\n");
     }
    else {
      complete_rule(parserStruct.cur_rule, parserStruct);
      int num_ans = execute_single_rule(parserStruct);
      if (exEnv.C_verbose_answer_default) 
	fprintf(exEnv.print_file, "(Number of Tuples to Append = %d)\n", num_ans);
     }
   }
  else {
    fprintf(exEnv.error_file, "CORAL::error :");
    fprintf(exEnv.error_file, "Imperative statement inside module!\n");
  }
  if (exEnv.C_verbose_answer_default) fflush(exEnv.print_file);
  stack_mark.pop_to();   
}


void DeleteFunction(ParserStruct& parserStruct)
{
  StackMark stack_mark;

  if (parseEnv.in_query_loop) {
    if (is_recursive(parserStruct)) {
      fprintf(exEnv.error_file, "CORAL::error :");
      fprintf(exEnv.error_file, "Recursion not allowed in imperative rule!\n");
     }
    else {
      complete_rule(parserStruct.cur_rule, parserStruct);

      Name headName = parserStruct.cur_rule->head->pred;
      Name tmpName  = EnterSymbol(TMP_RELNAME);

      // rename the <head relation> to TMP_NAME
      if (!renameRelation(headName, tmpName)) {
	fprintf(exEnv.error_file, "unable to rename file\n");
	return;
       }

      // the tuples to delete are inserted into a new <head relation>
      int num_ans = execute_single_rule(parserStruct);

      Relation *rel = find_external_relation(headName,
				    parserStruct.cur_rule->head->arity());
      
      Relation *temprel = find_external_relation(tmpName,
					parserStruct.cur_rule->head->arity());


      if (!rel || !temprel) {
	fprintf(exEnv.error_file, "Strange brew !!\n");
	return;
       }

      // Then delete the tuples in <head relation> from TMP_NAME
      Tuple *tuple ;
      FOR_EACH_TUPLE(tuple, rel) {
	temprel->tuple_delete(tuple);
      }END_EACH_TUPLE(tuple);

      // Finally, close the <head relation>
      rel->empty_relation(0);
      DeleteInTab(CurDB->RelationTable, headName);
      delete rel ;

      // rename TMP_NAME to <head relation>
      if (!renameRelation(tmpName, headName)) {
	fprintf(exEnv.error_file, "unable to rename tmp file\n");
	return;
       }

      if (exEnv.C_verbose_answer_default) 
	fprintf(exEnv.print_file, "(Number of Tuples to Delete = %d)\n", num_ans);
     }
   }
  else {
    fprintf(exEnv.error_file, "CORAL::error :");
    fprintf(exEnv.error_file, "Imperative statement inside module!\n");
  }
  if (exEnv.C_verbose_answer_default) 
    fflush(exEnv.print_file);
  stack_mark.pop_to();
   
}


void AssignFunction(ParserStruct& parserStruct)
{
  StackMark stack_mark;

  if (parseEnv.in_query_loop) {
    if (is_recursive(parserStruct)) {
      fprintf(exEnv.error_file, "CORAL::error :");
      fprintf(exEnv.error_file, "Recursion not allowed in imperative rule!\n");
     }
    else {
      complete_rule(parserStruct.cur_rule, parserStruct);

      Relation *rel = find_external_relation(parserStruct.cur_rule->head->pred,
					parserStruct.cur_rule->head->arity());

      // Clear the lhs relation.
      if (rel) rel->empty_relation(0);

      // now execute the rule
      int num_ans = execute_single_rule(parserStruct);

      if (exEnv.C_verbose_answer_default) 
	fprintf(exEnv.print_file, "(Number of Tuples to Assign = %d)\n", num_ans);
     }
   }
  else {
    fprintf(exEnv.error_file, "CORAL::error :");
    fprintf(exEnv.error_file, "Imperative statement inside module!\n");
  }
  if (exEnv.C_verbose_answer_default) 
    fflush(exEnv.print_file);

  stack_mark.pop_to();   
}

void QueryFunction(ParserStruct& parserStruct)
{
  if (!parseEnv.in_query_loop) {
    fprintf(exEnv.error_file, "CORAL::error :");
    fprintf(exEnv.error_file, "Imperative statement inside module!\n");
    return;
  }
  
  StackMark stack_mark;
  Symbol *varSymbol;

#ifdef DO_PROFILE
  GlobalProfileInfo.clear() ;
#endif

 Symbol *headSymbol;

  if (exEnv.C_answer_style_default == COR_EMPTY_ANSWER_PRINT)
    headSymbol = PrintEmptySymbol;
  else if (exEnv.C_answer_style_default == COR_TUPLE_ANSWER_PRINT)
    headSymbol = PrintTupleSymbol;
  else
    headSymbol = PrintBindingSymbol;

 struct rule *cur_rule = parserStruct.cur_rule;
 // make printa() the head of the rule 
 cur_rule->head = AllocLiteral(parserStruct, headSymbol,
			       parserStruct.rule_var_names.length);
 // create the arglist of printa() to have all the
 // variables in the body of the query 
 for (int i = 0; i < cur_rule->head->arity(); i++) {
   varSymbol=(Symbol *)parserStruct.rule_var_names.data[i];
   cur_rule->head->args[i] = new VarArg(varSymbol,
					rule_var_enter(parserStruct, varSymbol));
  }

  exEnv.C_interactive_mode_current = exEnv.C_interactive_mode_default;

  complete_rule(parserStruct.cur_rule, parserStruct);

  int num_ans = execute_single_rule(parserStruct);
  if (exEnv.C_verbose_answer_default) {
    fprintf(exEnv.print_file, "(Number of Answers = %d)\n", num_ans);
    fflush(exEnv.print_file);
   }

  stack_mark.pop_to();
   
}

void FactFunction(ParserStruct& parserStruct)
{
  if (parserStruct.rhspreds.length > 0) {
    fprintf(exEnv.error_file, "CORAL::error : ");
    fprintf(exEnv.error_file, "Rule declared outside a module!\n");
  }

  Relation *rel;
  rel = find_external_relation(parserStruct.cur_rule->head->pred,
			       parserStruct.cur_rule->head->arity());
  // use the kludge that ensures that all builtins have count = -1
    
  if (!(exEnv.C_insert_mode_default) && 
      !parseEnv.fileStack.is_empty() &&
      parseEnv.fileStack.top_file() == stdin) {
    if (!rel || rel->count >= 0) {
      fprintf(exEnv.error_file, "CORAL::error : ");
      fprintf(exEnv.error_file, "Not in insert mode !\n");
      return;
     }
   }
  
  if (!rel)
    rel = make_relation(parserStruct.cur_rule->head->pred,
			parserStruct.cur_rule->head->arity());
  
  BindEnv *insert_env = NULL;
  if (parserStruct.rule_var_names.length > 0)
    insert_env = new VersionedBindEnv(parserStruct.rule_var_names.length);
  
  rel->insert_new(parserStruct.cur_rule->head->args, insert_env);
  if (insert_env)
    delete insert_env;
  
}

void EndModuleFunction(ParserStruct& parserStruct)
{
  if (parserStruct.CurModule.PreProcessing) 
//  if (parserStruct.CurModule.Rewriting)
    perform_rewriting(parserStruct);
  else {
    interpret_module(parserStruct) ;
  }
  parserStruct.cur_rule = NULL;
}
