/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "linked-rel.h"
#include "profile.h"
#include "globals.h"
#include "interp.h"

extern int subsumes_tuple(Tuple *tuple, Tuple *newtuple, int display);
extern int unify_literal(TupleIterator &iterator, Tuple *tuple, int display);

LinkedRelation::LinkedRelation(int arity, int delta) :
	StorageRelation(arity, delta), index_set(this) 
{ 
  /*  It is essential to have at least one index - a lot of code 
      depends on this. */
    
  BitVector* bv1 = new BitVector(arity);
  for (int i = 0; i < arity; i++)   bv1->set(i); // all arguments bound
  HashIndex* h1 = new HashIndex( this, bv1) ;
  index_set.insert_index( h1 );

}

RMark * LinkedRelation::getMark()
{
    return new RMark(lastptr);
}



void LinkedRelation::initialize_iterator( TupleIterator& iterator )
{
#ifdef DO_TRACE
  if (exEnv.dbg_get_next) {
    fprintf(exEnv.trace_file, "\nLinkedRelation::initialize_iterator: ");
    iterator.relation->name->print(NULL, exEnv.trace_file);
    fprintf(exEnv.trace_file, " ( ");
    iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
    fprintf(exEnv.trace_file, " )\n");
  }
#endif
  iterator.stack_mark.get_mark();

  Term t1;
  int all_free = 1;

  for (int i = 0; i < _arity; i++) {
    if (iterator.arg_list[i]->hash(iterator.bindenv) != VarHashValue) {
      all_free = 0;
      break;
    }
  }

  if (! delta_indexed) {
    if (iterator.start_mark) { /* don't need to go to the hash table  */
      iterator.ipos = Scanning_New;
      iterator.ppos = (iterator.start_mark)->lastptr;
    }
    else {
      // need to scan from hash table
      // find the appropriate index to be used
      if (all_free) { 
	iterator.ppos = &chain;
	iterator.index = NULL;
      }
      else 
	iterator.index = index_set.find_index( iterator );
    }
    } 
  else {
    if ( !iterator.in_delta()) { /* Starting on main relation */
      if (iterator.start_mark) { /* go to the delta relations */
	iterator.ipos = Scanning_Init;
	iterator.delta_rel_pos =  (iterator.start_mark)->rel_p;
      }
      else {
	// need to scan from hash table
	// find the appropriate index to be used
	if (all_free) {
	  iterator.ppos = &chain;
	  iterator.index = NULL;
	}
	else 
	  iterator.index = index_set.find_index( iterator );
      }
    }
    else {  /* In a delta relation */
      if (all_free) {
	iterator.ppos = &chain;
	iterator.index = NULL;
      }
      else 
	iterator.index = index_set.find_index( iterator );
    }
  }

#ifdef DO_TRACE
  if (exEnv.dbg_get_next && !iterator.index) {
    fprintf(exEnv.trace_file, " : using tuple list !\n");
  }
#endif

}

#define FAIL_RETURN  {iterator.ipos = Scanning_Done; 	\
			iterator.set_no_match();	\
			return NULL;			\
		     }

Tuple *LinkedRelation::get_next_tuple(TupleIterator& iterator)
{
#ifdef DO_PROFILE
  if (TableStackCount > 0)
    ((TableStack[TableStackCount-1])->moduledata->module_info.
     GlobalProfileInfo.getnexts)++;
  else
    (GlobalProfileInfo.getnexts)++ ;
#endif
  
  BindEnv *result_env = iterator.bindenv;
  iterator.tuple_env = NULL;
  
  Tuple *result = NULL;

  if (exEnv.C_interrupt_raised) FAIL_RETURN;

  // initialize
  if (iterator.ipos == Scanning_Init)
    initialize_iterator(iterator);
  else iterator.stack_mark.pop_to();


  if (!iterator.index) {      /* an unbound scan using the linked rel ! */

    // The current position is remembered in (TupleLink**)iterator.ppos.
    TupleLink **next_ptr = (TupleLink**)iterator.ppos;
    StackMark stack_mark;

    for (;;) {
      if (*next_ptr == NULL) { 
	iterator.stack_mark.pop_to();
	FAIL_RETURN;
      }
      if (iterator.end_mark)
	if ((iterator.end_mark)->lastptr == next_ptr)
	  { 
	    iterator.stack_mark.pop_to();
	    FAIL_RETURN;
	  }
      iterator.ipos++;
      Tuple *tuple = (*next_ptr)->tuple;
      if (tuple->is_deleted()) { 
	// the tuple has been logically deleted
	  
	*(next_ptr) = (*next_ptr)->next;
	if (scan_count == 1)
	  delete (*next_ptr);
	
#ifdef DO_PROFILE
	if (TableStackCount > 0)
	  (TableStack[TableStackCount-1]->moduledata->module_info.
	   GlobalProfileInfo.deleted_tuples)++ ;
	else
	  (GlobalProfileInfo.deleted_tuples)++ ;
#endif
	continue;
      }
      
      next_ptr = &(*next_ptr)->next;
      iterator.ppos = next_ptr;
      
      if (unify_literal(iterator, tuple, 0))
	return tuple;
      
      stack_mark.pop_to();
    }
  }
  else {  /* use the chosen hash-index : ASSUME DELTA_INDEXING */

    if (!iterator.in_delta()) { /* Scanning from main hash table */
      result = iterator.index->get_next_tuple( iterator);
      if (result != NULL) return result;
      if (!delta_relations) FAIL_RETURN;
	
      // now go into the delta relations
      iterator.ipos = Scanning_Init;	// Scanning_Init for delta reln
      iterator.delta_rel_pos = delta_relations->reln_chain;
    }
    // delta_rel_pos has to have been set by this point.
    if (delta_relations != NULL) { 
      // iterator scanning deltas, this == main relation
	for(;;) { /* Loop till successful delta is found */
	  if (iterator.ipos == Scanning_Init) {
	    if(iterator.delta_rel_pos == NULL)
	      FAIL_RETURN;
	    if (iterator.end_mark && (iterator.delta_rel_pos == 
				      (iterator.end_mark)->rel_p)) 
	      FAIL_RETURN;
	  }
	  result = iterator.delta_rel_pos->reln->get_next_tuple(iterator);
	  if (result != NULL) return result;
	  // Done with current delta relation.  Got to go to next delta.
	  iterator.delta_rel_pos = iterator.delta_rel_pos->next;
	  iterator.ipos = Scanning_Init;  	
	  // To start on new delta reln.
	} 
    }
    else { 
      // iterator scanning deltas, this == delta relation
      return iterator.index->get_next_tuple( iterator);
    }
   
  }
 }

void LinkedRelation::release(TupleIterator& )
{
    /* Do nothing, since TupleIterator does not maintain extra info to
    be released in the case of LinkedRelations. */
}

BindEnv *LinkedRelation::get_next(TupleIterator& iterator)
{
   Tuple *result = get_next_tuple(iterator);
   if (!result) return NULL;
   return iterator.bindenv;
}

int LinkedRelation::is_subsumed(Tuple *newtuple, RMark *start_mark, 
					RMark *end_mark)
{

    TupleLink **next;
    if (start_mark == NULL) next = &chain;
	else next = (start_mark)->lastptr;
    StackMark stack_mark;

    for (;;) {
	if (*next == NULL) { 
	     return is_agg_subsumed(newtuple, start_mark, end_mark);
	}
	if (end_mark)
	    if ((end_mark)->lastptr == next) { 
		return is_agg_subsumed(newtuple, start_mark, end_mark); 
	    }
	Tuple *tuple = (*next)->tuple;
	next = &(*next)->next;

        if (tuple->is_deleted()) // tuple has been logically deleted
		{ 
		  *(next) = (*next)->next;
		  if (scan_count == 1)
		    delete (*next);
#ifdef DO_PROFILE
        if (TableStackCount > 0)
	  (TableStack[TableStackCount-1]->moduledata->module_info.
	   GlobalProfileInfo.deleted_tuples)++ ;
	else
	  (GlobalProfileInfo.deleted_tuples)++ ;
#endif
		  continue;
		}
        
	if (subsumes_tuple(tuple, newtuple, (DISPLAY_INSERTIONS)) )
	    return 1;

	stack_mark.pop_to();
    }
}

int LinkedRelation::insert_raw(Tuple *tuple)
{

  // tuple has been logically deleted
  if (tuple->is_deleted()) return 0;

  tlist_insert_tuple(tuple);

  /** inserts tuple into each index constructed for the relation. **/
    
  for (int i = 0; i < index_set.num_indices(); i++) {
    index_set[i]->insert_tuple(tuple);
  }
  return 1;
}

void LinkedRelation::empty_relation(int deleteTuples /* =0 */ )
{	// Empty out relation, but do NOT delete tuples (which may be shared)

    TupleLink* next;
    for (TupleLink *link = chain; link != NULL; link = next) {
	if (deleteTuples) delete link->tuple;
	next = link->next;
	delete link;
    }
    chain = NULL;
    lastptr = &chain;
}

void LinkedRelation::print_name( FILE *outf)
{
  fprintf(outf, "%15s/%d  : (base:list)    ", SymbolString(name), arity()) ;
  index_set.print_adornments(outf);
  fprintf(outf, ": count %d\n", count);
}
