/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/* Copyright Per Bothner 1987. Read the file Q-INFO */
#include <stdio.h>
#include "hash.h"
#include "externs.h"
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

typedef Association (*Func)(Pointer, Association*);

Association * SymbolLookup(HashTable *tab, ConstPointer arg)
{
    unsigned short hash = (unsigned short) SymbolHash(arg);
#define HASH_ELEMENT_TYPE Association
#define HASH_LENGTH_LOG tab->tab_len_log
#define HASH_ELEMENT_LOG tab->element_len_log
#define HASH_TO_INDEX(hash) \
    (hash >> (HASH_WORD_LEN - HASH_LENGTH_LOG)) << HASH_ELEMENT_LOG
#define HASH_EQUAL(element,arg) (element->arg==(Pointer)arg)
//#define HASH_EQUAL(element,arg) (((Symbol *)(element->arg))->equals((Symbol *)arg))
#define HASH_NULL(element) (element->arg==HashNull)
#define HASH_DATA tab->data
#define HASH_DELETED(element)  (element->arg == HashDeleted)
/* the mask is redundant if masking is done before indexing */
#define HASH_TO_STEP(hash) \
	(((hash<<1)+1) & ((1<<HASH_LENGTH_LOG)-1)) << HASH_ELEMENT_LOG
#include "hashfunc.h"
}

struct HashFuncs StdHashFuncs = {NULL, SymbolLookup};

Association * DeleteInTab(struct SymbolTable *tab, ConstPointer arg)
  {
    Association *p = SymbolLookup(tab, arg);
    if (HashNone(p->arg)) return NULL;
    tab->cur_size--;
    tab->cur_deleted++;
    p->arg = HashDeleted;
    return p;
  }

void ForEachTabElement(register struct SymbolTable *tab, Func f, Pointer extra)
{
    register i; register Association *element;
    i = 1<<tab->tab_len_log; element = tab->data;
    for (; i > 0; i--) {
        if (!HashNone(element->arg))
	    (*f)(extra, element);
	element = (Association*)((char*)element + tab->element_len);
    }
}

void TabInserted(register struct SymbolTable *tab, Association *)
  { int max = 1<<tab->tab_len_log;
    max -= max>>3; /* max is ceiling(max_space*7/8) */
    tab->cur_size++;
    if (tab->cur_size >= max)
	RehashBigger(tab);
  }

void TabInsert(register struct SymbolTable *tab, Association *element)
  { register Pointer *dst, *src = (Pointer*)element;
    register len = tab->element_len >> 2;
    dst = (Pointer*)(*tab->f->lookup)(tab, element->arg);
    if (HashNone(((Association*)dst)->arg))
      {
	while (--len >= 0)
	    *dst++ = *src++;
	TabInserted(tab, element);
      }
    else
	while (--len >= 0)
	    *dst++ = *src++;
  }

void Insert(register HashTable *tab, ConstPointer arg, Pointer val)
{
    Association element;
    element.arg = arg;
    element.val = val;
    TabInsert(tab, &element);
}

void RehashBigger(register struct SymbolTable *tab)
  { Association *old_data = tab->data;
    register int i; register char *element;
    register size;
    i = 1<<tab->tab_len_log; element = (char*)old_data;
    tab->tab_len_log++;
    size = 1<<(tab->element_len_log + tab->tab_len_log);
    tab->data =	(Association*)malloc(size);
    tab->cur_size = 0;
    //bzero(tab->data, size);
    memset(tab->data,0, size);
    if (old_data)
      {
	size = tab->element_len;
	for (; i > 0; i--, element = element + size)
            if (!HashNone(((Association*)element)->arg))
		TabInsert(tab, (Association*)element);
 	free(old_data);
      }
  }

struct SymbolTable *
InitTab(register struct SymbolTable *tab, int n, Pointer defaultVal)
  { register int i;  int size;
    tab->element_len = 8;
    tab->element_len_log = 3;
    for (i = 3; (1 << i) < n; i++) ;
    tab->tab_len_log = i;
    if (defaultVal == NULL)
	tab->f = &StdHashFuncs;
    else {
	//tab->f = (struct HashFuncs*)malloc(sizeof(struct HashFuncs));
	tab->f = new struct HashFuncs;
	*tab->f = StdHashFuncs;
	tab->f->defaultVal = defaultVal;
    }
    tab->cur_size = 0;
    tab->cur_deleted = 0;
    tab->flags = 0;
    size = 1 << (tab->element_len_log + tab->tab_len_log);
    //tab->data = (Association*)malloc(size);
    tab->data = (Association *) new char[size];
    //bzero(tab->data, size);
    memset(tab->data, 0, size);
    return tab;
  }

SymbolTable::~SymbolTable()
{
 if (f != &StdHashFuncs) delete f;
 delete data;
}

struct SymbolTable * AllocTab(int n, Pointer defaultVal)
  { struct SymbolTable *tab;
//    tab = (struct SymbolTable*)malloc(sizeof(struct SymbolTable));
    tab = new struct SymbolTable ;
    InitTab(tab, n, defaultVal);
    return tab;
  }

typedef void (*TabIterator)(Pointer extra, ConstPointer arg, Pointer val);
#define CALL_f(name, value) (*f)(extra, name, value)
void ForEachInTab(register SymbolTable *tab, TabIterator f, Pointer extra)
{
    DoForEachInTab(tab, CALL_f);
}

int TableSize(struct SymbolTable *tab)
  {
#if 1
    return tab->cur_size;
#else
    register i; register MapPair *pair; register n = 0;
    for (i = tab->tabLen, pair = tab->tab; i > 0; i--, pair++)
        if (pair->arg.O != NULLARG) n++;
    return n;
#endif
  }

