/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "externs.h"
#include "hash-rel.h"
#include "profile.h"
#include "globals.h"
#include "interp.h"

extern int subsumes_arg_lists(ArgList& left, ArgList& right,
    BindEnv *left_bindings, BindEnv *right_bindings);
extern int subsumes(BindEnv* env1, ArgList& arg2, BindEnv* env2);
int subsumes_tuple(Tuple *tuple, Tuple *newtuple, int display);
int unify_literal(TupleIterator& iterator, Tuple *tuple, int display);

int C_NewHashRelation = 0;
int C_DeleteHashRelation = 0;


/***************************************************************************/

HashSimpleRelation::HashSimpleRelation( int arity, int delta, int buckets)
    : StorageRelation(arity, delta), index_set(this)
{
  // NOTE: remember to update the code in empty_relation() and in 
  //  	move_all_entries() when updating this code.

  /*  It is essential to have at least one index - a lot of code 
      depends on this. */
    

  // MEMORY LEAK : Praveen
  BitVector* bv1 = new BitVector(arity);

  for (int i = 0; i < arity; i++)   bv1->set(i); // all arguments bound
  HashIndex* h1 = new HashIndex( this, bv1, buckets ); 
  index_set.insert_index( h1 );
  C_NewHashRelation++;
}

void HashSimpleRelation::empty_relation(int deleteTuples /* = 0 */ )
{	// Empty all tuples out of relation.  

    if (deleteTuples) {
        HashIndexPtr index0 = (HashIndexPtr) index_set[0];
        ASSERT (index0 != NULL);
        index0->delete_all_tuples();
    }

    /* Empty out the indices */

    TupleLink* next;
    for (TupleLink *link = chain; link != NULL; link = next) {
	if (deleteTuples) delete link->tuple;
	next = link->next;
	delete link;
    }
    chain = NULL;
    lastptr = &chain;

    //LinkedRelation::empty_relation(deleteTuples);

    for (int i = 0; i < index_set.num_indices(); i++) {
	index_set[i]->free_all_entries();
	index_set[i]->reset_index();
    }

    /* Recursively empty out the delta relations and add them to the 
	free_reln_chain
    */
    RelationLink *old;
    if (delta_indexed && delta_relations) {
    	while(delta_relations->reln_chain) {
	    Relation *reln = delta_relations->reln_chain->reln;
	    old = delta_relations->reln_chain;
	    delta_relations->reln_chain = old->next;

	    reln->empty_relation(deleteTuples);	
            old->next = free_reln_list;
	    free_reln_list = old;
	}
	delta_relations->reln_lastptr = NULL;
	delta_relations = NULL;
    }

    headMark.next = &headMark;
    headMark.prev = &headMark;

    count  = 0;   
}

int HashSimpleRelation::move_all_entries(StorageRelation *rel)
{
    // Moves all entries in the main relation of (this) to the relation rel.
    // This DOES NOT move entries that are in the delta_relations list or in 
    // the LinkedRelation list.  
    // In general it would be good to have this function
    // do that too, but right now this function is configured to only move
    // tuples from delta  relations into the main relation.
    //

    headMark.next = &headMark;
    headMark.prev = &headMark;

    // NOTE:  If relation count is present, reset it here.
    rel->count += count;

    index_set.move_all_entries(rel);
    for (int i = 0; i < index_set.num_indices(); i++) {
	index_set[i]->reset_index();
    }
    count = 0;
    return 1;
}

void HashSimpleRelation::free_indices()
{

    TupleLink* next;
    for (TupleLink *link = chain; link != NULL; link = next) {
	next = link->next;
	// This doesn't free the components of the tuple.
	delete link->tuple;
	delete link;
    }
    chain = NULL;
    lastptr = &chain;

    //LinkedRelation::free_all();
    // when deleting relation, also delete the indices to the relation
    for (int i = 0; i < index_set.num_indices(); i++)
	delete ((HashIndex *) index_set[i]); 
	
}

void HashSimpleRelation::free_delta_relations()
{
    RelationLink *old;
    if (delta_indexed && delta_relations) {
	for (RelationLink *tmp=delta_relations->reln_chain; tmp != NULL; ) {
	    delete tmp->reln;    
	    old = tmp;
	    tmp = tmp->next;
	    delete old;
	}
    }
    for (RelationLink *tmp = free_reln_list; tmp != NULL;) {
	delete tmp->reln;
	old = tmp;
	tmp = tmp->next;
	delete old;
    }

}

void HashSimpleRelation::free_all()
{

    headMark.next = &headMark;
    headMark.prev = &headMark;
    
    HashIndexPtr index0 = (HashIndexPtr) index_set[0];
    ASSERT (index0 != NULL);
    index0->delete_all_tuples();

    free_indices();
    free_delta_relations();
    C_DeleteHashRelation++;
	
}

HashSimpleRelation::~HashSimpleRelation()
{
    free_all();

}


void HashSimpleRelation::freeMark( RMark *mark, int hide_em )
{
  if (mark == NULL) return;
  RMark *this_mark = mark;

  // Unlink mark
  this_mark->next->prev = this_mark->prev;
  this_mark->prev->next = this_mark->next;

  // add it to the free marks list
  this_mark->next = free_marks;
  free_marks = this_mark;

  // check if this was the first mark in the list of marks
  if (this_mark->prev != &headMark) return ;
      // thus, if an "intermediate" mark is deleted, nothing is done!
      // this is fine for (!delta_indexed) relations, but with delta_indexed
      // relations, an alternative is to merge the delta relations 
      // corresponding to this mark with the "previous" relation.

  if (!delta_indexed) {
    TupleLink *limit;

    // Move all linked tuples upto new first mark to hash table.
    if (there_are_marks()) {
      limit = *headMark.next->lastptr;
      for (RMark *hmark = headMark.next; ; hmark = hmark->next) {
	if (hmark == &headMark) break;
	if (*hmark->lastptr != limit) break;
	hmark->lastptr = &chain;  
      }
    }
    else
      limit = *lastptr;
	
    TupleLink *old;
    while (chain && chain != limit) {
      Tuple *tuple = chain->tuple;
      old = chain;
      chain = chain->next;
      if (!hide_em) {
	count ++;
	insert_raw(tuple);
      }
      else insert_in_hidden_relation(tuple);
      delete old;
      // make sure this calls the index updates also.
    }
    if (chain == NULL)
      lastptr = &chain;
  }
  else{ 
    RelationLink *limit;

    ASSERT((delta_relations!= NULL));
    ASSERT((delta_relations->reln_lastptr != NULL));
    
    if (there_are_marks()) 
      limit = headMark.next->rel_p;
    else limit = NULL;

    RelationLink *old;
    while(delta_relations->reln_chain!=limit) {
      StorageRelation *reln = delta_relations->reln_chain->reln;
      old = delta_relations->reln_chain;
      delta_relations->reln_chain = old->next;

#define DELTA_INDEX_HACK 
#ifdef DELTA_INDEX_HACK
      // WARNING - we assume that the delta relation is a 
      // HashSimpleRelation.
      if (!hide_em)
	((HashSimpleRelation*)reln)->move_all_entries(this);
      else {
          reln->add_all_tuples(this, /*marks_into_account=*/ 0,
                              /* check_dupl=*/ 0,
                              hide_em);
          reln->empty_relation();     // Empty tuples out of relation
      }


#else
      reln->add_all_tuples(this, /*marks_into_account=*/ 0,
                               /* check_dupl=*/ 0,
                               hide_em);
      reln->empty_relation();	// Empty tuples out of relation
#endif
      old->next = free_reln_list;
      free_reln_list = old;
    }
    if (delta_relations->reln_chain==NULL)
      delta_relations->reln_lastptr = NULL;
  }
}

void HashSimpleRelation::free_allMarks()
{
    RMark *hmark;
    while (headMark.next != &headMark) {
	hmark = headMark.next;
	freeMark(hmark);
    }
    ASSERT((headMark.prev == headMark.next));
}

void HashSimpleRelation::initialize_iterator( TupleIterator& iterator )
{
#ifdef DO_TRACE
  if (exEnv.dbg_get_next) {
    fprintf(exEnv.trace_file, "\nHashSimpleRelation::initialize_iterator: ");
    iterator.relation->name->print(NULL, exEnv.trace_file);
    fprintf(exEnv.trace_file, " ( ");
    iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
    fprintf(exEnv.trace_file, " )\n");
  }
#endif
  iterator.stack_mark.get_mark();

  Term t1;

  scan_count++;

  if (! delta_indexed) {
    if (iterator.start_mark) { /* don't need to go to the hash table  */
      iterator.ipos = Scanning_New;
      iterator.ppos = (iterator.start_mark)->lastptr;
    }
    else {
      // need to scan from hash table
      // find the appropriate index to be used
      iterator.index = index_set.find_index( iterator );
    }
    } 
  else {
    if ( !iterator.in_delta()) { /* Starting on main relation */
      if (iterator.start_mark) { /* go to the delta relations */
	iterator.ipos = Scanning_Init;
	iterator.delta_rel_pos =  (iterator.start_mark)->rel_p;
      }
      else { 
	// need to scan from hash table
	// find the appropriate index to be used
	iterator.index = index_set.find_index( iterator );
      }
    }
    else {  /* In a delta relation */
      iterator.index = index_set.find_index( iterator );
    }
  }
}

/******************
*   HashSimpleRelation::get_next_tuple: 
	Tries to find tuple in relation that unifies with 
		<iterator.arg_list, iterator.bindenv>

	On success:  
	    Resets iterator.no_match, sets iterator.tuple_env to
	    the environment created for the tuple, and returns the fetched 
	    tuple.  The tuple is NOT a copy, and should not be deleted or 
	    destructively modified where it is called from.  The same holds
	    for tuple.bindenv.  However, iterator.tuple_env (if it is non-null)
	    is a local copy and may be modified by the calling routine.
	    It may need to be disposed off by the calling routine once it has
	    served its purpose.

	    In general, DO NOT assume that a return value of NULL implies 
	    that no tuple was found - evaluable relations do not create tuples,
	    but merely modify iterator.bindenv.  Hence they always return null.

	On failure:  
	    Sets iterator.no_match.

    HashSimpleRelation::get_next:
	As above, except that it does not return the tuple, but instead
	returns iterator.bindenv on success, and NULL on failure.
	returns a fetched tuple

    HashSimpleRelation::release:
	Releases state associated with tuple iterator.
******************/


BindEnv * HashSimpleRelation::get_next( TupleIterator& iterator )
{
    Tuple *result = get_next_tuple(iterator);
    if (!result) return NULL;
    return iterator.bindenv;
}
#define FAIL_RETURN  {iterator.ipos = Scanning_Done; 	\
			iterator.set_no_match();	\
			return NULL;			\
		     }

Tuple *HashSimpleRelation::get_next_tuple( TupleIterator& iterator )
{

#ifdef DO_PROFILE
   if (T_Stack.count > 0)
     (T_Stack.top()->moduledata->module_info.
       GlobalProfileInfo.getnexts)++;
   else
     (GlobalProfileInfo.getnexts)++ ;
#endif
    iterator.tuple_env = NULL;

    Tuple *result = NULL;

    if (exEnv.C_interrupt_raised) FAIL_RETURN;

    if ((iterator.ipos == Scanning_Init)) 
	    initialize_iterator( iterator );
	else iterator.stack_mark.pop_to();

    if (!delta_indexed) { // do the old stuff with chain and everything
        if (iterator.ipos != Scanning_New) { // need to scan from hash table
	    result = iterator.index->get_next_tuple( iterator);
	    if (result != NULL) return result; 
		    // found something in hash table
	    else {
	        iterator.ipos = Scanning_New;
	        iterator.ppos = &chain;
		    /** this is required because we don't want 
		        HashIndex::get_next_tuple() to set iterator.ipos to 
		        Scanning_New at the end of search. **/
	    }
        }
    
        StackMark stack_mark;
        // need to scan from the chain now

        for (;;) { // Continue until we find a match
	    TupleLink **next = (TupleLink**)iterator.ppos;
	    TupleLink *temp;
	    if (*next == NULL) {
	        iterator.ipos = Scanning_Done;
	        iterator.set_no_match();
	        result = NULL;
			stack_mark.pop_to();
	        return result;
	    }
	    if (iterator.end_mark && (iterator.end_mark)->lastptr 
	    	    == next) {
	        iterator.ipos = Scanning_Done;
	        iterator.set_no_match();
	        result = NULL;
			stack_mark.pop_to();
	        return result;
	    }
	    Tuple *tuple = (*next)->tuple;

	    if (tuple->is_deleted()) { // the tuple has been logically deleted

                temp = *next;
		*(next) = (*next)->next;
      
      
	      /* The if check is needed because we might have a rule of the form
		 try :- p(X), delete(p(X)), print(X), p(Y), print(Y).
		 The delete() builtin merely marks the tuples as deleted.
		 The later p iterator must not reclaim the space, because this 
		 will corrupt the first iterator.
		 */
	      if (scan_count == 1) {
		delete temp;

                // PRAVEEN:: I am doubtful about adding this here. Will this break the system ?
                /********
		for (int ti = 0; ti < tuple->arity(); ti++)
		  delete tuple->arg(ti);
		delete tuple->_args;
		delete tuple->bindenv;
		delete tuple;
	        ********/
	       }

#ifdef DO_PROFILE
   if (T_Stack.count > 0)
     (T_Stack.top()->moduledata->module_info.
      GlobalProfileInfo.deleted_tuples)++; 
   else
     (GlobalProfileInfo.deleted_tuples)++; 
#endif
		continue;
	    } 
	    
	    iterator.ppos = &(*next)->next;

	    if (unify_literal(iterator, tuple, exEnv.dbg_get_next))
			return (tuple);
	    stack_mark.pop_to();
        }
    }
    else { // relation is delta-indexed
	/** WARNING: the following hack has been done.
	    iterator not copied when calling delta relations.  so it
	    has the same "relation" field value, but each time the index field
	    changes based on the main/delta relations.
	    note that iterator.get_next_tuple is NOT called, which
	    would be wrong because the "relation" field value is not correct!!

	    the main/delta relations->get_next_tuple is called directly.
	    the following ASSUMPTION is made:
	    -- relation->get_next_tuple(iterator) does NOT use the 
	       relation field of iterator.
	    -- HashSimpleRelation::get_next_tuple satisfies this assumption.
	**/

	if (!iterator.in_delta()) { // Scanning from main hash table
	    result = iterator.index->get_next_tuple( iterator);
	    if (result != NULL) return result;
	    if (!delta_relations) FAIL_RETURN

	    // now go into the delta relations
	    iterator.ipos = Scanning_Init;	// Scanning_Init for delta reln
	    iterator.delta_rel_pos = delta_relations->reln_chain;
        }
	// delta_rel_pos has to have been set by this point.
	if (delta_relations != NULL) { 
	    // iterator scanning deltas, this == main relation
	    for(;;) { // Loop till successful delta is found
	        if (iterator.ipos == Scanning_Init) {
	            if(iterator.delta_rel_pos == NULL)
		        FAIL_RETURN
	            if (iterator.end_mark && (iterator.delta_rel_pos == 
				(iterator.end_mark)->rel_p)) 
		        FAIL_RETURN
	        }
	        result = iterator.delta_rel_pos->reln->get_next_tuple(iterator);
	        if (result != NULL) return result;
	        // Done with current delta relation.  Got to go to next delta.
	        iterator.delta_rel_pos = iterator.delta_rel_pos->next;
	        iterator.ipos = Scanning_Init;  	
			// To start on new delta reln.
            } 
	}
	else { 
	     // iterator scanning deltas, this == delta relation
	    return iterator.index->get_next_tuple( iterator);
	}
    }
}


void HashSimpleRelation::release(TupleIterator& )
{
   // scan_count--;
    /* Do nothing.  No state release is required */
}


int HashSimpleRelation::insert_raw( Tuple *tuple )
{

  /** inserts tuple into each index constructed for the relation. **/
  if (tuple->is_deleted()) return 0;
  // tuple has been logically deleted
    
  for (int i = 0; i < index_set.num_indices(); i++) {
    index_set[i]->insert_tuple( tuple );
  }
  return 1;
}

int HashSimpleRelation::is_subsumed(Tuple *newtuple, RMark *start_mark,
					RMark *end_mark)
{

    StackMark stack_mark;
    int result;
    TupleLink **next, *temp;
    GenericIndex *index;


    if (! start_mark) { // need to go to the hash table
	// find the appropriate index to be used
	index = index_set.find_index(newtuple);
    }
    else index = NULL;

    if (!delta_indexed) { // do the old stuff with chain and everything
        if (index) { // need to scan from hash table
	    result = index->is_subsumed(newtuple);
	    if (result != 0) return result; 
		    // found something in hash table
        }
    
        // need to scan from the chain now
	next = &chain;

        for (;;) { // Continue until we find a match
	    if (*next == NULL) 
		return( is_agg_subsumed(newtuple, start_mark, end_mark) );
	    if (end_mark && (end_mark)->lastptr == next) 
		return( is_agg_subsumed(newtuple, start_mark, end_mark) );
	    Tuple *tuple = (*next)->tuple;

	    if (tuple->is_deleted()) {

                temp = *next;
		*(next) = (*next)->next;
		delete temp;

#ifdef DO_PROFILE
   if (T_Stack.count > 0)
     (T_Stack.top()->moduledata->module_info.
      GlobalProfileInfo.deleted_tuples)++; 
   else
     (GlobalProfileInfo.deleted_tuples)++; 
#endif
		continue;
	    } // the tuple has been logically deleted

	    next = &((*next)->next);

	    if (subsumes_tuple(tuple, newtuple, (DISPLAY_INSERTIONS)))
		return 1;
	}

    }
    else { // relation is delta-indexed

	if (index) {	// Need to look at index for this relation.
	    result = index->is_subsumed(newtuple);
	    if (result != 0) return result;
	}
	if (delta_relations != NULL) { 
	    RelationLink* delta_rel_pos = delta_relations->reln_chain;

	    if (start_mark) { /* Find first delta relation to be used */
		while((start_mark)->rel_p != delta_rel_pos &&
			delta_rel_pos != NULL)
		    delta_rel_pos = delta_rel_pos->next;
	    }

	    for(;;) { // Loop till successful delta is found
		if (!delta_rel_pos) 	// End of delta_relations chain
		    return( is_agg_subsumed(newtuple, start_mark, end_mark) );
	        if (end_mark && (delta_rel_pos == 
				(end_mark)->rel_p)) 
		    return( is_agg_subsumed(newtuple, start_mark, end_mark) );
	        result = delta_rel_pos->reln->is_subsumed(newtuple);
	        if (result != 0) return result;
	        // Done with current delta relation.  Got to go to next delta.
	        delta_rel_pos = delta_rel_pos->next;
            } 
	}
	return( is_agg_subsumed(newtuple, start_mark, end_mark) );
    }
}

/****************************************************************************/
/******* Prioritize related stuff *********/

void heap_insert(HeapNode *heap, Tuple *tuple1, NumArg *val1, int order);
Tuple* pop_heap(HeapNodePtr *heap, int order);

int HashSimpleRelation::add_hidden_relation(PrioritizeInfo *) 
{

    heap = NULL;
      // Nothing more to do.  The heap _is_ the hidden relation.
    return 0;
}

int HashSimpleRelation::insert_in_hidden_relation(Tuple *tuple) 
{
    if (tuple->is_deleted())
      return 0;
    Term val_term(tuple->arg(priority_info->argnum), tuple->bindenv);
    FULL_DEREFERENCE_TERM(val_term);
    if (val_term.expr->kindof() != COR_NUM_CONST) {
      CORAL_error(COR_BAD_ARG_TYPE, "argument to prioritize on not a number",
              "HashSimpleRelation::insert_in_heap");
      return 0;
    }
    NumArg *val = (NumArg *) val_term.expr;

    HeapNode *newnode = new HeapNode(tuple, val);

    if (!heap)
      heap = newnode;
    else heap_insert(heap, tuple, val, priority_info->order);

#ifdef DO_TRACE
    if (DISPLAY_INSERTIONS)  {
      fprintf(exEnv.error_file, "\tHiding fact: %s(", name->string());
      tuple->printon(exEnv.error_file);
      fprintf(exEnv.error_file, ")\n");
    }
#endif

    return 1;
}

int HashSimpleRelation::insert_tuple(Tuple *tuple)
{
  if (there_are_marks()) {
    if (delta_indexed) { delta_relations->insert_tuple(tuple); }

    // PRAVEEN :: this here is a problem !!!
    else {
      this->tlist_insert_tuple(tuple);
      count++;
    }
  }
  else {
    count++;
    insert_raw(tuple);
  }

//    _hash = unknownhashvalue; 
                    // to ensure set is re-hashed, since it changed.
// this fix doesn't work, consistency of hash-cons table may be violated!

    return 1;

// return StorageRelation::insert_tuple(tuple);
}

int HashSimpleRelation::pop_from_hidden_relation() 
{
    for(;;) {  // Until new tuple is found
      if (!heap)
          return 0;
        Tuple *tuple = pop_heap(&heap,priority_info->order);
        if (tuple->is_deleted())
          continue;
#ifdef DO_TRACE
    if (DISPLAY_INSERTIONS)  {
      fprintf(exEnv.error_file, "\tUnhiding fact: %s(",
              name->string());
      tuple->printon(exEnv.error_file);
      fprintf(exEnv.error_file, ")\n");
    }
#endif
        if (check_subsum && is_subsumed(tuple)) {
          delete tuple;
          continue;
      }
      insert_tuple(tuple);  // This routine is typically called before
                            // the delta relation updates have been performed
                            // so the insert goes to the delta_new relation.
      return 1;
    }
}

int HashSimpleRelation::pop_all_from_hidden_relation() 
{
    for(;;) {  // Until new tuple is found
      if (!heap)
          return 0;
        Tuple *tuple = pop_heap(&heap,priority_info->order);
        if (tuple->is_deleted())
          continue;
#ifdef DO_TRACE
        if (DISPLAY_INSERTIONS)  {
          fprintf(exEnv.error_file, "\tUnhiding fact: %s(",
                  name->string());
          tuple->printon(exEnv.error_file);
          fprintf(exEnv.error_file, ")\n");
        }
#endif
        if (check_subsum && is_subsumed(tuple)) {
          delete tuple;
          continue;
      }
      insert_tuple(tuple);  // This routine is typically called before
                            // the delta relation updates have been performed
                            // so the insert goes to the delta_new relation.
      // Don't return here -- move all the tuples
    }
}

/***** heap operations *****/

HeapNode::HeapNode(Tuple *tuple1, NumArg *val1) {
    tuple = tuple1;
    val = val1;
    left = NULL;
    right = NULL;
    weight = 1;
}

static void swap_values(HeapNode *left, HeapNode *right) {
    Tuple *tmp_tuple = left->tuple;
    NumArg *tmp_val = left->val;
    left->tuple = right->tuple;
    left->val = right->val;
    right->tuple = tmp_tuple;
    right->val = tmp_val;
}

void merge_heaps(HeapNodePtr *rootptr, HeapNode *left, HeapNode *right,
                      int order)
{

    if (!left) {
      *rootptr = right;
      return;
    }
    else if (!right) {
      *rootptr = left;
      return;
    }

    if (left->weight > right->weight) {
      if (left->val->compare((*right->val)) * order < 0)
          swap_values(left, right);
      left->weight += right->weight;
      merge_heaps( &(left->right), left->right, right, order);
      (*rootptr) = left;
    }
    else {
      right->weight += left->weight;
      if (right->val->compare(*(left->val)) * order < 0)
          swap_values(left, right);
      merge_heaps( &(right->left), left, right->left, order);
      (*rootptr) = right;
    }
}

Tuple* pop_heap(HeapNodePtr *heap, int order) 
{
    Tuple *tuple1;

    if (! (*heap)) {
      CORAL_error( COR_INTERNAL_ERROR, "Attempt to pop empty heap!",
                      "pop_heap(...)");
      return NULL;
    }

    tuple1 = (*heap)->tuple;
    ASSERT((tuple1!=NULL));

    HeapNode *tmp = (*heap);
    merge_heaps(heap, (*heap)->left, (*heap)->right, order);
    delete tmp;

    return tuple1;
}

void heap_insert(HeapNode *heap, Tuple *tuple1, NumArg *val1, int order) 
{
    heap->weight ++;

    if ( (val1->compare(*(heap->val)) * order) > 0 ) {
      NumArg *tmp = heap->val;
      heap->val = val1;
      val1 = tmp;
      Tuple *tmptup = heap->tuple;
      heap->tuple = tuple1;
      tuple1 = tmptup;
    }

    if (!heap->left) {
        heap->left = new HeapNode(tuple1, val1);
    }
    else if (!heap->right) {
      heap->right = new HeapNode(tuple1, val1);
    }
    else if (heap->left->weight > heap->right->weight) {
      heap_insert(heap->right, tuple1, val1, order);
    }
    else {
      heap_insert(heap->left, tuple1, val1, order);
    }
}


void HashSimpleRelation::print_name( FILE *outf)
{
  fprintf(outf, "%15s/%d  : (base)    ", SymbolString(name), arity()) ;
  index_set.print_adornments(outf);
  fprintf(outf, ": count %d\n", count);
}
