/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "arg.h"
#include "aggreg-arg.h"
#include "generic-rel.h"
#include "externs.h"
#include <stdlib.h>
#include "globals.h"
extern ArrayBindEnv UnusedEnv;

Grouping::Grouping(int argcount)
{
    nestedArgs = FuncArg::New(NestedSymbol, argcount);
    index = 0;
    kind = NoAggregation;
    _kindof = COR_GROUPING;
}

Grouping::Grouping(FuncArg *func, int _index)
{
    nestedArgs = func;
    index = _index;
    kind = NoAggregation;
    _kindof = COR_GROUPING;
}

Arg* Grouping::simplify(BindEnv *context,
			TermLink*& renamed_vars, BindEnv *const_env,
			BindEnv *rename_only_env) 
{

    switch (kind) {
      case SetAggregation:
      case NoAggregation: {
	StorageRelation *rel = new HashSimpleRelation(nested_set_arity, 0,
					       COR_DEFAULT_SET_BUCKETS);
	rel->name = NestedSymbol;
        //rel->set_subsumption( this->check_subsum );
	ArgList *copy_args = ArgList::New(arity());
	// WARNING - the following may not be quite right
	int env_size = CopyArgs(copy_args->first(), first(),
				context, arity(), const_env,
				rename_only_env);
	Tuple *tuple1 = new Tuple(copy_args);
	tuple1->env_size = env_size;
        int inserted = 0;
	if (kind == SetAggregation) {
	   if (!rel->is_subsumed(tuple1))
		  inserted = rel->insert_tuple(tuple1);
		}
	else
		inserted = rel->insert_tuple(tuple1);

        if (!inserted) { delete tuple1; delete copy_args; }
	return rel;
      }
      case CountAggregation:
	return (Arg *) One;

      case ProductAggregation:
      case SumAggregation:
      case MinAggregation:
      case MaxAggregation:
      case AnyAggregation:
	if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file, "Grouping::simplify: bad arity\n");
	    return (Arg *) Zero;
	}
	return first()[0]->simplify(context, renamed_vars, const_env, 
			rename_only_env);
      case AvgAggregation:{ 
        if (arity() != 1) { // ERROR!
            fprintf(exEnv.error_file, "Grouping::simplify: bad arity\n");
            return (Arg *) Zero;
        }

	Arg *new_val = first()[0]->simplify(context, renamed_vars, const_env, 
			rename_only_env);

        if (new_val->kindof() != COR_NUM_CONST) { // ERROR!
	     fprintf(exEnv.error_file, "Avg aggregation not a numeric constant!\n");
	     return (Arg *) Zero;
        }

	AvgArg *avg = new AvgArg(((NumArg *)new_val)->doubval());
	return (Arg *)avg;
}
      case CountDAggregation: {
        if (arity() != 1) { // ERROR!
            fprintf(exEnv.error_file, "Grouping::simplify: bad arity\n");
            return (Arg *) Zero;
        }


	Arg *new_valc = first()[0]->simplify(context, renamed_vars, const_env, 
			rename_only_env);

	StorageRelation *new_relc = new HashSimpleRelation(nested_set_arity, 0,
					       COR_DEFAULT_SET_BUCKETS);
	new_relc->name = NestedSymbol;
        new_relc->set_subsumption(1);
	ArgList *copy_argsc = ArgList::New(1);
        *(((Arg**)copy_argsc)+1) = new_valc;
	Tuple *new_tuplec = new Tuple(copy_argsc, NULL);
        new_relc->insert_tuple(new_tuplec);

        DistArg *new_argc = new DistArg((int)(1),new_relc);

        return (Arg *)new_argc;
}

      case AvgDAggregation:
{
        if (arity() != 1) { // ERROR!
            fprintf(exEnv.error_file, "Grouping::simplify: bad arity\n");
            return (Arg *) Zero;
        }

        Arg *new_vala = first()[0]->simplify(context, renamed_vars, const_env,
                        rename_only_env);
        
        if (new_vala->kindof() != COR_NUM_CONST) { // ERROR!
	     fprintf(exEnv.error_file,"Aggregation on non-numeric constant!\n");
	     return (Arg *) Zero;
        }

	StorageRelation *new_rela = new HashSimpleRelation(nested_set_arity, 0,
					       COR_DEFAULT_SET_BUCKETS);
	new_rela->name = NestedSymbol;
        new_rela->set_subsumption(1);
	ArgList *copy_argsa = ArgList::New(1);
        *(((Arg**)copy_argsa)+1) = new_vala;
	Tuple *new_tuplea = new Tuple(copy_argsa, NULL);
        new_rela->insert_tuple(new_tuplea);

        ADistArg *new_arga =
              new ADistArg(((NumArg *)new_vala)->doubval(),new_rela);

        return (Arg *) new_arga;
}
      case ProdDAggregation:
      case SumDAggregation:{ 
        if (arity() != 1) { // ERROR!
            fprintf(exEnv.error_file, "Grouping::simplify: bad arity\n");
            return (Arg *) Zero;
        }

        Arg *new_val2 = first()[0]->simplify(context, renamed_vars, const_env,
                        rename_only_env);
        
        if (new_val2->kindof() != COR_NUM_CONST) { // ERROR!
	     fprintf(exEnv.error_file, "Aggregation not a numeric constant!\n");
	     return (Arg *) Zero;
        }

	StorageRelation *new_rel = new HashSimpleRelation(nested_set_arity, 0,
					       COR_DEFAULT_SET_BUCKETS);
	new_rel->name = NestedSymbol;
        new_rel->set_subsumption(1);
	ArgList *copy_args = ArgList::New(1);
        *(((Arg**)copy_args)+1) = new_val2;
	Tuple *new_tuple = new Tuple(copy_args, NULL);
        new_rel->insert_tuple(new_tuple);

        DistArg *new_arg = new DistArg(((NumArg *)new_val2)->doubval(),new_rel);

        return (Arg *) new_arg;
}
      default :

	return (Arg *) Zero;
    }
}

/*****************************/


// Count and Sum:   These currently work ONLY if they are called in a 
//		 stratified fashion.  That is, if a relation is defined using
//		 count or sum, it better not be recursive.
// Max and Min:	    These currently work in some non-stratified cases.
//		 If a new tuple is found to be better than an old one,
//		 the old one is deleted and the do_insert flag is set so that
//		 the new tuple is inserted later on.


/****************************/

inline void alloc_tuple(Tuple *t_old, Tuple *&t_new) {

   if ( !t_new ) {

      t_new = new Tuple();
      *t_new = *t_old;

   }

}


int update_grouping(Relation *rel, Tuple *old_tuple, ArgList *args,
                    BindEnv *bindings) {


    TermLink *renamed_vars = NULL;
    //ASSERT(argnum < old_tuple->arity() );

    Tuple *new_tuple = NULL;
    int grouping_arg_num = -1;
    int stat = 1;

    for (int i=0; i < args->count(); i++) {

       if ( ((*args)[i])->kindof() == COR_GROUPING) {

          grouping_arg_num = i;

          /* This code will not work if val has variables in it */
          Arg *new_val = 
             ((Grouping *)(*args)[i])->first()[0]->simplify(bindings, 
               renamed_vars, NULL,0);

          if (!new_val->isConstant()) {
	      fprintf(exEnv.error_file,
                   "Grouping::update_grouping: value is not a constant.\n");
              return 0;
          }

          stat *= ((Grouping *)(*args)[i])->update_tuple(old_tuple, new_tuple,
                                         new_val, grouping_arg_num, bindings);
       }

    } // for

    if (grouping_arg_num < 0) fprintf(exEnv.error_file,
              "Grouping::update_grouping: No grouping operator found.\n");


    if ( new_tuple ) {
          old_tuple->do_delete();
          rel->insert_tuple(new_tuple);
    }

    return stat;

}

int Grouping::update_tuple(Tuple *old_tuple, Tuple *new_tuple,
                           Arg *val, int argnum, BindEnv *context)
{


    switch (kind) {
      case SetAggregation:
      case NoAggregation: {
 	if (old_tuple->args()[argnum]->kindof() != COR_RELATION) {
	    fprintf(exEnv.error_file, 
		"Error: grouping - expected relation argument to insert into");
	    return(0);
	}
	// this creates a copy of the original tuple and updates
	// the value in the grouping argument.  the original tuple is left
	// where it was, and it is marked deleted -- so as to not
	// affect indices, etc.

	alloc_tuple(old_tuple,new_tuple);   // allocate a new tuple if one
                                           //  hasn't already been allocated.

	StorageRelation *rel = (StorageRelation *)new_tuple->args()[argnum];

	rel->_hash = UnknownHashValue; 
		// so that a new hash value will be computed for the set
	ArgList *copy_args = ArgList::New(arity());

	/*********************************
	// WARNING::  ReturnUnify optimizations needed here!!!
	....
	.... See how this is affected by and will affect return unify 
	.... optimizations
	....
	**********************************/

	int env_size = CopyArgs(copy_args->first(), first(),
				context,  arity(), &UnusedEnv);
	Tuple *tuple1 = new Tuple(copy_args);
	tuple1->env_size = env_size;
	if (kind == SetAggregation) {
	   if (!rel->is_subsumed(tuple1))
	     rel->insert_tuple(tuple1);
	   }
	else
		rel->insert_tuple(tuple1);

	// NOTE: add rel->env_size and update it here.
	// also add rel->hash_val and rel->id and update them
	// also do this whenever nested relations are created.
	// (see gram.y)

	return 0;
       }
      case CountAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file,
		     "Grouping::update_tuple: CountAggregation: bad arity\n");
	    return 0;
	 }

	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.

	 alloc_tuple(old_tuple,new_tuple);

	 new_tuple->args()[argnum] = 
             new NumArg(((NumArg *)(old_tuple->args()[argnum]))->i_val + 1);

	 return 1;
       }

      case AnyAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file,
		     "Grouping::update_tuple: AnyAggregation: bad arity\n");
	    return 0;
	 }
         return 1;
      }
      case SumAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file,
		     "Grouping::update_tuple: SumAggregation: bad arity\n");
	    return 0;
	 }
	 if (old_tuple->args()[argnum]->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) { // ERROR!
	    fprintf(exEnv.error_file,
	     "Grouping::update_tuple: SumAggregation: not an integer!\n");
		return 0;
	 }
		

	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.

	 alloc_tuple(old_tuple,new_tuple);

	 new_tuple->args()[argnum] = 
             new NumArg(((NumArg *)(old_tuple->args()[argnum]))->doubval() +
			   ((NumArg *)val)->doubval());

	 return 1;

       }

      case ProductAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file,
		     "Grouping::update_tuple: ProductAggregation: bad arity\n");
	    return 0;
	 }
	 if (old_tuple->args()[argnum]->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) {
	    fprintf(exEnv.error_file,
	     "Grouping::update_tuple: ProductAggregation: not an integer!\n");
   	    return 0;
	 }
		

	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.

	 alloc_tuple(old_tuple,new_tuple);

	 new_tuple->args()[argnum] = 
             new NumArg(((NumArg *)(old_tuple->args()[argnum]))->doubval() *
						((NumArg *)val)->doubval());

	 return 1;

       }

      case MinAggregation:
      case MaxAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file,
		   "Grouping::update_tuple: Min/MaxAggregation: bad arity\n");
	    return 0;
	 }
	 if (old_tuple->args()[argnum]->kindof() != COR_NUM_CONST) { // ERROR!
	    fprintf(exEnv.error_file,
                "Grouping::update_tuple: Min/MaxAggregation: not a number\n");
            return 0;
	 }

	 int c_stat = ((NumArg*)(old_tuple->args()[argnum]))->compare(
			*(NumArg*) val) ;
	 if (kind == MaxAggregation)
		c_stat = -c_stat;
	 if (c_stat <= 0) { 	// No replacement to be done.
	     return 0;
	 }

        #ifdef DO_TRACE
	if (exEnv.dbg_aggregates)
	    fprintf(exEnv.trace_file,
		    "Min/Max aggregation - new extreme value found\n");
        #endif

	 alloc_tuple(old_tuple,new_tuple);

	 if ( ((NumArg *)val)->num_kindof() == COR_INTEGER) 
	   new_tuple->args()[argnum] = new NumArg( ((NumArg *)val)->i_val);
	 else
	   new_tuple->args()[argnum] = new NumArg( ((NumArg *)val)->d_val);
	 return 1;
        }
      case AvgAggregation:  {

	 if (arity() != 1) { // ERROR!
	    fprintf(exEnv.error_file,
		     "Grouping::update_tuple: AvgAggregation: bad arity\n");
	    return 0;
	 }

	 if ((AvgArg*)(old_tuple->args()[argnum])->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) { // ERROR!
          fprintf(exEnv.error_file,
          "Grouping::update_tuple: AvgAggregation: not a numeric constant!\n");
		return 0; }
		
	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.

	 alloc_tuple(old_tuple,new_tuple);

	 int cnt = ((AvgArg *)(old_tuple->args()[argnum]))->count();
	 int new_cnt = cnt + 1;

	 double av =  ( (double)(cnt)
		         * ((AvgArg *)(old_tuple->args()[argnum]))->doubval() 
		         + ((NumArg *)val)->doubval() ) / (double)(new_cnt);

	 new_tuple->args()[argnum] = new AvgArg(new_cnt, av);

	 return 1;

       }

      case AvgDAggregation: {

        if (arity() != 1) { // ERROR!
            fprintf(exEnv.error_file, "Grouping operator bad arity\n");
            return 0;
        }

	if ((DistArg*)(old_tuple->args()[argnum])->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) { // ERROR!
          fprintf(exEnv.error_file,
          "Numeric Aggregation on non-numeric constant\n");
		return 0;
        }
		
	ArgList *val_lista = ArgList::New(1);
        *(((Arg**)val_lista)+1) = val;
	Tuple *val_tuplea = new Tuple(val_lista, NULL);

        StorageRelation *drela = 
                ((ADistArg *)(old_tuple->args()[argnum]))->rel();

        if (drela->is_subsumed(val_tuplea)) {

           // then not a distinct element, so don't need to do anything.
           return 1;
        }

        // otherwise, need to update the grouping value, and the set

         drela->insert_tuple(val_tuplea);
        
	 alloc_tuple(old_tuple,new_tuple);

	 int countd = ((ADistArg *)(old_tuple->args()[argnum]))->count();
	 int new_countd = countd + 1;

	 double avd =  ( (double)(countd)
		         * ((ADistArg *)(old_tuple->args()[argnum]))->doubval() 
		         + ((NumArg *)val)->doubval() ) / (double)(new_countd);

	 new_tuple->args()[argnum] = new ADistArg(new_countd, avd, drela);

	 return 1;
      }

      case CountDAggregation: {

        if (arity() != 1) { // ERROR!
            fprintf(exEnv.error_file, "Grouping operator bad arity\n");
            return 0;
        }

	ArgList *val_listc = ArgList::New(1);
        *(((Arg**)val_listc)+1) = val;
	Tuple *val_tuplec = new Tuple(val_listc, NULL);

        StorageRelation *drelc = 
               ((DistArg *)(old_tuple->args()[argnum]))->rel();

        if (drelc->is_subsumed(val_tuplec)) {

           // then not a distinct element, so don't need to do anything.
           return 1;
        }

        // otherwise, need to update the grouping value, and the set

         drelc->insert_tuple(val_tuplec);
        
	 alloc_tuple(old_tuple,new_tuple);

         new_tuple->args()[argnum] = 
          new DistArg(((DistArg *)(old_tuple->args()[argnum]))->i_val+1,drelc);

	 return 1;
      }

      case ProdDAggregation:
      case SumDAggregation: {

        if (arity() != 1) { // ERROR!

            fprintf(exEnv.error_file, "Grouping operator bad arity\n");
            return 0;
        }

	if ((DistArg*)(old_tuple->args()[argnum])->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) { // ERROR!
          fprintf(exEnv.error_file,
          "Numeric Aggregation on non-numeric constant\n");
		return 0;
        }
		
	ArgList *val_list = ArgList::New(1);
        *(((Arg**)val_list)+1) = val;
	Tuple *val_tuple = new Tuple(val_list, NULL);

        StorageRelation *drel=((DistArg *)(old_tuple->args()[argnum]))->rel();
        if (drel->is_subsumed(val_tuple)) {

           // then not a distinct element, so don't need to do anything.
           return 1;
        }

        // otherwise, need to update the grouping value, and the set

         drel->insert_tuple(val_tuple);
        
	 alloc_tuple(old_tuple,new_tuple);

         if (kind == SumDAggregation) {
        
	   new_tuple->args()[argnum] = 
               new DistArg(((DistArg *)(old_tuple->args()[argnum]))->doubval()
               + ((NumArg *)val)->doubval(),drel);

         }
         else {

	   new_tuple->args()[argnum] = 
               new DistArg(((DistArg *)(old_tuple->args()[argnum]))->doubval()
               * ((NumArg *)val)->doubval(),drel);

         }

	 return 1;
      }

      default :
	return 0;
    }
}

void Grouping::print(BindEnv* env, FILE *file, char *) const
{
  this->print(env, file);
}

/** Tarun **/
void Grouping::print_dump(BindEnv *env, FILE *file) const
{
    fprintf(file, "\"");
    print(env, file);
    fprintf(file, "\"");
}

void Grouping::print(BindEnv* env, FILE *file) const
{
    switch (kind) {
      case NoAggregation:
	fputs("<", file); break;
      case SetAggregation:
	fputs("distinct(<", file); break;
      case SumAggregation:
	fputs("sum(<", file); break;
      case ProductAggregation:
	fputs("prod(<", file); break;
      case CountAggregation:
	fputs("count(<", file); break;
      case MinAggregation:
	fputs("min(<", file); break;
      case MaxAggregation:
	fputs("max(<", file); break;
      case AvgAggregation:
	fputs("avg(<", file); break;
      case SumDAggregation:
	fputs("sum_distinct(<", file); break;
      case ProdDAggregation:
	fputs("prod_distinct(<", file); break;
      case CountDAggregation:
	fputs("count_distinct(<", file); break;
      case AvgDAggregation:
	fputs("avg_distinct(<", file); break;
      case AnyAggregation:
	fputs("any(<", file); break;
      default :
	break;
    }
    Arg** arg_ptr = first();
    int i = arity();
    for (;;) {
	(*arg_ptr++)->print(env, file);
	if (--i == 0)
	    break;
	fputs(", ", file);
    };
    fprintf(file, kind == NoAggregation ? ">" : ">)");
}

void Grouping::sprint(char *str, int *pos, BindEnv *env) const
{
    switch (kind) {
      case NoAggregation:
	sprintf(str + *pos, "<");
	(*pos)++ ;
	break;
      case SumAggregation:
	sprintf(str + *pos, "sum(<");
	*pos += 5;
	break;
      case ProductAggregation:
	sprintf(str + *pos, "prod(<");
	*pos += 6;
	break;
      case CountAggregation:
	sprintf(str + *pos, "count(<");
	*pos += 7 ;
	break;
      case MinAggregation:
	sprintf(str + *pos, "min(<");
	*pos += 5;
	break;
      case MaxAggregation:
	sprintf(str + *pos, "max(<");
	*pos += 5;
	break;
      case AvgAggregation:
	sprintf(str + *pos, "avg(<");
	*pos += 5;
	break;
      case SumDAggregation:
	sprintf(str + *pos, "sum_distinct(<");
	*pos += 14;
	break;
      case ProdDAggregation:
	sprintf(str + *pos, "prod_distinct(<");
	*pos += 15;
	break;
      case CountDAggregation:
	sprintf(str + *pos, "count_distinct(<");
	*pos += 16;
	break;
      case AvgDAggregation:
	sprintf(str + *pos, "avg_distinct(<");
	*pos += 14;
	break;
      case SetAggregation:
	sprintf(str + *pos, "distinct(<");
	*pos += 10;
	break;
      case AnyAggregation:
	sprintf(str + *pos, "any(<");
	*pos += 5;
	break;
      default :
	break;
    }
    Arg** arg_ptr = first();
    int i = arity();
    for (;;) {
	(*arg_ptr++)->sprint(str, pos, env);
	if (--i == 0)
	    break;
	sprintf(str + *pos, ", ");
	*pos += 2 ;
    };
    sprintf(str + *pos, kind == NoAggregation ? "> " : ">)");
    *pos += 2 ;
}
