/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

%{
#include <stdio.h>
#include "scanner.h"
#include "generic-rel.h"
#include "builtin-syms.h"
#include "parse-utils.h"
#include "profile.h"
#include "annotations.h"
#include "interp.h"

EXTERN int yylex();
EXTERN int yyparse();

ParserStruct parserStruct ;
ExecutionEnv exEnv ;
ParserEnv parseEnv;

// No. of evaluable functors in the lhs of a clause
// that were converted into literals by create_functor.
// (We want to evaluate these *after* the true rhs literals.)
static char *fname = "yyparse" ;
static  Clause *cur_rule;
static BitVector CurTail;
static BitVector CurBoundVars;
extern void COR_set_single_answer(ModuleInfo& Module, int val);

//DontCareArg TheParameterArg;
Arg *TheParameterArg;

const Symbol ** builtin_ops[] = {
    // Aggregation operators: These must be FIRST, and in the same
    // ORDER as in the enum AggregateKind (defined in arg.h). 
    &SumOpSymbol,
    &ProdOpSymbol,
    &CountOpSymbol,
    &MinOpSymbol,
    &MaxOpSymbol,
    &AvgOpSymbol,
    &SDstOpSymbol,
    &PDstOpSymbol,
    &CDstOpSymbol,
    &ADstOpSymbol,
    &DstOpSymbol,
    &AnyOpSymbol,

    /** Normal (not aggregation) operators: **/
    /** Builtin_Arith_Start = 12 **/
    &LssOpSymbol,
    &GrtOpSymbol,
    &LeqOpSymbol,
    &GeqOpSymbol,
    /** Builtin_Convertible_Start = 16 **/
    &AddOpSymbol,
    &SubOpSymbol,
    &MulOpSymbol,
    &DivOpSymbol,
    &IDivOpSymbol,

    &LShiftOpSymbol,
    &RShiftOpSymbol,
    &BitxorOpSymbol,
    &BitandOpSymbol,
    &BitorOpSymbol,
    &BitnotOpSymbol,
    &ModOpSymbol,

    0
};

struct SymbolTable * BuiltinRelTable ;
int Builtin_Arith_Start = 12 ;
int Builtin_Convertible_Start = 16 ;


int C_num_head_arith_lits;   /* Number of arithmetic literals introduced in
				converting arithmetic functions in the head
				literal.  These need to be moved to the end
				of the rule later */

int complexRelation = 0; /* used only for set grouping */

int in_bulk_load = 0;

%}

%type <pred>	pred clause_lhs clause_left clause_lhs_list clause_lhs_element
%type <arg>	arg arg_fact arg_primary var_arg simple_arg
%type <sip>	arc sip
%type <sips>	sip_list sip_list_entry
%type <name>    id const relop anno_name adorn_string opt_adorn_string
%type <alias_list> literal_alias
%type <rule_anno> rule_anno rule_anno_list opt_annotes sips_or_rule_anno
%type <anno_case> anno_case anno_case_list
%type <anno_case_name> anno_case_name
%type <anno_case_details> anno_case_details
%type <integer> plus_or_minus
%token  APPEND UPDATE ASSIGN DELETE
%token	MARK LPAREN RPAREN COMMA COLON SLASHSLASH PERIOD LBRACE RBRACE ARROW 
%token	SIPS LBRACKET RBRACKET UNDERSCORE VBAR PERCENT NOT QUESTION DOLLAR TRUE
%token	SUM PROD COUNT MIN MAX AVG ANY DISTINCT COUNT_D SUM_D PROD_D AVG_D
%token  DEL START_C_MODULE END_C_MODULE MODULE EXPORT ALIAS END_MODULE 
%token  PLUS MINUS STAR SLASH EQUAL NOTEQUAL LESS GREATER LESSEQUAL GREATEREQUAL
%token  LSHIFT RSHIFT BITXOR BITAND BITNOT BITOR MOD
%token	AT CUT
%token <name>	SYMBOL VAR OP RELOP 
%token <arg> NUM
%left   BITOR
%left   BITXOR
%left   BITAND
%left   LSHIFT RSHIFT
%left   PLUS MINUS
%left   STAR SLASH SLASHSLASH MOD
%right   BITNOT

%%
prog:
		{
                    exEnv.C_interrupt_raised = 0;
		    parserStruct.init() ;  
                    parserStruct.rules->chain = NULL;
                    parseEnv.print_prompt();
		}
		clause_list
		{
		    parserStruct.rule_list = (struct rule*)
                                              parserStruct.rules->chain;
		}
;

clause_list:	clause_list
		{
		    parserStruct.rule_var_names.length = 0;
 		    parserStruct.rhspreds.length = 0;
 		    parserStruct.nested_index = 0;
		    if (parseEnv.C_at_end_module) {
                      // IS THIS NECESSARY ?? - PRAVEEN
		      parserStruct.init();
                      init_collection(parserStruct.rules, 0);
		     }
      		}
		clause
		{
                    if (exEnv.C_interrupt_raised != 0) {
		      if (exEnv.C_interrupt_raised == 2) {
			/* happens if there is quit() executed */
			/** exEnv.flush_all_outputs(); **/
			YYACCEPT;
		       }
		      if (exEnv.C_interrupt_raised > 0) {
			fprintf(exEnv.error_file,"CORAL:: Interrupt occurred during execution!:");
			fprintf(exEnv.error_file,"resetting state !\n");
			fflush(exEnv.error_file);
			//abort a consult that is halfway thru
			parseEnv.abort_file();
		       }
		      // else, the user does not want to see more answers to the query, and the
                      // value is -1
		      exEnv.C_interrupt_raised = 0;
		     }

		    if (exEnv.C_do_history_default) parseEnv.handle_history();

                    if (parseEnv.show_prompt) parseEnv.print_prompt();
#ifdef DEBUG
                    if (T_Stack.count) {
		      fprintf(exEnv.error_file, "Warning : non-zero tablestack = %d!\n",
			      T_Stack.count);
		      T_Stack.count = 0;
		    }
#endif
		}
	|
;
clause_lhs:    id COLON clause_lhs
		{
		    struct ClauseName *cname = new ClauseName();
		    cname->name = $1;
		    cname->negated = 0;
		    cname->next = cur_rule->clause_names;
		    cur_rule->clause_names = cname;
		}
	|	id MINUS COLON clause_lhs
		{
		    struct ClauseName *cname = new ClauseName();
		    cname->name = $1;
		    cname->negated = 1;
		    cname->next = cur_rule->clause_names;
		    cur_rule->clause_names = cname;
		}
	| 	clause_lhs_list
		{
		}
;

clause_lhs_list: clause_lhs_list COMMA clause_lhs_element
		{
		}
	|       clause_lhs_element
		{
		}
;

clause_lhs_element: const LPAREN  optarglist RPAREN
		{
		    cur_rule->head = AllocLiteral(parserStruct, $1, 
					 parserStruct.cur_arg_chain->count);
                    if (complexRelation)
		      complexRelation--;
		    pop_arg_chain(parserStruct, cur_rule->head->args);
		    cur_rule->clause_names = NULL;
		}
	|
		DEL const LPAREN optarglist RPAREN
		{
		    // Used to be 
		    // cur_rule->head =
		    Literal *lit = 
		    	 AllocLiteral(parserStruct, $2,
					   parserStruct.cur_arg_chain->count);
                    if (complexRelation)
		      complexRelation--;
		    lit->negated = 1;
		    pop_arg_chain(parserStruct, lit->args);
		    cur_rule->clause_names = NULL;

		    if (parseEnv.in_query_loop && cur_rule->head == NULL) {
			cur_rule->head = lit;
		    }
		    else {
			if (cur_rule->head_deletes) {
			    cur_rule->head_deletes =
			      (Literal **) realloc((char *)cur_rule->head_deletes,
			         sizeof(Literal*) *
			         (++cur_rule->head_deletes_count) );
			}
			else {
			    cur_rule->head_deletes =
				    (Literal **)malloc(sizeof(Literal*));
			    cur_rule->head_deletes_count++;
			}
			cur_rule->head_deletes[cur_rule->head_deletes_count-1]=lit;
		    }
                    COR_set_eager_eval(parserStruct.CurModule, 0);
		}
	|
		SYMBOL
		{
		    cur_rule->head = AllocLiteral(parserStruct, $1,0);
                    if (complexRelation)
		      complexRelation--;
		    cur_rule->clause_names = NULL;
		}
;
/* export pred1(adorn11, adorn12, ...), pred2(adorn21, ..), ... */
export_clause:	EXPORT arg_fact
		{
		    AddExportInfo(parserStruct, (FuncArg*)$2);
		}
	|	export_clause COMMA arg_fact
		{
		    AddExportInfo(parserStruct, (FuncArg*)$3);
		}
	|	EXPORT const LBRACKET optarglist RBRACKET
		{
                  AddExportInfo(parserStruct, 
				(FuncArg*)(create_functor(parserStruct, $2)));
		}
	|	export_clause COMMA const LBRACKET optarglist RBRACKET
		{
                  AddExportInfo(parserStruct, 
				(FuncArg*)(create_functor(parserStruct, $3)));
		}
;

clause_left:
             { parserStruct.lhs_flag = 1; 
	       cur_rule = copy_rule(NULL);
	       cur_rule->line_number = parseEnv.C_linenum;
	     }
             clause_lhs
             { // $$ = $2; 
	       parserStruct.lhs_flag = 0;
	       C_num_head_arith_lits = parserStruct.rhspreds.length;
	     }
;

clause:       clause_left clause_rhs
                {
		    if (parseEnv.in_query_loop) {
		      parserStruct.assign_func(FactFunction);
		      parserStruct.cur_rule = cur_rule;
		      if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE)
			YYACCEPT;
		      parserStruct.execute();
		      parserStruct.reset(0);
		    }
		    else {
		      /* transfer information from parserStruct to cur_rule
		       * and insert cur_rule into the parserStruct's rulelist
		       */
		      complete_rule(cur_rule, parserStruct);
		    }
		}

	|	clause_left APPEND rhs_pred_list opt_annotes PERIOD
		{
                    parserStruct.assign_func(AppendFunction);
                    parserStruct.cur_rule = cur_rule;

                    if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE)
		      YYACCEPT;
                    parserStruct.execute();
                    delete parserStruct.cur_rule; 
                    /* Better not delete the head predicate. */
		    parserStruct.cur_rule = NULL;
		}

	|       clause_left DELETE rhs_pred_list opt_annotes PERIOD
                {
                    parserStruct.assign_func(DeleteFunction);
                    parserStruct.cur_rule = cur_rule;
                    if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE)
		      YYACCEPT;
                    parserStruct.execute();
                    delete parserStruct.cur_rule; 
                    /* Better not delete the head predicate. */
		    parserStruct.cur_rule = NULL;
		}

	|	clause_left UPDATE rhs_pred_list opt_annotes PERIOD
                {
                  fprintf(exEnv.error_file, "Sorry : Updates not implemented yet\n");
                }

	|	clause_left ASSIGN rhs_pred_list opt_annotes PERIOD
                {
                    parserStruct.assign_func(AssignFunction);
                    parserStruct.cur_rule = cur_rule;
                    if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE)
		      YYACCEPT;
                    parserStruct.execute();
                    delete parserStruct.cur_rule; 
                    /* Better not delete the head predicate. */
		    parserStruct.cur_rule = NULL;
                }

	|	QUESTION 
                {
                    cur_rule = copy_rule(NULL);
	            cur_rule->line_number = parseEnv.C_linenum;
		    cur_rule->clause_names = NULL;
                }
                rhs_pred_list PERIOD
		{
                    parserStruct.assign_func(QueryFunction);
                    parserStruct.cur_rule = cur_rule;
                    if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE)
		      YYACCEPT;
                    parserStruct.execute();
		    parserStruct.reset(1);
		}
        |       START_C_MODULE PERIOD
                {
                    parseEnv.c_module_separator = 0;
                }

        |       END_C_MODULE PERIOD
                {
                    parseEnv.c_module_separator = 1;
                    if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE)
		      YYACCEPT;
                }

	|	MODULE id PERIOD
		{
                    parserStruct.init() ;
                    init_collection(parserStruct.rules, 1);
                    parseEnv.C_at_end_module = 0;
		    parseEnv.in_query_loop = 0 ;
		    parserStruct.CurModule.name = $2;
		    strcpy(parseEnv.prompt_name, parseEnv.prompt);
		    strcat(parseEnv.prompt_name, "*");
		    parseEnv.prompt = parseEnv.prompt_name;	      
		}

        |       END_MODULE PERIOD
                {
		    parseEnv.C_at_end_module = 1;

		    parserStruct.rule_list = (struct rule*)
                                              parserStruct.rules->chain;
                    parserStruct.assign_func(EndModuleFunction);
                    parserStruct.cur_rule = cur_rule;

		    if (exEnv.C_exec_mode == COR_DOING_INTERPRET) {
                      parserStruct.execute();
		      init_collection(parserStruct.rules, 0);
		      // reinitialize CurrModuleInfo 
		      CurrModuleInfo->init_flags();
		      parseEnv.in_query_loop = 1 ;

		      if (!strcmp(SymbolString(CurDB->name), "default_db"))
			parseEnv.prompt = CORAL_PROMPT ;
		      else {
			strcpy(parseEnv.prompt_name, SymbolString(CurDB->name));
			strcat(parseEnv.prompt_name, CORAL_PROMPT);
			parseEnv.prompt = parseEnv.prompt_name;
		      }
		      parseEnv.print_prompt();
		    }
                    else if (exEnv.C_exec_mode == COR_DOING_IMPERATIVE) {
		      parseEnv.in_query_loop = 1;
		      YYACCEPT;
		    }
                    else { 
		      // magic or factoring or existential optimization
		      YYACCEPT;
		    }
                  }

	|	export_clause PERIOD

	|	AT SYMBOL SYMBOL opt_adorn_string plus_or_minus PERIOD
		{
                    ArgList *al1 = ArgList::New(1);
                    if ((Arg *)($4))
                      (*al1)[0] = (Arg *)($4);
                    else al1->set_count(0);
		    if ($2 == AllowedAdornSymbol) {
			add_allowed_adornment(parserStruct, $3, al1 );
		    }
                    // NOTE :: Currently this does not give multiset
                    // semantics. It merely acts as do_not_check_subsum.
                    // The user should not use this annotation in its 
                    // current state.
		    else if ($2 == MultisetSymbol) {
			add_multiset_annotation(parserStruct, $3, al1, 0);
		    }
		    else if ($2 == CheckSubsumSymbol) {
			add_multiset_annotation(parserStruct, $3, al1, $5);
		    }
/***
		    else if ($2 == DiskResidentSymbol) {
			add_diskrel_annotation(parserStruct, $3, al1);
		    }
***/
		    else if ($2 == IndexDeltaSymbol) {
			add_index_delta_annotation(parserStruct, $3, al1 );
		    }
		    else CORAL_error(COR_BAD_ANNO, SymbolString($2),
				     "yyparse:anno3");

		}

	|	AT SYMBOL SYMBOL opt_adorn_string LPAREN optarglist RPAREN LPAREN optarglist RPAREN plus_or_minus PERIOD
		{
		    ArgList *al2 = ArgList::New(parserStruct.cur_arg_chain->count);
		    pop_arg_chain(parserStruct, *al2);
		    ArgList *al1 = ArgList::New(parserStruct.cur_arg_chain->count);
		    pop_arg_chain(parserStruct, *al1);
		    if ( $2 == MakeIndexSymbol) {
		      add_make_index_annotation(
			parserStruct.make_index_annotations, $3,$4, al1, al2);
		    }
                    else if ( $2 == ChoiceSymbol) {
                      fprintf(exEnv.error_file,
                        "ERROR:  choice no longer supported %s\n",
                        " -- use aggregate selection `any' instead");
                    }
                    else
		      CORAL_error( COR_BAD_ANNO,SymbolString($2),"yyparse:anno1");
		}

	|	AT SYMBOL SYMBOL opt_adorn_string LPAREN optarglist RPAREN plus_or_minus PERIOD
		{
		    ArgList *al1 = ArgList::New(parserStruct.cur_arg_chain->count);
		    pop_arg_chain(parserStruct, *al1);
		    if ( $2 == MakeIndexSymbol) {
		      add_make_index_annotation(
			parserStruct.make_index_annotations,$3,$4, al1, NULL);
		    }
		    else if ($2 == DiskResidentSymbol) {
			add_diskrel_annotation(parserStruct, $3, $4, al1);
		    }
		    else CORAL_error(COR_BAD_ANNO, 
				     SymbolString($2),"yyparse:anno2");

		}

	|	AT SYMBOL SYMBOL opt_adorn_string LPAREN optarglist RPAREN
                LPAREN optarglist RPAREN simple_arg plus_or_minus PERIOD
		{
		    Arg * op_arg = $11;
		    ArgList *al2 = ArgList::New(parserStruct.cur_arg_chain->
						count);
		    pop_arg_chain(parserStruct, *al2);

		    ArgList *al1 = ArgList::New(parserStruct.cur_arg_chain->
						count);
		    pop_arg_chain(parserStruct, *al1);

		    /* Should have some error checking to see if 
				predicate name is correct! */

		    if ( $2 == AggSelectionSymbol) {
			add_agg_sel_annotation(parserStruct,
					$3, $4, al1, al2, op_arg);
			COR_set_eager_eval(parserStruct.CurModule, 0);
		    }
		    else CORAL_error(COR_BAD_ANNO, SymbolString($2),
				     "yyparse:anno4");

		}

	|	AT SYMBOL SYMBOL opt_adorn_string LPAREN optarglist RPAREN
                simple_arg  plus_or_minus PERIOD
		{
                  ArgList *al1 = ArgList::New(parserStruct.cur_arg_chain->count);
                  pop_arg_chain(parserStruct, *al1);
                  if ( $2 == PrioritizeSymbol) {
                      add_prioritize_annotation(parserStruct, $3, $4,
                              al1, $8);
                  }
                  else CORAL_error(COR_BAD_ANNO, SymbolString($2), fname);
                }

	|       AT SYMBOL plus_or_minus PERIOD
		{
		    if ( $2 == SaveModuleSymbol)
		        COR_set_save_module(parserStruct.CurModule, $3);
		    else if ( $2 == SupplementaryMagicSymbol)
			COR_set_supplementary_magic(parserStruct.CurModule, $3);
		    else if ( $2 == OrdinaryMagicSymbol)
			COR_set_ordinary_magic(parserStruct.CurModule, $3);
		    else if ( $2 == SupMagicIndexingSymbol)
			COR_set_sup_magic_indexing(parserStruct.CurModule, $3);
		    else if ( ($2 == NoMagicSymbol) && $3) 
                        COR_set_no_magic(parserStruct.CurModule);
                    else if ($2 == ExistOptSymbol)
                        COR_set_exist_opt(parserStruct.CurModule, $3);
                    else if ($2 == UseFactoringSymbol)
		      COR_set_use_factoring(parserStruct.CurModule, $3);
                    else if ($2 == UseOrdSearchSymbol)
                        COR_set_use_ordsearch(parserStruct.CurModule, $3);
                    else if ($2 == EagerEvalSymbol)
                        COR_set_eager_eval(parserStruct.CurModule, $3);
		    else if ($2 == UsePipeliningSymbol)
                        COR_set_pipelining(parserStruct.CurModule, $3);
		    else if ( $2 == IndexDeltaSymbol)
                        COR_set_index_deltas(parserStruct.CurModule, $3);
                    else if ( $2 == PredicateSNSymbol)
                        COR_set_predicate_seminaive(parserStruct.CurModule, $3);
		    else if ($2 == MultisetSymbol)
                        COR_set_multisets(parserStruct.CurModule, $3);
		    else if ($2 == CheckSubsumSymbol)
                        COR_set_check_subsum(parserStruct.CurModule, $3);
		    else if ($2 == SingleSccSymbol)
                        COR_set_single_scc(parserStruct.CurModule, $3);
		    else if ($2 == SingleAnswerSymbol)
                        COR_set_single_answer(parserStruct.CurModule, $3);
		    else if ($2 == ConvertFunctionsSymbol)
                        COR_set_convert_functions(parserStruct.CurModule, $3);
                    else if ($2 == MonotonicSymbol)
                        COR_set_monotonic(parserStruct.CurModule, $3);
		    else if ($2 == ReturnUnifySymbol)
                        COR_set_return_unify(parserStruct.CurModule, $3);
                    else if ($2 == NoRewritingSymbol)
                        COR_set_rewriting(parserStruct.CurModule, !($3));
                    else if ($2 == NoPreProcessingSymbol)
                        COR_set_preprocessing(parserStruct.CurModule, !($3));
                    else if ($2 == NonGroundFactsSymbol)
                        COR_set_non_ground_facts(parserStruct.CurModule, $3);
                    else if ($2 == DiskResidentSymbol)
                        COR_set_disk_resident(parserStruct.CurModule, $3);
		    else  CORAL_error(COR_BAD_ANNO, SymbolString($2),fname);

		}

        |       PERIOD {} 

	|	error PERIOD
		{
		    CORAL_error(COR_BAD_SYNTAX, NULL, fname);
		    yyerrok ;
		    parserStruct.rule_var_names.length = 0;
 		    parserStruct.rhspreds.length = 0;
 		    parserStruct.nested_index = 0;
                    //parserStruct.parameters = new parameter_chain;
		    parseEnv.print_prompt();
		}
		clause {}
;

plus_or_minus:
                PLUS  { $$ = 1;}
        |       MINUS { $$ = 0; }
        |       { $$ = 1;}
;
clause_rhs:
		MARK rhs_pred_list opt_annotes PERIOD
                {
                }
	|	PERIOD
		{
		    cur_rule->annotations = NULL;
		    cur_rule->sips    = NULL;
		}
;

opt_annotes:	ALIAS 	{cur_rule->sips = NULL;}
		literal_alias sips_or_rule_anno
		{ 
		   $$ = NULL;
		}
	|	{ 
		    $$ = NULL; 
		    cur_rule->annotations = NULL; 
		    cur_rule->sips = NULL;
		}
;
rhs_pred_list:	rhs_pred_list COMMA rhs_pred
	|	rhs_pred
/*
	|
*/
;
rhs_pred:	pred
		{
		    add_to_array(&parserStruct.rhspreds, (int)$1);
		}
	|
;

pred:		const LPAREN optarglist RPAREN
		{
		    $$ = AllocLiteral(parserStruct, $1,
				      parserStruct.cur_arg_chain->count);
		    pop_arg_chain(parserStruct, $$->args);
		}
        |       const
                {
                    $$ = AllocLiteral(parserStruct, $1, 0);
                }
	|	arg relop arg
		{
		    $$ = AllocLiteral(parserStruct, $2, 2);
		    arg_vector($$->args)[0] = $1;
		    arg_vector($$->args)[1] = $3;
		}
	|	NOT arg relop arg
		{
		    $$ = AllocLiteral(parserStruct, $3, 2);
		    $$->negated = 1;
		    arg_vector($$->args)[0] = $2;
		    arg_vector($$->args)[1] = $4;
		}
	|	NOT const LPAREN optarglist RPAREN
		{
		    $$ = AllocLiteral(parserStruct, $2, 
				      parserStruct.cur_arg_chain->count);
		    $$->negated = 1;
		    pop_arg_chain(parserStruct, $$->args);
		}
	|	NOT const
		{
		    $$ = AllocLiteral(parserStruct, $2, 0);
		    $$->negated = 1;
		}
        |       CUT
		{
		    $$ = AllocLiteral(parserStruct, CutSymbol, 0);
		}
;

relop:		EQUAL		{ $$ = EquOpSymbol; }
	|	NOTEQUAL	{ $$ = NeqOpSymbol; }
	|	LESS		{ $$ = LssOpSymbol; }
	|	GREATER		{ $$ = GrtOpSymbol; }
	|	LESSEQUAL	{ $$ = LeqOpSymbol; }
	|	GREATEREQUAL	{ $$ = GeqOpSymbol; }
;


arglist:
              arglist COMMA arg
		{
		    if (parserStruct.CurModule.ConvertFunctions &&
			($3)->kindof() == COR_NUM_CONST &&
			    ((NumArg *) ($3))->num_kindof() == COR_ARITH_EXPR) {
			// need to create the equality literal 
			Arg *temp_var = NULL;
			push_arg_chain(parserStruct);
			append_arg(parserStruct, $3);
			temp_var = pull_out_arith_expr(parserStruct);
			    // the above function also does a pop_arg_chain

			append_arg(parserStruct, temp_var);
		    }
		    else {
		        append_arg(parserStruct, $3);
		    }
		}
	|	
                 arg
		{
		    push_arg_chain(parserStruct);
		    if (parserStruct.CurModule.ConvertFunctions &&
			($1)->kindof() == COR_NUM_CONST &&
			    ((NumArg *) ($1))->num_kindof() == COR_ARITH_EXPR) {
			// need to create the equality literal 
			Arg *temp_var = NULL;
			push_arg_chain(parserStruct);
			append_arg(parserStruct, $1);
			temp_var = pull_out_arith_expr(parserStruct);
			// the above function also does a pop_arg_chain

			append_arg(parserStruct, temp_var);
		    }
		    else {
		        append_arg(parserStruct, $1);
		    }
		}
;

/* grouping_list: var_arg */
grouping_list: arg 
               {
                    push_arg_chain(parserStruct);
                    append_arg(parserStruct, $1);
               }
;


optarglist:	arglist
	|
		{
		    push_arg_chain(parserStruct);
		}
;
arg:		arg_primary
	|	arg PLUS arg
		{
		    $$ = new ExprArg(AddOpSymbol, $1, $3);
		}
	|	arg MINUS arg
		{
		    $$ = new ExprArg(SubOpSymbol, $1, $3);
		}
	|	arg STAR arg
		{
		    $$ = new ExprArg(MulOpSymbol, $1, $3);
		}
	|	arg SLASH arg
		{
		    $$ = new ExprArg(DivOpSymbol, $1, $3);
		}
	|	arg SLASHSLASH arg
		{
		    $$ = new ExprArg(IDivOpSymbol, $1, $3);
		}

        |       arg LSHIFT arg
                {
	            $$ = new ExprArg(LShiftOpSymbol, $1, $3);
                }
        |       arg RSHIFT arg
                {
	            $$ = new ExprArg(RShiftOpSymbol, $1, $3);
                }
        |       arg BITXOR arg
                {
	            $$ = new ExprArg(BitxorOpSymbol, $1, $3);
                }
        |       arg BITAND arg
                {
	            $$ = new ExprArg(BitandOpSymbol, $1, $3);
                }

        |       arg BITOR arg
                {
                    $$ = new ExprArg(BitorOpSymbol, $1, $3);
                }

	| 	BITNOT arg_primary 
                {
                    $$ = new ExprArg(BitnotOpSymbol, $2);
                }

        |       arg MOD arg
                {
	            $$ = new ExprArg(ModOpSymbol, $1, $3);
                }


	| 	MINUS arg_primary	%prec 'bitnot'
		{
		    if (($2)->kindof() == COR_NUM_CONST) {
		      if (((NumArg *)$2)->num_kindof() == COR_INTEGER)
			$$ = new NumArg(-((NumArg *)$2)->i_val);
		      else 
			$$ = new NumArg(-((NumArg *)$2)->d_val);
                        // This delete is okay because NUM_CONSTs are not shared.
                        delete ((NumArg *)$2);
		    }
		    else {
			$$ = new ExprArg(SubOpSymbol, $2);
		    }
		}
;
arg_primary:	arg_fact
	|	LPAREN arg RPAREN
		{
		    $$ = $2;
		}

simple_arg:   const LPAREN optarglist RPAREN
               {
                   $$ = create_functor(parserStruct, $1);
               }

arg_fact:	const { $$ = (Arg*)$1; }
        |	NUM
        |       var_arg { $$ = $1; }
	|	UNDERSCORE { 

                // NOTE : this is a kludge ! Unification with dont care terms
                // is tricky, so instead we force the DontCareSymbol to be
                // treated each time as a distinct variable. The parser
                // NEVER generates  TheDontCareArg !! The scanner NEVER
                // returns UNDERSCORE !! Instead it returns VAR for "_"
                   $$ = &TheDontCareArg; fprintf(stderr, "DONT_CARE_ARG!!\n"); 
                }
        |       DOLLAR 
                {
                  //$$ = &TheParameterArg;
                  $$ = TheParameterArg;
                }
	|	const LPAREN optarglist RPAREN
		{
                  $$ = create_functor(parserStruct, $1);
		}
	|	LBRACKET arglist VBAR arg RBRACKET
		{
		    $$  = create_list(parserStruct, $4);
		}
	|	LBRACKET optarglist RBRACKET
		{
		    $$ = create_list(parserStruct, NilArg);
		}
	|	LESS grouping_list GREATER
		{
                  if (parserStruct.lhs_flag) {
                    complexRelation++ ;
		    if (exEnv.dbg_aggregates) 
                      fprintf(exEnv.error_file,"nested att found complex relation %d\n",
			      complexRelation);
                    $$ = create_multi_grouping(parserStruct) ;
                  }
                  else {
                    CORAL_error( COR_GROUPING_ON_RHS,NULL, fname);
                    YYERROR;
                  }
		}
        |       { push_cur_set(parserStruct, create_nested_multiset()); }
                LBRACE member_list RBRACE
                { $$ = parserStruct.cur_set->info;
                  complexRelation++ ;
                  if (exEnv.dbg_aggregates)
                    fprintf(exEnv.error_file,"nested att found complex relation %d\n",
                          complexRelation);
                  pop_cur_set(parserStruct);
                } 
;

var_arg: VAR { $$ = new VarArg($1, rule_var_enter(parserStruct, $1)); }

member_list:    member_list COMMA arg_fact 
                { insert_cur_set(parserStruct, $3); }
        |       arg_fact  { insert_cur_set(parserStruct, $1); }
        |       /* added this to allow an empty set {}  */
;

const:		SYMBOL     
;

literal_alias:		LBRACKET { parserStruct.sip_var_names.length=0; }
		p_idlist RBRACKET 
		{
                  $$ = NULL;
		}
;

p_id:		id
		{ add_to_array(&parserStruct.sip_var_names, (int)$1); }
;
p_idlist:	p_idlist COMMA p_id | p_id | ;


sips_or_rule_anno: rule_anno_list
		{
			$$ = NULL;
		}
;
	
rule_anno_list:		
	 	rule_anno_list COMMA rule_anno
		{
			if ($3 != NULL)
			    $$ = link_rule_anno($3,$1);
			else $$ = $1;
		}
	|	rule_anno
		{
			$$ = link_rule_anno($1,NULL);
		}
	|
		{
			$$ = NULL;
		}
;

rule_anno:	anno_name anno_case_details
		{
			$$ = make_anno($1,$2);
		}
	| 	sips
		{
			$$ = NULL;
		}
;

anno_name:	SYMBOL
;

anno_case:	anno_case_name ARROW anno_case_details
		{
			$$ = make_anno_case($1,$3);
		}
;

anno_case_list:	anno_case COMMA anno_case_list
		{
			$$ = link_anno_case_list($3, $1);
		}
	| 	anno_case
		{
			$$ = link_anno_case_list($1,NULL);
		}
;

anno_case_name:	  SYMBOL
		{
			$$ = make_anno_case_name($1);
		}
	|	NUM
		{
			$$ = make_anno_case_name($1);
		}
	|	VAR
		{
			VarArg *v= new VarArg($1, rule_var_enter(parserStruct, $1)) ;
			$$ = make_anno_case_name(v);
		}
	| 	UNDERSCORE
		{
			$$ = make_anno_case_name(&TheDontCareArg);
		}
	|	const LPAREN optarglist RPAREN
		{
			$$ = make_anno_case_name(create_functor(parserStruct, $1));
		}
	| 	LBRACKET optarglist RBRACKET
		{
			$$ = make_anno_case_name(create_list(parserStruct, NilArg));
		}
;

anno_case_details:	SYMBOL
		{
			$$ = make_anno_case_details($1);
		}
        |	NUM
		{
			$$ = make_anno_case_details($1);
		}
	|	VAR 
		{
			VarArg *v= new VarArg($1, rule_var_enter(parserStruct, $1)) ; 
			$$ = make_anno_case_details(v);
		}
	|	UNDERSCORE 
		{ 
			$$ = make_anno_case_details(&TheDontCareArg); 
		}
	|	const LPAREN optarglist RPAREN
		{
			$$ = make_anno_case_details(create_functor(parserStruct, $1));
		}
	| 	LBRACKET optarglist RBRACKET
		{
			$$ = make_anno_case_details(create_list(parserStruct, NilArg));
		}
	|	LBRACKET  anno_case_list RBRACKET
		{
			$$ = make_anno_case_details($2);
		}
;

sips:		SIPS LBRACKET sip_list RBRACKET
		{cur_rule->sips = $3;}
;
		

sip_list_entry: LBRACKET adorn_string 
				/** LBRACKET ad_idlist RBRACKET  **/
		COLON sip RBRACKET
		{
		    $$ = new sips;
		    {   char *ap;
		    	int i;
		    	/* ??? Check for possible length errors */
		    	$$->adorn.setlen((int) SymbolLength($2));
		    	for(i=0,ap = SymbolString($2); i < SymbolLength($2);
						i++, ap++) 
				if ( *ap == 'b') $$->adorn.set(i);
		    }
		    $$->sip_list = $4;
		    $$->next = NULL;
		}
;
sip_list:	sip_list COMMA sip_list_entry
		{
		    $$ = $3;
		    $3->next = $1;

		}
	|	sip_list_entry
		{
		    $$ = $1;
		    $1->next = NULL;
		}
	|	LBRACKET RBRACKET { $$ = NULL; }
;

opt_adorn_string:    
		{$$ = NULL;}
	| LBRACKET id RBRACKET
		{$$ = $2;}
;

adorn_string:	id
		{
			$$ = $1;
		}
;


sip:		sip COMMA arc
		{
		    $$ = $1;
		    $$->next = $3;
		}
	|	arc
		{
		    $$ = $1;
		}
;
arc:		LBRACKET
		arc_idlist RBRACKET ARROW id LPAREN bound_var_list RPAREN
		{
		    $$ = new sip();
		    $$->tail = CurTail;
		    $$->bound_vars = CurBoundVars;
		    $$->head = sip_var_lookup(parserStruct, $5);
                    $$->next = NULL;
		    CurTail.clear();
		    CurBoundVars.clear();
		}
	|
		{
		    $$ = NULL;
		}
;
bound_var:	VAR
		{
		    CurBoundVars.set(rule_var_lookup(parserStruct, $1));
		}
        |
;
bound_var_list:	bound_var_list COMMA bound_var
        |       bound_var
;

arc_id:		id
		{
		    CurTail.set(sip_var_lookup(parserStruct, $1));
		}
;
arc_idlist:	arc_idlist COMMA arc_id
	|	arc_id
;
id:		const
	|	VAR
;
%%

void yyerror(char *s)
{
 fprintf(exEnv.error_file, "%s line %d:\n", s, parseEnv.C_linenum);
 if (exEnv.C_interrupt_raised > 0) {
   fprintf(exEnv.error_file,
	   "CORAL:: Interrupt occurred during execution!:");
   fprintf(exEnv.error_file, "resetting state !\n");
   fprintf(exEnv.error_file, "Type a period to continue.\n");
   fflush(exEnv.error_file);
   // abort a consult that is halfway thru
   parseEnv.abort_file();
   exEnv.C_interrupt_raised = 0;
  }
}
