/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

// A set of C++ classes for generic (mixed-type) arithmetic.
// Copyright Per Bothner, 1990.
// This is a preliminary version; please do not re-distribute
// without my permission.

// There are a number of things missing, including BigNum
// divide, BigNum gcd (and hence fractions).
// Some thought to re-using storage is needed (though I believe
// garbage collection is best in the long run).

// Some of the routines are modification of ones in the PRL
// bignum package (which also implements the Bnn routines).

#include <stdio.h>
#include "arg.h"
#ifndef CORAL
#include "genmap.h"
#include "gkinds.h"
#include "gcompile.h"
#include "exceptions.h"
#include "gfiles.h"
#endif
#include <stdlib.h>
#include <string.h>
#ifdef __GNUG__
#ifdef USEGNUGPRAGMAS
#pragma implementation
#endif
#endif
#include <malloc.h>
/*
#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) alloca(size)
#endif
#ifndef DEALLOCATE_LOCAL
#define DEALLOCATE_LOCAL(size) 
#endif
*/
#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) malloc(size)
#endif
#ifndef DEALLOCATE_LOCAL
#define DEALLOCATE_LOCAL(size) /* do nothing */
#endif
#define NOT_IMPLEMENTED() return NULL


#ifdef Q_ENV
long Numeric::magic() const { return NumericKind; }
long Integer::magic() const { return IntegerKind; }
#endif

const SmallInt *Zero = &MkSmallInt(0);
const SmallInt *One = &MkSmallInt(1);
const SmallInt *MinusOne = &MkSmallInt(-1);

long print_base = 10;
long print_width = -1;
char print_pad_char = ' ';
long print_readable = 0;
long print_precision = -1;
long print_left_justify = 0;
char print_float_format = 'g';

int C_NewIntCount = 0;
int C_NewDoubleCount = 0;
/* extern "C" Double * NewDouble(double d); */
EXTERN Double * NewDouble ARGS((double d));

extern char * BigToString (const Integer* z, int base);

/**************************************************************************/
/*** fix_int functions ***/

inline fix_unsigned fix_abs(fix_int x) { return x < 0 ? -x : x; }

// Return least i such that word&(1<<i). Assumes word!=0.

int find_lowest_bit(register fix_unsigned word)
{
    register int i = 0;
    while (!(word & 0xF)) word >>= 4, i += 4;
    if (!(word & 3)) word >>= 2, i += 2;
    if (!(word & 1)) i += 1;
    return i;
}

int integer_length(fix_int i)
{
    int size = 0;
    if (i < 0) {
	while (i < (-1 << 16)) size += 16, i >>= 16;
	if (i < (-1 << 8)) size += 8, i >>= 8;
	if (i < (-1 << 4)) size += 4, i >>= 4;
	if (i < (-1 << 2)) size += 2, i >>= 2;
	if (i < (-1 << 1)) size += 1, i >>= 1;
	if (i < -1) size += 1;
    }
    else {
	while (i >= (1 << 16)) size += 16, i >>= 16;
	if (i >= (1 << 8)) size += 8, i >>= 8;
	if (i >= (1 << 4)) size += 4, i >>= 4;
	if (i >= (1 << 2)) size += 2, i >>= 2;
	if (i >= (1 << 1)) size += 1, i >>= 1;
	if (i >= 1) size += 1;
    }
    return size;
}

fix_unsigned gcd(fix_unsigned a, fix_unsigned b)
{ // Euclid's algorithm, copied from libg++.
    fix_unsigned tmp;

    if (b > a) {
	tmp = a; a = b; b = tmp;
    }
    for(;;) {
	if (b == 0)
	    return a;
	else if (b == 1)
	    return b;
	else {
	    tmp = b;
	    b = a % b;
	    a = tmp;
	}
    }
}

int BigDigitsNeeded(fix_unsigned* words, int len)
{
    register fix_int *ptr = (fix_int*)words + len;
    int new_len = len;
    fix_int word = *--ptr;
    if (word == -1)
	while (new_len > 1 && (word = *--ptr) < 0) {
	    new_len--;
	    if (word != -1) break;
	}
    else
	while (word == 0 && new_len > 1 && (word = *--ptr) >= 0) new_len--;
    return new_len;
}

#if 1 /* Erase 1 */

/**************************************************************************/
/*** Numeric methods ***/

const Numeric * Numeric::numeric() const { return this; }
const Numeric * Numeric::mul(const Numeric&) const { return NULL; }
const Numeric * Numeric::div(const Numeric&) const { return NULL; }
const Numeric * Numeric::addFixInt(fix_int) const { return NULL; }
const Numeric * Numeric::subFixInt(fix_int) const { return NULL; }
const Numeric * Numeric::mulFixInt(fix_int) const { return NULL; }
const Numeric * Numeric::divFixInt(fix_int) const { return NULL; }
const Numeric * Numeric::addInteger(const Integer&) const {return NULL;}
const Numeric * Numeric::subInteger(const Integer&) const {return NULL;}
const Numeric * Numeric::mulInteger(const Integer&) const {return NULL;}
const Numeric * Numeric::divInteger(const Integer&) const {return NULL;}
const Numeric * Numeric::addDouble(double) const {return NULL;}
const Numeric * Numeric::subDouble(double) const {return NULL;}
const Numeric * Numeric::mulDouble(double) const {return NULL;}
const Numeric * Numeric::divDouble(double) const {return NULL;}
const Numeric * Numeric::ipower(fix_int) const { return NULL; }
int Numeric::compareRational(const Rational&) const { return -2; }
int Numeric::compareFixInt(fix_int) const { return -2; }
int Numeric::compareDouble(double) const { return -2; }
int Numeric::getlong(long *) const  { return 0; }

/***************************************************************************/


void Numeric::printon(FILE *file, char *) const
{
  this->printon(file);
}

void Numeric::printon(FILE *) const
{
}

void NotANumber::printon(FILE *file) const
{
    switch (kind)  {
      case PosInfinityCode: fputs("Infinity", file); break;
      case NegInfinityCode: fputs("-Infinity", file); break;
      default: fprintf(file, "NaN[%d]", kind);
    }
}

void NotANumber::printon(FILE *file, char *) const
{
    this->printon(file);
}

int NotANumber::sign() const
{
    switch (kind)  {
      case PosInfinityCode: return 1;
      case NegInfinityCode: return -1;
      default: return 0;
    }
}

const Numeric& NotANumber::neg() const
{
    switch (kind)  {
      case PosInfinityCode: return NegInfinity;
      case NegInfinityCode: return PosInfinity;
      default: return *(const Numeric*)NULL;
    }
}

/***************************************************************************/
/*** Complex methods ***/

const Numeric * Complex::add(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*this + *c_other);
    else return other.addr(*this);
}
const Numeric * Complex::addr(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*c_other + *this);
    else return NULL;
}
const Numeric * Complex::sub(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*this - *c_other);
    else return other.subr(*this);
}
const Numeric * Complex::subr(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*c_other - *this);
    else return NULL;
}
const Complex& operator*(const Complex &x, const Complex& y)
{
    const Real& xr = x.realPart();
    const Real& xi = x.imagPart();
    const Real& yr = y.realPart();
    const Real& yi = y.imagPart();
    const Real& r = xr * yr - xi * yi;
    const Real& i = xi * yr + xr * yi;
    if (&i == Zero) return r; else return *new ComplexPair(r, i);
}
const Numeric * Complex::mul(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*this * *c_other);
    else return other.subr(*this);
}
const Numeric * Complex::mulr(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*c_other * *this);
    else return NULL;
}
const Complex& operator/(const Complex &x, const Complex& y)
{
    const Real& xr = x.realPart();
    const Real& xi = x.imagPart();
    const Real& yr = y.realPart();
    const Real& yi = y.imagPart();
    const Real& norm = yr * yr + yi * yi;
    return *new ComplexPair((xr * yr + xi * yi) / norm,
			    (xi * yr - xr * yi) / norm);
}
const Numeric * Complex::div(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*this / *c_other);
    else return other.subr(*this);
}
const Numeric * Complex::divr(const Numeric& other) const
{
    const Complex *c_other = other.complex();
    if (c_other) return &(*c_other / *this);
    else return NULL;
}

const Numeric * Complex::addFixInt(fix_int i) const 
{
    return new ComplexPair(i + realPart(), imagPart());
}

const Numeric * Complex::subFixInt(fix_int i) const 
{
    return new ComplexPair(i - realPart(), imagPart());
}

const Numeric * Complex::mulFixInt(fix_int i) const 
{
    if (i == 0) return Zero;
    return new ComplexPair(i * realPart(), i * imagPart());
}
const Numeric * Complex::divFixInt(fix_int i) const 
{
    const Real& yr = realPart();
    const Real& yi = imagPart();
    const Real& norm = yr * yr + yi * yi;
    return new ComplexPair((i * yr) / norm,
			   (i * yi).rneg() / norm);
}

void Complex::printon(FILE *file, char *) const
{
  this->printon(file);
}

void Complex::printon(FILE *file) const
{
    const Real& re = realPart();
    const Real& im = imagPart();
    re.printon(file);
    if (&im != Zero) {
	fputs("+%", file);
	im.printon(file);
    }
}

/***************************************************************************/
/*** ComplexPair methods ***/

const Real& ComplexPair::realPart() const 
{ 
    return re; 
}

const Numeric& ComplexPair::neg() const
{
    return *new ComplexPair(re.rneg(), im.rneg());
}
int ComplexPair::sign() const {return re.sign() ? 1 : im.sign();} //ARBITRARY!

/***************************************************************************/
/*** Integer Utility routines ***/

Integer * NewInteger(int len)
{
    Integer dummy;
    struct dummy_class {
	char c[sizeof(Integer)];
    };
    int size = sizeof(Integer) +(len-1)*sizeof(fix_int);
#ifdef DO_GC 
    // ... see FuncArg::New to see how to do this.
    fprintf(stderr, "GC for NewInteger not implemented\n");
#else
    Integer* I = (Integer*)new char[size];
#endif
    *(dummy_class*)I = *(dummy_class*)&dummy;
    I->len = len;
    C_NewIntCount += len;
    return I;
}

Integer * NewInteger(int len, fix_unsigned* data)
{
    Integer* I = NewInteger(len);
    BnnAssign(I->U, data, len);
    return I;
}

void div(const Integer& X, const Integer& Y,
	 enum RealToIntMode mode,
	 const Integer** quotient, const Integer** remainder)
{
    register int i;
    register fix_unsigned* p;
    int yLen = Y.big_len();
    int xLen = X.big_len();
    int nLen = (xLen > yLen ? xLen : yLen) + 1; // size of main work area.
   // fix_unsigned *xPtr = (fix_unsigned*)alloca(nLen * sizeof(fix_unsigned));
    fix_unsigned *xPtr = (fix_unsigned*)malloc(nLen * sizeof(fix_unsigned));
    BnnAssign(xPtr, (BigNum) X.U, xLen);
    fix_unsigned *yPtr;
    int qNegative; // True if quotient is negative.
    if ((qNegative = Y.is_negative()) || (remainder && mode != TruncateMode)) {
	//yPtr = (fix_unsigned*)alloca(yLen * sizeof(fix_unsigned));
	yPtr = (fix_unsigned*)malloc(yLen * sizeof(fix_unsigned));
	BnnAssign(yPtr, (BigNum) Y.U, yLen);
	if (qNegative) {
	    BnnComplement(yPtr, yLen);
	    BnnAddCarry(yPtr, yLen, 1);
	}
    }
    else {
        yPtr = (fix_unsigned *) Y.U;
    }
    int xNegative = X.is_negative();
    if (xNegative) {
	for (p = xPtr, i = xLen; --i >= 0; p++) *p = ~*p;
	BnnAddCarry(xPtr, xLen, 1);
	qNegative = 1 - qNegative;
    }
    BnnSetToZero(xPtr+xLen, nLen-xLen);
    int n_digits = (int) BnnNumDigits(xPtr, nLen-1);
    yLen = (int) BnnNumDigits(yPtr, yLen);
    if (yLen == 1 && yPtr[0] == 0) {
	// ZERO-DIVIDE!
	return;
    }
    int add_one = 0;
    BnnDivide(xPtr, nLen, yPtr, yLen);
    fix_unsigned* remainderPtr = xPtr;
    int remainderLen = BigDigitsNeeded(remainderPtr, yLen);
    int quotientLen = nLen - yLen;
    fix_unsigned* quotientPtr = xPtr+yLen;
    int exact = remainderLen <= 1 && remainderPtr[0] == 0;
    switch (mode) {
      case TruncateMode:
	break;
      case CeilingMode:
	if (qNegative) break;
	if (!exact) add_one = 1;
	break;
      case FloorMode:
	if (!qNegative) break;
	if (!exact) add_one = 1;
	break;
      case RoundMode:
	// NOT IMPLEMENTED!
	break;
    }
    if (quotient) {
	if (qNegative)
	    BnnComplement(quotientPtr, quotientLen);
	if (qNegative != add_one)
	    BnnAddCarry(quotientPtr, quotientLen, 1);
	quotientLen = BigDigitsNeeded(quotientPtr, quotientLen);
	if (quotientLen == 1)
	    *quotient = MakeFixInt((fix_int)quotientPtr[0]);
	else
	    *quotient = NewInteger(quotientLen, quotientPtr);
    }
    if (remainder) {
	// The remainder is by definition: X-Q*Y
	if (add_one) {
	    // Subtract the remainder from Y.
	    BnnSubtract(yPtr, yLen, remainderPtr, remainderLen, 1);
	    remainderLen = BigDigitsNeeded(yPtr, yLen);
	    remainderPtr = yPtr;
	    // In this case, abs(Q*Y) > abs(X).
	    // So sign(remainder) = -sign(X).
	    xNegative = 1 - xNegative;
	} else {
	    // If !add_one, then: abs(Q*Y) <= abs(X).
	    // So sign(remainder) = sign(X).
	}
	if (xNegative) {
	    BnnComplement(remainderPtr,  remainderLen);
	    BnnAddCarry(remainderPtr, remainderLen, 1);
	}
	if (remainderLen == 1)
	    *remainder = MakeFixInt((fix_int)remainderPtr[0]);
	else
	    *remainder = NewInteger(remainderLen, remainderPtr);
    }
}

void div(const Real& X, const Real& Y,
	 enum RealToIntMode mode,
	 const Real** quotient, const Real** remainder)
{
    const Integer *Xint = X.integer();
    if (Xint) {
	const Integer *Yint = Y.integer();
	if (Yint) {
	    div(*Xint, *Yint, mode,
		(const Integer**)quotient, (const Integer**)remainder);
	    return;
	}
    }
    const Real& ratio = X / Y;
    const Integer& Q = ratio.to_integer(mode);
    if (quotient) *quotient = &Q;
    if (remainder) *remainder = &(X - Q * Y);
}

#endif /* Erase 1 */


#if 1 /* Erase 3 */

/***************************************************************************/
/*** Real methods ***/

const Real& Real::realPart() const { return *this; }
const Real& Real::imagPart() const { return *Zero; }

const Real *ConvertReal(const Root *num)
{
    const Numeric *n = num->numeric();
    if (n == NULL) return NULL;
    return n->real();
}

const Integer& Real::div_floor(const Real& divisor) const
{
    return ConvertReal(div(divisor))->floor();
}

/***************************************************************************/
/*** Rational methods ***/

int Rational::compare(const Root& other) const
{
    const Numeric *num = other.numeric();
    if (!num) return -2;
    return num->compareRational(*this);
}

const Rational * Rational::rational() const
{ 
    return this; 
}

const Numeric * Rational::add(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*this + *r_other);
    else return other.addr(*this);
}
const Numeric * Rational::addr(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*r_other + *this);
    else return NULL;
}

const Numeric * Rational::sub(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*this - *r_other);
    else return other.subr(*this);
}
const Numeric * Rational::subr(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*r_other - *this);
    else return NULL;
}

const Numeric * Rational::mul(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*this * *r_other);
    else return other.subr(*this);
}
const Numeric * Rational::mulr(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*r_other * *this);
    else return NULL;
}
const Numeric * Rational::div(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*this / *r_other);
    else return other.subr(*this);
}

const Numeric * Rational::divr(const Numeric& other) const
{
    const Rational *r_other = other.rational();
    if (r_other) return &(*r_other / *this);
    else return NULL;
}

int compare(const Rational& x, const Rational& y) 
{
    const Integer& x_num = x.numerator();
    const Integer& x_den = x.denominator();
    const Integer& y_num = y.numerator();
    const Integer& y_den = y.denominator();
    return ::compare(&y_den == One ? x_num : x_num * y_den,
		     &x_den == One ? y_num : y_num * x_den);
}

int Rational::compareRational(const Rational& x) const
{
    return ::compare(x, *this);
}

int Rational::compareFixInt(fix_int left) const
{
    FixInt left_int(left);
    const Integer& y_den = denominator();
    return ::compare(&y_den==One ? *(const Integer*)&left_int : left_int*y_den,
		     numerator());
}

const Numeric * Rational::ipower(fix_int pow) const
{
    if (pow >= 0)
	return new Fraction(power(numerator(), pow),
			    power(denominator(),pow));
    else // MakeRational is only necessary in case numerator is negative
	return MakeRational(power(denominator(), -pow),
			    power(numerator(), -pow));
}

/**************************************************************************/
/*** Rational Utilities ***/

const Rational *MakeRational(const Integer& num, const Integer& den)
{
    const Integer *g = num.gcd(den);
#if 1
    if (g == Zero) // In this case num and/or den is Zero.
	return MakeRational(num.sign(), den.sign());
#else
    if (g != One) {
	if (g->is_fix()) {
	    if (g->fix_value() == 0) { // In this case num and/or den is Zero.
	    	return MakeRational(num.sign(), den.sign());
	    }
	    if (den.is_fix() && num.is_fix())
	    int den_is_fix = den.getlong(&l_den);
	    int num_is_fix = num.getlong(&l_num);
	    if (den_is_fix) l_den = l_den / l_g;
	    if (num_is_fix) l_num = l_num / l_g;
	    if (den_is_fix + num_is_fix == 2)
	    	return MakeRational(l_num, l_den);
	}
    }
#endif
    const Integer *new_num, *new_den;
    div(num, *g, TruncateMode, &new_num, NULL);
    div(den, *g, TruncateMode, &new_den, NULL);
    if (new_den == One)
	return new_num;
    return new Fraction(*new_num, *new_den);
}

const Rational *MakeRational(fix_int num, fix_int den)
{
    if (den == FixInt::smallest() || num == FixInt::smallest()) {
	// Not safe to deal with these values.
	SmallInteger num_big(num);
	SmallInteger den_big(den);
	return MakeRational(num_big, den_big);
    }
	
    fix_unsigned g = gcd(fix_abs(num), fix_abs(den));
    if (g == 0)
	if (den == 0)
	    if (num > 0) return &PosInfinity;
	    else if (num == 0) return Zero; // Some prefer One
	    else return &NegInfinity;
	else
	    return Zero;

    if (g != 1) {
	num = (fix_int) (num / (long)g);
	den = (fix_int) (den / (long)g);
    }
    
    if (den < 0) {
	den = -den;
	num = -num;
    }
    if (den == 1) return MakeFixInt(num);
    return new Fraction(*MakeFixInt(num), *MakeFixInt(den));
}

/**************************************************************************/
/*** More Integer Utilities ***/

const Integer& gcd(const Integer& a0, const Integer& a1)
{
    int i = a0.big_len();
    int j = a1.big_len();
    if (BnnIsZero((BigNum)a0.U, 1) || BnnIsZero((BigNum)a1.U, j))
	return *Zero;
    int alen = (int) max(i, i);
    fix_unsigned *a0p = (fix_unsigned *) 
			ALLOCATE_LOCAL(2 * sizeof(fix_unsigned)*alen);
    fix_unsigned *a1p = a0p + alen;
    BnnAssign(a0p, (BigNum)a0.U, i);
    if (alen > i) BnnSetToZero(a0p + i, alen - i);
    if (a0.is_negative()) {
	BnnComplement(a0p, alen);
	BnnAddCarry(a0p, alen, 1);
    }
    BnnAssign(a1p, (BigNum)a1.U, j);
    if (alen > j) BnnSetToZero(a1p + j, alen - j);
    if (a1.is_negative()) {
	BnnComplement(a1p, alen);
	BnnAddCarry(a1p, alen, 1);
    }

    // Find i such that both a0p and a1p are divisible by 2**i.
    fix_unsigned *p0 = a0p, *p1 = a1p;
    fix_unsigned word;
    for (i = 0; ; i++) {
	word = *p0|*p1;
	if (word) break; // Must terminate, since a0 and a1 are non-zero.
    }
    int initShiftWords = i;
    int initShiftBits = find_lowest_bit(word);
    // Logically: i = initShiftWords * BN_DIGIT_SIZE + initShiftBits

    // Temporarily devide both a0p and a1p by 2**i.
    a0p += initShiftWords;
    a1p += initShiftWords;
    alen -= initShiftWords;
    if (initShiftBits) {
	BnnShiftRight(a0p, alen, initShiftBits);
	BnnShiftRight(a1p, alen, initShiftBits);
    }

    fix_unsigned *odd_arg; // One of a0p or a1p which is odd.
    fix_unsigned *other_arg; // The other one; can be even or odd.
    if (a0p[0] & 1) odd_arg = a0p, other_arg = a1p;
    else odd_arg = a1p, other_arg = a0p;

    for (;;) {
	// Shift other_arg until it is odd; this doesn't
	// affect the gcd, since we divide by 2**k, which does not
	// divide odd_arg.
	for (p0 = other_arg, i = 0; !*p0; p0++, i++) ;
	if (i) {
	    BnnAssign(other_arg, other_arg+i, alen-i);
	    BnnSetToZero(other_arg+i, alen-i);
	}
	i = find_lowest_bit(*p0);
	if (i) BnnShiftRight(other_arg, alen, i);
	
	// Now both odd_arg and other_arg are odd.

	// Subtract the smaller from the larger.
	// This does not change the result, since gcd(a-b,b)==gcd(a,b).
	int i = BnnCompare(odd_arg, alen, other_arg, alen);
	if (i == 0)
	    break;
	if (i > 0) { // odd_arg > other_arg
	    BnnSubtract(odd_arg, alen, other_arg, alen, 1);
	    // Now odd_arg is even, so swap with other_arg;
	    fix_unsigned *tmp = odd_arg; odd_arg = other_arg; other_arg = tmp;
	}
	else { // other_arg > odd_arg
	    BnnSubtract(other_arg, alen, odd_arg, alen, 1);
	}
    }
    BnnShiftLeft(a0p, alen, initShiftBits);
    alen += initShiftWords;
    a0p -= initShiftWords;
    a1p -= initShiftWords;
    while (alen > 1 && a0p[alen-1] == 0) alen--;
    // Always safe, since at worst a1p (continguous with a0p) may be trashed.
    if (a0p[alen-1] < 0) a0p[alen++] = 0;
    const Integer *result = alen>1 ? NewInteger(alen,a0p) : MakeFixInt(a0p[0]);
    DEALLOCATE_LOCAL(a0p);
    return *result;
}

#if 0
const Integer& lcm(const Integer& x, const Integer& y)
{
    if (&x == Zero || &y == Zero)
	return Zero;
    Integer& g = gcd(x, y);
    return (x IDIV g) * y;
}
#endif

const Integer& power(const Integer& x, fix_unsigned apow)
{
    int maxsize =  ((x.integer_length() * apow) / BN_DIGIT_SIZE) + 1;
    int in_len = maxsize;
    // BnnMultiply requires that the size of the result is at
    // least the sum of the input sizes.
    // But perhaps something more clever than this is possible.
    int out_len = 2*in_len;
    Integer *r = NewInteger(out_len);
    Integer *work = NewInteger(out_len);
    int negate = 0;
    Integer *b = NewInteger(out_len);
    BnnSetToZero(b->U, in_len);
    BnnAssign(b->U, (BigNum)x.U, (int) x.len);
    if (x.S[x.len-1] < 0) {
	negate = apow & 1;
	BnnComplement(b->U, (int) x.len);
	BnnAddCarry(b->U, (int) x.len, 1);
    }

    Integer *tmp;
    BnnSetToZero(&r->U[1], (int) (r->len-1)); r->U[0] = 1; // r = 1;
    for (;;) {
	if (apow & 1) { // r *= b
	    BnnSetToZero(work->U, in_len);
	    BnnMultiply(work->U, out_len,
			r->U, in_len, b->U, in_len);
	    tmp = r; r = work; work = tmp; // swap to avoid a copy
	}
	if ((apow >>= 1) == 0)
	    break;
	// b *= b;
	BnnSetToZero(work->U, in_len);
	BnnMultiply(work->U, out_len,
		    b->U, in_len, b->U, in_len);
	tmp = b; b = work; work = tmp; // swap to avoid a copy
    }
    work->do_delete();
    b->do_delete();
    BnnSetToZero(r->U+in_len, out_len-in_len);
    if (negate) {
	BnnComplement(r->U, (int) r->len);
	BnnAddCarry(r->U, (int) r->len, 1);
    }
    return *r->simplify_Int();
}

const Numeric* power(const Numeric* x, const Numeric* y)
{
#if 0
    if (x == Zero) {
	if (y == Zero) return 1;
	return Zero;
    }
#endif
    if (x == One) return One;
    long y_l;
    if (y->getlong(&y_l))
	return x->ipower((fix_int)y_l);
    // return exp(y * ln(x));
    return NULL;
}

/**************************************************************************/
/*** RationalInfinity methods ***/


const RationalInfinity PosInfinity(1);
const RationalInfinity NegInfinity(-1);
RationalInfinity::RationalInfinity(int s)
  : Fraction(MkSmallInt(s), *Zero) { val = s; }

void RationalInfinity::printon(FILE *file, char *) const
{
  this->printon(file);
}

void RationalInfinity::printon(FILE *file) const
{
    switch (val)  {
      case -1: fputs("-Infinity", file); break;
      case 1: fputs("Infinity", file); break;
      default: abort();
    }
}

#if 1  /* erase */
/*******************************************
*** This stuff has been moved into gennum2.C to get around a Cfront compiler 
*** bug!*/
const Real& RationalInfinity::rneg() const
{
    switch (val)  {
       case 1: return NegInfinity;
       case -1: return PosInfinity;
       default: return *(Real*)NULL;
    }
}
/********************************************/
#endif /* erase */

/***************************************************************************/
/*** FixInt methods */


const Numeric * FixInt::addFixInt(fix_int j) const
{
    fix_int sum = j + val;
    if (j >= 0)
	if (sum >= 0 || val <= 0) return MakeFixInt(sum);
	else {
	    Integer* result = NewInteger(2);
	    result->S[0] = sum;
	    result->U[1] = 0;
	    return result;
	}
    else
	if (sum < 0 || val >= 0) return MakeFixInt(sum);
	else {
	    Integer* result = NewInteger(2);
	    result->S[0] = sum;
	    result->S[1] = -1;
	    return result;
	}
}

const Numeric * FixInt::subFixInt(fix_int j) const
{
    fix_int diff = j - val;
    if (j >= 0)
	if (diff >= 0 || val >= 0)
	    return MakeFixInt(diff);
	else {
	    Integer* result = NewInteger(2);
	    result->S[0] = diff;
	    result->S[1] = 0;
	    return result;
	}
    else
	if (val <= 0 || diff < 0)
	    return MakeFixInt(diff);
	else {
	    Integer* result = NewInteger(2);
	    result->S[0] = diff;
	    result->S[1] = -1;
	    return result;
	}
}

const Numeric * FixInt::mulFixInt(fix_int j) const
{
    fix_unsigned x, y; int neg;
    if (j >= 0) neg = 0, x = j;
    else neg = 1, x = -j;
    if (val >= 0) y = val;
    else neg = 1-neg, y = -val;
    fix_unsigned prod[2];
    prod[0] = 0; prod[1] = 0;
    BnnMultiplyDigit(prod, 2, &x, 1, y);
    // Does the result fit into a FixInt?
    if (prod[1] == 0) {
	if (!neg) {
	    j = (fix_int)prod[0];
	    if (j >= 0) return MakeFixInt(j);
	}
	else {
	    j = -(fix_int)prod[0];
	    if (j <= 0) return MakeFixInt(j);
	}
    }
    Integer& result = *NewInteger(2);
    if (neg) {
	// -result == ~result + 1
	result.U[0] = ~prod[0];
	result.U[1] = ~prod[1];
	BnnAddCarry(result.U, 2, 1);
    } else {
	result.U[0] = prod[0];
	result.U[1] = prod[1];
    }
    return &result;
}

const Numeric * FixInt::divFixInt(fix_int arg) const
{
    return  NewDouble(((double) arg)/(double) fix_value()) ;
    // Used to be 
    //    MakeRational(arg, fix_value());

}

int FixInt::compare(const Root& other) const
{
    const Numeric *num = other.numeric();
    if (!num) return -2;
    return num->compareFixInt(val);
}

const FixInt* MakeFixInt(long i)
{
    register long j = i - LeastSmallInt;
    if ((unsigned long)j < CountSmallInt) return &SmallIntTable[(int) j];
    C_NewIntCount++;
    return new FixInt((int) i);
}

double FixInt::as_double() const 
{
    return (double) val;
}


#if 0
char NumChar[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

int IntPut(
    register unsigned long x,
    char *buffer, /* points to the RIGHT OF the UNITS position of result */
    unsigned base) /* a number in the range 2..36 */
    /* returns number of significant digits */
  { register char *ptr = buffer;
    while (x != 0)
      { *--ptr = NumChar[x % base]; x /= base; }
    return buffer - ptr;
  }

void UIntPrint(
    unsigned long i,
    register FILE *f,
    int base) /* 2..36 */
{
#define IntPutBufLen 34
    char buffer[IntPutBufLen]; /* max size if binary */
    register char *b;
    register count;
    if (i == 0) { putc('0', f); return; }
    count = IntPut(i, buffer+IntPutBufLen, base);
    b = buffer+IntPutBufLen-count;
    while (--count >= 0) putc(*b++, f);
}

void SIntPrint(long i, FILE *f, int base)
{
    if (i < 0) { putc('-', f); i = -i; }
    if (base != 10 && print_readable)
	fprintf(f, "%dr", print_base);
    UIntPrint((unsigned long)i, f, base);
}


void FixInt::printon(FILE *file) const
{
    SIntPrint(val, file, print_base);
}
#endif

const Real& FixInt::rneg() const
{
    if (val == (int)0x80000000) { abort(); return *(const Real*)0; }
    return *MakeFixInt(-val);
}

const Integer * FixInt::gcdFixInt(fix_int arg) const
{
    unsigned long g = ::gcd(fix_abs(val), fix_abs(arg));
    if ((long)g < 0) { NOT_IMPLEMENTED(); }
    return MakeFixInt(g);
}

const Integer& FixInt::operator<<(int count) const
{
    if (count <= 0) // shift right
	if (count < -(BN_DIGIT_SIZE-1))
	    if (ival() >= 0) return *Zero;
	    else return *MinusOne;
	else
	    return *MakeFixInt(ival() >> -count);

    // Shift left
    if (ival() > 0) {
	if (count < (BN_DIGIT_SIZE-1)
	    && ival() < (1 << ((BN_DIGIT_SIZE-1) - count)))
	    return *MakeFixInt(ival() << count);
    } else {
	if (ival() == 0) return *Zero;
	if (count <= (BN_DIGIT_SIZE-1)
	    && (~ival()) < (1 << ((BN_DIGIT_SIZE-1) - count)))
	    return *MakeFixInt(ival() << count);
    }
    return this->Integer::operator<<(count);
}

int FixInt::compareDouble(double left) const
{   double right = (double)val;
    return left > right ? 1 : left==right ? 0 : -1;
} 

#ifdef Q_ENV
const StringC *FixInt::asString(int format=0) const
{
    char buf[20];
    sprintf(buf, "%d", val);
    return NewString(strlen(buf), buf);
}

static void FixIntDumpProc(struct PrevDumped *dump, CFile *cf)
{
    fprintf(cf->asmFile, "FixInt %s(%d);\n", dump->name(),
	((FixInt*)dump->addr())->val);
}

void FixInt::dumpPtr(CFile *cf) const
{
    struct PrevDumped *dump = NewPendingDump(cf, this, &FixIntDumpProc, NULL);
    fprintf(cf->auxFile, "extern FixInt %s;\n", dump->name());
    fprintf(cf->asmFile, "&%s", dump->name());
}
#endif

int FixInt::compareFixInt(fix_int left) const
{ return left > val ? 1 : left==val ? 0 : -1; } 

int FixInt::getlong(long *i) const { *i = val; return 1; }


/***************************************************************************/
/*** FixIntTab methods ***/

FixIntTab SmallIntTable;

#if 1 /* erase 2 */
/*****************************************
*** This stuff has been moved into gennum3.C to get around a Cfront compiler 
*** bug!
*/
static int InitSmallIntTabDone = 0;
FixIntTab::FixIntTab()
{ 
    SmallInt x(LeastSmallInt);
    // static 
    if (InitSmallIntTabDone++) return;
    register int count = CountSmallInt;
    // register SmallInt *ptr = &SmallIntTable.fixes[0];
    register SmallInt *ptr = fixes;
    for ( ; -- count >= 0; ptr++, x.val++) *ptr = x;
}
/****************************************** */
#endif /* erase 2 */

/***************************************************************************/
/*** SmallInt methods ***/

#ifdef Q_ENV
void SmallInt::dumpPtr(CFile *cf) const
{
    fprintf(cf->asmFile, "SMALL_INT(%d)", val);
}
#endif

const Numeric * SmallInt::addFixInt(fix_int x) const
{
    // Use unsigned arithmetric, because that should not raise an
    // exception on overflow. (Does ANSI mandate this?)
    unsigned index = (unsigned)x + (unsigned)val - (unsigned)LeastSmallInt;
    if (index < CountSmallInt) return &SmallIntTable[index];
    return FixInt::addFixInt(x);
}

const Numeric * SmallInt::subFixInt(fix_int x) const
{
    // Use unsigned arithmetric, because that should not raise an
    // exception on overflow. (Does ANSI mandate this?)
    unsigned index = (unsigned)x - (unsigned)val - (unsigned)LeastSmallInt;
    if (index < CountSmallInt) return &SmallIntTable[index];
    return FixInt::subFixInt(x);
}

const Numeric * SmallInt::mulFixInt(fix_int x) const
{
    if (x + (unsigned)LeastSmallInt < CountSmallInt) {
	unsigned index = (unsigned)x * (unsigned)val - (unsigned)LeastSmallInt;
	if (index < CountSmallInt) return &SmallIntTable[index];
    }
    return FixInt::mulFixInt(x);
}

/***************************************************************************/
/*** Double methods ***/
/****

extern "C" Double * NewDouble(double d) {
	C_NewDoubleCount++;
	return new Double(d);
	}
****/
Double * NewDouble(double d) {
	C_NewDoubleCount++;
	return new Double(d);
	}

numarg_kind Double::num_kindof() const
{
    return COR_DOUBLE;
}

HashVal Double::hash(BindEnv *)
{ 
    int *ptr = (int *)&val;
    return IntToHash( ptr[0] ^ ptr[1]); 
}

void Double::printon(FILE *file) const
{
    char format[20]; char buffer[100];
    char *fptr = format;
    *fptr++ = '%';
    if (print_width >= 0) {
	sprintf(fptr, "%d", print_width);
	fptr += strlen(fptr);
    }
    if (print_precision >= 0) {
	sprintf(fptr, ".%d", print_precision);
	fptr += strlen(fptr);
    }
    *fptr++ = print_float_format;
    *fptr = '\0';
    sprintf(buffer, format, val);

    // Kludge to make sure the last char isn't '.'.
    fptr = buffer + strlen(buffer);
    if (fptr[-1] == '.') {
	fptr[0] = '0';
	fptr[1] = 0;
    }

    fputs(buffer, file);
}

void Double::printon(FILE *file, char *fmt_str) const
{
    char buffer[100];
    sprintf(buffer, fmt_str, val);

    char *temp = fmt_str;

    while (*temp != '\0')
      {
       if (*temp == 'f' || *temp == 'g' || *temp == 'G'
           || *temp == 'e' || *temp == 'E') break;
       temp++;
      }

    if (*temp == '\0')
        fprintf( stderr,
           "Incorrect format statement provided to print float value.\n");

    // Kludge to make sure the last char isn't '.'.
    char * fptr = buffer + strlen(buffer);
    if (fptr[-1] == '.')
      {
        fptr[0] = '0';
        fptr[1] = 0;
      }

    fputs(buffer, file);

}

void Double::sprint(char *str, int *pos, BindEnv *) const
{
    sprintf(str + *pos, "%f", val);
    *pos = strlen(str);
}

#ifdef Q_ENV
static void DoubleDumpProc(struct PrevDumped *dump, CFile *cf)
{
    fprintf(cf->asmFile, "Double %s(%d);\n", dump->name(),
	((Double*)dump->addr())->val);
}

void Double::dumpPtr(CFile *cf) const
{
    struct PrevDumped *dump = NewPendingDump(cf, this, &DoubleDumpProc, NULL);
    fprintf(cf->auxFile, "extern Double %s;\n", dump->name());
    fprintf(cf->asmFile, "&%s", dump->name());
}
#endif


int Double::compare(const Root& other) const
{
    const Numeric *num = other.numeric();
    if (!num) return -2;
    return num->compareDouble(val);
}

int Double::compareFixInt(fix_int other) const
{   double left = (double)other;
    return left > val ? 1 : left==val ? 0 : -1;
} 


int Double::compareDouble(double left) const
{ return left > val ? 1 : left==val ? 0 : -1; } 

const Integer& Double::to_integer(enum RealToIntMode mode) const
{
    // Does not handle NaNs, infinities, -0.0, or unnormalized numbers.
    int i;
#define MAX_COR_DOUBLE_FIXES 34 /* Max size in fix_ints for double: 1024+64 bits */
    fix_unsigned buf[MAX_COR_DOUBLE_FIXES]; 
    union {
	double d;
	long l[2];
	struct {
#define EXPONENT_LENGTH 11
#define EXPONENT_MASK 0x7FF0
#define EXPONENT_BIAS 0x400 /* 1024 */
	    unsigned sign : 1;
	    unsigned exponent : EXPONENT_LENGTH;
	    unsigned w1 : 31-EXPONENT_LENGTH;
	    unsigned long w2;
	} b;
    } u;
    u.d = val;
    int sign = u.b.sign;
    int exp = u.b.exponent - EXPONENT_BIAS;
    u.b.exponent = 1; /* add supressed bit */
    u.b.sign = 0;
    /* now l[0..1] is the factor to be shifted */
#define FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA 2
    // Copy mantissa to first FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA
    // fix_ints of buf. MACHINE DEPENDENCY!
    buf[0] = (fix_unsigned) u.b.w2;
    buf[1] = (fix_unsigned) u.l[0];
    // We consider the buf to be an integer, with the
    // binary point at the far "right" (little end).
    // Adjust exp to compensate for this. MACHINE DEPENDENCY!
    exp -= 51;
    if (exp >= 0) { // shift left
	// exp_words == # of whole fix_ints to shift by.
	int exp_words = exp >> BN_DIGIT_LOG;
	int total_length = exp_words+(FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA+1);
	// Set up buf to consist of:
	// a) First exp_words contain 0.
	// b) Next FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA contain mantissa.
	// c) A single high-order fix_int containing 0 (to shift into).
	for (i = FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA; --i >= 0; )
	    buf[i + exp_words] = buf[i];
	for (i = exp_words; --i >= 0; ) buf[i] = 0;
	buf[total_length-1] = 0;
	BnnShiftLeft(buf, total_length, exp & BN_DIGIT_SIZE-1);
	register fix_unsigned *p;
	if (sign) { // Negative
	    for (p = buf, i = total_length; --i >= 0; p++)
		*p = ~*p;
	    BnnAddCarry(buf, total_length, 1);
        }
	return *NewInteger(BigDigitsNeeded(buf, total_length), buf);
    } else { // shift right
	exp = -exp;
	// exp_words == # of whole fix_ints to shift by.
	int exp_words = exp >> BN_DIGIT_LOG;
	int total_length = FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA - exp_words;
	int add_one = 0; // If absolute value of result should be increased.
	fix_unsigned shifted =
	    BnnShiftRight(buf, FIXINTS_NEEDED_FOR_COR_DOUBLE_MANTISSA,
			  exp & BN_DIGIT_SIZE-1);
        register fix_unsigned *p;
        fix_unsigned half, word ;
	switch (mode) {
	  case RoundMode:
	    half = (fix_unsigned)(FixInt::smallest());
	    i = exp_words;
	    p = buf+i;
	    word = --i >= 0 ? *--p : shifted;
	    if (word < half) break;
	    else if (word > half) { add_one = 1; break; }
	    for (;;) {
		word = --i >= 0 ? *--p : shifted;
		if (word > 0) { add_one = 1; break; }
		if (i <= 0) {
		    // The input is exactly between two integers.
		    // Round to the one that is even.
		    if (buf[exp_words] & 1) add_one = 1;
		    break;
		}
	    }
	  case CeilingMode:
	    if (sign) break;
	    if (shifted) add_one = 1;
	    else
		for (p = buf, i = exp_words; --i >= 0; )
		    if (*p++ != 0) { add_one = 1; break; }
	    break;
	  case FloorMode:
	    if (!sign) break;
	    if (shifted) add_one = 1;
	    else
		for (p = buf, i = exp_words; --i >= 0; )
		    if (*p++ != 0) { add_one = 1; break; }
	    break;
	  case TruncateMode:
	    break;
	}
	if (total_length <= 0)
	    if (!add_one) return *Zero;
	    else if (sign) return *MinusOne;
	    else return *One;
	if (sign) { // Negative
	    for (p = buf+exp_words, i = total_length; --i >= 0; p++)
		*p = ~*p;
	    add_one = 1 - add_one;
	}
	if (add_one)
	    BnnAddCarry(buf+exp_words, total_length, 1);
	total_length = BigDigitsNeeded(buf+exp_words, total_length);
	if (total_length == 1)
	    return *MakeFixInt((fix_int)buf[exp_words]);
	return *NewInteger(total_length, buf+exp_words);
    }
}

/*** end Double methods ***/
#endif /*** Erase 3 **/

#if 1 /* Erase 2 */
/***************************************************************************/
/*** Fraction methods ***/

const Integer& Fraction::to_integer(enum RealToIntMode mode) const
{
    Integer* quotient;
    ::div(num, den, mode, &quotient, NULL);
    return *quotient;
}

void Fraction::printon(FILE *file, char *) const
{
  this->printon(file);
}

void Fraction::printon(FILE *file) const
{
    num.printon(file);
    fputc('/', file);
    den.printon(file);
}

const Real& Fraction::rneg() const
{
    return *MakeRational(*(const Integer*)&num.rneg(), den);
}

const Numeric * Fraction::addFixInt(fix_int i) const
{
    return MakeRational(num + i * den, den);
}

const Numeric * Fraction::subFixInt(fix_int i) const
{
    return MakeRational(i * den - num, den);
}

const Numeric * Fraction::mulFixInt(fix_int i) const
{
    return MakeRational(i * num, den);
}

const Numeric * Fraction::divFixInt(fix_int i) const
{
    return MakeRational(i * den, num);
}

const Numeric * Fraction::addInteger(const Integer& big) const
{
    return MakeRational(
	num + *(Integer*)den.mulInteger(big),
	den);
}

const Numeric * Fraction::subInteger(const Integer &x) const
{
    return MakeRational(
	*(Integer*)den.mulInteger(x)->sub(num),
	den);
}

const Numeric * Fraction::mulInteger(const Integer &x) const
{
    return MakeRational(
	*(Integer*)num.mulInteger(x),
	den);
}

const Numeric * Fraction::divInteger(const Integer &x) const
{
    return MakeRational(
	*(Integer*)den.mulInteger(x),
	num);
}

/***************************************************************************/
/*** Integer methods ***/

numarg_kind Integer::num_kindof() const
{
    return COR_INTEGER;
}

int compare(const Integer& x, const Integer& y)
{
    if (x.is_negative()) // x < 0
	if (!y.is_negative())
	    return -1;
	else { // Both are negative
	    int xl = x.big_len();
	    register const fix_unsigned *xp = x.U + xl;
	    while (xl > 0 && xp[-1] == ~0) xp--, xl--;
	    int yl = y.big_len();
	    register const fix_unsigned *yp = y.U + yl;
	    while (yl > 0 && yp[-1] == ~0) yp--, yl--;

	    if (xl != yl)
		return (xl < yl ? 1 : -1);

	    int result = 0;
	    while (result == 0 && --xl >= 0)
		result = BnnCompareDigits (*--xp, *--yp);

	    return result;
	}
    else // x >= 0
	if (y.is_negative())
	    return 1;
	else // Both are non-negative
	    return BnnCompare((BigNum)x.U, x.big_len(), (BigNum)y.U, y.big_len());
}

double Integer::as_double() const
{ 
    int i;
    double base_power = 1.0;
    double base = (double)4.0 * (double)(1 << (BN_DIGIT_SIZE -2));
    double sum = 0.0;
    // Negative numbers are handled by inverting each big_digit while summing,
    // then using the formula for 2's complement: x == -(~x+1),
    // hence: (double)x == -((double)(~x) + 1.0).
    BigNumDigit mask = is_negative() ? ~(BigNumDigit)0 : (BigNumDigit)0;
    BigNum ptr = (BigNum)U;
    for (i = big_len(); --i >= 0; ) {
	sum += (*ptr++ ^ mask) * base_power;
	base_power *= base;
    }
    if (is_negative())
	sum = -(sum + 1.0);
    return sum;
}

int Integer::integer_length() const
// ceiling(log2(i < 0 ? -i : i+1))
// See Common Lisp: the Language, 2nd ed, p. 361
{
    // The loop is just to catch non-normalized integers.
    for (register int index = (int) len-1; index >= 0; index--) {
	int size = ::integer_length(U[index]);
	if (size) return size + BN_DIGIT_SIZE * index;
    }
    return 0;
}


#ifdef CORAL
HashVal Integer::hash(BindEnv *)
#else
int Integer::hash() const
#endif
{ return IntToHash(S[0]); }
void Integer::do_delete() { delete this; }
const Integer& Integer::numerator() const { return *this; }
const Integer& Integer::denominator() const { return *One; }
int Integer::sign() const { return bsign(); }
const Integer * Integer::gcd(const Integer& y) const {return &::gcd(*this,y); }
const Integer * Integer::gcdFixInt(fix_int i) const
{
    SmallInteger tmp(i);
    return &::gcd(*this, tmp);
}
const Numeric* Integer::add(const Numeric&x) const {return x.addInteger(*this);}
const Numeric* Integer::sub(const Numeric&x) const {return x.subInteger(*this);}
const Numeric* Integer::mul(const Numeric&x) const {return x.mulInteger(*this);}
const Numeric* Integer::div(const Numeric&x) const {return x.divInteger(*this);}

const Numeric * Integer::ipower(fix_int pow) const
{
    if (pow >= 0)
	return &power(*this, pow);
    else // "new Fraction" would do except when this is negative.
	return MakeRational(*One, power(*this, -pow));
}

int Integer::compareRational(const Rational& x) const
{
    const Integer& x_den = x.denominator();
    return ::compare(x.numerator(),
		     &x_den == One ? *this : *this * x_den);
}


int Integer::compareFixInt(fix_int left) const
{
    FixInt left_int(left);
    return ::compare(left_int, *this);
}

void Integer::printon(FILE *file) const
{
    char base_buf[4];
    int base_len;
    const Integer *this_abs = this;
    int put_minus = 0;
    if (is_negative()) {
	this_abs = &-(*this);
	put_minus = 1;
    }
    char *str = BigToString(this_abs, (int) print_base);
    if (print_base != 10 && print_readable) {
	sprintf(base_buf, print_base == 16 ? "0x" : "%dr", print_base);
	base_len = strlen(base_buf);
    } else
	base_len = 0;
    int width = put_minus+base_len+strlen(str);
    int padding = (int) (print_width - width);
    if (padding > 0 && !print_left_justify && print_pad_char != '0') {
	while (--padding >= 0) putc(print_pad_char, file);
    }
    if (put_minus)
	fputc('-', file);
    if (padding > 0 && !print_left_justify) {
	while (--padding >= 0) putc(print_pad_char, file);
    }
    if (base_len)
	fputs(base_buf, file);
    fputs(str, file);
    if (padding > 0 && print_left_justify) {
	while (--padding >= 0) putc(print_pad_char, file);
    }
    free((void*)str);
    if (this_abs != this) ((Integer*)this_abs)->do_delete();
}

void Integer::printon(FILE *file, char *fmt_str) const
{

    int pr_width, ret;
    int left_justify = 0;

    if ( (ret = sscanf(fmt_str, "%%%dd", &pr_width)) != 1)
      printon(file);
    else
     {
        const Integer *this_abs = this;
        int put_minus = 0;
        if (is_negative())
          {
            this_abs = &-(*this);
            put_minus = 1;
          }
        char *str = BigToString(this_abs, (int) print_base);
        int width = put_minus+strlen(str);
        if (pr_width < 0)
          {
            pr_width = -(pr_width);
            left_justify  = 1;
          }

        int padding = (int) (pr_width - width);
        if (padding > 0 && !left_justify && print_pad_char != '0')
          {
            while (--padding >= 0) putc(print_pad_char, file);
          }
        if (put_minus)
            fputc('-', file);
        if (padding > 0 && !left_justify)
          {
            while (--padding >= 0) putc(print_pad_char, file);
          }
        fputs(str, file);
        if (padding > 0 && left_justify)
          {
            while (--padding >= 0) putc(print_pad_char, file);
          }
        free((void*)str);
        if (this_abs != this) ((Integer*)this_abs)->do_delete();
      }
}

void Integer::sprint(char *str, int *pos, BindEnv *) const
{
    const Integer *this_abs = this;
    int put_minus = 0;
    if (is_negative())
      {
        this_abs = &-(*this);
        put_minus = 1;
      }
    char *int_str = BigToString(this_abs, (int) print_base);
    int width = put_minus+strlen(int_str);
    if (put_minus)
        sprintf(str + *pos, "-%s", int_str);
    else
        sprintf(str + *pos, "%s", int_str);

    *pos += width;
}


const Integer& Integer::operator<<(int count) const
{
    if (count == 0) return *this;
    else if (count > 0) { // Shift left
	int shiftBigDigits = count >> BN_DIGIT_LOG;
	int shiftBits = count & (BN_DIGIT_SIZE-1);
	Integer* dest = NewInteger(big_len() + shiftBigDigits + 1);
	BnnSetToZero(dest->U, shiftBigDigits);
	BnnAssign(dest->U + shiftBigDigits, (BigNum)U, big_len());
	dest->U[dest->big_len()] = is_negative() ? ~0 : 0;
	BnnShiftLeft(dest->U + shiftBigDigits, big_len() + 1, shiftBits);
	return *dest->simplify_Int();
    } else { // Shift right
	count = -count;
	int shiftBigDigits = count >> BN_DIGIT_LOG;
	int shiftBits = count & (BN_DIGIT_SIZE-1);
#if 1
	int d_len = big_len() - shiftBigDigits;
	int is_neg = is_negative();
	if (d_len <= 0)
	    if (is_neg) return *MinusOne;
	    else return *Zero;
	// One extra word for proper sign extension
	Integer* dest = (Integer*)NewInteger(d_len + is_neg);
	BnnAssign(dest->U, (BigNum)(U + shiftBigDigits), d_len);
	if (is_neg) dest->U[d_len++] = ~0;
	BnnShiftRight(dest->U, d_len, shiftBits);
	return *dest->simplify_Int();
#else
	// Old algorithm if bignums are signed-magnitude
	// If x<0 then x>>n == -(((abs(x) - 1) >> n) + 1)
	// not optimal: newLength could be one less
	int newLength = len - shiftBigDigits;
	if (newLength <= 0)
	    if (sgn >= 0) return *Zero;
	    else return *MakeFixInt(-1);
	BigZ result = BzCreate(newLength);
	BnnAssign(&result->Digits,
	    ((BigZ)this)->Digits+shiftBigDigits,
	    newLength);
	if (sgn < 0)
	    if (shiftBigDigits == 0
	     || BnnIsZero(((BigZ)this)->Digits, shiftBigDigits))
		BnnSubtractBorrow(result->Digits, BzGetSize(result), 0);
	BnnShiftRight(result->Digits, newLength, shiftBits);
	if (sgn < 0)
	    BnnAddCarry(result->Digits, newLength, 1);
	BzSetSign(result, sgn);
	return *((Integer *)result)->simplify_Int();
#endif
    }
}

const Integer& Integer::operator-() const
{
    // -(*this) == ~(*this) + 1
    int new_len = (int) len;
    if (s[len-1] == (fix_unsigned)(1 << (BN_DIGIT_SIZE-1))) new_len++;
    Integer *dest = NewInteger(new_len);
    register const fix_unsigned *src_p = s;
    register fix_unsigned *dst_p = dest->s;
    for (register int i = (int) len; --i >= 0; )
	*dst_p++ = ~*src_p++;
    if (new_len > (int)len)
	*dst_p++ = (fix_unsigned)(-1);
    BnnAddCarry(dest->s, (int) dest->len, 1);
    return *dest->simplify_Int();
}

const Real& Integer::rneg() const
{
    return -(*this);
}

const Numeric * Integer::addFixInt(fix_int i) const
{return &(*this + i);}

const Numeric * Integer::subFixInt(fix_int i) const
{
    SmallInteger tmp(i);
    return subInteger(tmp);
}

const Numeric * Integer::mulFixInt(fix_int i) const
{
    if (i == 0) return Zero;
    int numDigits = (int) BnnNumDigits((BigNum)U, (int) len);
    if (numDigits == 0) return Zero;
    Integer* result = NewInteger(numDigits + 1);
    BnnSetToZero(result->U, result->big_len());
    BnnMultiplyDigit(result->U, numDigits + 1,
	(BigNum)U, numDigits, i);
    return result->simplify_Int();
}

const Integer& operator+(const Integer &X, const Integer& Y)
{
    const Integer *x, *y;
    if (X.len > Y.len) x = &X, y = &Y;
    else x = &Y, y = &X;
    // x is longer than y.
    int x_neg = x->is_negative();
    int y_neg = y->is_negative();
    // Allocate one extra digit if x and y have the same sign.
    Integer *dest = NewInteger((int) (x->len + (x_neg==y_neg)));
    if (y_neg) { // y is negative
	BnnAssign(dest->s, (BigNum)y->s, (int) y->len);
	register fix_unsigned* d_ptr = dest->s + y->len;
	for (register int i = (int) (x->len - y->len); --i >= 0; ) *d_ptr++ = ~0;
	BnnAdd(dest->s, (int) x->len, (BigNum)x->s, (int) x->len, 0);
	if (x_neg) dest->s[x->len] = ~0;
    } else { // y is non-negative
	BnnAssign(dest->s, (BigNum)x->s, (int) x->len);
	BnnAdd(dest->s, (int) x->len, (BigNum)y->s, (int) y->len, 0);
	if (!x_neg) dest->s[x->len] = 0;
    }
    return *dest->simplify_Int();
}

const Integer& operator+(const Integer &X, fix_int Y)
{
    const Integer *x = &X;
    // x is longer than y.
    int x_neg = x->is_negative();
    int y_neg = Y < 0;
    // Allocate one extra digit if x and y have the same sign.
    Integer *dest = NewInteger((int) (x->len + (x_neg==y_neg)));
    if (y_neg) { // y is negative
	BnnAssign(dest->s, (fix_unsigned *)&Y, 1);
	register fix_unsigned* d_ptr = dest->s + 1;
	for (register int i = (int) (x->len - 1); --i >= 0; ) *d_ptr++ = ~0;
	BnnAdd(dest->s, (int) x->len, (BigNum)x->s, (int) x->len, 0);
	if (x_neg) dest->s[x->len] = ~0;
    } else { // y is non-negative
	BnnAssign(dest->s, (BigNum)x->s, (int) x->len);
	BnnAdd(dest->s, (int) x->len, (fix_unsigned *)&Y, 1, 0);
	if (!x_neg) dest->s[x->len] = 0;
    }
    return *dest->simplify_Int();
}

const Integer& operator-(const Integer &X, const Integer& Y)
{
    // Perhaps not the most clever or optimal algorithm...
    const Integer& Yneg = -Y;
    const Integer& sum = X + Yneg;
    ((Integer*)&Yneg)->do_delete();
    return sum;
}

const Numeric * Integer::addInteger(const Integer& arg) const
{
    return &(arg + *this);
}
const Numeric * Integer::subInteger(const Integer& arg) const
{
    return &(arg - *this);
}

const Integer& operator*(const Integer &X, const Integer& Y)
{
    int x_neg = X.is_negative();
    int y_neg = Y.is_negative();
    const Integer* x = &(x_neg ? -X : X);
    const Integer* y = &(y_neg ? -Y : Y);
    const fix_unsigned *m = x->U;
    const fix_unsigned *n = y->U;
    int ml = (int) BnnNumDigits((BigNum)m, x->big_len());
    int nl = (int) BnnNumDigits((BigNum)n, y->big_len());
    if (nl > ml) { // swap m and n
	const fix_unsigned *t = m; m = n; n = t;
	int tl = ml; ml = nl; nl = tl;
    }
    int d_len = ml+nl+1;
    Integer* dest = NewInteger(d_len);
    BnnSetToZero(dest->U, d_len);
    BnnMultiply(dest->U, d_len, (fix_unsigned *) m, ml, (fix_unsigned*)n, nl);
    if (x_neg) ((Integer*)x)->do_delete();
    if (y_neg) ((Integer*)y)->do_delete();
    if (x_neg != y_neg) {
	const Integer& negated = -(*dest);
	dest->do_delete();
	return negated;
    }
    return *dest->simplify_Int();
}

const Numeric * Integer::mulInteger(const Integer& arg) const
{
    return &(arg * *this);
}

const Numeric * Integer::divInteger(const Integer& x)  const
{
    return NewDouble (x.as_double() / as_double() );
    // Used to be:
    //   return MakeRational(x, *this);
}

#define Bool0(X,Y) 0
#define Bool1(X,Y) X & Y
#define Bool2(X,Y) X & ~Y
#define Bool3(X,Y) X
#define Bool4(X,Y) ~X & Y
#define Bool5(X,Y) Y
#define Bool6(X,Y) X^Y
#define Bool7(X,Y) X|Y
#define Bool8(X,Y) ~(X|Y)
#define Bool9(X,Y) ~(X^Y)
#define Bool10(X,Y) ~Y
#define Bool11(X,Y) X|~Y
#define Bool12(X,Y) ~X
#define Bool13(X,Y) ~X|Y
#define Bool14(X,Y) ~(X&Y)
#define Bool15(X,Y) ~0

static char swap_ops[16] = {
    // swap_ops[op](x,y) == op(y,x)
    // Same as swaping two middle bits of op-code
    0, 1, 4, 5,
    2, 3, 6, 7,
    8, 9,12,13,
   10,11,14,15};

const Integer& Integer::boolean(const Integer& arg, int op) const
{
    switch (op) {
      case 0: return *Zero;
      case 3: return arg;
      case 5: return *this;
      case 15: return *MinusOne;
    }
    const Integer *x, *y;
    if (len > arg.len) x = this, y = &arg;
    else x = &arg, y = this, op = swap_ops[op];
    // x is longer than y.
    register const fix_unsigned *x_ptr = x->s, *y_ptr = y->s;
    Integer *dest = NewInteger((int) (x->len));
    register fix_unsigned* d_ptr = dest->s;
    register int i = (int) y->len;
    int y_neg = i > 0 && y->s[i-1] < 0;
    switch (op) {
      case 0:
	while (--i >= 0) *d_ptr++ = 0;
	goto clear_rest;
      case 1:
	while (--i >= 0) *d_ptr++ = *x_ptr++ & *y_ptr++;
	if (y_neg) goto copy_rest; else goto clear_rest;
      case 2:
	while (--i >= 0) *d_ptr++ = *x_ptr++ & ~ *y_ptr++;
	if (y_neg) goto clear_rest; else goto copy_rest;
      case 3:
	while (--i >= 0) *d_ptr++ = *y_ptr++;
	if (y_neg) goto set_rest; else goto clear_rest;
      case 4:
	while (--i >= 0) *d_ptr++ = ~ *x_ptr++ & *y_ptr++;
	if (y_neg) goto invert_rest; else goto clear_rest;
      case 5:
	while (--i >= 0) *d_ptr++ = *x_ptr++;
	goto copy_rest;
      case 6:
	while (--i >= 0) *d_ptr++ = *x_ptr++ ^ *y_ptr++;
	if (y_neg) goto invert_rest; else goto copy_rest;
      case 7:
	while (--i >= 0) *d_ptr++ = *x_ptr++ | *y_ptr++;
	if (y_neg) goto set_rest; else goto copy_rest;
      case 8:
	while (--i >= 0) *d_ptr++ = ~ (*x_ptr++ | *y_ptr++);
	if (y_neg) goto clear_rest; else goto invert_rest;
      case 9:
	while (--i >= 0) *d_ptr++ = ~ (*x_ptr++ ^ *y_ptr++);
	if (y_neg) goto copy_rest; else goto invert_rest;
      case 10:
	while (--i >= 0) *d_ptr++ = ~ *y_ptr++;
	if (y_neg) goto clear_rest; else goto set_rest;
      case 11:
	while (--i >= 0) *d_ptr++ = *x_ptr++ | ~ *y_ptr++;
	if (y_neg) goto copy_rest; else goto set_rest;
      case 12:
	while (--i >= 0) *d_ptr++ = ~ *x_ptr++;
	goto invert_rest;
      case 13:
	while (--i >= 0) *d_ptr++ = ~ *x_ptr++ | *y_ptr++;
	if (y_neg) goto set_rest; else goto invert_rest;
      case 14:
	while (--i >= 0) *d_ptr++ = ~ (*x_ptr++ & *y_ptr++);
	if (y_neg) goto invert_rest; else goto set_rest;
      case 15:
	while (--i >= 0) *d_ptr++ = ~0;
	goto set_rest;
    }

  clear_rest:
    for (i = (int) (x->len - y->len); --i >= 0; ) *d_ptr++ = 0;
    goto done;
  set_rest:
    for (i = (int) (x->len - y->len); --i >= 0; ) *d_ptr++ = ~0;
    goto done;
  copy_rest:
    for (i = (int) (x->len - y->len); --i >= 0; ) *d_ptr++ = *x_ptr++;
    goto done;
  invert_rest:
    for (i = (int) (x->len - y->len); --i >= 0; ) *d_ptr++ = ~*x_ptr++;
    goto done;

  done:
    return *dest->simplify_Int();
}

const Integer * Integer::simplify_Int()
{
    int new_len = BigDigitsNeeded(U, (int) len);
    if (new_len > 1)
	if (new_len < len) {
#if 1
	    Integer *new_int = (Integer*)
		realloc((void*)this,
			sizeof(Integer) + (new_len-1)*sizeof(fix_int));
	    new_int->len = new_len;
	    return (const Integer*)new_int;
#else
	    const Integer *new_int = NewInteger(new_len, U);
	    do_delete();
	    return this;
#endif
	}
	else
	    return (const Integer*)this;
    fix_int i = S[0];
    // *************
    // register long j = i - LeastSmallInt;
    // if ((unsigned long)j < CountSmallInt) {
    //	do_delete();
    // return &SmallIntTable[j];
    // }
    // if (len > 1) {
    // do_delete();
    // return new FixInt(i);
    // }
    // **************
    const Integer *temp = MakeFixInt(i);
    do_delete();
    return(temp);
}

const Integer *ConvertInteger(const Root *num)
{
    const Numeric *n = num->numeric();
    if (n != NULL) return n->integer();
    return NULL;
}

// The remaining routines and definitions are taken (and modified) from c/bz.c 
// in the DEC/PRL BigNum package.
/* Copyright     Digital Equipment Corporation & INRIA     1988, 1989 */
/* Modified for C++ by Per Bothner, Spetember 1990. */

/* constants used by BzToString() and BzFromString() */
#define M_LN2	                0.69314718055994530942
#define M_LN10	                2.30258509299404568402
static double BzLog [] = 
{
    0, 
    0, 			/* log (1) */
    M_LN2,  		/* log (2) */
    1.098612, 		/* log (3) */
    1.386294, 		/* log (4) */
    1.609438, 		/* log (5) */
    1.791759, 		/* log (6) */
    1.945910, 		/* log (7) */
    2.079442, 		/* log (8) */
    2.197225, 		/* log (9) */
    M_LN10, 		/* log (10) */
    2.397895, 		/* log (11) */
    2.484907, 		/* log (12) */
    2.564949, 		/* log (13) */
    2.639057, 		/* log (14) */
    2.708050, 		/* log (15) */
    2.772588, 		/* log (16) */
};    
#define CTOI(c)			(c >= '0' && c <= '9' ? c - '0' :\
                                 c >= 'a' && c <= 'z' ? c - 'a' + 10:\
                                 c >= 'A' && c <= 'Z' ? c - 'A' + 10:\
                                 0)

// This is extern "C", so it can be called by lex.

const Integer *StrToInt(const char *str, int base, int str_len /* = -1 */)
{
    if (str_len == -1) {
	str_len = strlen(str);
	if (str_len <= 2 * sizeof(fix_int) && base == 10)
	    return MakeFixInt(atoi(str));  // Optimization
    }
    const char *limit = str + str_len;
/*
 * Creates a BigZ whose value is represented by "string" in the
 * specified base.  The "string" may contain leading spaces,
 * followed by an optional sign, followed by a series of digits.
 * Assumes 2 <= base <= 36.
 * When called from C, only the first 2 arguments are passed.
 */

    Integer 	*z, *p, *t;
    int 	zl;
    int neg = 0;

    
    /* Throw away any initial space */
    while (str < limit && *str == ' ') str++;
    if (str >= limit)
	return Zero;
    if (*str == '-')
	neg = 1, str++;
    else if (*str == '+')
	str++;
    while (str < limit && *str == ' ') str++;
    
    /* Allocate BigNums */
    /* Add 1 extra bit for sign bit. -PB */
    zl = (int)((1 + (limit-str) * BzLog[base]) / (BzLog[2]*BN_DIGIT_SIZE)) + 1;

    // The +1 is not in bz.c, but that violates the input
    // constraint on BnnMultipleDigit (which then trashes memory).
    z = NewInteger(zl + 1);
    BnnSetToZero(z->U, zl);
    p = NewInteger(zl + 1);

    if (!z || !p) 
        return (NULL);
    
    /* Multiply in the digits of the string, one at a time */
    for (;  str < limit;  str++)
    {
	BnnSetToZero (p->U, zl);
	BnnSetDigit (p->U, CTOI (*str));
	BnnMultiplyDigit (p->U, zl, z->U, zl, base);  

	/* exchange z and p (to avoid a copy) */
	t = p,  p = z,  z = t;
    }
    
    /* Free temporary BigNums */
    p->do_delete();

    /* Set sign of result */
    if (neg) {
	BnnComplement(z->U, zl);
	z->U[zl] = ~0;
	BnnAddCarry(z->U, (int) z->len, 1);
    }
    else
	z->U[zl] = 0;
    return z->simplify_Int();
}

/* Modified from BzToString() */

char * BigToString (const Integer* z, int base)

/*
 * Returns a pointer to a string that represents Z in the specified base.
 * Assumes 2 <= base <= 16.
 */

{
    char *	string;
    Integer 	*y, *q, *t;
    fix_unsigned r;

    static char Digit[] = "0123456789ABCDEF";
    char *	s;
    int 	sd, zl, sl;


    if (base < 2 || base > 16)
        return (NULL);

    /* Allocate BigNums and set up string */
    zl = (int) BnnNumDigits((BigNum)z->U, (int) z->len) + 1;
    sl = (int)(BzLog[2] * BN_DIGIT_SIZE * zl / BzLog[base] + 3);

    y = NewInteger(zl); y->U[zl-1] = 0;
    q = NewInteger(zl); q->U[zl-1] = 0;

    string = new char[sl];

    if (!y || !q || !string)
        return (NULL);

    BnnAssign (y->U, (BigNum)z->U, zl-1);
    s = string + sl;

    /* Divide Z by base repeatedly; successive digits given by remainders */
    *--s = '\0';
    if (z == Zero)
        *--s = '0';
    else
    do
    {
	r = BnnDivideDigit (q->U, y->U, zl, base);
	*--s = Digit[r];

	/* exchange y and q (to avoid BzMove (y, q) */
	t = q,  q = y,  y = t;
    } while (!BnnIsZero ((BigNum)y->U, zl));
    
    /* Set sign if negative */
    if (z->is_negative())
        *--s = '-';

    /* and move string into position */
    if ((sd = s-string) > 0) 
        while (s < string + sl)
	{
	    *(s-sd) = *s;
	    s++;
	}

    /* Free temporary BigNums and return the string */
    y->do_delete();
    q->do_delete();

    return string;
}
#endif /* Erase 2 */


