/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "rules.h"
#include "builtin-rel.h"
#include "hash.h"
#include <stdio.h>
#include <stdlib.h>
#include "externs.h"
#include "globals.h"
#include "ordsearch.h"
#include "interp.h"
#include "annotations.h"

// temporary hack to avoid changing generic-index.h
// also see persistent-index.C ::PRAVEEN
#define COR_I_PARTIAL_SUCCESS  2

static RelCount = 0;

#define MAX_STORED_TUPLEITS 1024
int C_tupleiterConstructs = 0;
int C_tupleiterDestructs = 0;

int C_cont_id = 1;  /* Used for ReturnUnification */

extern DatabaseStruct BuiltinDB ;

extern int subsumes_arg_lists(ArgList& left, ArgList& right,
    BindEnv *left_bindings, BindEnv *right_bindings);
extern int subsumes(BindEnv* env1, ArgList& arg2, BindEnv* env2);
extern int subsumes_value(AggregateKind aggkind, Arg *arg1, Arg *arg2,
			BindEnv *env1, BindEnv *env2);
extern ArgList *vararglist(int n);
extern char *simplify_index(ArgList *pat, int n_var, ArgList *boundvars);
extern StorageRelation * AllocateRelation(Name name, int arity, int);

extern update_grouping(Relation *, Tuple *, ArgList *, BindEnv *);

extern int is_magic(Name name);
extern int is_mp_done(Name name);
extern is_supp(Name name);

extern void reclaim_index(GenericIndex *index, RelationKind r_kind);

/**************************************************************************/
/** Tarun **/
void group_dump(BindEnv * new_env, ArgList * new_arglist,
                        Relation *rel, char *old_arglist = NULL)
{
  if (T_Stack.count <= 0 || T_Stack.top() == NULL)
    return;
  
  Table * F = T_Stack.top();
  
  RuleInfo * rInfo =  F->moduledata->curr_rInfo;
  
  FILE *fd = F->moduledata->module_info.file_desc;
  if (!fd) {
    fprintf(exEnv.error_file, "Error:: Explain: Cannot create dump file.\n");
    return;
  }
  
  for (int j=0; j <= rInfo->num_literals; j++)
    {
      if (j==rInfo->num_literals)
	{
	  /* First Argument */
	  fprintf(fd, "def_%s(",
		  SymbolString(F->moduledata->export_pred->name));
	  rInfo->rule->head->predicate->name->print(new_env, fd);
	  fprintf(fd, "(");
	  ((ArgList *)new_arglist)->
	    print_dump(new_env, fd);
	  
	  fprintf(fd, ")");
	}
      else
	{
	  fprintf(fd, "use_%s(",
		  SymbolString(F->moduledata->export_pred->name));
	  rInfo->rule->preds[j]->predicate->
	    name->print(new_env, fd);
	  fprintf(fd, "(");
	  ((ArgList *)rInfo->arg_list[j])->print_dump(new_env, fd);
	  fprintf(fd, ")");
	}
      
      fprintf(fd, ", [");
      
      rInfo->rule->head->predicate->
	name->print(new_env, fd);
      fprintf(fd, "(");
      ((ArgList *)new_arglist)->
	print_dump(new_env, fd);
      fprintf(fd, ")");
      
      for (int i=0; i < rInfo->num_literals; i++)
	{
	  fprintf(fd, ",");
	  rInfo->rule->preds[i]->predicate->
	    name->print(new_env, fd);
	  fprintf(fd, "(");
	  ((ArgList *)rInfo->arg_list[i])->print_dump(new_env, fd);
	  fprintf(fd, ")");
	}
      if (old_arglist)   {
	fprintf(fd, ", %s_SUBSUMED__", SymbolString(rel->name));
	fprintf(fd, "(");
	fprintf(fd, "%s", old_arglist);
	fprintf(fd, ")");
      }
      
      fprintf(fd, "]).\n");
    }
  fflush(fd);
}

/**************************************************************************/

ArgList NullArgs = {0};

/***************************************************************************/

TupleIterator::TupleIterator(Relation *rel, Tuple *tuple, 
	 RMark *start /*= NULL*/, RMark *end /*= NULL*/)
	 : arg_list(tuple->args()), temp_arglist(tuple->args())
{
 //if (relation = rel) relation->scan_count++;
 relation = rel;
 bindenv = tuple->make_bindenv_version();
 start_mark = start;
 end_mark = end;
 indexnump = NULL;
 reset();
}

TupleIterator::TupleIterator(Relation *rel, ArgList& args, BindEnv* env,
    RMark *start /*=NULL*/, RMark *end /*= NULL*/, int *tryindexp /*=NULL*/)
    : arg_list(args), temp_arglist(args)
{
 //if (relation = rel) relation->scan_count++;
 relation = rel;
 bindenv = env ;
 start_mark = start;
 end_mark = end;
 indexnump = tryindexp;
 reset();
}


TupleIterator::TupleIterator(Relation *rel, Arg** args, BindEnv* env,
    RMark *start /*= NULL*/, RMark *end /*= NULL*/, int *tryindexp /*=NULL*/ )
    : arg_list(*(ArgList*)args), temp_arglist(*(ArgList*)args)
{
 //if (relation = rel) relation->scan_count++;
 relation = rel;
 bindenv = env ;
 start_mark = start;
 end_mark = end;
 indexnump = tryindexp;
 reset();
}

TupleIterator::~TupleIterator()
{
 this->release();
 //if (relation)
   //relation->release(*this);
 // if (tuple_env) 		// Check if code is safe and reinsert it
 // delete tuple_env;
}

BindEnv *TupleIterator::get_next()
{
  BindEnv *temp = relation->get_next(*this);
  while (_no_match && state) {
    _no_match = 0;
    (*state->solver)(state->md, state->magic, 0, this);
    temp = relation->get_next(*this);
  }
  return temp;
}

/***************************************************************************/

extern int is_magic(Name) ;
extern int is_supp(Name) ;
extern int is_mp_done(Name) ;

RelationKind find_r_kind(Name name)
{
 if (is_magic(name)) return COR_R_MAGIC;
 else if (is_supp(name)) return COR_R_SUPPLEMENTARY;
 else return COR_R_ANSWER;
}

int Relation::isConstant() { return 1; }

Relation::Relation() 
{
  char namep[100];
  sprintf(namep,"Rel_%d", RelCount++);
  name = EnterSymbol(namep);
  _arity = 0;
  _kindof = COR_RELATION;

  local_options = 0;
  count = 0;
  scan_count = 0;
  ref_count = 1 ;
  single_success = 0;
  has_release = 1;

  check_subsum = exEnv.C_check_subsum_default;

  r_kind = COR_R_ANSWER;  // default

  delta_indexed = exEnv.C_index_deltas_default ;
}

Relation::Relation(int new_arity, int delta)
{
  char namep[100];
  sprintf(namep,"Rel_%d", RelCount++);
  name = EnterSymbol(namep);
  _arity = new_arity;
  _kindof = COR_RELATION;

  local_options = 0;
  count = 0;
  scan_count = 0;
  ref_count = 1 ;
  single_success = 0;
  check_subsum = exEnv.C_check_subsum_default;
  has_release = 1;

  r_kind = COR_R_ANSWER;  // default

  if (delta == -1)
    delta_indexed = exEnv.C_index_deltas_default ;
  else delta_indexed = delta;


  agg_sel_info = NULL;
  priority_info = NULL;

  _hash = UnknownHashValue;
  _eq_id = UnknownHashValue;

  ordsearch = 0;
  for_ordsearch = NULL;
  mp_done_reln = NULL;

}

StorageRelation::StorageRelation() 
  :  Relation(), TupleList(), headMark()
{
  char namep[100];
  sprintf(namep,"Rel_%d", RelCount++);
  name = EnterSymbol(namep);
  _arity = 0;

  local_options = 0;
  count = 0;
  scan_count = 0;
  ref_count = 1 ;
  single_success = 0;

  check_subsum = exEnv.C_check_subsum_default;

  for_supp_index = NULL;

  r_kind = COR_R_ANSWER;  // default

  delta_indexed = exEnv.C_index_deltas_default ;
  delta_relations = NULL;
  free_reln_list  = NULL;

  // initialize circular list of marks
  headMark.next = &headMark;
  headMark.prev = &headMark;

  free_marks = NULL;  /* to allow reuse of marks*/

}

StorageRelation::StorageRelation(int new_arity, int delta) 
  :  Relation(new_arity, delta), TupleList(), headMark()
{
  char namep[100];
  sprintf(namep,"Rel_%d", RelCount++);
  name = EnterSymbol(namep);
  _arity = new_arity;

  local_options = 0;
  count = 0;
  scan_count = 0;
  ref_count = 1 ;
  single_success = 0;
  check_subsum = exEnv.C_check_subsum_default;
  agg_sel_info = NULL;
  priority_info = NULL;

  _hash = UnknownHashValue;
  _eq_id = UnknownHashValue;

  for_supp_index = NULL;

  ordsearch = 0;
  for_ordsearch = NULL;
  mp_done_reln = NULL;

  if (delta == -1)
    delta_indexed = exEnv.C_index_deltas_default ;
  else delta_indexed = delta;
  delta_relations = NULL;
  free_reln_list  = NULL;

  // initialize circular list of marks
  headMark.next = &headMark;
  headMark.prev = &headMark;

  free_marks = NULL;  /* to allow reuse of marks*/

}

void Relation::print(BindEnv* env, FILE *file, char *) const
{
  this->print(env, file);
}

void Relation::print(BindEnv*, FILE *file) const
{
    fprintf(file, "{");
    printon(file);
    fprintf(file, "}");
}

void Relation::sprint(char* str, int* pos, BindEnv *env) const
{
    sprintf(str + *pos, "{");
    (*pos)++ ;

    StackMark stack_mark0;
    ArrayBindEnv env0(arity());
    ArgList *args = vararglist(arity());
    TupleIterator iter((Relation*)this, *args, &env0);
    StackMark stack_mark1;
    Term term1;

    BindEnv *env1 = iter.get_next();
    if (!(iter.no_match())) {
     for (int iarg = 0; iarg < arity(); iarg++) {
             if (iarg > 0) { sprintf(str+ *pos, ", ");(*pos) += 2;}
             term1 = env1->lookup(iarg);
             if (term1.expr) term1.expr->sprint(str, pos, env); 
     }
     for (;;) {
        BindEnv *env1 = iter.get_next();
        if (iter.no_match()) break;
        sprintf(str + *pos, ",");
        (*pos)++ ;
        for (int iarg = 0; iarg < arity(); iarg++) {
             if (iarg > 0) { sprintf(str+ *pos, ", ");(*pos) += 2;}
             term1 = env1->lookup(iarg);
             if (term1.expr) term1.expr->sprint(str, pos, env); 
        }
        stack_mark1.pop_to();
     }
    }
    stack_mark0.pop_to();
    delete args;

    sprintf(str + *pos, "}");
    (*pos)++ ;
}

void Relation::print_name( FILE *outf)
{
  fprintf(outf, "%15s/%d\t : (generic)\n", SymbolString(name), arity()) ;
}


int StorageRelation::insert_tuple(Tuple *tuple)
{
  count++;
  insert_raw(tuple);

  return 1;
}


int StorageRelation::insert_raw(Tuple *)
{
    CORAL_error(COR_BAD_TUPLE_INSERT,name->string(),"insert_raw");
    return -1;
}


/*------------------------------------------------------------------
 *::release(TupleIterator &iterator)
  
  Called when the tupleiterator is no longer needed, and the state
  stored in the tuple iterator can be released.  The get_next / get_next_tuple
  functions store data in the tuple iterator, so that the data is saved
  across calls to get_next / get_next_tuple.  When the external routine is
  done with getting new answers, it calls tuple_iterator.release(), 
  which in turn calls reln::release(tuple_iterator).  

  Oddities/Quirks ::   
	WARNING:: release may get called more than once with the 
	same tuple_iterator.  Care should be taken to avoid deleting space
  	more than once.  This is typically done by resetting pointed fields 
	to NULL after deletion.
-------------------------------------------------------------------*/

/**
 ** for now, lets assume that any delta relation that are indexed are 
 ** hashsimplerelations
 **/
RMark * StorageRelation::getMark()
{
  RMark *mark;
  if (!delta_indexed) {
    if (free_marks) {
      mark = free_marks;
      free_marks = free_marks->next;
      mark->init(lastptr);
    }
    else mark = new RMark(lastptr);
  }
  else {
    HashSimpleRelation *newreln;
    int create_relation = 1;
    
    if (!delta_relations) {
      delta_relations = new RelationList();
      
    }
    else { /******
	     // NOTE: Restore this after adding counts to all relations.
	     if (delta_relations->reln_lastptr && 
	     delta_relations->reln_lastptr->reln->count == 0) 
	     then { // there's no need to create a new reln. 
	     // Just do mark->init(delta_relations->reln_lastptr);
             create_relation = 0;
	     }
	     ****/
    }
    
    if( create_relation) {
      if (!free_reln_list) {
	newreln = new HashSimpleRelation(arity(), delta_indexed,
					 exEnv.C_delta_buckets_default);
	
	newreln->name = name;	// NOTE: This is to circumvent 
	  // a problem with the hashing code, which uses the
	  // relation name unnecessarily.
	add_all_indices(newreln);
						
	delta_relations->append_relation(newreln);
      }
      else { /* Reuse relation in list; */
	RelationLink *new_reln_link = free_reln_list;
	free_reln_list =  free_reln_list->next;
	new_reln_link->next = NULL;
	delta_relations->append(new_reln_link);
	
      }
    }
    if (free_marks) {
      mark = free_marks;
      free_marks = free_marks->next;
      mark->init(delta_relations->reln_lastptr);
    }
    else mark = new RMark(delta_relations->reln_lastptr);
  }

  // Link it in
  mark->next = &headMark;
  mark->prev = headMark.prev;
  headMark.prev->next = mark;
  headMark.prev = mark;
  return mark;
}

void StorageRelation::freeMark(RMark *mark, int)
{
    if (mark == NULL) return;
    delete mark;
}

void StorageRelation::free_allMarks()
{
    fprintf(exEnv.trace_file, "Relation::free_allMarks() should not be called.\n");
}

// to be used internally, not by user
int StorageRelation::add_index(BitVector *bv)
{
  GenericIndexSet *index_set;
  GenericIndex *h;
  int ret_val;

  if ((index_set = get_index_set()) == NULL) {
    fprintf(exEnv.error_file,
	    "StorageRelation::add_index found NULL index_set\n");
    return COR_I_FAIL;
   }
  if ((h  = create_index_object(bv)) == NULL) {
    fprintf(exEnv.error_file,
	    "StorageRelation::add_index unable to create index object\n");
    return COR_I_FAIL;
   }

  if ((ret_val = index_set->insert_index(h)) == COR_I_FAIL) {
    // temporary hack : need to add reclaim_index_object method !!
    //fprintf(exEnv.error_file,
    //	    "StorageRelation::add_index unable to insert index\n");
    reclaim_index(h, r_kind);
    return COR_I_FAIL;
   }
  else if (ret_val == COR_I_PARTIAL_SUCCESS) {
    return COR_I_PARTIAL_SUCCESS;
   }

  index_set->fill_index(h);

  // add the same index to the relation pointed to by for_supp_index
  if (for_supp_index != NULL) {
    for_supp_index->add_index(bv);
  }
  
  // add the same index to each of the delta_indexed relations
  if (delta_indexed && delta_relations) {
    for (RelationLink *tmp=delta_relations->reln_chain; tmp != NULL; 
	 tmp=tmp->next) {
      tmp->reln->add_index(bv);    
    }
  }
  return COR_I_SUCCESS;
}


int StorageRelation::add_index(char *adorn)
{
    ASSERT(adorn != NULL);

    // MEMORY LEAK : Praveen
    BitVector* bv = new BitVector(arity());

    char *adorn1 = adorn;

    for(int i = 0; i < arity(); i++, adorn++) {
	if(*adorn == 0) {
	    fprintf(exEnv.error_file,
		    "StorageRelation::add_index adorn too short: \n");
	    fprintf(exEnv.error_file, "    --- arity of %s=%d, adorn len=%d)\n", 
			name->string(), arity(), i); 
	    return(COR_I_FAIL);
	}
	if (*adorn == 'b' || *adorn == '1')
		bv->set(i);
    }
    if (*adorn != 0) {
	fprintf(exEnv.error_file,"StorageRelation::add_index adorn too long\n");
	fprintf(exEnv.error_file, "    --- arity of %s=%d, adorn len=%d adorn = %s)\n",
		name->string(), arity(), i, adorn1); 
	return(COR_I_FAIL);
    }

    return (this->add_index(bv));
}

int StorageRelation::add_index(ArgList *args)
{
    ASSERT(args->count() != 0);
    if (args->count() > 1) {
        fprintf(exEnv.error_file, "More than one argument to add_index ");
	fprintf(exEnv.error_file, "-- using first one to build index.\n");
    }
    ASSERT((*args)[0]->kindof() == COR_SYMBOL_CONST);
    char *arg_str = ((Symbol *) ((*args)[0]))->string();

    return add_index(arg_str);
}

int StorageRelation::add_index(ArgList *pat, int n_var, ArgList *v_nm)
{
  char *argindex = simplify_index(pat, n_var, v_nm);
  if (argindex) 
    return add_index(argindex);

  GenericIndexSet *index_set;
  GenericIndex *h;

  if ((h  = create_index_object(pat, n_var, v_nm)) == NULL) return COR_I_FAIL;

  if ((index_set = get_index_set()) == NULL) return COR_I_FAIL;
  if (index_set->insert_index(h) == COR_I_FAIL) return COR_I_FAIL;

  index_set->fill_index(h);
    
  // add the same index to the relation pointed to by for_supp_index
  if (for_supp_index != NULL) {
    for_supp_index->add_index(pat, n_var,v_nm);
  }
  
  // add the same index to each of the delta_indexed relations
  if (delta_indexed && delta_relations) {
    for (RelationLink *tmp=delta_relations->reln_chain; tmp != NULL; 
	 tmp=tmp->next) {
      tmp->reln->add_index(pat, n_var, v_nm);
    }
  }
  return COR_I_SUCCESS;
}

int Relation::add_hidden_relation(PrioritizeInfo *) 
{
    fprintf(exEnv.trace_file,
      "System error: add_hidden_relation not implemented for some %s\n",
      "relation types\n");
    return(0);
}

int Relation::pop_from_hidden_relation() 
{
    fprintf(exEnv.trace_file,
      "System error: pop_from_hidden_relation not implemented for some %s\n",
      "relation types\n");
    return(0);
}

int Relation::pop_all_from_hidden_relation() 
{
    fprintf(exEnv.trace_file,
     "System error: pop_all_from_hidden_relation not implemented for some %s\n",
     "relation types\n");
    return(0);
}

int Relation::insert_in_hidden_relation(Tuple *) 
{
    fprintf(exEnv.trace_file,
      "System error: insert_in_hidden_relation not implemented for some %s\n",
      "relation types\n");
    return(0);
}


/*------------------------------------------------------------------
 *:: add_all_indices(Relation *reln)
 
    Called to add all the indices in one relation on to another (usually
    on to a newly created delta relation. 

 -----------------------------------------------------------------*/
int StorageRelation::add_all_indices(StorageRelation *reln)
{
  GenericIndexSet *index_set;
  if (index_set = this->get_index_set())
    return index_set->add_all_indices(reln);
  else
    return 0;
}

/*------------------------------------------------------------------
 *:: add_all_tuples(Relation *reln, int marks_into_account, int check_dupl)
 
    Called to add all the tuples in (this) into reln.

 -----------------------------------------------------------------*/
int StorageRelation::add_all_tuples(StorageRelation *reln, int marks_into_account,
				       int check_dupl, int hide_em)
{
  GenericIndexSet *index_set;
  
  if (index_set = this->get_index_set())
    return index_set->add_all_tuples(reln, marks_into_account,
				     check_dupl, hide_em);
  else return (0);
}

/*------------------------------------------------------------------
 *:: add_all_goals(Relation *reln, Context *context, Relation *owner_rel)
 
    Called to convert all tuples in (this) into goal nodes and
    add them to reln and context.  For OrdSearch
 -----------------------------------------------------------------*/
extern class Context;

int StorageRelation::add_all_goals(StorageRelation *reln, Context *context,
					StorageRelation *owner_rel)
{
  GenericIndexSet *index_set;
  
  if (index_set = this->get_index_set())
    return index_set->add_all_goals(reln, context, owner_rel);
  else return (0);
}

int has_grouping_args(ArgList &args) 
{
    int i ;

    for(i=0;i<args.count();i++)
	if(args[i]->kindof()==COR_GROUPING)
		return 1;
    return 0;
}

/****************** Aggregate selection info ***************/

// checks the relation to see if the anno has already been specified
// temporary kludge !! - PRAVEEN
static int duplicate_agg_sel_anno(StorageRelation *rel, AggSelInfo *newinfo)
{
  AggSelInfo *aggsel;
     
  for(aggsel=rel->agg_sel_info; aggsel; aggsel=aggsel->next) {
    if ((newinfo->agg_kind == aggsel->agg_kind) &&
	(newinfo->agg_value == aggsel->agg_value) &&
	(newinfo->var_count == aggsel->var_count))
      return 1;
  }
  return 0;
}

void StorageRelation::add_agg_sel_info(AggSelInfo *newinfo) 
{
  /* first check that this aggsel has not already been specified */
  if (duplicate_agg_sel_anno(this, newinfo)) return;

  newinfo->next = agg_sel_info;
  agg_sel_info = newinfo;
}

extern void annotation_error(PredAnnotations *anno, char *string);


void StorageRelation::add_agg_sel_anno(PredAnnotations *anno) 
{

/*
    AggSelInfo *newinfo = new AggSelInfo;
    ArgList *arglist = newinfo->arglist = anno->arglist1;
*/

    if (anno->op_arg->kindof() != COR_FUNCTOR) {
      annotation_error(anno, "Bad aggregation type");
      return;
    }
    FuncArg *fop_arg = (FuncArg*) anno->op_arg;

    if (fop_arg->arity() != 1 && fop_arg->functor() != AnyOpSymbol) {
      annotation_error(anno,
               "Bad number of arguments for aggregate selection");
      return;
    }

    for (int opargnum=0; opargnum < fop_arg->arity(); opargnum++) {
      AggSelInfo *newinfo = new AggSelInfo;
      if (fop_arg->functor() == MaxOpSymbol)
          newinfo->agg_kind = MaxAggregation;
      else if (fop_arg->functor() == MinOpSymbol)
        newinfo->agg_kind = MinAggregation;
      else if (fop_arg->functor() == AnyOpSymbol)
          newinfo->agg_kind = AnyAggregation;
      else { // possibly extend to irrelevant fact annotation
          annotation_error(anno, "Only min, max and any aggregation handled");
        return;
      }

      ArgList *arglist = newinfo->arglist = anno->arglist1;
      newinfo->next = NULL;
      newinfo->indexnum = -1;

      newinfo->agg_value = fop_arg->args[opargnum];
      if (newinfo->agg_value->kindof() != COR_VARIABLE) {
	annotation_error(anno, "Aggregated argument should be a variable");
	return;
      }
      newinfo->var_count = arglist->max_vars();

      ArgList* copy_args = ArgList::New(arglist->arity());
      VarLink *groupby_vars = anno->arglist2->var_list(NULL);

      BitVector* groupargs = new BitVector(arglist->arity());
      groupargs->clear();

      for (int i=0; i < arglist->arity(); i++) {
	if ( (*arglist)[i]->kindof() != COR_VARIABLE ) {
	  annotation_error(anno, "Arglist should contain only variables");
	  return;
	}
	VarArg *oldvar = (VarArg *)(*arglist)[i];
	/* Search for var in anno->arglist2 */
	if (groupby_vars->contains(oldvar) ) {
	  (*copy_args)[i] = oldvar;
	  groupargs->set(i);
	}
	else
	  (*copy_args)[i] = make_var( newinfo->var_count++ );
	if ( oldvar->var == ((VarArg *)(newinfo->agg_value))->var )
	  newinfo->gb_agg_value = (*copy_args)[i];
      }

      newinfo->groupbylist = copy_args;
      newinfo->bindenv = new ArrayBindEnv(newinfo->var_count);

      /****** Add the aggregate selection, and create an index too *****/
      // WARNING: Better to move the index generation into the rewriting phase,
      // so that it is visible.

      add_agg_sel_info(newinfo);
      add_index(groupargs);
    }
}

/*************************************************************/
/********* prioritize annotation *********/


void Relation::add_prioritize_info(PredAnnotations *anno) 
{
    PrioritizeInfo *newinfo = new PrioritizeInfo();


    newinfo->next = NULL;

    if (anno->op_arg->kindof() != COR_FUNCTOR || 
		( ((FuncArg*)(anno->op_arg))->arity() != 1) ) {
	annotation_error(anno, "Bad aggregation type");
	return;
    }
    FuncArg *fop_arg = (FuncArg*) anno->op_arg;

    if (fop_arg->functor() == MaxOpSymbol)
        newinfo->order = 1;
    else if (fop_arg->functor() == MinOpSymbol)
	newinfo->order = -1;
    else { // possibly extend to irrelevant fact annotation
	annotation_error(anno, 
		     "Prioritize: bad ordering - only min and max allowed ");

	return;
    }

    if (fop_arg->args[0]->kindof() != COR_VARIABLE) {
      annotation_error(anno, "Prioritize argument should be a variable");
      return;
    }

    VarArg *order_var = (VarArg *) fop_arg->args[0];

    newinfo->argnum = -1;

    for (int i=0; i < anno->arglist1->arity(); i++) {
      if ( (*anno->arglist1)[i]->kindof() != COR_VARIABLE ) {
	annotation_error(anno, 
		 "Arglist of prioritize should contain only variables");
	return;
      }
      VarArg *listvar = (VarArg *)(*anno->arglist1)[i];
      if (listvar->var == order_var->var) {
	if (newinfo->argnum == -1)
	  newinfo->argnum = i;
	else annotation_error(anno,
	    "Prioritize: repeated ordering variable in argument list");
      }
    }
    newinfo->next = priority_info;
    priority_info = newinfo;
    add_hidden_relation(newinfo);
}

extern ArrayBindEnv UnusedEnv;

/***********************************/

// insert_new:  returns 1 if a tuple was inserted into the end of a relation.
// 		In the case of aggregation this function calls 
//		    insert_grouping, and the convention  is more complicated - 
//			a) returns 1 if the new tuple is inserted
//			b) returns 0 in the case that an existing tuple was
//				modified, but new tuple not inserted.
//
/******************/

int StorageRelation::insert(Tuple *tuple) {

#ifdef DO_TRACE
    if (DISPLAY_INSERTIONS) {
       fprintf(exEnv.trace_file, "[Inserting %s(", SymbolString(name));
       tuple->args().print(tuple->bindenv, exEnv.trace_file);
       fprintf(exEnv.trace_file, ")");
    }
#endif

    if( tuple->arity() != arity() ) {
	fprintf(exEnv.trace_file,
	     "Relation::insert - attempt to insert tuple of arity %d \n",
	  	tuple->arity());
	fprintf(exEnv.trace_file, "	             - in relation %s of arity %d \n",
	  	name->string(), arity() );
	return 0;
    }
	
    if (has_grouping_args(tuple->args())) 
	return insert_grouping(tuple->args(),tuple->bindenv);

    if( tuple->bindenv == NULL ) {
	tuple->env_size = tuple->args().max_vars();
        return insert_tuple(tuple);
    }
    else {
    	ArgList *copy_args = ArgList::New(arity());
    	/** CopyArgs also renames variables so that they are distinct,
		and the bindenv need not be used to distinguish variables.  **/
    	int env_size = CopyArgs(copy_args->first(), tuple->args().first(),
			    	tuple->bindenv, tuple->arity(), &UnusedEnv);

#ifdef DO_TRACE
    if (DISPLAY_INSERTIONS | DISPLAY_NEW_INSERTIONS) {
	if ( ! DISPLAY_INSERTIONS) {
	    fprintf(exEnv.trace_file, "[Inserting %s(", SymbolString(name));
	            copy_args->print(NULL, exEnv.trace_file);
	    fprintf(exEnv.trace_file, ")");
	}
	if (env_size == 0)
	    fprintf(exEnv.trace_file, " - done (ground)]\n");
	else
	    fprintf(exEnv.trace_file, " - done (env-size:%d)]\n", env_size);
    }
#endif
    Tuple *tuple1 = new Tuple(copy_args);
    tuple1->env_size = env_size;
    //count++;
    insert_tuple(tuple1);
    return 1;
    }
}


/*------------------------------------------------------------------

int Relation::insert_new(ArgList& args, BindEnv* env, BindEnv *dont_rename_env,
	Tuple *parent_goal, int dont_rename)

    Inserts a tuple into the relation.
    Checks for subsumption depending on this->check_subsum.

    If dont_rename is set, it does not perform renaming,
    else it renames (args, env);  variables in dont_rename_env
	are not renamed.
    The (renamed) (args,env) is stored in (copy_args, copy_env)

    If OrderedSearch is used, special things are done, and 
    (copy_args, copy_env) (with additional fields) is inserted into context.
    Otherwise (copy_args, copy_env) is inserted into the relation.

  Oddities/Quirks ::

-------------------------------------------------------------------*/

// this dummy tuple structure is used to package an arglist and a bindenv
// that need to be passed to a function that expect a tuple !
static Tuple dummy_tuple;

int StorageRelation::insert_new(ArgList& args, BindEnv* tupenv, 
	BindEnv *dont_rename_env,
	Tuple *parent_goal, int dont_rename)
{		/* Variables in dont_rename_env are not renamed */
  StackMark stack_mark0;
  BindEnv *env;
  
  
  if (exEnv.C_interrupt_raised) return 0;  

#ifdef DO_TRACE
    if (DISPLAY_INSERTIONS) {
	fprintf(exEnv.trace_file, "[Starting to insert %s(", SymbolString(name));
	args.print(tupenv, exEnv.trace_file);
	fprintf(exEnv.trace_file, ")");

    }
#endif
 

    if( args.arity() != arity() ) {
	fprintf(exEnv.trace_file,
	     "Relation::insert_new - attempt to insert tuple of arity %d \n",
	  	args.arity());
	fprintf(exEnv.trace_file, "	             - in relation %s of arity %d \n",
	  	name->string(), arity() );
	return 0;
    }

    if (has_grouping_args(args)) 
	return insert_grouping(args,tupenv,dont_rename_env,
				parent_goal,dont_rename);

    if (tupenv==NULL) {
        int env_size = args.max_vars();
      	if (env_size != 0)
            env = new ArrayBindEnv(args.max_vars());
	// WARNING - this space is never reclaimed.  Make sure insert_new
	//   		is not called with a null bindenv
	else env = NULL;
    }
    else 
      	env = tupenv;

    // first some subsumption checks
    if (check_subsum==1) {
      Tuple *newtuple;

      // If non-ground facts are present, a new tuple needs to be created
      // before performing subsumption checks, otherwise the old tuple
      // itself can be used.
      newtuple = new Tuple(&args, env);

      if (!ordsearch) { 
	// ordinary case
	if (is_subsumed(newtuple)) {
#ifdef DO_TRACE
	  if (DISPLAY_INSERTIONS) {
	    fprintf(exEnv.trace_file, " - subsumed]\n");
	  }
#endif
	  delete newtuple;
	  return 0;
	}
      }
      else { 
	// OrdSearch: these are just preliminary checks
	//            subsumption against Context done later
	  
	if (r_kind == COR_R_MAGIC) {
	  // subsumption checking is first done against the mp_done_reln
	  if (mp_done_reln && mp_done_reln->is_subsumed(newtuple)) {
#ifdef DO_TRACE
	    if (DISPLAY_INSERTIONS) {
	      fprintf(exEnv.trace_file, " - subsumed]\n");
	      fprintf(exEnv.trace_file, "    OrdSearch: using mp_done\n");
	    }
#endif
	    delete newtuple;
	    return 0;
	  }
	}
	else if (r_kind != COR_R_SUPPLEMENTARY) {
	  // don't want any subsumption checking done if 
	  // (ordsearch && (r_kind == COR_R_SUPPLEMENTARY))
	    
	  if (is_subsumed(newtuple)) {
#ifdef DO_TRACE
    	    if (DISPLAY_INSERTIONS) {
	      fprintf(exEnv.trace_file, " - subsumed]\n");
	    }
#endif
	    delete newtuple;
	    return 0;
	  }
        }
      }
      delete newtuple;
    }
	   
    // now add the tuple to the appropriate relation 


    GoalNode *g_node;
    int negated_g_node = 0;
    Table * F;
    struct ClauseName *c_names;

    if (ordsearch && ((r_kind == COR_R_MAGIC) ||
		(r_kind == COR_R_SUPPLEMENTARY)) && 
		T_Stack.count > 0) {
    	F = T_Stack.top();
	if (F && F->moduledata && F->moduledata->curr_rInfo && 
			F->moduledata->curr_rInfo->rule) {
    	    c_names = F->moduledata->curr_rInfo->rule->clause_names;
    	    for (; c_names; c_names = c_names->next) {
	        negated_g_node = c_names->negated;
	        if (negated_g_node) break;
            }
	}
    }

    /** for Ordered Search, the m_p and sup_ facts in Context are maintained as 
	auxiliary relations "for_ordsearch" associated with the regular
	m_p and sup_ relations.  the "for_ordsearch" relation is used as 
	an index into context.
    **/
    if (ordsearch && ((r_kind == COR_R_MAGIC) || 
		(r_kind == COR_R_SUPPLEMENTARY)) && (!for_ordsearch)) {
	for_ordsearch = new HashSimpleRelation(arity());
	// what other indices besides the default indices need to be created?

        // WARNING: if linked relations are to be used, this may have to
	//          be modified
    }

    /**** divesh: added stuff for optimizing insertion of facts by
	  insert_new.  when there is a for_supp_index relation, then
	  this is a magic relation, and a previous call to goal_id
	  should have inserted this same fact in the for_supp_index 
	  relation.  hence, instead of CopyArgs and deleting the 
	  fact there, we just "move" the fact from the for_supp_index
	  relation to the main relation. ***/

    /************************************
    // WARNING::  ReturnUnify optimizations needed here!!!
    ....
    .... check if this works correctly with non-ground magic facts.
    ....
    ************************************/

    ArgList *copy_args;
    BindEnv *copy_env = NULL;
    int	env_size;

    if (for_supp_index) {
	// there is an auxiliary relation and the fact can be got from there
	TupleIterator supp_iter(for_supp_index, args, env);
	StackMark supp_stack_mark1;
	
	for (;;) {
	    StackMark supp_stack_mark2;
	    Tuple *supp_tuple1 = supp_iter.get_next_tuple();
	    supp_stack_mark2.pop_to();
		// Undo any bindings done by get_next_tuple()
		// WARNING: will work ONLY if tuples don't have bindenvs!!
	    if (supp_tuple1 == NULL) { // should not happen
		fprintf(exEnv.trace_file, "insert_new: no matching fact in ");
		fprintf(exEnv.trace_file, "for_supp_index relation.\n");
		stack_mark0.pop_to();
		return 0;
	    }

	    ArrayBindEnv supp_tuple_env(supp_tuple1->env_size);
	    
	    if (subsumes_arg_lists(supp_tuple1->args(), args, 
		    &supp_tuple_env, env)) {
		supp_stack_mark1.pop_to(); 
		    // undo bindings due to subsumes_arg_lists
		if (subsumes_arg_lists(args, supp_tuple1->args(), env,
			NULL)) { 
		    supp_stack_mark1.pop_to(); // undo bindings

		    // supp_tuple1 is the appropriate tuple that needs to
		    // be inserted, and no CopyArgs need be done

#ifdef DO_TRACE
		    if (DISPLAY_INSERTIONS | DISPLAY_NEW_INSERTIONS) {
	    	      	if ( ! DISPLAY_INSERTIONS) {
	        	  fprintf(exEnv.trace_file,
				  "[Inserting %s(", SymbolString(name));
			  supp_tuple1->args().print(NULL,exEnv.trace_file);
			  fprintf(exEnv.trace_file, ")");
	    	        }
	    	      	if (supp_tuple1->env_size == 0)
			  fprintf(exEnv.trace_file, " - done (ground)]\n");
	    		else
			  fprintf(exEnv.trace_file, " - done (env-size:%d)]\n",
				supp_tuple1->env_size);
		    }
#endif
		    if (ordsearch && ((r_kind == COR_R_MAGIC) || 
				(r_kind == COR_R_SUPPLEMENTARY))) {
			// create a goal node with the appropriate fields
			g_node = new GoalNode(supp_tuple1->_args,
				supp_tuple1->bindenv, this,
				negated_g_node);
			g_node->env_size = supp_tuple1->env_size;

			// NOTE: Now, the GoalNode has to be inserted into
			// the for_ordsearch relation and also into
			// context, and subsumption checks have to be 
			// done there.
		    }
		    else {
		        //count++;
			insert_tuple(supp_tuple1);
		        // now we need to delete the tuple from for_supp_index
		        // delete_id_tuple(for_supp_index, supp_tuple1);
			    // NOTE: check if this will work for deletion!!
		        return 1;
		    }


		}
	    }
	    // not found the same tuple, so continue searching
	    supp_stack_mark1.pop_to();
	}
    }
    else { // there is no auxiliary relation and CopyArgs needs to be called

	if (dont_rename) {
	    copy_args = &args;
	    copy_env = env;
	    env_size = copy_env->max_var_number();
	}
	else {
            copy_args = ArgList::New(arity());
            /** CopyArgs also renames variables so that they are distinct,
	        and the bindenv need not be used to distinguish variables.  **/
            env_size = CopyArgs(copy_args->first(), args.first(),
			    env, arity(), dont_rename_env);
	    if (dont_rename_env && dont_rename_env != &UnusedEnv)
		copy_env = dont_rename_env->copy_shell();
	    else if (env_size)
		copy_env = new VersionedBindEnv(env_size);
	    else copy_env = NULL;
	    // delete deref_args;	
		// can reclaim space since deref_args isn't used after this
	}

#ifdef DO_TRACE
        if (DISPLAY_NEW_INSERTIONS && !DISPLAY_INSERTIONS ) {
	        fprintf(exEnv.trace_file, "[Inserting %s(", SymbolString(name));
	        copy_args->print(copy_env, exEnv.trace_file);
                fprintf(exEnv.trace_file, ")");
        }
#endif
	if (ordsearch && ((r_kind == COR_R_MAGIC) || 
				(r_kind == COR_R_SUPPLEMENTARY))) {
	    g_node = new GoalNode(copy_args, copy_env, this, negated_g_node);
	    g_node->env_size = env_size;
	}
	else { /* do the regular stuff */
	    Tuple *tuple1;
	    tuple1 = new Tuple(copy_args, copy_env);
	    tuple1->env_size = env_size;

	    // WARNING:: Will need to eventually create a version of the env
	    // and bump up its size as required.

	    tuple1->contid = C_cont_id++; // See below.
            if (USING_RETURN_UNIFY) {  /* RETURN UNIFICATION */
		/**********************
	        //  we need to set the contid field if the relation is 
		//       or an interface magic relation.
		//       (We do it for all relations, always,
		//       as a kind of backup, to ensure that 
		//       interface relations have a contid set up, even if
		//	 set up from a module that does not implement 
		//	 return unification
		***********************/

		if (r_kind == COR_R_MAGIC) 
		        /**	
	                // parent_goal is a supplementary fact
			// WARNING::  ReturnUnify optimizations needed here!!!
			//    The following will have to change for 
			//    tail-recursive literals.  They shouls inherit 
			//    the parid, and not the cont-id.  Figure out
			//    a way of finding if a goal is tail-recursive.
	                **/
		    tuple1->parid = parent_goal->contid;
		else tuple1->parid = parent_goal->parid;
	    }

            //count++;
	    insert_tuple(tuple1);
#ifdef DO_TRACE
	    if (DISPLAY_INSERTIONS | DISPLAY_NEW_INSERTIONS) {
	        if (env_size == 0)
	            fprintf(exEnv.trace_file, " - done (ground)]\n");
	        else
	            fprintf(exEnv.trace_file, " - done (env-size:%d)]\n", env_size);
            }
#endif
            return 1;
	 }
    }

    // finally, for ordered search relations a special kind of 
    // subsumption needs to be done on the basis of the position of
    // insertion of g_node in context

    // for the ordinary case, the tuple has been inserted previously
    // the program control reaches this point only with OrdSearch

    ASSERT((ordsearch && ((r_kind == COR_R_MAGIC) || (r_kind == COR_R_SUPPLEMENTARY))));

    g_node->contid = C_cont_id++;  // for ReturnUnification; see comments above
				  // related to return unification
    if ( USING_RETURN_UNIFY) {
	if (r_kind == COR_R_MAGIC)
	    g_node->parid = parent_goal->contid;
	else g_node->parid = parent_goal->parid;
    }

    int stat = insert_in_context(g_node, (GoalNode *) parent_goal);
#ifdef DO_TRACE
    if (DISPLAY_INSERTIONS | DISPLAY_NEW_INSERTIONS) {

        if (env_size == 0)
	    fprintf(exEnv.trace_file, " - done (ground)]\n");
	else
	    fprintf(exEnv.trace_file, " - done (env-size:%d)]\n", env_size);
    }
#endif
    return stat;
}

int StorageRelation::insert_grouping(ArgList& args, BindEnv* env,
	BindEnv *, Tuple *, int )
{
    StackMark stack_mark0;

    #ifdef DO_TRACE
    if (DISPLAY_INSERTIONS) {
	fprintf(exEnv.trace_file, "[Insert grouping: %s(", SymbolString(name));
	args.print(env, exEnv.trace_file);
	fprintf(exEnv.trace_file, ")");
    }
    #endif

    Arg    *grouping_arg=NULL;
    int grouping_arg_num;
    int i;

    ArgList *temp_args = ArgList::New(args.count());

    /*********************************
    // WARNING::  ReturnUnify optimizations needed here!!!
    ....
    .... See how this is affected by and will affect return unify optimizations
    ....
    **********************************/

    for (i=0;i<args.count(); i++) {
        (*temp_args)[i] = args[i];
	if (args[i]->kindof() == COR_GROUPING) {
	    grouping_arg_num=i;
    	    grouping_arg = args[i];
	    // **** WARNING::
	    //	 The following code is dangerous - it 
	    //	 changes a static rule structure.
	    //   Make sure the structure is reset before
	    //	 this function returns.
	    //   Since the function can never recursively
	    //   call the rule to which the arg belongs,
	    //   this modification is safe.

	    args[i]= &TheDontCareArg; 
		// Replace DontCareArg by a new variable !!?????
		// Tricky replacement - unification on args will affect 
		//   grouping arg in case it shares variables with 
		//   the non-grouping arg.
	}
    }

    TupleIterator iter(this, args, env);
    StackMark stack_mark1;
    int do_insert = 1; 
    int stat=0;

    for (;;) {
	StackMark stackmark2;
	Tuple *tuple1 = iter.get_next_tuple();
	stackmark2.pop_to(); 
		// Undo any bindings done by get_next_tuple();
		// WARNING: will work ONLY if tuples don't have bindenvs!!
		// WARNING: the current version of subsumes_args also has this
		//		limitation!!
        if (tuple1==NULL) 
	    break;
	if (subsumes_arg_lists(args, tuple1->args(), env, iter.tuple_env)){ 
            #ifdef DO_TRACE
    	    if (DISPLAY_INSERTIONS) {
		fprintf(exEnv.trace_file, " - non-grouping args subsume - (");
		tuple1->printon(exEnv.trace_file);
		fprintf(exEnv.trace_file, ")]\n");
	    }
            #endif

          #ifdef DO_EXPLAIN
	  /** Tarun **/
          char *copy_arglist;
          if (this->local_options & REL_EXPLAIN) {
            copy_arglist = new char[5000];
            int  pos = 0;
           (tuple1->args()).sprint(copy_arglist, &pos);
          }
          #endif

          do_insert = 0;
	  stat = update_grouping(this, tuple1, temp_args, env);

          #ifdef DO_EXPLAIN
          if (this->local_options & REL_EXPLAIN) {
            group_dump(env, tuple1->_args, this, copy_arglist);
            delete [] copy_arglist;
          }
          #endif

	}
	stack_mark1.pop_to();
	break;
    }
    stack_mark0.pop_to();

    for (i=0;i<args.count(); i++) {
        args[i] = (*temp_args)[i];
    }

    if (! do_insert) {

        #ifdef DO_TRACE
        if (DISPLAY_INSERTIONS | DISPLAY_NEW_INSERTIONS) {
	    if (!DISPLAY_INSERTIONS) {
	        fprintf(exEnv.trace_file,
                        "[Inserting Grouping %s(", SymbolString(name));
	        args.print(env, exEnv.trace_file);
	    }
	    fprintf(exEnv.trace_file,
		") - no new fact created (old one may have been modified)\n");
        }
        #endif

	return 0;  // Examine carefully to see if non-ground
				// cases are handled properly.
    }

    ArgList *copy_args = ArgList::New(arity());
    /** CopyArgs also renames variables so that they are distinct,
	and the bindenv need not be used to distinguish variables.  **/
    /** Grouping::simplify does the ``right'' thing with aggregation - 
	it removes the grouping junk and returns the argument.
	In fact, for count it just returns a default arg since it 
	will never be looked at. **/
    int env_size = CopyArgs(copy_args->first(), args.first(),
			    env, arity(), &UnusedEnv);


    #ifdef DO_TRACE
    if (DISPLAY_INSERTIONS | DISPLAY_NEW_INSERTIONS) {
	    fprintf(exEnv.trace_file, 
                     "[Inserting Grouping %s(", SymbolString(name));
	    copy_args->print(NULL, exEnv.trace_file);
	if (env_size == 0)
	    fprintf(exEnv.trace_file, " - done (ground)]\n");
	else
	    fprintf(exEnv.trace_file, " - done (env-size:%d)]\n", env_size);
    }
    #endif

    // the new tuple created has copied the arglist.  subsequent
    // modifications to the tuple by Grouping::update_tuple 
    // can hence update the arglist in place without worrying
    // about it being shared by anyone else

    Tuple *tuple2 = new Tuple(copy_args);
    tuple2->env_size = env_size;
    insert_tuple(tuple2);

    #ifdef DO_EXPLAIN
    /** Tarun **/
    if (this->local_options & REL_EXPLAIN)
        group_dump(env, tuple2->_args, this);
    #endif

    return 1;
}

void Relation::printon(FILE *file, char *) const
{
  this->printon(file);
}

void Relation::printon(FILE *file) const
{
    StackMark stack_mark0;
    ArrayBindEnv env0(arity());
    ArgList *args = vararglist(arity());
    TupleIterator iter((Relation*)this, *args, &env0);
    StackMark stack_mark1;

    BindEnv *env1 = iter.get_next();
    if (!(iter.no_match())) {
     for (int iarg = 0; iarg < arity(); iarg++) {
             if (iarg > 0) fputs(", ", file);
             env1->lookup(iarg).printon(file);
     }
     for (;;) {
        BindEnv *env1 = iter.get_next();
        if (iter.no_match()) break;
        fprintf(file, ",");
        for (int iarg = 0; iarg < arity(); iarg++) {
             if (iarg > 0) fputs(", ", file);
             env1->lookup(iarg).printon(file);
        }
        stack_mark1.pop_to();
     }
    }
    stack_mark0.pop_to();
    delete args;
}

void Relation::print_facts(FILE *file, ArgList *arglist) const
{
    StackMark stack_mark0;
    ArgList *args;

    if (!arglist)
    	args = vararglist(arity());
    else {
	if (arglist->arity() != arity()) {
	    CORAL_error(COR_BAD_ARGLIST, NULL, "print_facts");
	    fprintf(exEnv.trace_file, "Bad arity %d - %d expected\n",
			arglist->arity(), arity());
	    return;
	}
	args = arglist;
    }

    ArrayBindEnv env0(arity());
    TupleIterator iter((Relation*)this, *args, &env0);
    StackMark stack_mark1;
    Term term;
    for (;;) {
	BindEnv *env1 = iter.get_next();
        if (iter.no_match()) break;
	fprintf(file, "%s(", name->string());
	for (int iarg = 0; iarg < arity(); iarg++) {
	     if (iarg > 0) fputs(",", file);
	     term.expr = (*args)[iarg];
	     term.bindenv = &env0;
	     term = term.dereference();
	     term.printon(file);
	}
	fprintf(file, ").\n");
	stack_mark1.pop_to();
    }
    stack_mark0.pop_to();
    if (!arglist)
        delete args;
}


// ??? The following has to be fixed some time or the other, but is complicated 
// by structure sharing.
// ???

void StorageRelation::free_all() { }
void StorageRelation::free_indices() { }
StorageRelation::~StorageRelation() { free_all(); }

void RelationList::append_relation(StorageRelation* _rel)
{ 
    RelationLink *n_link  = new RelationLink(_rel);
    if (!reln_lastptr) {
	reln_chain = reln_lastptr = n_link;
    }
    else {
	reln_lastptr->next = n_link;
	reln_lastptr = n_link;
    }
}

void RelationList::append(RelationLink * n_link)
{ 
    if (!reln_lastptr) {
	reln_chain = reln_lastptr = n_link;
    }
    else {
	reln_lastptr->next = n_link;
	reln_lastptr = n_link;
    }
}

Relation *find_external_relation(Name name, int arity)
{
 char      buf[1000];
/**
 sprintf(buf, "%s %d", SymbolString(name), arity);
 Name new_name = EnterSymbol(buf);
**/
 Name new_name = name;

  Association *ptr = SymbolLookup(CurDB->RelationTable, new_name);
  if (HashNone(ptr->arg)) {
    Association *ptr1 ;
    ptr1 = SymbolLookup(BuiltinDB.RelationTable, name) ;
    if (HashNone(ptr1->arg)) return NULL;
    else return (Relation *)ptr1->val;
  }
  else {
    return (Relation *)(ptr->val);
   }
}

Relation *Find_External_Relation(Name name, int arity)
{
  // This version creates a relation if none is found.
  // It gives a warning if it did not find an existing relation
  /* NOTE: remove FindRelation once all calls to it are replaced */

  Relation *rel = find_external_relation(name, arity);
  if (rel) return rel;
  
  if (!exEnv.C_quiet_mode_default) {
    CORAL_error(COR_REL_NOT_FOUND,name->string(),"Find_External_Relation");
    fprintf(exEnv.trace_file, "Arity of relation = %d \n", arity);
    fprintf(exEnv.trace_file, "Allocating new relation.\n");
  }
  
  return make_relation(name, arity);
}

Relation *find_relation(char * name, int arity) 
{
    Name n = EnterSymbol(name);
    return find_relation(n, arity);
}

Relation *find_relation(Name name, int arity)
{

    Relation *rel;
    rel = find_local_relation(name, arity);
    if (!rel) rel = find_external_relation(name, arity);
    if (!rel) {
	CORAL_error(COR_REL_NOT_FOUND,name->string(),"find_relation");
	fprintf(exEnv.trace_file, "Arity of relation = %d\n", arity);
    }
    return rel;
}

Relation * make_relation(Name name, int arity, int delta_indexed)
{
 char      buf[1000];

 if (is_magic(name)  || is_supp(name) || is_mp_done(name)) {
   fprintf(exEnv.error_file, "Warning::relation name %s conflicts with system reserved names !\n",
	   SymbolString(name));
   sprintf(buf, "new%m%d", SymbolString(name), arity);
   fprintf(exEnv.error_file, "New name is %s.\n", buf);
  }
 else
   sprintf(buf, "%s", SymbolString(name));

 Name new_name = EnterSymbol(buf);

 Association *ptr = SymbolLookup(CurDB->RelationTable, new_name);
 if (HashNone(ptr->arg)) {
   Association *ptr1 ;
   ptr1 = SymbolLookup(BuiltinDB.RelationTable, name) ;
   if (HashNone(ptr1->arg)) {
     ptr->arg = new_name;
     ptr->val = AllocateRelation(new_name, arity, delta_indexed);
     TabInserted(CurDB->RelationTable, ptr);
    }
   else return (Relation *)ptr1->val ;
  }
 return (Relation*)ptr->val;
}

Relation *make_relation(char *name, int arity, int delta_indexed)
{

    Name n = EnterSymbol(name);
    return make_relation(n, arity, delta_indexed);
}

StorageRelation *make_local_relation(Name name, int arity, 
			      int delta_indexed, int set_subsum)
{ 
  /*
   * this stuff ensures that the relation constructor sees the desired
   * value of exEnv.C_check_subsum_default    -- P
   */

  if ((set_subsum == -1) || (exEnv.C_check_subsum_default == set_subsum))
    return AllocateRelation(name, arity, delta_indexed);


  int temp = exEnv.C_check_subsum_default;
  exEnv.C_check_subsum_default = set_subsum;
  StorageRelation *rel = AllocateRelation(name, arity, delta_indexed);
  exEnv.C_check_subsum_default = temp;
  return rel;
}

#ifdef DO_GC
void Tuple::GCPointers() { gcpointer(*args); }
#endif

int StorageRelation::is_subsumed(Tuple *tuple, 
				 RMark *startmark, RMark *endmark)
{
    StackMark stack_mark1;

    /******** Check for ordinary subsumption *********/
    TupleIterator iter(this, *(tuple->_args), tuple->bindenv, startmark, 
		endmark);
    for (;;) {
        StackMark stackmark2;
	Tuple *tuple1 = iter.get_next_tuple();
	stackmark2.pop_to(); 
	// Undo any bindings done by get_next_tuple();
        if (tuple1 == NULL) break;
	if (subsumes_arg_lists(tuple1->args(), *(tuple->_args), 
	    		iter.tuple_env, tuple->bindenv)){ 
#ifdef DO_TRACE
    	    if (DISPLAY_INSERTIONS) {
	        fprintf(exEnv.trace_file, " - subsumed by (");
	        tuple1->printon(exEnv.trace_file);
		fprintf(exEnv.trace_file, ")]\n");
	    }
#endif
	    stack_mark1.pop_to();
	    return 1;
	}
	stack_mark1.pop_to();
    }
    stack_mark1.pop_to();

    return is_agg_subsumed(tuple, startmark, endmark);
}


int StorageRelation::is_agg_subsumed(Tuple *tuple, 
				     RMark *startmark, RMark *endmark)
{
    /********* Check aggregate selections *********/

#define GETBINDENV(aggsel,env) { 					       \
        env = aggsel->bindenv;						       \
	aggsel->bindenv = NULL;  /*To allow reentrant use of aggsel->bindenv*/ \
        if(env==NULL) env = new ArrayBindEnv(aggsel->var_count);	       \
	}

#define RELEASE(aggsel,env) {					\
	if (aggsel->bindenv==NULL) aggsel->bindenv = env;	\
	else delete env;					\
	} 


    /*********************************
    // WARNING::  ReturnUnify optimizations needed here!!!
    **********************************/

   
    StackMark stack_mark1;
    AggSelInfo *aggsel;
     
    for(aggsel=agg_sel_info; aggsel != NULL; aggsel=aggsel->next) {
	// For each agg sel in the list
    	StackMark stack_mark2;
	BindEnv *aggsel_env;
	GETBINDENV(aggsel, aggsel_env);

	unify_arg_lists(*(aggsel->arglist), *(tuple->_args), aggsel_env, 
			tuple->bindenv);
        TupleIterator iter(this, *(aggsel->groupbylist), aggsel_env,
			startmark, endmark, &(aggsel->indexnum));

        for (;;) {
	    StackMark stackmark3;
	    Tuple *tuple1 = iter.get_next_tuple();
              // aggsel->groupbylist and aggsel->gb_agg_value correspond to
              // the fetched tuple.
	    stackmark3.pop_to(); 

            if (iter.no_match() || tuple1==NULL) 
	        break;

	    if (subsumes_arg_lists(*(aggsel->groupbylist), tuple1->args(), 
			aggsel_env, iter.tuple_env)){ 

              // Check if new value (aggsel->agg_value) subsumes old
              // value (aggsel->gb_agg_value).
              int stat = subsumes_value(aggsel->agg_kind, aggsel->agg_value,
                     aggsel->gb_agg_value, aggsel_env, aggsel_env);
              if (stat > 0) {
#ifdef DO_TRACE
		if (exEnv.dbg_aggregates || DISPLAY_INSERTIONS) {
		  fprintf(exEnv.trace_file, "\n\t\t - aggsel: new fact subsumes");
		  fprintf(exEnv.trace_file, ": %s(", name->string());
		  tuple1->printon(exEnv.trace_file);
		  fprintf(exEnv.trace_file, ")\n");
		}
#endif
		delete_id_tuple(this, tuple1);
		}
		else if (stat < 0) 
		  {
#ifdef DO_TRACE
		    if (exEnv.dbg_aggregates || DISPLAY_INSERTIONS) {
		      fprintf(exEnv.trace_file,
			      "\n\t\t - aggsel: old fact subsumed by");
		      fprintf(exEnv.trace_file, ": %s(", name->string());
		      tuple1->printon(exEnv.trace_file);
		      fprintf(exEnv.trace_file, ")\n");
		    }
#endif
		    stack_mark1.pop_to();
		    RELEASE(aggsel,aggsel_env)
		    return 1;
		  }
              // New fact not subsumed
	      //  using current aggregate selection

	    }
	    stackmark3.pop_to();
 	}	
	stack_mark2.pop_to();
        RELEASE(aggsel,aggsel_env)
    }
    stack_mark1.pop_to();


    /******* Fact is not subsumed ******/
    return 0;
}



void RMark::init(TupleLink **link) 
{
    lastptr = link;
    rel_p = NULL;
}

void RMark::init(RelationLink *link) 
{
    lastptr = NULL;
    rel_p = link;
}

RMark::RMark()
{
    rel_p = NULL;
}

RMark::RMark(TupleLink **link)
{
  lastptr = link;
  rel_p = NULL;
}

RMark::RMark(RelationLink *link)
{
    rel_p = link;
}

void TupleList::free_all()
{
    TupleLink* next;
    for (TupleLink *link = chain; link != NULL; link = next) {
	next = link->next;
	// This doesn't free the components of the tuple.
	delete link->tuple;
	delete link;
    }
    chain = NULL;
    lastptr = &chain;
}
