/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "generic-index.h"
#include "externs.h"
#include "globals.h"
#include "ordsearch.h"

int GenericIndex::matches(GenericIndex *ind)
{
    if (argset) {
	if (!ind->argset) return 0;
	if (*argset == *(ind->argset))
	    return 1;
	return 0;
    }

    return 1;
}

int GenericIndexSet::add_all_indices( StorageRelation *reln)
{
    if (rel->arity() != reln->arity()){
	fprintf(stderr, "add_all_indices: relations of different arities.\n");
	return COR_I_FAIL;
    }
    for (int i=0; i < num_in_array; i++) {
	(Indices[i])->add_index_to_reln(reln);
    }
    return COR_I_SUCCESS;  
}

void GenericIndexSet::print_adornments(FILE *outf)
{
  fprintf(outf, ": indexes ");
  for (int i = 0; i < num_in_array; i++) {
    // NOTE:: right now, only argument form indices are printed out
    if (Indices[i]->argset) {
      print_adornment(*(Indices[i]->argset), outf);
      fprintf(outf, " ");
    }
  }
}

void GenericIndex::delete_all_tuples()
{
  fprintf(stderr, "delete_all_tuples: not implemented yet\n");
}


char *simplify_index(ArgList *pat, int n_var, ArgList *v_nm)
{
/** 
    This takes a pattern form index and returns an argument form
    index, if possible; else it returns NULL.

  (1) if there is a function symbol in pat with an embedded variable 
      that does not occur in v_nm, return NULL
  (2) if there is a repeated variable in pat which does not occur 
      in v_nm, return NULL
**/

    StackMark stackmark;
    ArrayBindEnv pat_env(n_var);
    Term dummy_term(make_arg(0), NULL);

#ifdef DO_TRACE
    if (exEnv.dbg_indexing) {
	fprintf(exEnv.trace_file, "simplify_index: (");
	pat->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, "), bound vars = (");
	v_nm->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file,")\n");
    }
#endif

    // First bind each position of pat_env occurring in v_nm to dummy_term
    for (int i=0; i < v_nm->count(); i++) {
	pat_env.bind(((VarArg*) (*v_nm)[i])->var, dummy_term);
	// pat_env[((VarArg*) (*v_nm)[i])->var] = dummy_term;	
    }

    // Now check if each argument of pat is either a variable or a constant
    //     in pat_env

    char *return_val = new char[pat->count()+1];
    for (int j=0; j < pat->count(); j++) {
	if ((*pat)[j]->hash(&pat_env) == VarHashValue){
	    if ((*pat)[j]->kindof() != COR_VARIABLE){ // embedded unbound variable
		delete return_val;
		stackmark.pop_to();
		return NULL;
	    }
	    else { // free variable
		return_val[j] = 'f';
	    }
	}
	else { // the argument is ground, given the bound variables
	    return_val[j] = 'b';
	}
    }
    return_val[j] = '\0';

    // Now check for repeated unbound variables at top-level in pat.

    for (int j1=0; j1 < pat->count(); j1++){
	if (((*pat)[j1]->kindof() == COR_VARIABLE) && (return_val[j1] == 'f')) {
	    // check if this is a repeated variable
	    for (int j2=j1+1; j2 < pat->count(); j2++){
		if (((*pat)[j2]->kindof() == COR_VARIABLE) &&
		  (((VarArg*) (*pat)[j1])->var == ((VarArg*) (*pat)[j2])->var)){
			// found a repeated variable
			delete return_val;
			stackmark.pop_to();
			return NULL;
		}
	    }
	}
    }

#ifdef DO_TRACE
    if (exEnv.dbg_indexing) {
	fprintf(exEnv.trace_file, 
		"simplify_index: simplified to %s\n", return_val);
    }
#endif
    stackmark.pop_to();
    return return_val;

}

