/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	execute.C

	Contains routines to execute a query given the intermediate
	representation of modules, sccs and seminaive rules.

 ***********************************************************************/

#include "externs.h"
#include "interp.h"
#include "pipelined.h"
#include "derived-rel.h"
#include "profile.h"
#include "apply.h"
#include "annotations.h"
#include "globals.h"
#include <stdlib.h>
#include <string.h>
#include "ordsearch.h"

#ifdef WITH_PERSISTENCE
extern StorageRelation *make_pers_relation(Name, int arity, int delta_index,
					   int set_subsum, ArgList *a_list);

#define MAKE_PERS_REL_MACRO(a,b,c,d,e) make_pers_relation(a,b,c,d,e)
#else
#define MAKE_PERS_REL_MACRO(a,b,c,d,e) make_local_relation(a,b,c,d)
#endif

#define DISPLAY_RULES(X) ((exEnv.GlobalRelationOptions | (X)->rel_options) &  \
			   REL_DISPLAY_INSERTIONS)

//static long display_rules = 0 ;

extern void sprint_pred_name(char *buf, char *name, char *adorn);
extern void sprint_pred_name(char *buf, char *name, BitVector *adorn);
extern void sprint_magic_name(char *buf, char *name, BitVector *adorn);
extern void sprint_magic_name(char *buf, char *predname, char *adorn);
extern int print_new_line_after_rule;
extern int print_adorn_for_pred;

extern int has_grouping_args(ArgList &args);
extern void AddProfileInfo(ProfileInfo *A, ProfileInfo *B) ;

extern DatabaseStruct BuiltinDB ;

// Defined in compile.C
extern void compile_single_rule(ParserStruct &parserStruct, 
			 Table* &module_table,
			 RuleInfoArray* &module_rules,
			 SemiNaive &snrule);

extern void reclaim_relation(StorageRelation *rel);

ArgList *MagicArgs = NULL;
BindEnv *MagicBindEnv = NULL;
StorageRelation *MagicRelation = NULL;


// points to current moduleInfo defaults
ModuleInfo *CurrModuleInfo = NULL;

// Constructor for RMarkArray. All RMarks * are initially NULL.
// Even RMarks are 'old' and odd RMarks are 'new'.
// Size should be even !!
RMarkArray::RMarkArray(int size)
{
 markList = new RMark*[size] ;
 for (int i = 0; i< size; i++) {
   markList[i] = NULL ;
  }
 array_size = size ;
}

// Copies a new RMark at position i+1 to the old RMark at position i.
// Obviously, i should be even.
void RMarkArray::New_To_Old(int i)
{
    if (i < array_size - 1) {
	markList[i] = markList[i+1] ;
	markList[i+1] = NULL;
    }
}

RMarkArray::~RMarkArray()
{
	delete [] markList ;
}

void SemiNaive::clean_cache() 
{
	for (int i=0; i < rInfo->num_literals; i++)
	    indices[i] = -1;
}

static void PrintSccRecursiveRules(SccInfo* scc, int start, FILE *outf)
{
 int j;
  fprintf(outf,"\n[Iterating over recursive rules ...]") ;
  fprintf(outf,"\n---------------------------------------\n");
  
  for (int i = start; i < scc->numSNRules ; i++)
    //    if (!scc->sn_rules[i].ignore_this_rule) 
    {
      fprintf(outf,"%s\n",scc->sn_rules[i].rInfo->pInfo.rule);
      fprintf(outf, "Predord :: ");
      for (j = 0; j < scc->sn_rules[i].rInfo->num_literals; j++)
	fprintf(outf, "%d ",scc->sn_rules[i].predOrders[j]);      
      fprintf(outf, "\n1st bt :: ");
      for (j = 0; j < scc->sn_rules[i].rInfo->num_literals; j++)
	fprintf(outf, "%d ",scc->sn_rules[i].firstFailureBacktrack[j]);
      fprintf(outf, "\nnext bt :: ");
      for (j = 0; j < scc->sn_rules[i].rInfo->num_literals; j++)
	fprintf(outf, "%d ",scc->sn_rules[i].nextFailureBacktrack[j]);
      fprintf(outf, "\n\n");
     }
  
  fprintf(outf,"---------------------------------------\n\n");
  fflush(outf);

}

static void PrintSccNonRecursiveRules(SccInfo* scc, FILE *outf)
{
  fprintf(outf,"\n[Applying non-recursive rules ...]") ;
  fprintf(outf,"\n---------------------------------------\n");
  
  for (int i = 0; i < scc->numSNRules ; i++) {
    if (scc->sn_rules[i].recursive) break ;
//    if (!scc->sn_rules[i].ignore_this_rule) {
      fprintf(outf,"%s\n",scc->sn_rules[i].rInfo->pInfo.rule);
      fprintf(outf, "\n");
//    }
  }
  
  fprintf(outf,"---------------------------------------\n\n");

}

static void EndOfScc(SccInfo* scc, int iters, FILE *outf)
{
  int i ;

  if (exEnv.profile_scc) {
    for (i=0; i< scc->numSNRules; i++) {
      //if (!scc->sn_rules[i].ignore_this_rule) {
	scc->sn_rules[i].rInfo->pInfo.print(outf, "SCC",
					    scc->sn_rules[i].predOrders,
					    scc->sn_rules[i].rInfo->num_literals);
      //}
     }
    fprintf(outf, "\nNumber of SCC iterations = %d\n", iters);
  }
}

static void clearStatistics(QFMaterializedModuleData *md, FILE *outf)
{
  int i, j;
  long profile_rules = ((exEnv.GlobalRelationOptions | md->rel_options) &
			REL_PROFILE_STATS) ;
  
  if (profile_rules && (exEnv.profile_module)) {
    md->module_info.GlobalProfileInfo.clear();
    md->module_info.GlobalProfileInfo.set_rule_name("");
    for (i = 0; i < md->numSccs; i++)
      for (j=0; j < md->ruleArray->numRules; j++) {
	AddProfileInfo(&(md->ruleArray->rInfoPtrs[j]->pInfo),
		       &(md->module_info.GlobalProfileInfo));
	md->ruleArray->rInfoPtrs[j]->pInfo.clear();
      }

    md->module_info.GlobalProfileInfo.print(outf, "MODULE SUMMARY");
    md->module_info.GlobalProfileInfo.clear();
  }
  else {
    for (i = 0; i < md->numSccs; i++)
      for (j = 0; j < md->sccArray[i]->numSNRules; j++)
	md->sccArray[i]->sn_rules[j].rInfo->pInfo.clear();
  }

}

RMarkArray * SccInfo::setupSolve(Table *F)
{
  int sn_count;
  int i;
  
  // Create array of RMarks
  // By default, all RMark *s are NULL 
  RMarkArray *rm_Arr = NULL;
  RMarkArray *hidden_rel_rmarks = NULL;

  rm_Arr = F->module_env->scc_envs[this->scc_id]->rm_Arr;
  if (module->module_info.SaveModule) {
    // set up RMarks for the case of non-recursive SN rules for SaveModules
    StorageRelation *hrel = NULL;
    for (i=0; i < numPreds+num_lowerPreds; i++) {
      hrel = (StorageRelation*)(F->rels[offset_arr[i]].relPtr);
      if (hrel) {
	ASSERT((hrel->there_are_marks()));
	// set up the old marks to the status of the relations as of
	// the end of the previous call to the SaveModule
	rm_Arr->markList[2*i] = hrel->headMark.prev;
	
	// we don't need to get new marks for any of the relations 
	// for SaveModule
       }
     }
   }

  if (has_hidden_relations) {
    hidden_rel_rmarks = new RMarkArray(2*numPreds) ;
    for (i=0; i < numPreds; i++) {
      if (F->rels[offset_arr[i]].relPtr->priority_info)
        hidden_rel_rmarks->markList[2*i+1] =
	  F->rels[offset_arr[i]].relPtr->getMark() ;
     }
  }
  
  //  if ((display_rules) && (!sn_rules[0].recursive) && 
  if ((DISPLAY_RULES(module)) && (!sn_rules[0].recursive) && 
      (!exEnv.C_quiet_mode_default))
    PrintSccNonRecursiveRules(this, exEnv.trace_file) ;
  
  /* For Basic SemiNaive, evaluate non-recursive rules
    * For Predicate SemNaive, this is incorporated into the
      * first iteration of the recursive rules.
	*/

#define CUR_POS sn_offset_arr[sn_count]
  for (sn_count = 0; sn_count < numSNRules ; sn_count++)
    if (sn_rules[sn_count].recursive) break ;
    else if (!module->use_psn) {
      //if (!sn_rules[sn_count].ignore_this_rule) {
      F->moduledata->curr_rInfo = sn_rules[sn_count].rInfo;
      sn_rules[sn_count].evaluate(F, rm_Arr) ;
      //}
    }
#undef CUR_POS


  // I dont know if it is possible that the lowest scc has a rule for
  // the m_query relation , but the rule is non-recursive. But just in
  // case this is possible, i catch it here, and insert the m_query
  // seed tuple at this point
  if (MagicRelation && module->use_psn && (sn_count == numSNRules)) {
      MagicRelation->insert_new(*MagicArgs, MagicBindEnv);
      MagicRelation = NULL; MagicArgs = NULL; MagicBindEnv  = NULL;
  }

  /*
   * NOTE : if the scc has only non-recursive rules, evaluate them all
   *        even for PSN.
   */

  if (module->use_psn && (sn_count == numSNRules)) {
    for (sn_count = 0; sn_count < numSNRules ; sn_count++) {
      //if (!sn_rules[sn_count].ignore_this_rule) {
        F->moduledata->curr_rInfo = sn_rules[sn_count].rInfo;
        sn_rules[sn_count].evaluate(F, rm_Arr) ;
      //}
    }
  }

  rec_rule_start = sn_count ;

  if (has_hidden_relations) {
    for (i=0; i < numPreds; i++) {
      if (F->rels[offset_arr[i]].relPtr->priority_info)
      F->rels[offset_arr[i]].relPtr->freeMark(
                      hidden_rel_rmarks->markList[2*i+1], /*hide_em=*/ 1);
    }
  }


  if (sn_count == numSNRules) return rm_Arr;


  // Note on RMarks for recursive rules. For each predicate, an 'old' RMark
  // and a 'new' RMark are created at consecutive positions in the RMarkArray.
  // The order in which these RMarks are created defines their positions in
  // the array, and this fact is used by Find_RMark_Offset() .

  if (DISPLAY_RULES(module) && !exEnv.C_quiet_mode_default)
    PrintSccRecursiveRules(this, rec_rule_start, exEnv.trace_file) ;

  return rm_Arr;
}

static int evaluateNonRecursive(SccInfo *scc, Table *F,
                                 RMarkArray *rm_Arr, int curpos)
{
  int sn_count;
  int new_tuples = 0;

  if (MagicRelation && 
      (F->rels[scc->offset_arr[curpos]].relPtr == MagicRelation)) {
    MagicRelation->insert_new(*MagicArgs,MagicBindEnv);
    MagicRelation = NULL; MagicArgs = NULL; MagicBindEnv  = NULL;
    new_tuples = 1;
  }

      
  for (sn_count = 0; sn_count < scc->rec_rule_start ; sn_count++)
    if (scc->sn_offset_arr[sn_count] == curpos) {
      //if (!scc->sn_rules[sn_count].ignore_this_rule) {
        F->moduledata->curr_rInfo = scc->sn_rules[sn_count].rInfo;
        new_tuples += scc->sn_rules[sn_count].evaluate(F, rm_Arr);
      // }
     }

  return new_tuples;

}

/*
 * performs one iteration over the recursive rules and returns 1 if the iteration
 * should continue, and 0 if the iterative loop should be exited
 */
int SccInfo::iterateRecursiveRules(Table *F, RMarkArray *rm_Arr, 
					int loop_iter_num, int iteration_number)
{
  int new_tuples = 0;
  int sn_count;
  
  if (module->use_psn) {
    // Predicate SemiNaive

    int curpos = sn_offset_arr[rec_rule_start];
    rm_Arr->markList[2*curpos+1] = 
      F->rels[offset_arr[curpos]].relPtr->getMark() ;

    for (sn_count = rec_rule_start; sn_count < numSNRules ; sn_count++){
      //if (!sn_rules[sn_count].ignore_this_rule) {
        F->moduledata->curr_rInfo = sn_rules[sn_count].rInfo;
        new_tuples += sn_rules[sn_count].evaluate(F, rm_Arr) ;
      // }

      if ((sn_count == numSNRules -1) || (sn_offset_arr[sn_count+1] != curpos)) {
	int hide_em = 0;
	if (module->use_psn && (loop_iter_num == 1) && (iteration_number == 1))
	  new_tuples += evaluateNonRecursive(this, F, rm_Arr, curpos);

	if ((! module->module_info.SaveModule) || (loop_iter_num > 1)) {
	    F->rels[offset_arr[curpos]].relPtr->
	     freeMark(rm_Arr->markList[2*curpos]) ;
	}

        if (has_hidden_relations  &&
	    F->rels[offset_arr[curpos]].relPtr->priority_info) {
          hide_em = 1;
          F->rels[offset_arr[curpos]].relPtr->freeMark(
			       rm_Arr->markList[2*curpos+1], hide_em) ;
          rm_Arr->markList[2*curpos+1] = F->rels[offset_arr[curpos]].
	    relPtr->getMark() ;
	}

	rm_Arr->New_To_Old(2*curpos);

	if (sn_count < numSNRules -1) {
	  curpos = sn_offset_arr[sn_count+1] ;
	  rm_Arr->markList[2*curpos+1] = F->rels[offset_arr[curpos]].
	    relPtr->getMark() ;
	}
      }
    }
  }

  else {
    // Basic SemiNaive
    int i, j, k;
    for (i=0, j =1; i < numPreds; i++, j += 2) {
      rm_Arr->markList[j] = 
	F->rels[offset_arr[i]].relPtr->getMark() ;
    }
    
    for (sn_count = rec_rule_start; sn_count < numSNRules ; 
	 sn_count++) {

      SemiNaive *cur_sn_rule = &(sn_rules[sn_count]);
//       if (!cur_sn_rule->ignore_this_rule) {
	 F->moduledata->curr_rInfo = cur_sn_rule->rInfo;
	 new_tuples += cur_sn_rule->evaluate(F, rm_Arr);
//	}
     }


    if (has_hidden_relations) {
      for (i=0; i < numPreds; i++){
	if (F->rels[offset_arr[i]].relPtr->priority_info) {
	  F->rels[offset_arr[i]].relPtr->
	    freeMark(rm_Arr->markList[2*i+1], /* hide_em */ 1);
	  rm_Arr->markList[2*i+1] = 
	    F->rels[offset_arr[i]].relPtr->getMark();
	 }
       }
     }

    if ((! module->module_info.SaveModule) || (loop_iter_num > 1)) {
      for (i=0, j = 0; i < numPreds; i++, j+=2){
	// the old marks should not be freed, if we are in the
	// first iteration of SaveModules since these correspond to 
	// the global old pointers obtained at the end of evaluation of
	// the previous call to the module.
	  F->rels[offset_arr[i]].relPtr->freeMark(rm_Arr->markList[j]) ;
       }
     }

    int numpreds2 = 2*numPreds;

    for (i=0, j=1; i < numpreds2; i+=2, j+=2) {
      // rm_Arr->New_To_Old(2*i) ;
      rm_Arr->markList[i] = rm_Arr->markList[j] ;
      rm_Arr->markList[j] = NULL;
     }
   }
	
  GoalNode *g_node; 

  if (new_tuples) return 1;

  else {
    /* There are a bunch of special cases in which the number of new_tuples is == 0,
       but there is still some computation to go. However, if the value of new_tuples
       is non_zero, then we can return right away
     */
    if (has_hidden_relations)
      for (int i =0; i < numPreds; i++)
        if (F->rels[offset_arr[i]].relPtr->priority_info)
           if (((StorageRelation*)(F->rels[offset_arr[i]].relPtr))->pop_from_hidden_relation() == 0)
                  continue;
           else {
	     return 1;
	     // return, so newly unhidden tuple
	     // can be displayed to user if required.
	     // Tuple will get used in a later call on this routine
	   }

    if (!(module->module_info.UseOrdSearch))
      return 0;

    // Ordered Search
    // have reached a fixpoint; need to get unmarked tuple 
    // from context, and put it in the appropriate relation

    int any_new_fact_in_done = 0;
    g_node = F->context->get_unmarked_goal(any_new_fact_in_done);
    
    // exit condition from Ordered Search
    if (g_node == NULL) {
      if (!any_new_fact_in_done) {
	return 0;
      }
      else return 2 ;
    }

    if ((!module->module_info.SaveModule) || 
	(! g_node->owner_rel->check_subsum) ||
	(! g_node->owner_rel->is_subsumed(g_node))) {
      g_node->owner_rel->insert_tuple(g_node);
      // NOTE: should remove g_node from 
      // g_node->owner_rel->for_ordsearch's index
      return 2;
    }

  return 0;
  }
}



// Iterator will be non-null ONLY if this is a top-level scc
// and staggered evaluation is desired on it.
void SccInfo::Solve(Table *F, TupleIterator *iterator)
{
  RMarkArray *rm_Arr;
  int i;
  
  // if staggered evaluation is not being performed, or this is the
  // not the top level scc, or this is the first time the top level 
  // scc is being executed

  if (!(iterator) || !(iterator->state->rm_Arr)) {
    rm_Arr = setupSolve(F);

    if (iterator) {
      // first time this top-level scc is being executed
      iterator->state->rm_Arr = rm_Arr;
    }
  }
  else {
    rm_Arr = iterator->state->rm_Arr;
  }

  /******
  // Sudarshan:  Handling prioritize at the level of SN updates is critical.
  //   I tried to handle hiding facts at the level of fact insertion, but
  //   that caused major problems if a relation has aggregation
  //   (even if non-recursive) as well as prioritize.  The trouble is that
  //   if facts are hidden during aggregation, the result of aggregation is
  //   garbage.  So now facts are hidden only when they are moved out of the
  //   delta relations.
  //
  // The priority code works as follows.
  // a)  get rmarks on prioritized relations even before exit rules,
  // b)  after each iteration or exit rule firing, move tuples from
  //     deltas to the hidden relation, instead of to the previous
  //   delta relation, if the relation uses priority.
  ******/

  if (rec_rule_start == numSNRules) {
    /*** if (rm_Arr) delete rm_Arr ;    ****/
    if (rm_Arr)
     for (i = 0; i< rm_Arr->array_size; i++) {
       rm_Arr->markList[i] = NULL ;
      }

     if (iterator) iterator->state->rm_Arr = NULL;
     if (has_hidden_relations) {  // Shouldn't happen normally, since the
              // annotation is meaningless in this case.
              // To be safe, unhide all hidden facts.
        clean_hidden_relations(F);
     }
#ifdef DO_PROFILE
     if ((exEnv.GlobalRelationOptions | module->rel_options) &
			REL_PROFILE_STATS)
        EndOfScc(this, 0, exEnv.trace_file) ;
#endif
     return;
  }

  // loop_iter_num is useful for SaveModules since the first time
  // around, the old RMarks correspond to global old pointers and 
  // should not be deleted

  int loop_iter_num = 0;
  int ret_val = 1;

  // Evaluate recursive rules
  if (iterator) {
    // if staggered evaluation is being used, then the iter number is
    // actually stored in the iterator's state, and not in the variable
    // loop_iter_num.
    for(;ret_val;)
      if ((ret_val = iterateRecursiveRules(F, rm_Arr, ++loop_iter_num,
                                      iterator->state->iter_number)) &&
	  ret_val != 2) return;
  }
  else {
    while (ret_val = iterateRecursiveRules(F, rm_Arr, ++loop_iter_num, loop_iter_num));

/****
    for(;ret_val;) {
      ret_val = iterateRecursiveRules(F, rm_Arr, ++loop_iter_num, loop_iter_num);
     }
*****/

  }
  
  // since the loop is going through at least once, these marks 
  // will not be the global old marks 

  for (i=0; i < numPreds; i++)
    F->rels[offset_arr[i]].relPtr->freeMark(rm_Arr->markList[2*i]) ;

     for (i = 0; i< rm_Arr->array_size; i++) {
       rm_Arr->markList[i] = NULL ;
      }



  if (iterator) iterator->state->rm_Arr = NULL;

#ifdef DO_PROFILE
     if ((exEnv.GlobalRelationOptions | module->rel_options) &
			REL_PROFILE_STATS)
        EndOfScc(this, loop_iter_num, exEnv.trace_file) ;
#endif
}


void SccInfo::clean_hidden_relations(Table *F) 
{
  for(int i=0; i < numPreds; i++) {
    if(has_hidden_relations  &&
       F->rels[offset_arr[i]].relPtr->priority_info)
       ((StorageRelation*)(F->rels[offset_arr[i]].relPtr))->pop_all_from_hidden_relation();
  }
}


void QFMaterializedModuleData::clean_cache()
{
	for (int i = 0; i < numSccs; sccArray[i++]->clean_cache()) ;
}

/*
 * iterator is guaranteed to be either NULL, or have a state field allocated.
 * If iterator->state->rm_Arr is NULL, it implies that this is the first
 * time this module is being invoked using this iterator
 */
void QFMaterializedModuleData::Solve(Table *table, TupleIterator *iterator)
{
  if (!(iterator) || !(iterator->state->rm_Arr)) { 
    clean_cache();	
    // This is conservative.  In most cases it is 
    // not needed

    for (int i = 0; i < numSccs-1; i++) {
      sccArray[i]->Solve(table);
    }
  }
  sccArray[numSccs-1]->Solve(table, iterator);
  if (iterator) iterator->state->iter_number++;
}



/*** WARNING  - with recursion deeper than 
	exEnv.C_max_recursion_depth_default this code will complain and abort.
*******/

StorageRelation *find_local_relation(Name name, int arity)
{
    if (T_Stack.count <= 0 || T_Stack.top() == NULL)
	return NULL;
    int offset = get_offset(T_Stack.top(), name, arity,
			/* print_error */ 0);
    if (offset < 0)
	return NULL;

    return (StorageRelation*)(T_Stack.top()->rels[offset].relPtr);
}

extern Relation *Find_External_Relation(Name name, int arity);

/* Initialize the cached Relation pointers. */


// Used by psn to determine whether to insert the query tuple before
// evaluating the scc, or during scc evaluation. the function in_scc
// returns non-zero if the Relation rel corresponds to one of the
// recursive predicates of the scc.
static int in_scc(SccInfo *scc, StorageRelation *rel)
{
  for (int i = 0; i < scc->numPreds; i++)
    {
      if ((scc->pred_ptrs[i]->name == rel->name) &&
	  (scc->pred_ptrs[i]->arity == rel->arity())) return 1;
    }
  return 0;
}
static void init_rule_pointers(Table *F, QFModuleData *md,
			StorageRelation *magic, int reused_table, 
			int old_magic_relation)
{
 StorageRelation *temp, *temprel;
 ModulePred *predicates = md->predicates->next;
 F->moduledata = md;

 // check whether it is a non SaveModule or the first invocation of a SaveModule
 int new_init = ((!md->module_info.SaveModule) || (! ((QFMaterializedModuleData *) md)->saved_state));
 
 for (; predicates; predicates = predicates->next) { 
   Name name = predicates->pred->name;
   int arity = predicates->pred->arity;
   int offset = predicates->offset;
   switch (predicates->kind) {
    case ExternalPredKind: 
     /********************** 
      * If reused_table is set, we should be able to avoid the 
      * overhead of finding external relations all over again.  
      * However if anything has changed externally (say, because 
      * of a rel_close), we need to do this.
      * Perhaps we should maintain a flag and find relations again
      * only if required
      **********************/ 
     F->rels[offset].AssignRel(Find_External_Relation(name, arity));
     F->rels[offset].relPtr->local_options = md->rel_options | exEnv.GlobalRelationOptions;
     break;
    case QueryPredKind:
     if (new_init) {
       /***********
	* the condition tested is not (! reused_table) as for 
	* LocalPredKind below since answer relations are used 
	* at the calling point even after the table is returned 
	* to the free table list.
	***********/
       if (predicates->disk_rel) {
	 temp = MAKE_PERS_REL_MACRO(name, arity, md->module_info.IndexDeltas, 
				    predicates->check_subsum, predicates->schema_def);
	 F->rels[offset].AssignRel(temp);
	 temp->ordsearch = md->module_info.UseOrdSearch;
	 if ((md->module_info.SaveModule) && (! ((QFMaterializedModuleData *) md)->saved_state)) {
	   temp->getMark();
	  }
	}
       
       else {
	 temp = make_local_relation(name, arity, md->module_info.IndexDeltas, predicates->check_subsum);
	 F->rels[offset].AssignRel(temp);
	 temp->ordsearch = md->module_info.UseOrdSearch;
	 if ((md->module_info.SaveModule) &&
	     (! ((QFMaterializedModuleData *) md)->saved_state)) {
	   temp->getMark();
	  }
	}
       F->rels[offset].relPtr->local_options = md->rel_options | exEnv.GlobalRelationOptions;
      }
     break;

    case LocalPredKind:
     if (! reused_table) { 
       // Relation not already set up. With SaveModules, the relation should also have all
       // the tuples computed until the last time.
				 
       ASSERT(new_init != 0)
       
       if (predicates->disk_rel)
	 temp = MAKE_PERS_REL_MACRO(name, arity, md->module_info.IndexDeltas, 
				    predicates->check_subsum, predicates->schema_def);
       else
	 temp = make_local_relation(name, arity, md->module_info.IndexDeltas, predicates->check_subsum);
       
       F->rels[offset].AssignRel(temp);
       temp->ordsearch = md->module_info.UseOrdSearch;       
       if ((md->module_info.SaveModule) &&
	     (! ((QFMaterializedModuleData *) md)->saved_state)) {
	 temp->getMark();
	}
      }
     else {
       F->rels[offset].relPtr->local_options = md->rel_options | exEnv.GlobalRelationOptions;
       continue;
      }
     
     F->rels[offset].relPtr->local_options = md->rel_options | exEnv.GlobalRelationOptions;
     break;
     
    case MagicQueryPredKind:
     if ((md->module_info.UseOrdSearch) && (! F->context)) {
       F->context = new Context();
      }
     
     if (new_init) {
       if (predicates->disk_rel)
	 F->rels[offset].AssignRel(MAKE_PERS_REL_MACRO(name, arity, md->module_info.IndexDeltas, 
						       predicates->check_subsum, predicates->schema_def));
       else
	 F->rels[offset].AssignRel(make_local_relation(name, arity, md->module_info.IndexDeltas, 
						       predicates->check_subsum));
       old_magic_relation = 0;
       if ((md->module_info.SaveModule) &&
	     (! ((QFMaterializedModuleData *) md)->saved_state)) {
	 ((StorageRelation *)(F->rels[offset].relPtr))->getMark();
	}
      }
     // else retain the old relation 
       
     // NOTE: the tuples in "magic" have not been added as yet
     temprel = (StorageRelation *)(F->rels[offset].relPtr);
     temprel->ordsearch = md->module_info.UseOrdSearch;
     temprel->r_kind = COR_R_MAGIC;
     
     if (md->module_info.UseOrdSearch) { 
       if (! temprel->for_ordsearch) {
	 temprel->for_ordsearch = new HashSimpleRelation(arity);
	}
       magic->add_all_goals(temprel->for_ordsearch, F->context, temprel);       
      }

     temprel->local_options = md->rel_options | exEnv.GlobalRelationOptions;

     break;
     //  From this point on, the passed in relation "magic"
     // is useless.  However, it gets reclaimed only in 
     // clear_rule_pointers.
     
    }
   
   struct AnnoStruct *cur;
   
   for(cur= predicates->index_annos; cur; cur=cur->next) {
     if (cur->anno->arglist2)
       F->rels[offset].relPtr->add_index(cur->anno->arglist1, cur->num_vars, cur->anno->arglist2) ;
     else F->rels[offset].relPtr->add_index(cur->anno->arglist1) ;
    }
   
   for(cur= predicates->aggsel_annos; cur; cur=cur->next)
     F->rels[offset].relPtr->add_agg_sel_anno(cur->anno);
   
   for(cur = predicates->prior_annos; cur; cur=cur->next)
     F->rels[offset].relPtr->add_prioritize_info(cur->anno);

   if (predicates->kind == MagicQueryPredKind) {
     if (!md->module_info.UseOrdSearch) {
       // first add the tuples in "magic" to the relation
       // there could be marks because of save modules
       magic->add_all_tuples((StorageRelation *)(F->rels[offset].relPtr), 
			     1, // take marks into account 
			     1) ; // can check for duplicates
			     
       if (((QFMaterializedModuleData *)md)->use_psn) {
	 MagicRelation = (StorageRelation *)(F->rels[offset].relPtr);
	 if (!in_scc(((QFMaterializedModuleData *)md)->sccArray[0],
		     MagicRelation)) {
	   MagicRelation->insert_new(*MagicArgs, MagicBindEnv);
	   MagicRelation = NULL;
	   MagicArgs  = NULL; MagicBindEnv = NULL;
	  }
	}
      }
     else { 
       // get the fact from the Context
       int any_new_fact_in_done = 0;
       GoalNode *g_node = F->context->get_unmarked_goal(any_new_fact_in_done);
       
       ASSERT((g_node != NULL));
       ASSERT((g_node->owner_rel == F->rels[offset].relPtr)) ;
       if ((!md->module_info.SaveModule) || 
	   (! g_node->owner_rel->check_subsum) ||
	   (! g_node->owner_rel->is_subsumed(g_node)))
	 g_node->owner_rel->insert_tuple(g_node);
      }

    } // if (predicates->kind == MagicQueryPredKind)

  } // for all predicates

}


static int occurs_in_module(ModulePred *predicates, Name name)
{
 for (predicates = predicates->next; predicates; predicates = predicates->next) {
   if (name->equals(predicates->pred->name)) return 1;
  }
 return 0;
}

static void clear_rule_pointers(Table *F, QFModuleData *md, StorageRelation *magic)
{
 StorageRelation *temp, *temprel;
 ModulePred *predicates = md->predicates->next;
 F->moduledata = md;

 for (; predicates; predicates = predicates->next) { 
   Name name = predicates->pred->name;
   int arity = predicates->pred->arity;
   int offset = predicates->offset;
   StorageRelation *temprel = (StorageRelation *)(F->rels[offset].relPtr);
   switch (predicates->kind) {
    case ExternalPredKind: 
     break;
    case QueryPredKind:
     if ((md->module_info.SaveModule) &&
	 (! ((QFMaterializedModuleData *) md)->saved_state)) {
       temprel->free_allMarks();
      }
     if (md->module_info.SaveModule) {
       temprel->getMark();
      }
     break;
    case LocalPredKind: {
      if (temprel->for_ordsearch) {
	// this can be done even for SaveModules
	temprel->for_ordsearch->empty_relation(0);
       }
      
      if (! md->module_info.SaveModule) {	
	if (temprel->mp_done_reln && !occurs_in_module(md->predicates, temprel->mp_done_reln->name)) {
	  // for OrdSearch
	  temprel->mp_done_reln->empty_relation(0);
	 }
	
	// the mp_done relation does not have copies of tuples
	if (is_mp_done(temprel->name))
	  temprel->empty_relation(0);
	else
	  reclaim_relation(temprel);	
       }
      
      else { // get appropriate mark after releasing previous marks
	temprel->free_allMarks();
	temprel->getMark();
	if (temprel->mp_done_reln && !occurs_in_module(md->predicates, temprel->mp_done_reln->name)) {
	  temprel->mp_done_reln->free_allMarks();
	  temprel->mp_done_reln->getMark();
	 }
       }
      break;
     }
    case MagicQueryPredKind: {
      if (!md->module_info.SaveModule) {
	
	temprel->ordsearch = 0; 
	// else Ordered Search will crash the next time around
	
	if (temprel->mp_done_reln && 
	    !occurs_in_module(md->predicates, temprel->mp_done_reln->name)) {
	  temprel->mp_done_reln->empty_relation(0);
	 }
       }
      else { // get appropriate mark after releasing previous marks
	temprel->free_allMarks();
	temprel->getMark();
	if (temprel->mp_done_reln && !occurs_in_module(md->predicates, temprel->mp_done_reln->name)) {
	  temprel->mp_done_reln->free_allMarks();
	  temprel->mp_done_reln->getMark();
	 }
       }
      
      if (temprel->for_ordsearch) {
	// this can be done even for SaveModules
	temprel->for_ordsearch->empty_relation(0);
       }
      
      if (! md->module_info.SaveModule) {
	// Change to reclaim some of the memory that is being wasted here
	//temprel->empty_relation( /*deleteTuples =*/ 1 );
	reclaim_relation(temprel);
	F->rels[offset].relPtr = NULL;
       }
      break;
     }
    }

  }

 // reclaim "magic" 
 magic->empty_relation(0);
 magic->ordsearch=0;
 // else Ordered Search will crash the next time around

 if (md->module_info.SaveModule) {
   ((QFMaterializedModuleData *) md)->saved_state = 1;
  }
 
}



static Table *initialize_do_query(QFModuleData *md, StorageRelation *magic,
                                  int old_magic_relation)
{
    // Make a copy of the table. This is to handle recursive calls to do_query.
    // Each call should see an unmodified Table.
    // Except in the case of SaveModule, where each call should see
    // the result of the last call to the module, and recursive calls
    // through a saved module are disallowed.
  
    Table *table_copy;
    int reused_table = 0;

    if (md->module_info.SaveModule) {
	ASSERT((md->F != NULL));
	ASSERT((md->F->rels != NULL));
	// check whether this module was called for the first time 
	if (((QFMaterializedModuleData *) md)->saved_state) {
	  table_copy = md->F;
	  reused_table = 1;
	  // each call should see the result of the last call to the 
	  // saved module.
	}
	else {
	  table_copy = new Table(md);
	  delete md->F;
	  md->F = table_copy;
	 }
    }
    else {
	  table_copy = new Table(md) ;
    }

    init_rule_pointers(table_copy, md, magic, reused_table, 
			old_magic_relation) ;
  
    return table_copy;
}

void cleanup_do_query(QFModuleData *md, StorageRelation *magic, Table *table_copy)
{
  if (md->module_info.UseOrdSearch) {
    if (table_copy->context) {
      table_copy->context->free_all();
    }
  }
  clear_rule_pointers(table_copy, md, magic) ;

  // probably unnecessary here -- Praveen
  MagicRelation = NULL;
  MagicBindEnv = NULL;
  MagicArgs = NULL;

  clearStatistics((QFMaterializedModuleData *)md, exEnv.trace_file);
}


/*
 * This function is called at run time to execute a query on the module.
 * The magic fact for the query is in the magic relation magic. old_magic_relation
 * specifies if the magic relation is new or old. The iterator is passed in
 * to allow for a staggered bottom-up evaluation mode, where answers at the top
 * level of the module are returned at the end of each iteration of the
 * seminaive loop. This requires that the state of the seminaive computation
 * has to be stored across calls to do_query, and the tuple_iterator is the
 * only structure that can store this state information
 */
StorageRelation *do_query(QFModuleData *md, StorageRelation *magic,
		   int old_magic_relation, TupleIterator *iterator)
{
  Table *table_copy;
  ModuleInfo *temp_module_info;

#ifdef DO_PROFILE
  md->module_info.GlobalProfileInfo.clear();
#endif

  /*
   * If staggered evaluation is not being performed, or this is the
   * first time do_query is being called on this module for this query
   * initialize the table of relations
   */
  if (!(iterator) || !(iterator->state)) {
    /* 
     * Make a copy of the table. This is to handle recursive calls to do_query.
     * Each call should see an unmodified Table.
     */
    table_copy = initialize_do_query(md, magic, old_magic_relation);
  }
  else {
    table_copy = iterator->state->table;
  }

  T_Stack.push(table_copy);
  // THIS SHOULD BE PART OF PUSH !!  PRAVEEN
  temp_module_info = CurrModuleInfo;
  CurrModuleInfo = &(table_copy->moduledata->module_info);

#ifdef DEBUG
  if (exEnv.dbg_modules) {
    fprintf(exEnv.trace_file, "Entering module %s\n");
    fprintf(exEnv.trace_file, "");
   }	
#endif

  StorageRelation *answer_rel = (StorageRelation *)(
    table_copy->rels[get_offset(table_copy, md->export_pred)].relPtr);

  /*
   * for the two cases, save_module + and eager_eval -, staggered evaluation
   * is not executed. Since md->Solve() is called with NULL as the iterator
   * argument, the module is completely evaluated, and the iterator->state
   * field remains NULL
   */
  if (!iterator || md->module_info.SaveModule || 
				!(md->module_info.EagerEval)) {
    // no need to evaluate a no_magic module a second time around
    if ((! md->module_info.SaveModule) || 
      		(! ((QFMaterializedModuleData *) md)->no_magic) ||
		(!((QFMaterializedModuleData *) md)->saved_state)) {
        md->Solve(table_copy, NULL);
    }
    cleanup_do_query(md, magic, table_copy);

    // adding this line to reclaim the magic relation allocated inside the
    // DerivedRel::get_next
    reclaim_relation(magic);

    T_Stack.pop();
  // THIS SHOULD BE PART OF PUSH !!  PRAVEEN
    CurrModuleInfo = temp_module_info;

    return answer_rel;
  }

  /*
   * if this is the first time the module is being called with the iterator,
   * the iterator->state field will be created.
   * otherwise, the existing iterator->state field will be used.
   * when there are no further answers, the state field is deleted and
   * set to NULL by SccInfo::Solve(), and this signifies that the
   * Table and temporary relations can be cleaned up.
   */
  else {
    // this is the first invocation of the module using this iterator
    if (!(iterator->state)) {
      iterator->state = new ModuleExecInfo(md, table_copy, magic, do_query);
    }

    // this sets the rm_Arr field
    md->Solve(table_copy, iterator);

    // if no more answers
    if (!(iterator->state->rm_Arr)) {
      cleanup_do_query(iterator->state->md, iterator->state->magic,
		       iterator->state->table);
      // NOTE that the state->scan_mark field is redundant !!
      delete iterator->state;
      iterator->state = NULL;

      T_Stack.pop(); CurrModuleInfo = temp_module_info;
     // THIS SHOULD BE PART OF PUSH !!  PRAVEEN

      return answer_rel;
    }

    // even for lazy evaluation, pop the table stack, or else,
    // the table stack abstraction is lost !
    T_Stack.pop();
    CurrModuleInfo = temp_module_info;
    // THIS SHOULD BE PART OF PUSH !!  PRAVEEN

    return answer_rel;
  }
}

/*
 * Fille the Table with the appropriate relation pointers
 */

static void fill_table(Table *F)
{
  for (int i = 0; i < F->numRels; i++) {
    F->rels[i].AssignRel(Find_External_Relation(F->rels[i].relName,
						F->rels[i].relArity));
    F->rels[i].relPtr->local_options = exEnv.GlobalRelationOptions;
   }

}

/*
 * Executes a single rule from the parserStruct. This function is invoked
 * from the proutines in arse-actions.C to execute imperative rules
 */

int execute_single_rule(ParserStruct &parserStruct)
{

 if (!parserStruct.snrule) {
   parserStruct.snrule = new SemiNaive;
   
   // get the info out of the parserStruct, and create the RuleInfo
   // structure, relation Table and seminaive rule structure
   compile_single_rule(parserStruct, parserStruct.table, parserStruct.rInfo_arr, 
		       *(parserStruct.snrule));
  }
 
 // fill the table with the appropriate relation pointers
 fill_table(parserStruct.table);
 
 // evaluate the rule using the code in apply.C
 int new_tuples = parserStruct.snrule->evaluate(parserStruct.table);
 
 return new_tuples;
}
