/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifdef __GNUG__
#ifdef USEGNUGPRAGMAS
#pragma implementation
#endif
#endif

#include "hash.h"
#include "rules.h"
#include "externs.h"
#include "derived-rel.h"
#include "pipelined.h"
#include "profile.h"
#include "globals.h"
#include <stdlib.h>
#include <string.h>
#ifdef WITH_PERSISTENCE
#include "persistent-rel.h"
#endif

extern void sprint_magic_name(char *buf, char *predname, BitVector *adorn);
extern void print_adornment_brack(BitVector& a, FILE *file);
extern void sprint_adornment(char *buf, BitVector* a);
extern char *simplify_index(ArgList *pat, int n_var, ArgList *boundvars);
extern int count_var_list(VarLink *rest);

extern void print_Annotations(ModuleInfo&, FILE *, PredAnnotations *,
			      PredAnnotations *, PredAnnotations *,
			      PredAnnotations *, PredAnnotations *,
			      PredAnnotations *);

extern ArgList *MagicArgs;
extern BindEnv *MagicBindEnv;
extern StorageRelation *MagicRelation;
extern Association * DeleteInTab(struct SymbolTable *tab, ConstPointer arg);

/** in interp.C **/
extern void cleanup_do_query(QFModuleData *md,
			     StorageRelation *magic, Table *table_copy);

extern int is_magic(Name name);
extern int is_mp_done(Name name);
extern is_supp(Name name);

void reclaim_relation(StorageRelation *rel)
{
#ifdef WITH_PERSISTENCE
 if (rel->r_kind == COR_R_EXODUS)
   delete ((PersistentRel *)rel);
 else
#endif
   delete ((HashSimpleRelation *)rel);

}

void reclaim_index(GenericIndex *index, RelationKind r_kind)
{
 if (!index) return;
#ifdef WITH_PERSISTENCE
 if (r_kind == COR_R_EXODUS)
   delete ((PersistentIndex *)index);
 else
#endif
   delete ((HashIndex *)index);

}

DerivedRelation::DerivedRelation(Name _name, int new_arity)
{
    name = _name;
    _arity = new_arity;
    methods = NULL;
    has_release = 1;
    r_kind = COR_R_DERIVED;
}

DerivedRelation::~DerivedRelation()
{
  DerivedMethod *meth = methods, *next_meth;
  while (meth) {
    next_meth = meth->next;
    delete meth ;
    meth = next_meth ;
  }
}

DerivedMethod::DerivedMethod(Name name,
				 BitVector& adorn,
				 InterpDerivedSolver solvr,
				 QFModuleData *module
				)
: adornment(adorn)
{
  DerivedRelation *rel ;

  valid_method = 1;
  md = module ;
  if (CurDB->RelationTable == NULL) {
    CurDB->RelationTable = AllocTab(COR_RELATION_TABLE_INCR, NULL);
  }

  char      buf[1000];

  strcpy(buf, SymbolString(name));
  sprint_adornment(buf+strlen(buf), &adorn);
  Name check_name = EnterSymbol(buf);
  
  if (is_magic(check_name)  || is_supp(check_name) || is_mp_done(check_name)) {
    fprintf(exEnv.error_file, "Warning::relation name %s conflicts with system reserved names !\n",
	    buf);
    fprintf(exEnv.error_file, "New definition not retained !\n");
    return;
   }
  else
    sprintf(buf, "%s", SymbolString(name));
  
  Name new_name = EnterSymbol(buf);

  Association *ptr = SymbolLookup(CurDB->RelationTable, new_name);
  if (HashNone(ptr->arg)) {
    ptr->arg = new_name;
    if (module->kindof() == COR_PIPELINED) {
      ptr->val = new PipelinedDerivedRelation((QFPipelinedModuleData *) md,
						new_name, adorn.len());
      md = NULL; /* this field is not used by pipelined relations. instead
		    the ModuleData is stored along with the relation */
    }
    else
      ptr->val = new DerivedRelation(new_name, adorn.len());
    ((Relation *)(ptr->val))->single_success = module->module_info.SingleAnswer;
    TabInserted(CurDB->RelationTable, ptr);
  }
  else {
    Relation *rel1 = (Relation *)(ptr->val);

    // search methods already defined to see if there is a conflict
    if (rel1->r_kind != COR_R_DERIVED) {
      fprintf(exEnv.error_file, "Base relation %s already exists !\n",
	      SymbolString(new_name));
      fprintf(exEnv.error_file, "Newer definition is NOT retained !\n");
      return;
    }

    rel = (DerivedRelation*)(ptr->val) ;
    DerivedMethod *meth = rel->methods;
    /* 
     * three cases : 
     *          1) the new definition is a pipelined relation. in this case,
     * we have to first delete the original relation, and insert the new one
     *          2) the new definition is a Derived relation, and the old
     * definition is a pipelined relation. in this case too, we have to first
     * delete the original relation, and insert the new one.
     *          3) both definitions are Derived relations. only the
     * ModuleData need be replaced
     */
    if (!meth->md || (module->kindof() == COR_PIPELINED)) {
      fprintf(exEnv.error_file, "Duplicate definition of relation %s\n",
	      SymbolString(new_name));
      fprintf(exEnv.error_file, "Retaining newer definition\n");

      DeleteInTab(CurDB->RelationTable, rel->name);
      // delete the old relation, and all its methods
      delete rel;

      ptr->arg = new_name;
      if (module->kindof() == COR_PIPELINED) {
	ptr->val = new PipelinedDerivedRelation((QFPipelinedModuleData *)md,
						    new_name, adorn.len());
	md = NULL; // this field is not used by pipelined relations. instead
	  // the ModuleData is stored along with the relation 
	  }
      else {
	ptr->val = new DerivedRelation(new_name, adorn.len());
      }
      ((Relation *)(ptr->val))->single_success = module->module_info.SingleAnswer;
      TabInserted(CurDB->RelationTable, ptr);
      rel = (DerivedRelation*)(ptr->val);
      next = rel->methods;
      rel->methods = this;
      interp_solver = solvr;
      return;
    }

    while (meth) {
      if (meth->valid_method && (meth->adornment==adorn)) {
	fprintf(exEnv.error_file, "Duplicate definition with identical adornment\n");
	fprintf(exEnv.error_file, "Retaining newer definition of %s",
		SymbolString(new_name));
	print_adornment(adorn, exEnv.error_file);
	fprintf(exEnv.error_file, "\n");

	meth->interp_solver = solvr;
	if (meth->md) delete meth->md ;
	meth->md = md;
	return ;
      }
      meth = meth->next;
    }
  }


  rel = (DerivedRelation*)(ptr->val);
  next = rel->methods;
  rel->methods = this;
  interp_solver = solvr;
}


DerivedMethod::~DerivedMethod()
{
  if (md) delete md ;
}

BindEnv * DerivedRelation::get_next(TupleIterator& iterator)
{
 this->get_next_tuple(iterator) ;
 if (iterator.no_match()) return NULL;
 return(iterator.bindenv) ;
}

Tuple * DerivedRelation::get_next_tuple(TupleIterator& iterator)
{
#ifdef DO_PROFILE
   if (T_Stack.count > 0)
     (T_Stack.cur_md()->module_info.GlobalProfileInfo.getnexts)++;
   else
     (GlobalProfileInfo.getnexts)++ ;
#endif
  
  int i; StorageRelation* tuples; TupleIterator* tuples_iterator;
  if (iterator.ipos++ == 0) {

    BindEnv *env = iterator.bindenv;
    iterator.tuple_env = NULL;
  
    int arity = iterator.arg_list.count();
    // Find adornment of query.
    BitVector adornment(arity);

    for (i = 0; i < arity; i++) {
      // new stuff
      Term term1 (iterator.arg_list[i], iterator.bindenv);
      FULL_DEREFERENCE_TERM (term1);
      TermLink *rv = NULL;
      if ((term1.expr->simplify(iterator.bindenv, rv,
			       iterator.bindenv, NULL))->isConstant())
	adornment.set(i, 1);
      else
	adornment.set(i, 0);
    }

    /*  Find a method that matches the query's adornment. */

    DerivedMethod *method;
    // Best method with insufficent 'b' (where query is 'f').
    DerivedMethod *best_underbound_method = NULL;;
    // Count of 'b's short in best_underbound_method.
    int best_underbound_shortfall = arity + 1;
    // Best method with excess 'b' (where query is 'f').
    DerivedMethod *best_overbound_method = NULL;;
    int least_overbound_excess = arity + 1;
    
    for (method = methods; ; method = method->next) {
      int adorn_delta[3];
      if (method == NULL) {
	if ((method = best_underbound_method) != NULL) {
	  if (best_underbound_shortfall && !exEnv.C_quiet_mode_default) {
	    fprintf(exEnv.error_file,
		    "CORAL::Warning : Using underbound method ");
	    (method->adornment).printon(exEnv.error_file);
	    fprintf(exEnv.error_file, " for %s ", SymbolString(name));
	    adornment.printon(exEnv.error_file);
	    fprintf(exEnv.error_file, "!\n");	    
	  }
	  break;
	}
	if ((method = best_overbound_method) != NULL) {
	  if (least_overbound_excess && !exEnv.C_quiet_mode_default) {
	    fprintf(exEnv.error_file,
		    "CORAL::Warning : Using overbound method ");
	    (method->adornment).printon(exEnv.error_file);
	    fprintf(exEnv.error_file, " for %s ", SymbolString(name));
	    adornment.printon(exEnv.error_file);
	    fprintf(exEnv.error_file, "!\n");	    
	    if (method->md->module_info.UseOrdSearch) {
	      fprintf(exEnv.error_file,
		      "CORAL:: Cannot use Ordered Search with overbound method!");
	      fprintf(exEnv.error_file, " Sorry !\n");
	      iterator.set_no_match();
	      return NULL;
	    }
	  }
	  break;
	}
	fprintf(exEnv.error_file,
		"No rule matches the query %s (with adornment ",
		SymbolString(name));
	print_adornment(adornment, exEnv.error_file);
	fprintf(exEnv.error_file, ")!\n");
	iterator.set_no_match();
	return NULL;
      }
      if (!method->valid_method) continue;

      int i = adornment.len();
      if (i != method->adornment.len())
	continue;
      // Use adorn_delta to summarizes the difference between
      // adornment (from the query) and method->adornment.
      // adorn_delta[0] counts bits where adornment is 'f' (0)
      // and method.adornment is 'b' (1).
      // adorn_delta[1] counts bits where the adornments are equal.
      // adorn_delta[2] counts bits where adornment is 'b'
      //   and method.adornment is 'f'.
      adorn_delta[0] = 0;
      adorn_delta[1] = 0;
      adorn_delta[2] = 0;
      while (--i >= 0)
	adorn_delta[1+adornment.test(i)-method->adornment.test(i)]++;
      if (adorn_delta[0] + adorn_delta[2] == 0) // Exact match.
	break;
      if (adorn_delta[0] == 0
	  && best_underbound_shortfall > adorn_delta[2]) {
	// adornment.implies(method->adornment)
	best_underbound_method = method;
	best_underbound_shortfall = adorn_delta[2];
      }
      else if (least_overbound_excess > adorn_delta[0]) {
	// adornment.implies(method->adornment)
        best_overbound_method = method;
	least_overbound_excess = adorn_delta[0];
      }
    }
    
#ifdef DO_EXPLAIN
    /** Tarun **/
    if ((method->md->rel_options | exEnv.GlobalRelationOptions) & REL_EXPLAIN)
      {
        char * file_name =
          new char [sizeof(SymbolString(method->md->export_pred->name))+30] ;
        sprintf(file_name, "dump_directory/%s.d",
             SymbolString(method->md->export_pred->name));
        FILE *fd;
        if (!(fd  = fopen(file_name, "a")))
         {
            CORAL_error(COR_CANNOT_OPEN_FILE, file_name, "explain");
            delete [] file_name;
            return 0;
         }
        method->md->module_info.file_desc = fd;
        fprintf(method->md->module_info.file_desc, "coral.\n");
        delete [] file_name;
      }
#endif


    iterator.moduledata =  method->md;

    StackMark stack_mark;
    
    // Insert the magic tuple.
    int magic_arity = method->adornment.count();
    ArgList* magic_args = ArgList::New(magic_arity);
    int arg_bit = -1;
    for (i = 0; i < magic_arity; i++) {
      arg_bit = method->adornment.next(arg_bit);
      (*magic_args)[i] = iterator.arg_list[arg_bit];
    }
    
    StorageRelation *magic_rel;
    int old_magic_rel = 0;
    
/*****
    if (method->md && method->md->free_query_relations) {
      RelationLink *tmp = iterator.moduledata->free_query_relations;
      magic_rel = tmp->reln;
      magic_rel->local_options = method->md->rel_options | 
	                            exEnv.GlobalRelationOptions;
      iterator.moduledata->free_query_relations = tmp->next;
      delete tmp;
      old_magic_rel = 1;
    }
    else 
*****/
   {
      /* WARNING: Dangerous in case of an overflow!!*/
      char magic_name[200];
      sprint_magic_name(magic_name, SymbolString(name), &(method->adornment));
      magic_rel = 
	make_local_relation(EnterSymbol(magic_name), magic_arity,
			    method->md->module_info.IndexDeltas);
      magic_rel->local_options = method->md->rel_options ;
    }
    

    if (((QFMaterializedModuleData *)(method->md))->use_psn) {
      MagicArgs = magic_args;
      MagicBindEnv = iterator.bindenv;
    }
    else
      magic_rel->insert_new(*magic_args, iterator.bindenv);
    
    // Solve the query.
    tuples = (*method->interp_solver)(method->md, magic_rel,
					old_magic_rel, &iterator);
    
    stack_mark.pop_to();
    
    RMark *endmark = NULL;
    if (iterator.moduledata->module_info.SaveModule) {
      ASSERT(tuples->headMark.prev != & (tuples->headMark));
      endmark = tuples->headMark.prev ;
      /*
      // this mark was grabbed by clear_rule_pointers after it 
      // completed evaluation of the query
      // with SaveModules, the relation should only be scanned
      // until endmark, since more facts could be added to it
      // by subsequent executions of this module, even though 
      // we haven't finished scanning this Derived relation
      */
    }

    tuples_iterator =
      new TupleIterator(tuples, iterator.arg_list, env, NULL, endmark);

    iterator.answer_iterator = tuples_iterator;
    tuples_iterator->state = iterator.state;
    
  }
  else {
    tuples_iterator = iterator.answer_iterator;
    tuples = (StorageRelation *)(tuples_iterator->relation);
  }
  
  Tuple *tuple = tuples->get_next_tuple(*tuples_iterator);
  
  // Careful here - we are returning a different tuple iterator, and
  // must make sure all necessary arguments are copied over as required.

  while (tuples_iterator->no_match() && iterator.state) {
    iterator.reset_no_match();
    (*(iterator.state)->solver)((iterator.state)->md,
					(iterator.state)->magic,
					0, &iterator);
    tuple = tuples->get_next_tuple(*tuples_iterator);
  }

  if (tuples_iterator->no_match()) {
    iterator.set_no_match();
    tuple = NULL;
  }
  else {
    iterator.reset_no_match();
    iterator.tuple_env = tuples_iterator->tuple_env;
    tuples_iterator->tuple_env = NULL;
  }
  
  return tuple;
}


/* WARNING:: This function may be called multiple times on an iterator.
	It must make sure things are not deleted multiple times.
 */
void DerivedRelation::release(TupleIterator& iterator)
{
    if (iterator.answer_iterator)  {
    	TupleIterator *tuples_iterator = iterator.answer_iterator;
        StorageRelation *tuples = (StorageRelation *)tuples_iterator->relation;

	if (iterator.state) {
	  // in the case of lazy evaluation, it is possible that
	  // there may still be some saved state. this happens when
	  // a cut is used to suddenly terminate a computation

	  if (iterator.state->rm_Arr) delete iterator.state->rm_Arr ;
	  cleanup_do_query(iterator.state->md, iterator.state->magic,
			   iterator.state->table);
	  delete iterator.state;
	  iterator.state = NULL;
	}
	

	if (! iterator.moduledata->module_info.SaveModule) {
            //tuples->empty_relation(/*deleteTuples=*/ 1) ;
            reclaim_relation(tuples);
            tuples_iterator->relation = NULL;
	}
	else { 
	    // NOTE: Several calls can be setup on the same module 
	    // within the evaluation of a single rule due to the 
	    // occurrence of several body literals with the same 
	    // predicate name.  Because of the nested-loops join
	    // strategy, marks are setup and should be released
	    // in stack-order, i.e., the last mark on the relation
	    // should be released

	    ASSERT(tuples->headMark.prev != & (tuples->headMark));
	    // should free the mark used by tuples_iterator and get a 
	    // mark corresponding to the new end of relation
	    RMark *endmark = tuples_iterator->end_mark;
	    ((HashSimpleRelation *)tuples)->freeMark(endmark);
	    // grab a new last mark for the answer relation
	    tuples->getMark();
	}
        delete tuples_iterator;
	iterator.answer_iterator = NULL;
    }
}


void DerivedRelation::print_name(FILE *outf)
{
  DerivedMethod *method;
  int i = 0;
  int j = 0;
  char buf[500];
  VarLink *rest;

  for (method = methods; method ; method = method->next) {

    if (!method->valid_method) continue;

    sprintf(buf, "%s", SymbolString(name));
    sprint_adornment(buf+strlen(buf), &(method->adornment));
    fprintf(outf, "%15s/%d  : (derived) ", buf, arity());
    fprintf(outf, ": indexes ");
    PredAnnotations *cur;
    for(cur= method->md->index_annotations; cur; cur=cur->next()) {
      if ((cur->pred == EnterSymbol(buf)) || (cur->pred == name)) {
	if (!cur->arglist2 )
	  cur->arglist1->printon(outf);
	else {
	  rest = cur->arglist1->var_list(NULL);
	  rest = cur->arglist2->var_list(rest);
	  char *argindex = simplify_index(cur->arglist1,
					  count_var_list(rest),cur->arglist2);
	  if (argindex) 
	    fprintf(outf, "%s", argindex);
	  else {	
	    fprintf(outf, "(");
	    cur->arglist1->printon(outf);
	    fprintf(outf, ")(");
	    cur->arglist2->printon(outf);	    
	    fprintf(outf, ")");
	  }
	}
	fprintf(outf, " ");
      }
    }
    fprintf(outf, "\n");
  }
}

void DerivedRelation::print_facts(FILE *outf, ArgList *) const
{
  DerivedMethod *meth = methods;
  while (meth) {
    if (meth->valid_method) {
      fprintf(outf, "module %s.\n", SymbolString(name));
      fprintf(outf, "export %s[", SymbolString(name));
      print_adornment_brack(meth->adornment, outf);
      fprintf(outf, "].\n");
      print_Annotations(meth->md->module_info,
			outf,
			meth->md->index_annotations ,
			meth->md->agg_sel_annotations ,
			NULL,
			meth->md->multiset_annotations ,
			meth->md->prioritize_annotations,
			meth->md->diskrel_annotations) ;
      
      meth->md->ruleArray->printon(outf);
      fprintf(outf, "end_module.\n");
    }
    meth = meth->next ;
  }
  
}


int DerivedRelation::insert_new(ArgList& , BindEnv*, BindEnv*,
				  Tuple* , int)
{
    CORAL_error(COR_BAD_TUPLE_INSERT, name->string(),"insert_new");
    return -1;
}

int orOptionToRelation(Relation *rel, char *adorn_form, RelationOptions opt)
{
  if ((rel->r_kind != COR_R_DERIVED) && (rel->r_kind != COR_R_ANSWER)) {
    fprintf(exEnv.error_file, "CORAL::Error: Relation is not a derived relation\n");
    return 0;
  }

  BitVector* bv = new BitVector(rel->arity());
  
  for(int i = 0; i < rel->arity(); i++, adorn_form++) {
    if(*adorn_form == 0) {
      fprintf(exEnv.error_file, "CORAL::Error: adornment too short");
      fprintf(exEnv.error_file, "    --- arity of %s=%d, adorn len=%d)\n", 
	      rel->name->string(), rel->arity(), i);
      delete bv;
      return 0;
    }
    if (*adorn_form == 'b' || *adorn_form == '1')
      bv->set(i);
  }

  if (*adorn_form != 0) {
    fprintf(exEnv.error_file, "CORAL::Error: adornment too long");
    fprintf(exEnv.error_file, "    --- arity of %s=%d, adorn len=%d)\n", 
	    rel->name->string(), rel->arity(), i); 
    delete bv;
    return 0;
  }

  DerivedMethod *meth = ((DerivedRelation *)rel)->methods;
  while (meth) {
    if (meth->valid_method && (meth->adornment==*bv)) {
      meth->md->rel_options |= opt;
      delete bv;
      return 1;
    }
    meth = meth->next ;
  }
  delete bv;
  fprintf(exEnv.error_file, "CORAL::Error: cannot find the adorned relation\n");
  return 1;
}

int andOptionToRelation(Relation *rel, char *adorn_form, RelationOptions opt)
{
  if ((rel->r_kind != COR_R_DERIVED) && (rel->r_kind != COR_R_ANSWER)) {
    fprintf(exEnv.error_file, "CORAL::Error: Relation is not a derived relation\n");
    return 0;
  }

  BitVector* bv = new BitVector(rel->arity());
  
  for(int i = 0; i < rel->arity(); i++, adorn_form++) {
    if(*adorn_form == 0) {
      fprintf(exEnv.error_file, "CORAL::Error: adornment too short");
      fprintf(exEnv.error_file, "    --- arity of %s=%d, adorn len=%d)\n", 
	      rel->name->string(), rel->arity(), i);
      delete bv;
      return 0;
    }
    if (*adorn_form == 'b' || *adorn_form == '1')
      bv->set(i);
  }

  if (*adorn_form != 0) {
    fprintf(exEnv.error_file, "CORAL::Error: adornment too long");
    fprintf(exEnv.error_file, "    --- arity of %s=%d, adorn len=%d)\n", 
	    rel->name->string(), rel->arity(), i); 
    delete bv;
    return 0;
  }

  DerivedMethod *meth = ((DerivedRelation *)rel)->methods;
  while (meth) {
    if (meth->valid_method && (meth->adornment==*bv)) {
      meth->md->rel_options &= opt;
      delete bv;
      return 1;
    }
    meth = meth->next ;
  }
  delete bv;
  fprintf(exEnv.error_file, "CORAL::Error: cannot find the adorned relation\n");
  return 1;
}
