/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdio.h>
#include <strings.h>
#include "coral-includes.h"

extern "C" int yyparse();
extern int DisplayFile(char *);
extern int set_print_file(char *file_name);


/*--------------------------------------------------------------- *
NAME : Command_Line_Error 

FUNCTION : Prints error message about command line error

 *--------------------------------------------------------------- */
void Command_Line_Error(char * str)
{
  fprintf(stderr, "Input syntax : %s [-o/O <output-file>][-f/F <input-file1> ...]\n", str);
  fprintf(stderr,"      -a answer_style   Specify answer print style(bindings, tuples or empty\n");
  fprintf(stderr,"      -c                Enable reading of .coralrc startup script\n");
  fprintf(stderr,"      -C                Disable reading of .coralrc startup script\n");
  fprintf(stderr,"      -e                Connect to EXODUS\n");
  fprintf(stderr,"      -E                Do not connect to EXODUS\n");
  fprintf(stderr,"      -f <in_file>%s     Specify input files\n", "+");
  fprintf(stderr,"      -i                Enable interactive mode\n");
  fprintf(stderr,"      -I                Disable interactive mode\n");
  fprintf(stderr,"      -m                Enable creation of.P.M files\n");
  fprintf(stderr,"      -M                Disable creation of.P.M files\n");
  fprintf(stderr,"      -o output_file    Specify output file\n");
  fprintf(stderr,"      -p                Enable prompt printing\n");
  fprintf(stderr,"      -P                Disable prompt printing\n");
  fprintf(stderr,"      -q                Enable quiet mode\n");
  fprintf(stderr,"      -Q                Disable quiet mode\n");
  fprintf(stderr,"      -v                Enable verbose answer display\n");
  fprintf(stderr,"      -V                Disable verbose answer display\n");
  fprintf(stderr,"      -w                Enable insert mode\n");
  fprintf(stderr,"      -W                Disable insert mode\n");

  exit(1);
}

/*--------------------------------------------------------------- *
NAME : GetFilePointers 

FUNCTION : Reads the filenames specified in src_strin, opens the files,
	   and saves the file pointer into f_stack. Also deletes the
	   .M files corresponding to the opened files.

 *--------------------------------------------------------------- */
int GetFilePointers(char ** src_str, FStack& f_stack, int max_files)
{
  int    count = 0 ; FILE *tmp_fd ;
  char temp_str[200];

  while ((count < max_files)&&(*src_str[count] != '-'))
    {
      if (tmp_fd = fopen(src_str[count],"r")) {
	f_stack.push(tmp_fd,0, src_str[count]) ;
	sprintf(temp_str, "%s.M", src_str[count]);
	unlink(temp_str);
      }
      else
	CORAL_error(COR_FILE_NOT_FOUND, src_str[count], "GetFileList");
      count++;
    }
  return(count);
}

void InvertFileStack(FStack& fs1, FStack& fs2)
{
// This line makes sure that the scanner returns finally to stdin
   fs1.push(stdin,0, "stdin") ;
   while(!fs2.is_empty()) {
	fs1.push(fs2.top_file(), fs2.top_file_line(), fs2.top_file_name());
	fs2.pop() ;
   }
}

/*--------------------------------------------------------------- *
NAME : GetAnswerStyle 

FUNCTION : Reads the answer print style from the command line

 *--------------------------------------------------------------- */
int GetAnswerStyle(char ** src_str, int max_args)
{
  char temp_str[200];

  if (max_args <= 0) return 0;

  if (!strcmp(src_str[0], "tuple"))
	exEnv.C_answer_style_default = COR_TUPLE_ANSWER_PRINT;
  else if (!strcmp(src_str[0], "binding"))
	exEnv.C_answer_style_default = COR_BINDING_ANSWER_PRINT;
  else if (!strcmp(src_str[0], "empty"))
	exEnv.C_answer_style_default = COR_EMPTY_ANSWER_PRINT;
  else {
    Command_Line_Error(src_str[0]);
   }

  return 1;
}

main(int ac, char **av)
{
    int		i;
    FStack tmp_fstack ;

    for (i=1; i<ac && *av[i]=='-'; ++i)
      {
	switch (av[i][1])
	  {
	    case 'a':                          /* Answer style */
		if (av[i][2] != '\0') Command_Line_Error(av[0]);

		i += GetAnswerStyle((char **)(av+i+1),(int)(ac - i -1));
		break;

	    case 'c':                     /* Read .coralrc mode ON : default */
		exEnv.C_read_coralrc_default = 1;
		break;
	    case 'C':                     /* Read .coralrc mode OFF */
		exEnv.C_read_coralrc_default = 0;
		break;

	    case 'e':                          /* Connect to EXODUS */
		exEnv.C_connect_exodus_default = 1;
		break;
	    case 'E':                    /* Dont connect to EXODUS : default */
		exEnv.C_connect_exodus_default = 0;
		break;

	    case 'f':                          /* Input files */
	    case 'F':
		if (av[i][2] != '\0') Command_Line_Error(av[0]);

		i += GetFilePointers((char **)(av+i+1), tmp_fstack,
					(int)(ac - i -1));
		break;

	    case 'i':                     /* Interactive mode ON : default */
		exEnv.C_interactive_mode_default = 1;
		break;
	    case 'I':                     /* Interactive mode OFF */
		exEnv.C_interactive_mode_default = 0;
		break;

	    case 'm':                     /* Create .P.M mode ON : default */
		exEnv.C_create_magic_default = 1;
		break;
	    case 'M':                     /* Create .P.M mode OFF */
		exEnv.C_create_magic_default = 0;
		break;

	    case 'o':                      /* Output file */
		if ((av[i][2] != '\0')||(i == ac-1)) Command_Line_Error(av[0]);

		if (!set_print_file(av[++i])) {
		  fprintf(stderr, "%s error: Cannot set print file to %s\n",
			  av[0], av[i]);
		  exit(1);
		}
		break ;

	    case 'p':                          /* Display the prompt : default */
		exEnv.C_print_prompt_default = 1;
		break;
	    case 'P':                          /* Dont display the prompt */
		exEnv.C_print_prompt_default = 0;
		break;

	    case 'q':                          /* Quiet mode ON */
		exEnv.C_quiet_mode_default = 1;
		break;
	    case 'Q':                          /* Quiet mode OFF : default */
		exEnv.C_quiet_mode_default = 0;
		break;

	    case 'v':                     /* Verbose answer display ON : default */
		exEnv.C_verbose_answer_default = 1;
		break;
	    case 'V':                     /* Verbose answer display OFF */
		exEnv.C_verbose_answer_default = 0;
		break;

	    case 'w':                     /* Insert mode ON : default */
		exEnv.C_insert_mode_default = 1;
		break;
	    case 'W':                     /* Insert mode OFF */
		exEnv.C_insert_mode_default = 0;
		break;

            default :
		Command_Line_Error(av[0]);

	      }
      }
    if (i<ac) Command_Line_Error(av[0]);

    InvertFileStack(parseEnv.fileStack, tmp_fstack);
    parseEnv.reset_position();
    parseEnv.in_query_loop = 1;

    exEnv.C_exec_mode = COR_DOING_INTERPRET ;

    init_coral(av[0]) ;

    if (!exEnv.C_quiet_mode_default) {
      // Print preliminary message
      char name_buffer[1000] ;
      sprintf(name_buffer, "%s%s/init.msg", exEnv.coral_path, HELP_PATH);
      DisplayFile(name_buffer);
    }

    while (yyparse()) {
	printf("syntax error -- skipping to next period\n");
    }

    exit_coral();
    if (!exEnv.C_quiet_mode_default) {
      printf("\nHave a good day, %s !\n", cuserid(NULL));
    }
    exit(0);

}

/* ------------------------------------------------------------- */
