/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	compile-rule.C

	Contains routines to 'compile' a single CORAL seminaive rule.
	It is invoked from compile.C, when a module is being compiled.

 ***********************************************************************/

#include "externs.h"
#include "interp.h"
#include "pipelined.h"
#include "derived-rel.h"
#include "profile.h"
#include "apply.h"
#include "annotations.h"
#include "globals.h"
#include <stdlib.h>
#include <string.h>

extern void sprint_magic_name(char *buf, char *name, BitVector *adorn);
extern void sprint_magic_name(char *buf, char *predname, char *adorn);

extern int getSuccessBacktrackPoint(SemiNaive *sn, Clause *clause, int);
extern int getfirstFailureBacktrackPoint(SemiNaive *sn, int rhs_index, int);
extern int getnextFailureBacktrackPoint(SemiNaive *sn, int rhs_index, int);
extern int has_grouping_args(ArgList &args);
// Defined in annotations.C
extern void add_make_index_annotation(PredAnnotations* &, Symbol *pred,
				      BitVector *bv,
				      ArgList *al1, ArgList *al2);

extern int count_var_list(VarLink *rest);

extern DatabaseStruct BuiltinDB ;

SemiNaive::SemiNaive()
{
  scc = NULL;
  rInfo = NULL ;
  first = 0 ;
  markOffsets = NULL ;
  negated = NULL;
  predOrders = NULL ;
  firstFailureBacktrack = NULL;
  nextFailureBacktrack = NULL;  
  successBacktrack = 0;
  recursive = 0 ;
  indices = NULL;
  ignore_this_rule = 0;
  rule_id = -1;
}

SemiNaive::~SemiNaive()
{
 if (rInfo) {
   if (markOffsets) delete markOffsets;
   if (indices) delete indices;
   if (negated) delete negated;
   if (predOrders) delete predOrders;
   if (rInfo->num_literals) {
     delete firstFailureBacktrack;
     delete nextFailureBacktrack;
    }
  }
}


/** WARNING: The following routine damages the varlists that are
	passed to it.
**/
VarLink *intersect_var_lists(VarLink *varlist1, VarLink *varlist2)
{
    VarLink *ptr1, *ptr2;
    VarLink *head=NULL, *prev=NULL;
    for(ptr1=varlist1; ptr1;) {
	for(ptr2=varlist2; ptr2; ptr2=ptr2->next) {
	    if (ptr1->arg->var == ptr2->arg->var)
		break;
	}
	if (ptr2) {
	    if (! head) head = ptr1;
	    if (! prev) prev = ptr1;
	    else {
		prev->next = ptr1;
		prev = ptr1;
	    }
	    ptr1 = ptr1->next;
	    prev->next = NULL;
	}
	else ptr1 = ptr1->next;
    }
    return head;
}

VarLink * build_var_list(Literal * pred, VarLink *list)
/*
 * Construct a list of all the variables in the bound arguments of the given
 * predicate.  Format the list as a Arg * for a predicate.
 */
{
    FOR_EACH_ARG(pred_arg, pred->args) {
	list = pred_arg->var_list(list);
    } END_EACH_ARG
    return list;
}


/** WARNING: The following routine damages the varlists that are
	passed to it.
**/
void create_an_annotation(PredAnnotations *&annos, 
			  Literal *lit, VarLink *var_list)
{
    VarLink *link;
    int var_count = 0;  // count of number of variables in var_list
    int const_count = 0; // count of number of constants in lit->args

    for (link = var_list ; link != NULL; link = link->next)
	var_count++;

    FOR_EACH_ARG(a, lit->args) {
      if (a->hash(NULL) != VarHashValue) const_count++;
     }END_EACH_ARG;

    // no point generating an index with all arguments free !!
    if (!var_count && !const_count) return ;

    ArgList *arglist = ArgList::New(var_count);

    for (link = var_list; var_count > 0; var_count -- ) {
	VarLink *next = link->next;
	(*arglist)[var_count-1]= link->arg;
	delete link;
	link = next;
    }
   
    Name name;
    if (lit->kind == COR_MAGIC) {
	char *buf = new char [lit->pred->length()+10];
	sprint_magic_name(buf,lit->pred->string(),"");
	name = EnterSymbol(buf);
    }
    else if (lit->kind == COR_DONE_MAGIC) {
	char *buf = new char [lit->pred->length()+15];
	sprintf(buf, "done_");
	char *buf1 = buf + strlen(buf);
	sprint_magic_name(buf1,lit->pred->string(),"");
	name = EnterSymbol(buf);
    }
    else {
	name = lit->pred;
    }


    add_make_index_annotation(annos,name, &(lit->adorn),&(lit->args),arglist);

}

VarLink *vars_between(struct rule *adrule, int start, int end,
					VarLink *rest, int *predOrders = NULL)
{
    int i;
    VarLink *result=rest;
    for (i=start; i <= end; i++)
      if (predOrders)
	result = build_var_list(adrule->preds[predOrders[i]], result);
      else 
	result = build_var_list(adrule->preds[i], result);
    return result;
}

int is_a_builtin(Name name)
{
  int ret_val = 1;
  Association *ptr1 ;
  ptr1 = SymbolLookup(BuiltinDB.RelationTable, name) ;

  if (HashNone(ptr1->arg)) ret_val = 0;
  //else ret_val = !((BuiltinRelation *)(ptr1->val))->is_printable_builtin() ;

  return ret_val;
}

static int lengthof(VarLink *vars)
{
  int length = 0;
  VarLink *ptr1;

  for(ptr1=vars; ptr1; length++) 
      ptr1 = ptr1->next;

  return length; 
}


/***
  * This funtion tries to find the literal in the rule that is best suited to be placed
  * immediately after 'start' in the join order.
  */
static int find_best_next_literal(Clause *rulePtr, int *predOrders,
			      VarLink *leading_vars,
			      int start, int end)

{
  int i;
  int best = start;
  int bestval = -1;
  VarLink *overlap_vars ;

  if (is_a_builtin(rulePtr->preds[predOrders[start]]->pred)) return start;

  for (i = start; i <= end; i++) {
    if (is_a_builtin(rulePtr->preds[predOrders[i]]->pred)) continue;
    overlap_vars = intersect_var_lists(
	 build_var_list(rulePtr->preds[predOrders[i]],NULL), leading_vars);
    if (lengthof(overlap_vars) > bestval) {
      bestval = lengthof(overlap_vars);
      best = i;
    }
  }

  return best;
}			      

static void generateIndexes(SemiNaive *snrule, PredAnnotations *&annos)
{
  int i, j, k;
  VarLink *leading_vars, *indexing_vars ;

#define RULEPTR snrule->rInfo->rule  
#define PREDINDEX(i) snrule->predOrders[i]

  /* The following code indexes predicates in the rule */
  for(i=0; i < RULEPTR->num_preds; i++) {
    leading_vars = vars_between(RULEPTR,0,i-1,NULL, snrule->predOrders);
    if (i < snrule->first) {
      j = find_best_next_literal(RULEPTR, 
				 snrule->predOrders,
				 leading_vars,
				 i, snrule->first);
      k = snrule->predOrders[j];
      while (j > i) {
	snrule->predOrders[j] = snrule->predOrders[j-1];
	j--;
      }
      snrule->predOrders[j] = k;
    }

    // no point building an index on an arithmetic predicate
    if (!is_a_builtin(RULEPTR->preds[PREDINDEX(i)]->pred)) {
      indexing_vars = intersect_var_lists(
	build_var_list(RULEPTR->preds[PREDINDEX(i)],NULL), leading_vars);
      create_an_annotation( //snrule->scc->module->index_annotations,
			   annos,
			   RULEPTR->preds[PREDINDEX(i)], indexing_vars);
    }
  }

  // if there is a grouping argument in the head, create an index on the
  // the head predicate that is bound on all arguments except the grouping
  // argument

  if (has_grouping_args(RULEPTR->head->args)) {
    char *buf = new char[RULEPTR->head->args.count() + 1];
    for(i=0;i< RULEPTR->head->args.count();i++)
      if(RULEPTR->head->args[i]->kindof()==COR_GROUPING)
	buf[i] = 'f';
      else buf[i] = 'b';
    buf[i] = '\0';
    ArgList *new_arglist = ArgList::New(1);
    (*new_arglist)[0] = EnterSymbol(buf);


    add_make_index_annotation(//snrule->scc->module->index_annotations,
			      annos,
			      RULEPTR->head->pred, &(RULEPTR->head->adorn),
			      new_arglist, NULL);
  }

#undef RULEPTR
#undef PREDINDEX
}

static void initPredOrders(SemiNaive *sn)
{
 if (sn->rInfo->num_literals) {
   sn->predOrders[0] = sn->first;
   for (int i = 1; i < sn->rInfo->num_literals; i++) {
     if ( i <= sn->first)
       sn->predOrders[i] = i-1;
     else sn->predOrders[i] = i ;
    }
  }
}

static void initFailureBacktrack(SemiNaive *sn, int ng_facts)
{
  for (int i = sn->rInfo->num_literals-1; i >0; i--) {
    sn->firstFailureBacktrack[i] = getfirstFailureBacktrackPoint(sn, i, ng_facts);

    sn->nextFailureBacktrack[i] =  getnextFailureBacktrackPoint(sn, i, ng_facts) ;
  }

  sn->firstFailureBacktrack[0] = -1;
  sn->nextFailureBacktrack[0] = -1;
}

void SemiNaive::Add_Rule_Info(RuleInfo *rule_info,
			      Clause *clause, int non_ground_facts)
{
 int i;

  rInfo = rule_info;
  markOffsets = new int[(rInfo->num_literals)*2];
  indices = new int [rInfo->num_literals];
  for (i = 0; i < rInfo->num_literals; i++)
    indices[i] = -1;

  predOrders = new int[rInfo->num_literals];
  initPredOrders(this);
    
  // Generate index annotations if the SemiNaive rule is a part of an scc.
  // In this case, the scc belongs to a module, and index annotations
  // can be created for the module. However, if the rule is a single
  // imperative rule (executed from the CORAL prompt), there is no
  // module for it. A separate index annotation list is created and
  // used to store the index annotations. These annotations are executed
  // right away resulting in eager index creation.
  // NOTE:: generateIndexes can change the PredOrders array ! Hence anything that
  // uses the predOrders should come after it.    
  if (scc)
    generateIndexes(this, scc->module->index_annotations);
  else {
    // if (exEnv.C_eager_index_create_default)
    PredAnnotations *tmp_anno = NULL, *cur;
    generateIndexes(this, tmp_anno);

    for(cur= tmp_anno; cur;) {
      VarLink *rest;
      rest = cur->arglist1->var_list(NULL);
      if ( cur->arglist2 )
	rest = cur->arglist2->var_list(rest);
      
      int num_vars = count_var_list(rest);
      Relation *indexrel = find_external_relation(cur->pred,
						  cur->arglist1->arity());
      if (indexrel) {
	if (cur->arglist2)
	  indexrel->add_index(cur->arglist1, num_vars, cur->arglist2) ;
	else indexrel->add_index(cur->arglist1) ;
       }
      // delete space for index annos
      PredAnnotations *temp = cur;
      cur = cur->next();
      delete temp;
     }    
    
   }

  // NOTE : predOrders MUST be assigned BEFORE the backtrack arrays and negated arrays

  negated = new int[rInfo->num_literals];
  for (i = 0; i < rInfo->num_literals; i++)
    negated[i] = (rInfo->relations[i] < 0);

  if (rInfo->num_literals) {
    firstFailureBacktrack = new int [rInfo->num_literals];
    nextFailureBacktrack = new int [rInfo->num_literals];
    initFailureBacktrack(this, non_ground_facts);
    btDecision[BACKWARD] = nextFailureBacktrack;
    btDecision[FORWARD] = firstFailureBacktrack;
    successBacktrack = getSuccessBacktrackPoint(this, clause, non_ground_facts);
   }
  
  clean_cache();

  // this is an optimization for supplementary magic with indexing
  // the magic rules are ignored, and the magic facts are generated
  // along withthe firing of the goalid() literal of the supp rule
  //            --- Praveen

  // note that scc could be NULL if this is an imperative rule invoked
  // from the coral prompt
  /******* This causes problems with return unify optimization : Praveen
  if (scc && (scc->module->module_info.SupMagicIndexing) && 
      is_magic(clause->head->pred))
    ignore_this_rule = 1;
  *****/
}

RuleInfo *create_rule_info(Table *F, struct rule *rule)
{
    int num_preds = rule->num_preds;
    int num_deletes = rule->head_deletes_count;
    int ipred;

    /* Variable declarations */
    
    RuleInfo *rInfo = new RuleInfo(rule);

//  Adding info for rInfo->arg_list, and rInfo->relations.

//  ArgList **arglist = new ArgList*[num_preds+1] ;

// NOTE : Should change Arg** to ArgList *
    for (ipred = 0; ipred < num_preds; ipred++)
	rInfo->arg_list[ipred] = (Arg **)(&rule->preds[ipred]->args) ;

    rInfo->arg_list[num_preds] = (Arg **)(&rule->head->args) ;
    for (ipred=0; ipred < num_deletes; ipred++) {
	rInfo->arg_list[num_preds+1+ipred] =
			(Arg **)(&rule->head_deletes[ipred]->args) ;
    }

// If the predicate is negated, a negative value is placed in the
// rInfo->relations[] field. This info is used by SemiNaive::evaluate() 
    for (ipred = 0; ipred < num_preds; ipred++)
	if (rule->preds[ipred]->negated)
	    rInfo->relations[ipred]= -2 
	      - (rInfo->offsets[ipred] = get_offset(F, rule->preds[ipred]));
	else
	    rInfo->relations[ipred]= 
	      (rInfo->offsets[ipred] = get_offset(F, rule->preds[ipred]));

    if (rule->head->negated)
	rInfo->relations[num_preds] = -2 - 
	  (rInfo->offsets[num_preds] = get_offset(F, rule->head)) ;
    else
	rInfo->relations[num_preds] = 
	  (rInfo->offsets[num_preds] = get_offset(F, rule->head)) ;

    for (ipred = 0; ipred < num_deletes; ipred++) {
	rInfo->relations[num_preds+1+ipred]= -2 -
	  (rInfo->offsets[num_preds+1+ipred] = 
	      get_offset(F, rule->head_deletes[ipred]));
    }

    rInfo->relations[num_preds+num_deletes+1] = -1 ;
    rInfo->offsets[num_preds+num_deletes+1] = -1 ;


    return(rInfo) ;
}

void compile_nonrec_rule(SemiNaive &sn, Clause *clause,
			 RuleInfo *rInfo, int non_ground)
{
  sn.first = 0 ;
  sn.recursive = 0 ;
  sn.Add_Rule_Info(rInfo, clause, non_ground);
  
  for (int jpred = 0; jpred < clause->num_preds; jpred++)
    sn.markOffsets[2*jpred] = sn.markOffsets[2*jpred+1] = -1 ;
}

