/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "rules.h"
#include "externs.h"
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

/* Number of BitWords to represent 'i' bits */
static int bit_words_needed(int i)
{
    return (i + BIT_VECTOR_WORD - 1) >> BIT_VECTOR_WORD_LOG;
}

void BitVector::init(BitVector& b2)
{
    int words_needed = bit_words_needed(b2.length);
    if (words_needed <= 1) {
	u.word0 = b2.u.word0;
    } else {
	u.words = (BitWord*)malloc(words_needed * sizeof(BitWord));
	BitWord *src = b2.u.words;
	BitWord *dst = u.words;
	while (--words_needed >= 0) *dst++ = *src++;
    }
    length = b2.length;
}

BitVector::~BitVector()  { if (length > BIT_VECTOR_WORD) free(u.words); }

void BitVector::printon(FILE *file)
{
    for (int i = 0; i < length; ++i)
	putc('0' + test(i), file);
}

int BitVector::next(int i) const
{
    for (++i; i < length; ++i)
	if (test(i))
	    return i;
    return -1;
}

void BitVector::setlen(int l)
{
    if (l > BIT_VECTOR_WORD) {
	BitWord *old_words = words();
	int old_length = bit_words_needed(length);
	int new_length = bit_words_needed(l);
	register int j;
	int new_bytes = new_length * sizeof(unsigned long);
	unsigned long *new_words = (unsigned long*)malloc(new_bytes);
	//bzero(new_words, new_bytes);
	memset(new_words, 0, new_bytes);
	for (j = old_length; --j >= 0; ) new_words[j] = old_words[j];
	u.words = new_words;
	if (old_length > 1) free(old_words);
    } else if (length > BIT_VECTOR_WORD) {
	BitWord w = u.words[0];
	free(u.words);
	u.word0 = w;
    }
    length = l;
}

void BitVector::set(int index, int value /*= 1*/)
{
    if (index >= length)
	setlen(index+1);
    BitWord *ptr = &words()[index>>BIT_VECTOR_WORD_LOG];
    BitWord mask = 1 << (index & BIT_VECTOR_WORD-1);
    if (value)
	*ptr |= mask;
    else
	*ptr &= ~mask;
}

void BitVector::operator=(BitVector& b2)
{
    // Ok for (&b2 == this).
    int words_needed = bit_words_needed(b2.length);
    if (words_needed <= 1) {
	if (length > BIT_VECTOR_WORD)
	    free(u.words);
	u.word0 = b2.u.word0;
    } else {
	if (length > BIT_VECTOR_WORD)
	    u.words = (BitWord*)realloc(u.words, words_needed*sizeof(BitWord));
	else
	    u.words = (BitWord*)malloc(words_needed * sizeof(BitWord));
	BitWord *src = b2.u.words;
	BitWord *dst = u.words;
	while (--words_needed >= 0) *dst++ = *src++;
    }
    length = b2.length;
}

int BitVector::operator==(BitVector& b2)
{
    if (length != b2.length) return 0;

    register unsigned long *ptr1 = words();
    register unsigned long *ptr2 = b2.words();
    int words1 = bit_words_needed(length);
    int words2 = bit_words_needed(b2.length);
    register int i = words1 > words2 ? words2 : words1;
    while (--i >= 0)
	if (*ptr1++ != *ptr2++)
	    return 0;
    i = words1 - words2;
    if (i > 0)
	while (--i >= 0) if (*ptr1++ != 0) return 0;
    else if (i < 0)
	for (i = -1; --i >= 0; ) if (*ptr2++ != 0) return 0;
    return 1;
}

int BitVector::implies(BitVector& b2)
{
    register unsigned long *ptr1 = words();
    register unsigned long *ptr2 = b2.words();
    int words1 = bit_words_needed(length);
    int words2 = bit_words_needed(b2.length);
    register int i = words1 > words2 ? words2 : words1;
    while (--i >= 0)
	if (*ptr1++ & ~*ptr2++)
	    return 0;
    i = words1 - words2;
    while (--i >= 0) if (*ptr1++ != 0) return 0;
    return 1;
}

int BitVector::count() const
{
    int i, c;
    for(c = next(-1), i = 0; c >= 0; c = next(c) )
	i++;
    return(i) ;
}

void BitVector::or_bits(BitVector *b2) 
{
    int c;
    for(c = b2->next(-1); c >= 0; c = b2->next(c) )
	set(c);
}

void BitVector::clear()
{
    //bzero(words(), bit_words_needed(length) * sizeof(unsigned long));
    memset(words(),0, bit_words_needed(length) * sizeof(unsigned long));
}

int BitVector::any()
{
    register unsigned long *ptr = words();
    register int i = bit_words_needed(length);
    while (--i >= 0)
	if (*ptr++)
	    return 1;
    return 0;
}

int BitVector::operator&(BitVector& b2)
{
    register unsigned long *ptr1 = words();
    register unsigned long *ptr2 = b2.words();
    register int i = length;
    if (i > b2.length) i = b2.length;
    i = (i+BIT_VECTOR_WORD-1) >> BIT_VECTOR_WORD_LOG;
    while (--i >= 0)
	if (*ptr1++ & *ptr2++)
	    return 1;
    return 0;
}
