/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	backtrack.C
 ***********************************************************************/

#include "externs.h"
#include "interp.h"
#include "pipelined.h"
#include "derived-rel.h"
#include "annotations.h"
#include "apply.h"
#include <stdlib.h>
#include <string.h>

extern void annotation_error(PredAnnotations *anno, char *msg);


static void check_this_arg(Arg *, struct VarLink *);

static void read_vars_from_arglist(struct VarLink *varlist, ArgList& args)
{
  FOR_EACH_ARG(a, args) {
    if (!a) {
      fprintf(exEnv.error_file, "Something wrong here !\n");
      continue;
    }
    check_this_arg(a, varlist);
  }END_EACH_ARG
}

static void check_this_arg(Arg *a, struct VarLink *varlist)
{
  struct VarLink *temp;

  switch(a->kindof()) {
  case COR_VARIABLE :
    temp = new VarLink((VarArg *)a, varlist->next);
    varlist->next = temp;
    break;
  case COR_FUNCTOR :
    read_vars_from_arglist(varlist, ((FuncArg *)a)->args);
    break;
  case COR_GROUPING :
    //read_vars_from_arglist(varlist, ((FuncArg *)a)->args);
    check_this_arg(((Grouping *)a)->nestedArgs, varlist);
    break;
  case COR_NUM_CONST :
    if ( ((NumArg *)a)->num_kindof() == COR_ARITH_EXPR) {
      check_this_arg(((ExprArg *)a)->left_arg, varlist);
      check_this_arg(((ExprArg *)a)->right_arg, varlist);
    }
    default : break;
  }
}


static int delete_this_arg(Arg *a, struct VarLink * varlist);

// returns non-zero if any delete occurs, and 0 otherwise.
static int delete_vars_from_arglist(struct VarLink * varlist, ArgList& args)
{
  int ret_val = 0;

  FOR_EACH_ARG(a, args) {
    ret_val = ret_val | delete_this_arg(a,varlist);
  } END_EACH_ARG;
  return ret_val;
}

static int delete_this_arg(Arg *a, struct VarLink * varlist)
{
  int ret_val = 0;
  struct VarLink *temp, *temp1;

  switch(a->kindof()) {
  case COR_VARIABLE : 
    for (temp = varlist; temp->next; temp = temp->next) 
      if (a->equals(temp->next->arg)) {
	temp1 = temp->next;
	temp->next = temp1->next;
	delete temp1;
	return 1;
      }
    break;
  case COR_FUNCTOR :
    return delete_vars_from_arglist(varlist, ((FuncArg *)a)->args);

  case COR_NUM_CONST :
    if ( ((NumArg *)a)->num_kindof() == COR_ARITH_EXPR) {
      ret_val = delete_this_arg(((ExprArg *)a)->left_arg, varlist);
      ret_val = ret_val | delete_this_arg(((ExprArg *)a)->right_arg, varlist);
      return ret_val;
    }

  case COR_GROUPING :
    // grouping cannot appear in the body of a rule
  default : break;
  }
  return 0;
}

/*
 * Never backtrack to relations that can succeed only once. Examples of such
 * relations are most builtins. Also, do not backtrack to a negated literal.
 * In both these cases, go back to the previous literal.
 */
static int skipSingleSuccess(RuleInfo *rInfo,
			     int i /* current backtrack position chosen */ ,
			     int *predOrders = NULL)
{
  int j;

  if (i < 0) return i;

  Relation *rel;
  while (i >= 0) {

    if (predOrders) j = predOrders[i];
    else j = i;

    rel = find_external_relation(rInfo->rule->preds[j]->name(),
				 rInfo->rule->preds[j]->arity());

    if (rel && (rel->single_success))  // handles builtins
      i--;

    else /* handles negated literals  */
      if (NEGATED(j))
      i--;
    else break;
  }

  return i;
}

/*
 * If a cut has been crossed in the process of backtracking, then the
 * backtrack point must be -1.
 */
static int cutCrossed(RuleInfo *rInfo,
		      int i /* current backtrack position chosen */,
		      int src /* position for which i is the backtrack position */)
{
  if (i < 0) return i;

  int j;
/****
  for (j = i; j < rInfo->num_literals; j++) 
    if (rInfo->rule->preds[j]->name() == CutSymbol) break;

  if (j == rInfo->num_literals) return i;
*******/
  for (j = i; j < src; j++) 
    if (rInfo->rule->preds[j]->name() == CutSymbol) break;

  if (j == src) return i;
  else return -1;
}


/*
 * success backtracking : is invoked upon succesful evaluation of
 * a rule. Execution backtracks to the right-most literal that generates
 * new bindings for the head literal. This function returns the success
 * backtracking point for the seminaive rule.
 * If there is a choice annotation on the head which specifies that
 * (X) -> (Y), where (X) and (Y) are disjoint sets of head variables,
 * then upon success, execution should backtrack to the right-most literal
 * that generates new bindings for those head variables other than ones in(Y).
 */
int getSuccessBacktrackPoint(SemiNaive *sn, Clause *clause, int ng_facts)
{
  PredAnnotations *cur;
  int i = -1;

  if (ng_facts) {
    i = sn->rInfo->num_literals-1;
  }
  else {

    struct VarLink *head_vars = new VarLink(NULL, NULL);

    // Read the variables from the head into a VarLink list
    read_vars_from_arglist(head_vars,
	       *((ArgList*)(sn->rInfo->arg_list[sn->rInfo->num_literals])));


    if (head_vars->next)  {
      for (i = -1; i < sn->rInfo->num_literals-1; ) {
	for( cur=parserStruct.agg_sel_annotations ;cur!=NULL; cur = cur->next())
	  {
	    if(cur->pred == clause->head->pred) {
	      if (cur->op_arg->kindof() != COR_FUNCTOR) {
		annotation_error(cur, "Bad aggregation type");
		break;
	      }
	      FuncArg *fop_arg = (FuncArg*) cur->op_arg;
	      if (fop_arg->functor() == AnyOpSymbol) {
		VarLink *gbvars = new VarLink(NULL,NULL);
		read_vars_from_arglist(gbvars, *(cur->arglist2));
		// Get the groupby vars
		
		for(int j=0;j<=i; j++) {
		  delete_vars_from_arglist(gbvars,
		       *(ArgList*)(sn->rInfo->arg_list[sn->predOrders[j]]));
		  if (!(gbvars->next)) break;
		}
		if (!(gbvars->next))
		  delete_vars_from_arglist(head_vars, fop_arg->args);
		/* All vars in groupby list have been bound -- can
		 * now delete the variables in the "any" selection's head
		 * from the list of head_vars.
		 */
	      }
	      if(!(head_vars->next))
		break; /* From inner for loop */
	    }
	  }
	if(!(head_vars->next))
	  break;
	
	i++;
	
	delete_vars_from_arglist(head_vars,
				 *(ArgList*)(sn->rInfo->arg_list[sn->predOrders[i]]));
	
	if(!(head_vars->next))
	  break;
      }
    }

    while (head_vars) {
      struct VarLink *temp = head_vars->next;
      delete head_vars;
      head_vars = temp;
    }
  }
  /** At this stage, i is the index of the rhs literal at which forward
   ** computation should resume in the rule after a successful firing.
   **/

  if (i < 0) return i;
  
  return skipSingleSuccess(sn->rInfo, i, sn->predOrders);
}

int getSuccessBacktrackPoint(RuleInfo *rInfo, int ng_facts)
{
  int i = -1;

  if (ng_facts) {
    i = rInfo->num_literals-1;
  }
  else {
    struct VarLink *head_vars = new VarLink(NULL, NULL);
    int last_binding_point = -1;

    // Read the variables from the head into a VarLink list
    read_vars_from_arglist(head_vars,
			   *((ArgList*)(rInfo->arg_list[rInfo->num_literals])));

    if (head_vars->next) 
      for (i = 0; i < rInfo->num_literals; i++) {
	delete_vars_from_arglist(head_vars,
				 *(ArgList*)(rInfo->arg_list[i]));
	last_binding_point = i;
	
	if(!(head_vars->next))
	  break;
      }
    
    while (head_vars) {
      struct VarLink *temp = head_vars->next;
      delete head_vars;
      head_vars = temp;
    }

    i = last_binding_point;
  }
    
  /** At this stage, i is the index of the rhs literal at which forward
   ** computation should resume in the rule after a successful firing.
   **/
  
  int j = skipSingleSuccess(rInfo, i);

  // check if a cut has been crossed
  return cutCrossed(rInfo, j, rInfo->num_literals);
}

/*
 * get-first-failure backtracking : is invoked when a rhs literal
 * fails the first time it is reached. In this case, execution should
 * backtrack to the rightmost point that generates fresh bindings for
 * it. Example : p(X,Y,C) :- q(X, Z), r(Z,A,B), s(Z,C), t(A,B,C).
 * if s(Z,C) fails the first time it is reached, execution should
 * backtrack to q(X,Z), not to r(Z,A,B). However, if the failure
 * occurs after s(Z,C) has returned succesfully a few times, it is
 * WRONG to backtrack to q(X,Z). r(Z,A,B) could generate some new bindings for
 * A and B that might result in an answer tuple.
 */

int getfirstFailureBacktrackPoint(SemiNaive *sn, int rhs_index, int ng_facts)
{
  int i = -1;

  if (ng_facts) {
    i = rhs_index-1;
  }
  else {

    struct VarLink *rhs_literal_vars = new VarLink(NULL, NULL);
    int last_binding_point = -1;
    
    // Read the variables from the rhs literal into a VarLink list
    read_vars_from_arglist(rhs_literal_vars,
		*((ArgList*)(sn->rInfo->arg_list[sn->predOrders[rhs_index]])));

    if (rhs_literal_vars->next)
      for (i = 0; i < rhs_index; i++) {
	if (delete_vars_from_arglist(rhs_literal_vars,
		        *(ArgList*)(sn->rInfo->arg_list[sn->predOrders[i]])))
	  last_binding_point = i;
	
	if (!(rhs_literal_vars->next))
	  break;
      }
    
    while (rhs_literal_vars) {
      struct VarLink *temp = rhs_literal_vars->next;
      delete rhs_literal_vars;
      rhs_literal_vars = temp;
    }

    i = last_binding_point;
  }

  /** At this stage, i is the index of the rhs literal at which forward
   ** computation should resume in the rule after a successful firing.
   **/

  if (i < 0) return i;

  return skipSingleSuccess(sn->rInfo, i, sn->predOrders);
}


/*
 * get-next-failure backtracking : is invoked when a rhs literal
 * fails after it has been successful at least once. 
 * In this case, execution should backtrack to the rightmost point that
 * generates fresh bindings for the literal or any literal after it in the
 * rule execution order.
 * Example : p(X,Y,C) :- q(X, Z), r(A,B), s(Z,C), t(A,B,C).
 * if s(Z,C) fails when it is reached on a get-next, execution should
 * backtrack to r(A,B), not to q(X,Z)).
 */

int getnextFailureBacktrackPoint(SemiNaive *sn, int rhs_index, int ng_facts)
{
  int i = -1;

  if (ng_facts) {
    i = rhs_index-1;
  }
  else {
    struct VarLink *rhs_literal_vars = new VarLink(NULL, NULL);
    int last_binding_point = -1;

    // Read the variables from the rhs literal into a VarLink list
    for (int tmp = rhs_index; tmp < sn->rInfo->num_literals; tmp++)

    read_vars_from_arglist(rhs_literal_vars,
	     *((ArgList*)(sn->rInfo->arg_list[sn->predOrders[tmp]])));

    if (rhs_literal_vars->next)
      for (i = 0; i < rhs_index; i++) {
	if (delete_vars_from_arglist(rhs_literal_vars,
		     *(ArgList*)(sn->rInfo->arg_list[sn->predOrders[i]])))
	  last_binding_point = i;
	
	if(!(rhs_literal_vars->next))
	  break;
      }
    
    while (rhs_literal_vars) {
      struct VarLink *temp = rhs_literal_vars->next;
      delete rhs_literal_vars;
      rhs_literal_vars = temp;
    }
    
    i = last_binding_point;
  }
  
  /** At this stage, i is the index of the rhs literal at which forward
   ** computation should resume in the rule after a successful firing.
   **/

  if (i < 0) return i;
  
  return skipSingleSuccess(sn->rInfo, i, sn->predOrders);
}

int getfirstFailureBacktrackPoint(RuleInfo *rInfo, int rhs_index, int ng_facts)
{
  int i = -1;

  if (ng_facts) {
    i = rhs_index-1;
  }
  else {
    struct VarLink *rhs_literal_vars = new VarLink(NULL, NULL);
    int last_binding_point = -1;

    // Read the variables from the rhs literal into a VarLink list
    read_vars_from_arglist(rhs_literal_vars,
			   *((ArgList*)(rInfo->arg_list[rhs_index])));
    
    if (rhs_literal_vars->next)
      for (i = 0; i < rhs_index; i++) {
	if (delete_vars_from_arglist(rhs_literal_vars,
				     *(ArgList*)(rInfo->arg_list[i])))
	  last_binding_point = i;
	
	if(!(rhs_literal_vars->next))
	  break;
      }
    
    while (rhs_literal_vars) {
      struct VarLink *temp = rhs_literal_vars->next;
      delete rhs_literal_vars;
      rhs_literal_vars = temp;
    }
    
    i = last_binding_point;
  }
  
  /** At this stage, i is the index of the rhs literal at which forward
   ** computation should resume in the rule after a successful firing.
   **/
  
  int j = skipSingleSuccess(rInfo, i);

  // check if a cut has been crossed
  return cutCrossed(rInfo, j, rhs_index);
}

int getnextFailureBacktrackPoint(RuleInfo *rInfo, int rhs_index, int ng_facts)
{
  int i = -1;

  if (ng_facts) {
    i = rhs_index-1;
  }
  else {
    struct VarLink *rhs_literal_vars = new VarLink(NULL, NULL);
    int last_binding_point = -1;
    
    // Read the variables from the rhs literal into a VarLink list
    for (int tmp = rhs_index; tmp < rInfo->num_literals; tmp++)

      read_vars_from_arglist(rhs_literal_vars,
			     *((ArgList*)(rInfo->arg_list[tmp])));
    
    
    if (rhs_literal_vars->next)
      for (i = 0; i < rhs_index; i++) {
	if (delete_vars_from_arglist(rhs_literal_vars,
				     *(ArgList*)(rInfo->arg_list[i])))
	  last_binding_point = i;
	
	if(!(rhs_literal_vars->next))
	  break;
      }
    
    while (rhs_literal_vars) {
      struct VarLink *temp = rhs_literal_vars->next;
      delete rhs_literal_vars;
      rhs_literal_vars = temp;
    }
    
    i = last_binding_point;
  }

  /** At this stage, i is the index of the rhs literal at which forward
   ** computation should resume in the rule after a successful firing.
   **/
  
  int j = skipSingleSuccess(rInfo, i);

  // check if a cut has been crossed
  return cutCrossed(rInfo, j, rhs_index);

}

