/**********************************************************************
 Added By: Bill Roth/Sat Feb  6 15:08:22 1993
 Comments: These functions allow CC compiled EXODUS to be used 
 with g++ compiled CORAL. (These come from Mike Zwilling).
**********************************************************************/

#ifdef __GNUC__
/*
 * This code allows applications to link when compiled with cc or g++.
 *
 * The storage manager is shipped compiled with ATT C++.  If an
 * application is linked with cc or g++ then it needs the
 * following functions as well.  
 *
 * To use this file remove the ifdefs and add it to libsm_client.a
 *
 *
 * P.S.: you might want to remove the prototypes so it will work on a Sun.
 *
*/

#ifndef notdef

   /*
	*  Do not include this support code, instead leave a dummy
	*  variable so that some broken linkers don't complain.
	*/ 
	static int __dummy;

/*#else*/

#include <sys/types.h>
#include <malloc.h>

/*
 *  Turn on function prototypes for these compilers
 */
#if defined(_AIX) || defined(mips) || defined(__cplusplus) || defined(c_plusplus) || defined(__GNUC__)
#   define PROTO(_parms) _parms 
#else
    /*
     *  Turn it off for everything else
     */
#define PROTO(_parms) ()
#endif


int	_main()
{
}

void *__nw__FUi PROTO((size_t size)) {
	return malloc(size);
}

void __dl__FPv PROTO((void *p)) {
	if (p) free(p);
}

void *__vec_new PROTO((void *space, int count, size_t size, void (*init)(void *))) {
	char *p;
	int i;

	if (!space)
		space = malloc(count * size);
	if (!space) return 0;
	if (init)
		for (i=0,p = (char *)space; i<count; i++, p+=size)
			(*init)(p);
	return space;
}

void __vec_delete PROTO((void *space, int count, size_t size,
	void (*fin)(void *,int), int del_flag)) {
	char *p;

	if (fin)
		for (p = (char *)space + (count-1)*size; p >= (char *)space; p-=size)
			(*fin)((void *)p, 2);
	if (del_flag)
		free(space);
}

#endif /* include code */

#endif __GNUC__
