
/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	apply.C : Contains code for the nested loops evaluation of a
	seminaive rule. The SemiNaive rule structure is defined in
	interp.h. The other relevant header file is apply.h, that
	contains the type definition for the RuleInfo structure.
	The function evaluate() which is a class method of SemiNaive
	takes an array of RMarks and a Table of relations as arguments.

	Code for evauluating a rule in pipelined manner is also included
	in this file. All future changes performed to evaluate() should
	also be reflected in PipelinedExecInfo::Solve().

 ***********************************************************************/

#include "term.h"
#include "generic-rel.h"
#include "rules.h"
#include "builtin-rel.h"
#include "hash.h"
#include "externs.h"
#include "profile.h"
#include "apply.h"
#include "interp.h"
#include "pipelined.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

// some macros defined to make the evaluate code easier to read.
// the INSERT_NG_FACT macro is actually a blob of code that
// is moved here as a macro to enhance readablity of the rest of the code.
// While this admittedly yucky, it makes it possible to understand the rest
// of the code : Praveen

#ifdef DO_EXPLAIN
#ifdef DO_PROFILE
#define HANDLE_SUCCESS { \
	if ((rel->local_options & REL_EXPLAIN) && (T_Stack.count > 0))\
	   do_dump(F, rInfo, env, (ArgList *)(rInfo->arg_list[index])); \
        (pinfo->i_newfacts)++ ; \
	}
#else
#define HANDLE_SUCCESS  { \
	if ((rel->local_options & REL_EXPLAIN) && (T_Stack.count > 0)) \
	   do_dump(F, rInfo, env, (ArgList *)(rInfo->arg_list[index])); \
			  }
#endif
#else
#ifdef DO_PROFILE
#define HANDLE_SUCCESS  { (pinfo->i_newfacts)++ ; }
#else
#define HANDLE_SUCCESS  { }
#endif
#endif

#define INSERT_NG_FACT  \
	  TermLink *renamed_vars = NULL; \
	  Arg **new_arglist = rInfo->arg_list[index]; \
	  BindEnv *new_env = env; \
	  int env_size; \
	  int dont_rename = 0; \
	  BindEnv *backup_env = NULL; \
	  int single_fact_env=1; \
	  StackMark *backup_env_mark; \
	  BindEnv *dont_rename_env = &UnusedEnv; \
              \
	  backup_env_mark = new StackMark; \
	      \
	  for (int i=0; i<rInfo_num_literals; i++) { \
	    if (tuples[i] && tuple_its[i]->tuple_env  \
		&& tuple_its[i]->tuple_env->is_versioned()) { \
	      dont_rename_env = tuple_its[i]->tuple_env; \
	      break; \
	    } \
	  } \
	  \
	  if (dont_rename_env != &UnusedEnv) { \
	    backup_env = dont_rename_env->make_version_and_swap(); \
	  }\
	  \
	  for (int j=0; j < rInfo_num_literals; j++) {\
	    if( (! tuples[j]) || tuple_its[j]->tuple_env == dont_rename_env \
	       || tuple_its[j]->tuple_env == NULL) \
	      continue; \
	    else single_fact_env = 0; \
	  } \
	  \
	  if (single_fact_env && dont_rename_env != &UnusedEnv && \
	     !has_grouping_args(*(ArgList *)rInfo->arg_list[index])) { \
	      \
	      if( backpatch_bindenvs(stackmark0, dont_rename_env, \
				     env, renamed_vars) && (rel->count >= 0)) { \
			\
		dont_rename = 1; \
		new_arglist =(Arg **)ArgList::New((*((ArgList*)new_arglist)).arity());\
		env_size = SimpleCopyArgs( (ArgList*) new_arglist, \
					  (ArgList *)rInfo->arg_list[index], \
					  env, dont_rename_env, renamed_vars); \
		if (dont_rename_env != &UnusedEnv) { \
		  new_env = dont_rename_env->copy_shell(); \
		} \
		else new_env = (BindEnv*) new VersionedBindEnv(env_size); \
	      }\
	  } \
	  if ( rel->insert_new( new_arglist, new_env, \
			       dont_rename_env, tuples[0], dont_rename)){ \
	    HANDLE_SUCCESS ;\
	    answer_count ++; \
	  } \
	  backup_env_mark->pop_to(); \
	  delete backup_env_mark; \
	  \
	  if (backup_env) { \
	    dont_rename_env->restore(backup_env); \
	    ::delete backup_env; \
	  } 


extern void AddProfileInfo(ProfileInfo *A, ProfileInfo *B) ;
extern int SimpleCopyArgs(ArgList *new_arglist, ArgList *old_arglist,
		BindEnv *rule_env, BindEnv *dont_rename_env,
		TermLink *&renamed_vars);
extern int backpatch_bindenvs(StackMark start, BindEnv *dont_rename_env,
		BindEnv *rule_env, TermLink *&renamed_vars);

extern void sprint_rule(Clause *rule, char *str) ;
extern int has_grouping_args(ArgList &args);


/***************************************************************************
Used to dump out information to be used by the Explain tool
****************************************************************************/
static void do_dump(Table * F, RuleInfo * rInfo, BindEnv * new_env,
              ArgList * new_arglist)
{
    FILE *fd = F->moduledata->module_info.file_desc;
    if (!fd)
      {
        fprintf(exEnv.error_file, "Error::Explain: Cannot create dump file.\n");
        return;
      }

    for (int j=0; j <= rInfo->num_literals; j++)
       {
        if (j==rInfo->num_literals)
          {
            /* First Argument */
            fprintf(fd, "def_%s(",
                 SymbolString(F->moduledata->export_pred->name));
            rInfo->rule->head->predicate->name->print(new_env, fd);
            fprintf(fd, "(");
            ((ArgList *)new_arglist)->
                                    print_dump(new_env, fd);

            fprintf(fd, ")");
          }
        else
          {
            fprintf(fd, "use_%s(",
                 SymbolString(F->moduledata->export_pred->name));
            rInfo->rule->preds[j]->predicate->
                                            name->print(new_env, fd);
            fprintf(fd, "(");
            ((ArgList *)rInfo->arg_list[j])->print_dump(new_env, fd);
            fprintf(fd, ")");
          }

         fprintf(fd, ", [");

         rInfo->rule->head->predicate->
                                    name->print(new_env, fd);
         fprintf(fd, "(");
         ((ArgList *)new_arglist)->
                                    print_dump(new_env, fd);
         fprintf(fd, ")");

         for (int i=0; i < rInfo->num_literals; i++)
           {
              fprintf(fd, ",");
              rInfo->rule->preds[i]->predicate->
                                name->print(new_env, fd);
              fprintf(fd, "(");
              ((ArgList *)rInfo->arg_list[i])->print_dump(new_env, fd);
              fprintf(fd, ")");

            }

       fprintf(fd, "]).\n");
    }
        fflush(fd);
}



// Class methods for RuleInfo

static char rule_buf [MAX_RULE_LENGTH] ;

RuleInfo::RuleInfo(struct rule *rul)
{
  num_vars = rul->num_var_names;
  num_literals = rul->num_preds;
  arg_list = new Arg**[rul->num_preds + rul->head_deletes_count + 1] ;
  relations = new int[rul->num_preds + rul->head_deletes_count + 2] ;
  offsets = new int[rul->num_preds + rul->head_deletes_count + 2] ;

  this->rule = rul;
  sprint_rule(rul, rule_buf);
  char *buf = new char[strlen(rule_buf)+1];
  strcpy(buf, rule_buf);
  ProfileInfo *temp = new ProfileInfo(buf) ;
  pInfo = *temp ;
}

RuleInfo::~RuleInfo()
{
    delete arg_list ;
    delete relations ;
    delete offsets ;
}

/***********************************************/
/*
 * Every time evaluate is called a number of structures need to be
 * initialized. However, this is a big overhead if there is going
 * to be allocation and deallocation for each evaluation of a seminaive
 * rule.  So we save them instead of deallocating them, and reuse them
 * on successive calls.  * We assume no parallelism however.
 *  TO DO:  Since space is never deallocated, we could be in trouble with
 *  	recursive module calls.  We may need to keep a count of saved up
 *	structs, and free them if there are too many saved up structures.
 */

#define RULE_MAX_LITERALS 10
#define RULE_MAX_VARS 20


ArrayBindEnv UnusedEnv(0);
RuleEnv *free_rule_envs = NULL;

static long profile_rule = 0;

/***********************************************/

#define MARKLIST(X) ((markOffsets[X]<0) ? NULL : \
			rm_array->markList[markOffsets[X]])

#define NEGATED1(index) (rInfo_relations[index] < 0)

/*------------------------------------------------------------------
 SemiNaive::evaluate(Table *F, RMarkArray *rm_array) :

 Evaluates a nested loop join of the seminaive rule. The Table structure
 F is defined in interp.h. It is a structure containing pointers to the
 various relations that the seminaive rule will have to access. It is
 initialized at query execution time with pointers to current relations
 and passed to the evaluate method as an argument. The evaluate function
 accesses all relations via the level of indirection provided by the Table.
 rm_array is an array of RMarks that specify the current extents of the
 'old' and 'new' relations used for seminaive evaluation. The evaluate
 function accesses the RMarks via offsets into the rm_array specified in
 the markOffsets array structure (class variable). Look at the code to 
 evaluate an Scc in interp.C to understand how RMarks are manipulated.

 The index 'current' counts how far we are along in the join.
 It represents the position of the current rhs literal being
 processed.

 The function returns the number of new tuples generated.

 -------------------------------------------------------------------*/

int SemiNaive::evaluate(Table *F, RMarkArray *rm_array)
{

  // Quick check for empty first relation. A relation is empty if
  // both the RMarks for the relation point to the same place.
  // The RMarks specify the extent of the relation to be scanned
  // and if they both are equal, the extent between them is empty.

  if ( recursive && (rInfo->num_literals > 0)) {
    int marklist_index = 2*first;
    int tmp_mark_offset;
    
    RMark * first_mark1 =
      (((tmp_mark_offset  = markOffsets[marklist_index]) < 0) ? NULL : 
       rm_array->markList[tmp_mark_offset]) ;
/**
    RMark * first_mark2 = 
      (((tmp_mark_offset  = markOffsets[++marklist_index]) < 0) ? NULL : 
       rm_array->markList[tmp_mark_offset]) ;
*****/    
    if (first_mark1) {
      if  (first_mark1->rel_p) {
	if (!first_mark1->rel_p->reln->count) return 0;
       }
      else if (!(*(first_mark1->lastptr)))
	return 0;
     }
  }

  int index;
  int offset;
  int current = 0;
  int answer_count = 0; // Count of number of new tuples generated.
  Relation *rel;
  int backtrack_index = 0; // used to specify next backtrack point 
  ProfileInfo *pinfo;

  // for efficiency, make the following assignments
  int rInfo_num_literals = rInfo->num_literals;
  int rInfo_num_vars = rInfo->num_vars;
  int *rInfo_relations = rInfo->relations;
  TupleIterator *tuple_its_index;
  int UsingRetUnify = USING_RETURN_UNIFY;
  


#ifdef DO_PROFILE
  // Initialize profiling information
  pinfo = &(CurrModuleInfo->GlobalProfileInfo);
  pinfo->set_rule_name(rInfo->pInfo.rule) ;
  profile_rule = ((exEnv.GlobalRelationOptions | 
	 (F->rels[rInfo_relations[rInfo_num_literals]].relPtr)->local_options) &
			REL_PROFILE_STATS) ;
  if (profile_rule)  pinfo->init_rule();

#endif

  TupleIterator **tuple_its;
  ArgList **arglist_its;
  StackMark stackmark0;
  ArrayBindEnv *env;
  StackMark *stack_marks;
  Tuple **tuples;
  RuleEnv *rule_env;
  BindEnv **it_bindenvs = NULL;

  if (rule_id < 0)
    // imperative rule
    rule_env = new RuleEnv(this);
  else
    rule_env = F->module_env->scc_envs[this->scc->scc_id]->snrule_envs[this->rule_id];

    env = & (rule_env->bindenv);
    stack_marks = rule_env->rmarks;
    tuple_its  = rule_env->tuple_its;
    arglist_its = rule_env->arglist_its;
    tuples = rule_env->tuples;
    it_bindenvs = rule_env->bindenvs;

  if (rule_id < 0) {
    if (rm_array && rm_array->array_size)
      for (index = 0; index < rInfo->num_literals; index++)
	tuple_its[index] = new TupleIterator (F->rels[rInfo->offsets[index]].relPtr,
					      rInfo->arg_list[index],
					      env, MARKLIST(2*index), MARKLIST(2*index+1),
					      &(indices[index]));
    else
      for (index = 0; index < rInfo->num_literals; index++)
	tuple_its[index] = new TupleIterator (F->rels[rInfo->offsets[index]].relPtr,
					      rInfo->arg_list[index],
					      env, NULL, NULL, &(indices[index]));
   }
  else {
    if (rm_array && rm_array->array_size)
      for (index = 0; index < rInfo->num_literals; index++)
	tuple_its[index]->reset_fields(F->rels[rInfo->offsets[index]].relPtr, env,
				       MARKLIST(2*index), MARKLIST(2*index+1), &(indices[index]));
    else
      for (index = 0; index < rInfo->num_literals; index++)
	tuple_its[index]->reset_fields(F->rels[rInfo->offsets[index]].relPtr, env, 
				       NULL, NULL, &(indices[index]));
    // NOTE:this should be moved into reset_fields!
    //F->rels[rInfo->offsets[index]].relPtr->scan_count++;
   }

  int direction = FORWARD;
  
  // Nested Loops Join evaluation using backtracking on failure.
      
  for(; current >= 0;) {
    
    // Exit statement from for loop. When current < 0, it implies that
    // no more facts can be generated from this rule evaluation, i.e.
    // it has backtracked past its starting point.

    // Check to see if rule evaluation has been succesful.
    // This happens when a valid tuple for the last rhs literal
    // has been found. When this happens, the head fact(s) should be created.

    if ( current >= rInfo_num_literals ) { 

      index = current;

      // The following code allows multiple heads per rule
      for( ; rInfo_relations[index] != -1; index ++) {
        offset = rInfo_relations[index];
	if (offset < 0) { 
	    // A negative offset implies a negated literal
	    // Eventually in such a case maybe we should delete the tuple
	    offset = (-2)-offset;
	    rel = F->rels[offset].relPtr ;
	    Tuple del_tup((ArgList *)rInfo->arg_list[index], env);
	    delete_tuple(rel, &del_tup);
	    continue;
	}

	// Find the relation in which the head fact should be inserted.
        rel = F->rels[offset].relPtr ;

#ifdef DO_PROFILE
	(pinfo->i_succesful)++ ;
#endif

	if (!CurrModuleInfo->NonGroundFacts) {
	  // Insert the new head fact into the relation
	  if (rel->insert_new( rInfo->arg_list[index], env,
			       &UnusedEnv, tuples[0], 0)){
	    HANDLE_SUCCESS;
	    answer_count ++;
	  }
	}

	else {    /** NON_GROUND FACTS **/
	  INSERT_NG_FACT
	}
      }

      // Continue with the nested loops join
      current = rInfo_num_literals -1;
      backtrack_index = successBacktrack;      
      direction = BACKWARD;
      continue;
    }

    else {   /**  the entire rule has not been instantiated yet **/
      index = predOrders[current];
      tuple_its_index = tuple_its[index];

      // To do a scan of each relation on the rhs, a TupleIterator is
      // needed on that relation. If this is the first time the relation
      // is reached during the evaluation, a TupleIterator needs to be created
      // for it.

      if (direction) {    /**  FORWARD **/
	tuple_its_index->reset();
	backtrack_index = current;
      }
      
      if (UsingRetUnify){
	if (direction) {
	  /* Return unify modifies the iterator bindenv
	     in some cases.  So the rest of the rule 
	     evaluation should use the new bindenv rather than
	     the original iterator bindenv.
	     The iterator's bindenv is reset when backtracking 
	     to the first literal.
	     */
	  if (index !=0)
	    it_bindenvs[index] = tuple_its[index-1]->bindenv;
	  else it_bindenvs[index] = env;
	  tuple_its_index->bindenv = it_bindenvs[index];
	}
	else
	  // Restore bindenv as it was when 
	  // the literal was reached in the forward
	  // direction.
	  tuple_its_index->bindenv = it_bindenvs[index];
	
	if (current == backtrack_index) {

	  /** Set the following flag to indicate the
	   *  literal in rule body that is being looked at; 
	   *  it is needed to implement return unification optimizations
	   **/	  
	  tuple_its_index->unification_number = current+1;
	  
	  /**  Set the prev_tuple and the prev_bindenv fields.  These are distinct
	   *  since prev_tuple is the original tuple with the original bindenv,
	   *  while prev_bindenv is the versioned copy of that bindenv.
	   **/
	  int prev_index;
	  
	  if (current != 0) {
	    prev_index = predOrders[current-1];
	    tuple_its_index->prev_tuple = tuples[prev_index];
	    tuple_its_index->prev_bindenv = tuple_its[prev_index]->tuple_env;
	  }
	  else {
	    tuple_its_index->prev_tuple = NULL;
	    tuple_its_index->prev_bindenv = NULL;
	  }
	}
      }      
      
      if (current == backtrack_index) {
	
	// Get the next tuple for the current relation in the nested loops join.
 
	tuples[index] = tuple_its_index->get_next_tuple();

	if (tuple_its_index->no_match() ^ negated[index])
	  backtrack_index = btDecision[direction][current];
	else {
	  current ++;
	  direction = FORWARD;
	  continue;
	 }	
      }
      
      // else on intelligent backtracking failure or
      // on failure to find a valid tuple, backtrack to the previous
      // rhs literal.
	
      // Undo bindings BEFORE
      // deleting tuple_iterator (and the tuple_env in it).
	  
      tuple_its_index->release(); /* Releases state of tuple iterator*/
      tuples[index] = NULL;
      
      // Decrement current so that the join evaluation backtracks to the
      // previous rhs relation, and a fresh tuple for that relation will
      // be fetched in the next iteration through the for loop.
      current --;
      direction = BACKWARD;

    }  // else
	
  }   // for loop

  // Cleaning up at the end of the nested loops rule evaluation.

  if (rule_id < 0) {
    for (index = 0; index < rInfo_num_literals; index++) {
      delete tuple_its[index];
     }
   }
  stackmark0.pop_to();

#ifdef DO_PROFILE
  if (profile_rule) {
    pinfo->exit_rule();
    _PROFILE(rInfo->pInfo, predOrders, rInfo_num_literals) ;
   }
#endif
    
  if (rule_id < 0)
    delete rule_env;
  return answer_count;
}

/*
 * PipelinedExecInfo::Solve() :
 * 
 * Evaluates the query in a top-down fashion. The Table structure
 * F is defined in interp.h. It is a structure containing pointers to the
 * various relations that will have to be accessed. It is
 * initialized at query execution time with pointers to current relations
 * and is a class variable of PipelinedExecInfo.The Solve function
 * accesses all relations via the level of indirection provided by Table.
 *
 * The processing for a rule is done in a left-to-right manner
 * The index 'current' counts how far we are along in the join.
 * It represents the position of the current rhs literal being
 * processed.
 *
 * We use top-down evaluation with backtracking
 *
 * Returns 1 on success and 0 on failure
 */

int PipelinedExecInfo::Solve()
{
  // for efficiency
  int rInfo_num_literals = rInfo->num_literals;
  int *rInfo_relations = rInfo->relations;
  TupleIterator *tuple_its_index;


  // Execution of a Pipelined module - top down using backtracking

    for(; current >= 0;) 
      {
	// Exit statement from for loop. When current < 0, it implies that
	// no more facts can be generated from this rule evaluation, i.e.
	// it has backtracked past its starting point.

	index = current;   // note:: it is redundant to have both index and current

	// Check to see if rule evaluation has been succesful.
	// This happens when a valid tuple for the last rhs literal
	// has been found. When this happens, we are going to return

	if ( current >= rInfo_num_literals ) 
	{
	    // decrement current so that the next time we begin here 
	    current = rInfo_num_literals -1;
      	    backtrack_index = successBacktrack;
	    direction = BACKWARD;
	    return 1;
	}

	tuple_its_index = tuple_its[index];

	// To do a scan of each relation on the rhs, a TupleIterator is
	// needed on that relation. If this is the first time the relation
	// is reached during the evaluation, a TupleIterator needs to be created
	// for it.

	if (direction) {    // == FORWARD
	  // iterator needs to be initialized
	  tuple_its_index->reset();
	  tuple_its_index->calling_pei = this;
	  backtrack_index = index;
	}

       if (index == backtrack_index)
	{
           // Get the next tuple for the current relation in the nested loops join.

	   tuple_its[index]->get_next_tuple();

           // If there is a valid tuple, go on to the next rhs relation.
           if ( (!tuple_its_index->no_match() && !NEGATED1(index))
	       || (tuple_its_index->no_match() && NEGATED1(index)) ) {
             current ++;
             direction = FORWARD;
             continue;
            }
	   else
	     backtrack_index = ((direction) ? firstFailureBacktrack[current] :
	       nextFailureBacktrack[current]);
        }

	// On failure to find a valid tuple, backtrack to the previous
	// rhs literal.

	// Undo bindings BEFORE
	// deleting tuple_iterator (and the tuple_env in it).

	tuple_its_index->release(); // releases state of tuple iterator

	// Decrement current so that the join evaluation backtracks to the
	// previous rhs relation, and a fresh tuple for that relation will
	// be fetched in the next iteration through the for loop.
	current --;
	direction = BACKWARD;
      }

  // Have failed 
  stackmark0.pop_to();

  return 0;
}

#undef MARKLIST
#undef NEGATED1
#undef INSERT_NG_FACT
